<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0 1.5rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-layout {
        display: flex;
        gap: 0;
        min-height: 320px;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-nav {
        width: 35%;
        flex-shrink: 0;
        display: flex;
        flex-direction: column;
        overflow-y: auto;
        max-height: 500px;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-tab {
        background-color: {$data['color_2']};
        color: {$data['color_1']};
        padding: 14px 20px;
        cursor: pointer;
        font-size: 1rem;
        font-weight: 600;
        line-height: 1.5;
        text-align: left;
        border: none;
        border-left: 4px solid transparent;
        transition: background-color 0.2s ease, border-color 0.2s ease, color 0.2s ease;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-tab + .{$name}-{$id}-tabs-tab {
        margin-top: 1px;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-tab:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-tab-active {
        background-color: {$data['color_6']};
        color: {$data['color_5']};
        border-left-color: {$data['color_1']};
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-tab-active:hover {
        background-color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-chevron {
        flex-shrink: 0;
        font-size: 0.75rem;
        opacity: 0;
        transition: opacity 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-tab-active .{$name}-{$id}-tabs-chevron {
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-panel-area {
        width: 65%;
        background-color: {$data['color_5']};
        padding: 32px;
        position: relative;
        min-height: 320px;
        display: flex;
        align-items: flex-start;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-panel {
        display: none;
        opacity: 0;
        transition: opacity 0.3s ease;
        width: 100%;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-panel-active {
        display: block;
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-tabs-answer-text {
        color: {$data['color_4']};
        font-size: 1rem;
        line-height: 1.8;
        text-align: left;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-tabs-layout {
            display: none;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-mobile {
            display: flex;
            flex-direction: column;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-item {
            margin-bottom: 1px;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-question {
            background-color: {$data['color_2']};
            color: {$data['color_1']};
            padding: 14px 20px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            line-height: 1.5;
            text-align: left;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
            border-left: 4px solid transparent;
            transition: background-color 0.2s ease, border-color 0.2s ease, color 0.2s ease;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-question:hover {
            background-color: {$data['color_3']};
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-question-active {
            background-color: {$data['color_6']};
            color: {$data['color_5']};
            border-left-color: {$data['color_1']};
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-question-active:hover {
            background-color: {$data['color_6']};
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-chevron {
            flex-shrink: 0;
            font-size: 0.75rem;
            transition: transform 0.3s ease;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-chevron-open {
            transform: rotate(90deg);
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-answer {
            overflow: hidden;
            max-height: 0;
            transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1), opacity 0.3s ease;
            opacity: 0;
            background-color: {$data['color_5']};
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-answer-visible {
            opacity: 1;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-m-answer-inner {
            padding: 24px 20px;
            color: {$data['color_4']};
            font-size: 0.95rem;
            line-height: 1.8;
            text-align: left;
        }

        .{$name}-{$id} .{$name}-{$id}-tabs-header {
            font-size: 1.5rem;
        }
    }

    @media (min-width: 769px) {
        .{$name}-{$id} .{$name}-{$id}-tabs-mobile {
            display: none;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-tabs-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-tabs-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-tabs-layout">
            <div class="{$name}-{$id}-tabs-nav">
                {foreach $data['qa'] as $key=>$value}
                    <div class="{$name}-{$id}-tabs-tab{if $key == 1} {$name}-{$id}-tabs-tab-active{/if}"
                         onclick="puqqatabs{$id}({$key})"
                         id="{$name}-{$id}-tabs-tab-{$key}">
                        <span>{$value['question']}</span>
                        <i class="fas fa-chevron-right {$name}-{$id}-tabs-chevron"></i>
                    </div>
                {/foreach}
            </div>

            <div class="{$name}-{$id}-tabs-panel-area">
                {foreach $data['qa'] as $key=>$value}
                    <div class="{$name}-{$id}-tabs-panel{if $key == 1} {$name}-{$id}-tabs-panel-active{/if}"
                         id="{$name}-{$id}-tabs-panel-{$key}">
                        <div class="{$name}-{$id}-tabs-answer-text">{$value['answer']}</div>
                    </div>
                {/foreach}
            </div>
        </div>

        <div class="{$name}-{$id}-tabs-mobile">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-tabs-m-item">
                    <div class="{$name}-{$id}-tabs-m-question"
                         onclick="puqqatabsmobile{$id}({$key})"
                         id="{$name}-{$id}-tabs-mq-{$key}">
                        <span>{$value['question']}</span>
                        <i class="fas fa-chevron-right {$name}-{$id}-tabs-m-chevron"
                           id="{$name}-{$id}-tabs-mc-{$key}"></i>
                    </div>
                    <div class="{$name}-{$id}-tabs-m-answer"
                         id="{$name}-{$id}-tabs-ma-{$key}">
                        <div class="{$name}-{$id}-tabs-m-answer-inner">{$value['answer']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqatabs{$id}(key) {
        var tabs = document.querySelectorAll('.{$name}-{$id}-tabs-tab');
        var panels = document.querySelectorAll('.{$name}-{$id}-tabs-panel');

        for (var i = 0; i < tabs.length; i++) {
            tabs[i].classList.remove('{$name}-{$id}-tabs-tab-active');
            panels[i].classList.remove('{$name}-{$id}-tabs-panel-active');
        }

        var activeTab = document.getElementById('{$name}-{$id}-tabs-tab-' + key);
        var activePanel = document.getElementById('{$name}-{$id}-tabs-panel-' + key);

        if (activeTab) {
            activeTab.classList.add('{$name}-{$id}-tabs-tab-active');
        }
        if (activePanel) {
            activePanel.style.opacity = '0';
            activePanel.classList.add('{$name}-{$id}-tabs-panel-active');
            setTimeout(function() {
                activePanel.style.opacity = '1';
            }, 10);
        }
    }

    function puqqatabsmobile{$id}(key) {
        var questions = document.querySelectorAll('.{$name}-{$id}-tabs-m-question');
        var answers = document.querySelectorAll('.{$name}-{$id}-tabs-m-answer');
        var chevrons = document.querySelectorAll('.{$name}-{$id}-tabs-m-chevron');

        for (var i = 0; i < answers.length; i++) {
            var itemKey = answers[i].id.split('-').pop();
            if (parseInt(itemKey) === key) {
                if (answers[i].style.maxHeight) {
                    answers[i].style.maxHeight = null;
                    answers[i].classList.remove('{$name}-{$id}-tabs-m-answer-visible');
                    questions[i].classList.remove('{$name}-{$id}-tabs-m-question-active');
                    chevrons[i].classList.remove('{$name}-{$id}-tabs-m-chevron-open');
                } else {
                    answers[i].style.maxHeight = answers[i].scrollHeight + 'px';
                    answers[i].classList.add('{$name}-{$id}-tabs-m-answer-visible');
                    questions[i].classList.add('{$name}-{$id}-tabs-m-question-active');
                    chevrons[i].classList.add('{$name}-{$id}-tabs-m-chevron-open');
                }
            } else {
                answers[i].style.maxHeight = null;
                answers[i].classList.remove('{$name}-{$id}-tabs-m-answer-visible');
                questions[i].classList.remove('{$name}-{$id}-tabs-m-question-active');
                chevrons[i].classList.remove('{$name}-{$id}-tabs-m-chevron-open');
            }
        }
    }
</script>