<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-split-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-split-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        padding: 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-split-panels {
        display: flex;
        gap: 20px;
        align-items: stretch;
    }

    .{$name}-{$id} .{$name}-{$id}-split-left {
        width: 40%;
        flex-shrink: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-split-right {
        width: 60%;
        flex-shrink: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-split-q-row {
        display: flex;
        align-items: center;
        gap: 14px;
        padding: 14px 16px;
        border-bottom: 1px solid {$data['color_2']};
        cursor: pointer;
        transition: background-color 0.25s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-split-q-row:last-child {
        border-bottom: none;
    }

    .{$name}-{$id} .{$name}-{$id}-split-q-row:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-split-q-row-active {
        background-color: {$data['color_2']};
        font-weight: bold;
    }

    .{$name}-{$id} .{$name}-{$id}-split-q-badge {
        width: 28px;
        height: 28px;
        min-width: 28px;
        border-radius: 50%;
        background-color: {$data['color_6']};
        color: {$data['color_5']};
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.8rem;
        font-weight: 700;
        line-height: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-split-q-text {
        color: {$data['color_1']};
        font-size: 1rem;
        line-height: 1.5;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-split-answer-panel {
        background-color: {$data['color_5']};
        border-radius: 12px;
        padding: 32px;
        min-height: 300px;
        display: flex;
        flex-direction: column;
    }

    .{$name}-{$id} .{$name}-{$id}-split-a-title {
        color: {$data['color_1']};
        font-size: 1.2rem;
        font-weight: 700;
        margin: 0 0 20px 0;
        padding: 0 0 16px 0;
        border-bottom: 2px solid {$data['color_6']};
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-split-a-content {
        position: relative;
        flex: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-split-a-block {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        opacity: 0;
        transition: opacity 0.35s ease;
        pointer-events: none;
    }

    .{$name}-{$id} .{$name}-{$id}-split-a-block-active {
        position: relative;
        opacity: 1;
        pointer-events: auto;
    }

    .{$name}-{$id} .{$name}-{$id}-split-a-text {
        color: {$data['color_4']};
        font-size: 1rem;
        line-height: 1.8;
        text-align: left;
    }

    /* Mobile accordion fallback */
    .{$name}-{$id} .{$name}-{$id}-split-mobile {
        display: none;
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-item {
        border-radius: 8px;
        overflow: hidden;
        border: 1px solid {$data['color_2']};
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-question {
        background-color: {$data['color_2']};
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 14px 18px;
        transition: background-color 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-question:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-q-left {
        display: flex;
        align-items: center;
        gap: 12px;
        flex: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-q-text {
        color: {$data['color_1']};
        font-size: 1rem;
        font-weight: 600;
        line-height: 1.5;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-icon {
        color: {$data['color_6']};
        font-size: 1rem;
        flex-shrink: 0;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-icon-open {
        transform: rotate(180deg);
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-answer {
        background-color: {$data['color_5']};
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
    }

    .{$name}-{$id} .{$name}-{$id}-split-mob-a-text {
        color: {$data['color_4']};
        padding: 20px 18px;
        text-align: left;
        font-size: 0.95rem;
        line-height: 1.7;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-split-header {
            font-size: 1.4rem;
            letter-spacing: 1px;
        }

        .{$name}-{$id} .{$name}-{$id}-split-panels {
            display: none;
        }

        .{$name}-{$id} .{$name}-{$id}-split-mobile {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-split-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-split-header">{$data['header']}</h2>
        {/if}

        <!-- Desktop: two-panel layout -->
        <div class="{$name}-{$id}-split-panels">
            <div class="{$name}-{$id}-split-left">
                {foreach $data['qa'] as $key=>$value}
                    <div class="{$name}-{$id}-split-q-row{if $key == 1} {$name}-{$id}-split-q-row-active{/if}"
                         id="{$name}-{$id}-split-q-{$key}"
                         onclick="puqqasplit{$id}({$key})">
                        <div class="{$name}-{$id}-split-q-badge">{$key}</div>
                        <div class="{$name}-{$id}-split-q-text">{$value['question']}</div>
                    </div>
                {/foreach}
            </div>

            <div class="{$name}-{$id}-split-right">
                <div class="{$name}-{$id}-split-answer-panel">
                    <h3 class="{$name}-{$id}-split-a-title" id="{$name}-{$id}-split-a-title"></h3>
                    <div class="{$name}-{$id}-split-a-content">
                        {foreach $data['qa'] as $key=>$value}
                            <div class="{$name}-{$id}-split-a-block{if $key == 1} {$name}-{$id}-split-a-block-active{/if}"
                                 id="{$name}-{$id}-split-a-{$key}">
                                <div class="{$name}-{$id}-split-a-text">{$value['answer']}</div>
                            </div>
                        {/foreach}
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile: accordion layout -->
        <div class="{$name}-{$id}-split-mobile">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-split-mob-item">
                    <div class="{$name}-{$id}-split-mob-question" onclick="puqqasplitmob{$id}({$key})">
                        <div class="{$name}-{$id}-split-mob-q-left">
                            <div class="{$name}-{$id}-split-q-badge">{$key}</div>
                            <div class="{$name}-{$id}-split-mob-q-text">{$value['question']}</div>
                        </div>
                        <i class="fas fa-chevron-down {$name}-{$id}-split-mob-icon" id="{$name}-{$id}-split-mob-icon-{$key}"></i>
                    </div>
                    <div class="{$name}-{$id}-split-mob-answer" id="{$name}-{$id}-split-mob-answer-{$key}">
                        <div class="{$name}-{$id}-split-mob-a-text">{$value['answer']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    (function() {
        // Set initial title on desktop
        var firstRow = document.getElementById('{$name}-{$id}-split-q-1');
        var titleEl = document.getElementById('{$name}-{$id}-split-a-title');
        if (firstRow && titleEl) {
            var firstText = firstRow.querySelector('.{$name}-{$id}-split-q-text');
            if (firstText) {
                titleEl.textContent = firstText.textContent;
            }
        }
    })();

    function puqqasplit{$id}(key) {
        var rows = document.querySelectorAll('.{$name}-{$id}-split-q-row');
        var blocks = document.querySelectorAll('.{$name}-{$id}-split-a-block');
        var titleEl = document.getElementById('{$name}-{$id}-split-a-title');

        for (var i = 0; i < rows.length; i++) {
            var rowKey = rows[i].id.split('-').pop();
            if (parseInt(rowKey) === key) {
                rows[i].classList.add('{$name}-{$id}-split-q-row-active');
                var qText = rows[i].querySelector('.{$name}-{$id}-split-q-text');
                if (qText && titleEl) {
                    titleEl.textContent = qText.textContent;
                }
            } else {
                rows[i].classList.remove('{$name}-{$id}-split-q-row-active');
            }
        }

        for (var j = 0; j < blocks.length; j++) {
            var blockKey = blocks[j].id.split('-').pop();
            if (parseInt(blockKey) === key) {
                blocks[j].classList.add('{$name}-{$id}-split-a-block-active');
            } else {
                blocks[j].classList.remove('{$name}-{$id}-split-a-block-active');
            }
        }
    }

    function puqqasplitmob{$id}(key) {
        var answers = document.querySelectorAll('.{$name}-{$id}-split-mob-answer');
        var icons = document.querySelectorAll('.{$name}-{$id}-split-mob-icon');

        for (var i = 0; i < answers.length; i++) {
            var itemKey = answers[i].id.split('-').pop();
            if (parseInt(itemKey) === key) {
                if (answers[i].style.maxHeight) {
                    answers[i].style.maxHeight = null;
                    icons[i].classList.remove('{$name}-{$id}-split-mob-icon-open');
                } else {
                    answers[i].style.maxHeight = answers[i].scrollHeight + 'px';
                    icons[i].classList.add('{$name}-{$id}-split-mob-icon-open');
                }
            } else {
                answers[i].style.maxHeight = null;
                icons[i].classList.remove('{$name}-{$id}-split-mob-icon-open');
            }
        }
    }
</script>