<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 3px;
        margin: 0 0 2rem 0;
        padding: 0;
        color: {$data['header_text_color']};
        text-shadow: 0 0 10px {$data['color_6']}40, 0 0 20px {$data['color_6']}20;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-body {
        position: relative;
        padding-left: 22px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-line {
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        width: 2px;
        background: {$data['color_6']};
        border-radius: 1px;
        box-shadow: 0 0 6px {$data['color_6']}60, 0 0 12px {$data['color_6']}30;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-list {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-item {
        border-radius: 8px;
        overflow: hidden;
        border: 1px solid {$data['color_6']};
        transition: box-shadow 0.35s ease;
        box-shadow: 0 0 0 0 transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-item:hover {
        box-shadow: 0 0 8px {$data['color_6']}40, 0 0 16px {$data['color_6']}20;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-item-active {
        box-shadow: 0 0 12px {$data['color_6']}60, 0 0 24px {$data['color_6']}30;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-question {
        background-color: {$data['color_2']};
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 22px;
        transition: background-color 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-question:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-neon-question-text {
        text-align: left;
        color: {$data['color_1']};
        font-size: 1.1rem;
        font-weight: 600;
        line-height: 1.5;
        flex: 1;
        padding-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-icon {
        color: {$data['color_6']};
        font-size: 1.3rem;
        flex-shrink: 0;
        display: inline-block;
        transition: transform 0.35s ease;
        transform: rotate(0deg);
    }

    .{$name}-{$id} .{$name}-{$id}-neon-icon-open {
        transform: rotate(90deg);
    }

    .{$name}-{$id} .{$name}-{$id}-neon-answer {
        background-color: {$data['color_5']};
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
        border-top: 0px solid transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-answer-open {
        border-top: 1px solid {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-neon-answer-text {
        color: {$data['color_4']};
        padding: 22px 24px;
        text-align: left;
        font-size: 1rem;
        line-height: 1.7;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-neon-header {
            font-size: 1.4rem;
            letter-spacing: 1px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-body {
            padding-left: 16px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-question {
            padding: 14px 16px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-question-text {
            font-size: 1rem;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-answer-text {
            padding: 18px;
            font-size: 0.95rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-neon-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-neon-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-neon-body">
            <div class="{$name}-{$id}-neon-line"></div>

            <div class="{$name}-{$id}-neon-list">
                {foreach $data['qa'] as $key=>$value}
                    <div class="{$name}-{$id}-neon-item" id="{$name}-{$id}-neon-item-{$key}">
                        <div class="{$name}-{$id}-neon-question" onclick="puqqaneon{$id}({$key})">
                            <div class="{$name}-{$id}-neon-question-text">{$value['question']}</div>
                            <span class="{$name}-{$id}-neon-icon" id="{$name}-{$id}-neon-icon-{$key}">&rsaquo;</span>
                        </div>
                        <div class="{$name}-{$id}-neon-answer" id="{$name}-{$id}-neon-answer-{$key}">
                            <div class="{$name}-{$id}-neon-answer-text">{$value['answer']}</div>
                        </div>
                    </div>
                {/foreach}
            </div>
        </div>
    </div>
</div>

<script>
    function puqqaneon{$id}(key) {
        var answers = document.querySelectorAll('.{$name}-{$id}-neon-answer');
        var icons = document.querySelectorAll('.{$name}-{$id}-neon-icon');
        var items = document.querySelectorAll('.{$name}-{$id}-neon-item');

        for (var i = 0; i < answers.length; i++) {
            var itemKey = answers[i].id.split('-').pop();
            if (parseInt(itemKey) === key) {
                if (answers[i].style.maxHeight) {
                    answers[i].style.maxHeight = null;
                    answers[i].classList.remove('{$name}-{$id}-neon-answer-open');
                    icons[i].classList.remove('{$name}-{$id}-neon-icon-open');
                    items[i].classList.remove('{$name}-{$id}-neon-item-active');
                } else {
                    answers[i].style.maxHeight = answers[i].scrollHeight + 'px';
                    answers[i].classList.add('{$name}-{$id}-neon-answer-open');
                    icons[i].classList.add('{$name}-{$id}-neon-icon-open');
                    items[i].classList.add('{$name}-{$id}-neon-item-active');
                }
            } else {
                answers[i].style.maxHeight = null;
                answers[i].classList.remove('{$name}-{$id}-neon-answer-open');
                icons[i].classList.remove('{$name}-{$id}-neon-icon-open');
                items[i].classList.remove('{$name}-{$id}-neon-item-active');
            }
        }
    }
</script>