<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-header {
        z-index: 2;
        text-align: left;
        font-size: 2.2rem;
        font-weight: 300;
        letter-spacing: 0;
        margin: 0 0 2rem 0;
        padding: 0;
        color: {$data['header_text_color']};
        line-height: 1.3;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-list {
        display: flex;
        flex-direction: column;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-item {
        border-bottom: 1px solid {$data['color_2']};
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-item:last-child {
        border-bottom: none;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-question {
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 0;
        transition: opacity 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-question:hover {
        opacity: 0.7;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-question-text {
        text-align: left;
        color: {$data['color_1']};
        font-size: 1.1rem;
        font-weight: 600;
        line-height: 1.5;
        flex: 1;
        padding-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-icon {
        color: {$data['color_1']};
        font-size: 0.85rem;
        flex-shrink: 0;
        transition: transform 0.35s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-icon-open {
        transform: rotate(180deg);
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-answer {
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1), opacity 0.3s ease;
        opacity: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-answer-visible {
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-answer-inner {
        padding: 0 0 20px 20px;
        border-left: 2px solid {$data['color_6']};
        margin-left: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-answer-text {
        color: {$data['color_4']};
        text-align: left;
        font-size: 0.95rem;
        line-height: 1.8;
        font-weight: 400;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-minimal-header {
            font-size: 1.6rem;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-question {
            padding: 14px 0;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-question-text {
            font-size: 1rem;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-answer-text {
            font-size: 0.9rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-minimal-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-minimal-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-minimal-list">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-minimal-item">
                    <div class="{$name}-{$id}-minimal-question" onclick="puqqaminimal{$id}({$key})">
                        <div class="{$name}-{$id}-minimal-question-text">{$value['question']}</div>
                        <i class="fas fa-chevron-down {$name}-{$id}-minimal-icon" id="{$name}-{$id}-minimal-icon-{$key}"></i>
                    </div>
                    <div class="{$name}-{$id}-minimal-answer" id="{$name}-{$id}-minimal-answer-{$key}">
                        <div class="{$name}-{$id}-minimal-answer-inner">
                            <div class="{$name}-{$id}-minimal-answer-text">{$value['answer']}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqaminimal{$id}(key) {
        var items = document.querySelectorAll('.{$name}-{$id}-minimal-answer');
        var icons = document.querySelectorAll('.{$name}-{$id}-minimal-icon');

        for (var i = 0; i < items.length; i++) {
            var itemKey = items[i].id.split('-').pop();
            if (parseInt(itemKey) === key) {
                if (items[i].style.maxHeight) {
                    items[i].style.maxHeight = null;
                    items[i].classList.remove('{$name}-{$id}-minimal-answer-visible');
                    icons[i].classList.remove('{$name}-{$id}-minimal-icon-open');
                } else {
                    items[i].style.maxHeight = items[i].scrollHeight + 'px';
                    items[i].classList.add('{$name}-{$id}-minimal-answer-visible');
                    icons[i].classList.add('{$name}-{$id}-minimal-icon-open');
                }
            } else {
                items[i].style.maxHeight = null;
                items[i].classList.remove('{$name}-{$id}-minimal-answer-visible');
                icons[i].classList.remove('{$name}-{$id}-minimal-icon-open');
            }
        }
    }
</script>