<style>
    .{$name}-{$id}-bubble- {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id}-bubble-container {
        position: relative;
        z-index: 2;
        display: inline-block;
        width: 100%;
        text-align: center;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
    }

    .{$name}-{$id}-bubble-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id}-bubble-qa-list {
        display: flex;
        flex-direction: column;
        gap: 20px;
        text-align: left;
    }

    .{$name}-{$id}-bubble-item {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    /* --- Question row: avatar + bubble --- */
    .{$name}-{$id}-bubble-q-row {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        max-width: 85%;
        cursor: pointer;
    }

    .{$name}-{$id}-bubble-q-avatar {
        flex-shrink: 0;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: {$data['color_6']};
        color: {$data['color_5']};
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        font-weight: 700;
        margin-top: 4px;
    }

    .{$name}-{$id}-bubble-q-bubble {
        background-color: {$data['color_2']};
        border-radius: 18px 18px 18px 4px;
        padding: 14px 20px;
        color: {$data['color_1']};
        font-weight: 600;
        font-size: 1.1rem;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
        transition: background-color 0.2s ease;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    }

    .{$name}-{$id}-bubble-q-bubble:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id}-bubble-q-text {
        flex: 1;
    }

    .{$name}-{$id}-bubble-chevron {
        color: {$data['color_1']};
        font-size: 0.85rem;
        transition: transform 0.3s ease;
        flex-shrink: 0;
    }

    .{$name}-{$id}-bubble-chevron.open {
        transform: rotate(180deg);
    }

    /* --- Answer row: bubble + avatar --- */
    .{$name}-{$id}-bubble-a-row {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        max-width: 85%;
        margin-left: auto;
        flex-direction: row-reverse;
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1),
                    opacity 0.3s ease;
        opacity: 0;
    }

    .{$name}-{$id}-bubble-a-row.open {
        opacity: 1;
    }

    .{$name}-{$id}-bubble-a-avatar {
        flex-shrink: 0;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: {$data['color_1']};
        color: {$data['color_5']};
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        font-weight: 700;
        margin-top: 4px;
    }

    .{$name}-{$id}-bubble-a-bubble {
        background-color: {$data['color_5']};
        border-radius: 18px 18px 4px 18px;
        padding: 14px 20px;
        color: {$data['color_4']};
        font-size: 1rem;
        line-height: 1.6;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-bubble-q-row,
        .{$name}-{$id}-bubble-a-row {
            max-width: 100%;
        }
    }
</style>

<div class="{$name}-{$id}-bubble-">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-bubble-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-bubble-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-bubble-qa-list">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-bubble-item">
                    <div class="{$name}-{$id}-bubble-q-row" onclick="puqqabubble{$id}({$key})">
                        <div class="{$name}-{$id}-bubble-q-avatar">Q</div>
                        <div class="{$name}-{$id}-bubble-q-bubble">
                            <span class="{$name}-{$id}-bubble-q-text">{$value['question']}</span>
                            <i class="fas fa-chevron-down {$name}-{$id}-bubble-chevron"></i>
                        </div>
                    </div>
                    <div class="{$name}-{$id}-bubble-a-row">
                        <div class="{$name}-{$id}-bubble-a-avatar">A</div>
                        <div class="{$name}-{$id}-bubble-a-bubble">{$value['answer']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqabubble{$id}(item) {
        var answers{$id} = document.getElementsByClassName("{$name}-{$id}-bubble-a-row");
        var chevrons{$id} = document.getElementsByClassName("{$name}-{$id}-bubble-chevron");

        for (var i = 0; i < answers{$id}.length; i++) {
            if (i + 1 === item) {
                if (answers{$id}[i].style.maxHeight) {
                    answers{$id}[i].style.maxHeight = null;
                    answers{$id}[i].classList.remove("open");
                    chevrons{$id}[i].classList.remove("open");
                } else {
                    answers{$id}[i].style.maxHeight = answers{$id}[i].scrollHeight + "px";
                    answers{$id}[i].classList.add("open");
                    chevrons{$id}[i].classList.add("open");
                }
            } else {
                answers{$id}[i].style.maxHeight = null;
                answers{$id}[i].classList.remove("open");
                chevrons{$id}[i].classList.remove("open");
            }
        }
    }
</script>
