<style>
    .{$name}-{$id} {
        padding-left: 0 !important;
        padding-right: 0 !important;
    }

    .{$name}-{$id}-slider- {
        position: relative;
        overflow: hidden;
    {if $data['width']}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {else}
        width: 100%;
    {/if}
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 500px;
    {/if}
    }

    .{$name}-{$id}-slide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.8s ease, visibility 0.8s ease;
        display: grid;
        grid-template-columns: 1fr;
        grid-template-rows: auto 1fr;
        align-items: center;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
    }

    .{$name}-{$id}-slide-active- {
        opacity: 1;
        visibility: visible;
    }

    .{$name}-{$id}-bg- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 0;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
    }

    .{$name}-{$id}-body- {
        position: relative;
        z-index: 1;
        display: grid;
        grid-template-columns: 1fr 1fr;
        align-items: center;
        gap: 20px;
        height: 100%;
        padding: 30px 50px;
    {if !$data['disable_nav_button']}
        padding-bottom: 80px;
    {/if}
    }

    .{$name}-{$id}-header- {
        grid-column: 1 / -1;
        text-align: center;
        padding: 10px 20px 0 20px;
        font-weight: 800;
        line-height: 1.2;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id}-left- {
        display: flex;
        flex-direction: column;
        justify-content: center;
        gap: 20px;
        padding: 0 20px;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id}-desc- {
        line-height: 1.7;
        font-weight: 400;
    }

    .{$name}-{$id}-btnwrap- {
        padding-top: 8px;
    }

    .{$name}-{$id}-btn- {
        display: inline-block;
        padding: 12px 36px;
        font-size: 15px;
        font-weight: 600;
        text-decoration: none;
        border-radius: 6px;
        transition: transform 0.25s ease, box-shadow 0.25s ease, filter 0.25s ease;
        cursor: pointer;
    }

    .{$name}-{$id}-btn-:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.25);
        filter: brightness(1.1);
        text-decoration: none;
    }

    .{$name}-{$id}-right- {
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id}-img- {
        max-width: 100%;
        max-height: 380px;
        object-fit: contain;
        border-radius: 8px;
    }

    .{$name}-{$id}-tabs- {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        z-index: 10;
        display: flex;
    }

    .{$name}-{$id}-tab- {
        flex: 1;
        padding: 18px 12px;
        text-align: center;
        cursor: pointer;
        font-size: 14px;
        font-weight: 600;
        transition: border-top 0.3s ease, background 0.3s ease, padding-top 0.3s ease;
        border-top: 4px solid transparent;
        background: rgba(0, 0, 0, 0.25);
        backdrop-filter: blur(6px);
        position: relative;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .{$name}-{$id}-tab-:hover {
        background: rgba(0, 0, 0, 0.4);
        padding-top: 14px;
    }

    .{$name}-{$id}-tab-active- {
        background: rgba(0, 0, 0, 0.45);
        padding-top: 14px;
    }

    .{$name}-{$id}-progress- {
        position: absolute;
        bottom: 0;
        left: 0;
        height: 3px;
        width: 0;
        transition: width linear;
    }

    .{$name}-{$id}-progress-run- {
        width: 100%;
    }

    @media screen and (max-width: 991px) {
        .{$name}-{$id}-body- {
            grid-template-columns: 1fr;
            padding: 20px 24px;
        {if !$data['disable_nav_button']}
            padding-bottom: 70px;
        {/if}
        }

        .{$name}-{$id}-right- {
            display: none;
        }

        .{$name}-{$id}-left- {
            text-align: center;
        }

        .{$name}-{$id}-btnwrap- {
            text-align: center;
        }

        .{$name}-{$id}-header- {
            padding: 5px 10px 0 10px;
        }

        .{$name}-{$id}-tab- {
            font-size: 11px;
            padding: 12px 6px;
        }
    }

    @media screen and (max-width: 600px) {
        .{$name}-{$id}-body- {
            padding: 14px 14px;
        {if !$data['disable_nav_button']}
            padding-bottom: 60px;
        {/if}
        }

        .{$name}-{$id}-tab- {
            font-size: 10px;
            padding: 10px 4px;
        }

        .{$name}-{$id}-btn- {
            padding: 10px 24px;
            font-size: 13px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-slider-" id="{$name}-{$id}-slider">
        {$i = 1}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-slide-{if $i == 1} {$name}-{$id}-slide-active-{/if}"
                 id="{$name}-{$id}-slide-{$i}"
                 data-index="{$i}">

                <div class="{$name}-{$id}-bg-"
                     style="background-color: {$member['member_background_color']};{if $member['member_background_img']} background-image: url('{$member['member_background_img']}');{/if}">
                </div>

                <div class="{$name}-{$id}-body-">
                    {if $member['member_header']}
                        <div class="{$name}-{$id}-header-"
                             style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">
                            {$member['member_header']}
                        </div>
                    {/if}

                    <div class="{$name}-{$id}-left-">
                        {if $member['member_description']}
                            <div class="{$name}-{$id}-desc-"
                                 style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">
                                {$member['member_description']}
                            </div>
                        {/if}
                        {if $member['member_button_text']}
                            <div class="{$name}-{$id}-btnwrap-">
                                <a href="{$member['member_button_url']}"
                                   {if $member['mmnew_tab']}target="_blank"{/if}
                                   class="{$name}-{$id}-btn-"
                                   style="color: {$member['member_button_color_text']}; background-color: {$member['member_button_color']}; border: 2px solid {$member['member_button_color_border']};">
                                    {$member['member_button_text']}
                                </a>
                            </div>
                        {/if}
                    </div>

                    {if $member['member_img']}
                        <div class="{$name}-{$id}-right-">
                            <img class="{$name}-{$id}-img-"
                                 src="{$member['member_img']}"
                                 alt="{$member['member_header']}" />
                        </div>
                    {/if}
                </div>
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
            <div class="{$name}-{$id}-tabs-" id="{$name}-{$id}-tabs">
                {$i = 1}
                {foreach $data['members'] as $member}
                    <div class="{$name}-{$id}-tab-{if $i == 1} {$name}-{$id}-tab-active-{/if}"
                         id="{$name}-{$id}-tab-{$i}"
                         data-slide="{$i}"
                         style="color: {$member['member_header_color']};"
                         onclick="puqSlider_{$name}_{$id}.goTo({$i})">
                        {$member['member_header']}
                        <div class="{$name}-{$id}-progress-"
                             id="{$name}-{$id}-progress-{$i}"
                             style="background-color: {$member['member_button_color']};"></div>
                    </div>
                    {$i = $i + 1}
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var ns = "{$name}";
        var id = "{$id}";
        var totalSlides = {$data['members']|count};
        var currentSlide = 1;
        var autoplayInterval = null;
        var autoplayDelay = 5000;
        var isPaused = false;
        var progressTimer = null;

        function getEl(suffix) {
            return document.getElementById(ns + "-" + id + "-" + suffix);
        }

        function getAllSlides() {
            var slider = getEl("slider");
            if (!slider) return [];
            return slider.querySelectorAll("." + ns + "-" + id + "-slide-");
        }

        function getAllTabs() {
            var tabs = getEl("tabs");
            if (!tabs) return [];
            return tabs.querySelectorAll("." + ns + "-" + id + "-tab-");
        }

        function showSlide(index) {
            if (index < 1 || index > totalSlides) return;
            var slides = getAllSlides();
            var tabs = getAllTabs();

            for (var s = 0; s < slides.length; s++) {
                slides[s].classList.remove(ns + "-" + id + "-slide-active-");
            }
            for (var t = 0; t < tabs.length; t++) {
                tabs[t].classList.remove(ns + "-" + id + "-tab-active-");
                var prog = getEl("progress-" + (t + 1));
                if (prog) {
                    prog.style.transition = "none";
                    prog.classList.remove(ns + "-" + id + "-progress-run-");
                    prog.style.width = "0";
                }
            }

            var target = getEl("slide-" + index);
            if (target) target.classList.add(ns + "-" + id + "-slide-active-");

            var tab = getEl("tab-" + index);
            if (tab) tab.classList.add(ns + "-" + id + "-tab-active-");

            currentSlide = index;
            startProgress();
        }

        function startProgress() {
            var prog = getEl("progress-" + currentSlide);
            if (!prog) return;
            prog.style.transition = "none";
            prog.style.width = "0";
            prog.classList.remove(ns + "-" + id + "-progress-run-");
            void prog.offsetWidth;
            prog.style.transition = "width " + (autoplayDelay / 1000) + "s linear";
            prog.classList.add(ns + "-" + id + "-progress-run-");
        }

        function nextSlide() {
            var next = currentSlide + 1;
            if (next > totalSlides) next = 1;
            showSlide(next);
        }

        function startAutoplay() {
            stopAutoplay();
            autoplayInterval = setInterval(function() {
                if (!isPaused) {
                    nextSlide();
                }
            }, autoplayDelay);
            startProgress();
        }

        function stopAutoplay() {
            if (autoplayInterval) {
                clearInterval(autoplayInterval);
                autoplayInterval = null;
            }
        }

        var api = {
            goTo: function(index) {
                showSlide(index);
                stopAutoplay();
                startAutoplay();
            }
        };

        window["puqSlider_" + ns + "_" + id] = api;

        var slider = getEl("slider");
        if (slider) {
            slider.addEventListener("mouseenter", function() {
                isPaused = true;
                var prog = getEl("progress-" + currentSlide);
                if (prog) {
                    prog.style.transition = "none";
                    var w = prog.getBoundingClientRect().width;
                    var parentW = prog.parentElement.getBoundingClientRect().width;
                    if (parentW > 0) {
                        prog.style.width = ((w / parentW) * 100) + "%";
                    }
                }
            });

            slider.addEventListener("mouseleave", function() {
                isPaused = false;
                var prog = getEl("progress-" + currentSlide);
                if (prog) {
                    var currentW = parseFloat(prog.style.width) || 0;
                    var remaining = ((100 - currentW) / 100) * autoplayDelay;
                    if (remaining < 200) remaining = autoplayDelay;
                    prog.style.transition = "width " + (remaining / 1000) + "s linear";
                    prog.classList.add(ns + "-" + id + "-progress-run-");
                }
            });
        }

        if (totalSlides > 1) {
            startAutoplay();
        }
    })();
</script>