<style>
    .{$name}-{$id} {
        padding-left: 0 !important;
        padding-right: 0 !important;
    }

    .{$name}-{$id}-slider- {
        position: relative;
        overflow: hidden;
    {if $data['width']}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {else}
        width: 100%;
    {/if}
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 500px;
    {/if}
    }

    .{$name}-{$id}-slide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.8s ease, visibility 0.8s ease, transform 0.8s ease;
        transform: scale(1.04);
    }

    .{$name}-{$id}-slide-active- {
        opacity: 1;
        visibility: visible;
        transform: scale(1);
    }

    .{$name}-{$id}-bg- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        z-index: 0;
    }

    .{$name}-{$id}-overlay- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
        opacity: 0.7;
    }

    .{$name}-{$id}-body- {
        position: relative;
        z-index: 2;
        display: flex;
        align-items: center;
        gap: 40px;
        height: 100%;
        padding: 40px 60px;
        box-sizing: border-box;
    {if !$data['disable_nav_button']}
        padding-bottom: 80px;
    {/if}
    }

    .{$name}-{$id}-vline- {
        position: absolute;
        left: 40px;
        top: 15%;
        height: 70%;
        width: 2px;
        z-index: 2;
        box-shadow: 0 0 8px currentColor, 0 0 20px currentColor;
    }

    .{$name}-{$id}-content- {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
        gap: 18px;
        padding-left: 30px;
        min-width: 0;
    }

    .{$name}-{$id}-title- {
        margin: 0;
        font-weight: 800;
        line-height: 1.2;
        word-wrap: break-word;
    }

    .{$name}-{$id}-desc- {
        margin: 0;
        line-height: 1.7;
        font-weight: 400;
        word-wrap: break-word;
        opacity: 0.85;
    }

    .{$name}-{$id}-btn- {
        display: inline-block;
        padding: 12px 36px;
        font-size: 15px;
        font-weight: 600;
        text-decoration: none;
        border-radius: 6px;
        border: 2px solid;
        background: transparent;
        cursor: pointer;
        transition: background-color 0.3s ease, box-shadow 0.3s ease, transform 0.3s ease;
        align-self: flex-start;
        margin-top: 6px;
    }

    .{$name}-{$id}-btn-:hover {
        transform: translateY(-2px);
        text-decoration: none;
    }

    .{$name}-{$id}-img-wrap- {
        flex-shrink: 0;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .{$name}-{$id}-img- {
        width: 200px;
        height: 200px;
        object-fit: cover;
        border-radius: 12px;
        border: 2px solid;
        transition: box-shadow 0.4s ease;
    }

    .{$name}-{$id}-neon-line- {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 1px;
        z-index: 3;
    }

    .{$name}-{$id}-nav- {
        position: absolute;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        display: flex;
        align-items: center;
        gap: 14px;
    }

    @keyframes {$name}-{$id}-pulse {
        0%   { box-shadow: 0 0 4px currentColor, 0 0 8px currentColor; }
        50%  { box-shadow: 0 0 8px currentColor, 0 0 20px currentColor, 0 0 30px currentColor; }
        100% { box-shadow: 0 0 4px currentColor, 0 0 8px currentColor; }
    }

    .{$name}-{$id}-dot- {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        border: 2px solid;
        background: transparent;
        cursor: pointer;
        padding: 0;
        opacity: 0.4;
        transition: opacity 0.3s ease, transform 0.3s ease;
    }

    .{$name}-{$id}-dot-:hover {
        opacity: 0.7;
    }

    .{$name}-{$id}-dot-active- {
        opacity: 1;
        transform: scale(1.3);
        animation: {$name}-{$id}-pulse 2s ease-in-out infinite;
    }

    {$i = 0}
    {foreach $data['members'] as $member}
    .{$name}-{$id}-btn-{$i}- {
        color: {$member['member_button_color_text']};
        border-color: {$member['member_button_color']};
        box-shadow: 0 0 15px {$member['member_button_color']}80, inset 0 0 15px {$member['member_button_color']}1A;
    }
    .{$name}-{$id}-btn-{$i}-:hover {
        background-color: {$member['member_button_color']};
        box-shadow: 0 0 20px {$member['member_button_color']}B3, 0 0 40px {$member['member_button_color']}66, inset 0 0 20px {$member['member_button_color']}33;
    }
    .{$name}-{$id}-title-{$i}- {
        text-shadow: 0 0 10px {$member['member_header_color']}80, 0 0 30px {$member['member_header_color']}40;
    }
    .{$name}-{$id}-img-{$i}- {
        border-color: {$member['member_button_color']};
        box-shadow: 0 0 15px {$member['member_button_color']}80, 0 0 30px {$member['member_button_color']}40;
    }
    .{$name}-{$id}-img-{$i}-:hover {
        box-shadow: 0 0 20px {$member['member_button_color']}B3, 0 0 40px {$member['member_button_color']}66;
    }
    .{$name}-{$id}-vline-{$i}- {
        background-color: {$member['member_button_color']};
        color: {$member['member_button_color']};
    }
    .{$name}-{$id}-neon-line-{$i}- {
        background-color: {$member['member_button_color']};
        box-shadow: 0 0 6px {$member['member_button_color']}B3, 0 0 16px {$member['member_button_color']}66;
    }
    .{$name}-{$id}-dot-{$i}- {
        border-color: {$member['member_button_color']};
        color: {$member['member_button_color']};
    }
    .{$name}-{$id}-dot-{$i}-active- {
        background-color: {$member['member_button_color']};
    }
    {$i = $i + 1}
    {/foreach}

    @media screen and (max-width: 991px) {
        .{$name}-{$id}-body- {
            flex-direction: column;
            padding: 30px 30px;
            gap: 20px;
            text-align: center;
        {if !$data['disable_nav_button']}
            padding-bottom: 70px;
        {/if}
        }

        .{$name}-{$id}-content- {
            padding-left: 0;
            align-items: center;
        }

        .{$name}-{$id}-btn- {
            align-self: center;
        }

        .{$name}-{$id}-img-wrap- {
            display: none;
        }

        .{$name}-{$id}-vline- {
            display: none;
        }
    }

    @media screen and (max-width: 600px) {
        .{$name}-{$id}-body- {
            padding: 20px 18px;
        {if !$data['disable_nav_button']}
            padding-bottom: 60px;
        {/if}
        }

        .{$name}-{$id}-title- {
            font-size: 22px !important;
        }

        .{$name}-{$id}-desc- {
            font-size: 13px !important;
        }

        .{$name}-{$id}-btn- {
            padding: 10px 28px;
            font-size: 13px;
        }

        .{$name}-{$id}-nav- {
            bottom: 14px;
            gap: 10px;
        }

        .{$name}-{$id}-dot- {
            width: 10px;
            height: 10px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-slider-" id="{$name}-{$id}-slider">
        {$i = 0}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-slide-{if $i == 0} {$name}-{$id}-slide-active-{/if}"
                 id="{$name}-{$id}-slide-{$i}">

                <div class="{$name}-{$id}-bg-"
                     style="background-color: {$member['member_background_color']};{if $member['member_background_img']} background-image: url('{$member['member_background_img']}');{/if}">
                </div>

                <div class="{$name}-{$id}-overlay-"
                     style="background-color: {$member['member_background_color']};">
                </div>

                <div class="{$name}-{$id}-vline- {$name}-{$id}-vline-{$i}-"></div>

                <div class="{$name}-{$id}-body-">
                    <div class="{$name}-{$id}-content-">
                        {if $member['member_header']}
                            <div class="{$name}-{$id}-title- {$name}-{$id}-title-{$i}-"
                                 style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">
                                {$member['member_header']}
                            </div>
                        {/if}
                        {if $member['member_description']}
                            <div class="{$name}-{$id}-desc-"
                                 style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">
                                {$member['member_description']}
                            </div>
                        {/if}
                        {if $member['member_button_text']}
                            <a href="{$member['member_button_url']}"
                               {if $member['mmnew_tab']}target="_blank"{/if}
                               class="{$name}-{$id}-btn- {$name}-{$id}-btn-{$i}-">
                                {$member['member_button_text']}
                            </a>
                        {/if}
                    </div>

                    {if $member['member_img']}
                        <div class="{$name}-{$id}-img-wrap-">
                            <img class="{$name}-{$id}-img- {$name}-{$id}-img-{$i}-"
                                 src="{$member['member_img']}"
                                 alt="{$member['member_header']}" />
                        </div>
                    {/if}
                </div>

                <div class="{$name}-{$id}-neon-line- {$name}-{$id}-neon-line-{$i}-"></div>
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
            <div class="{$name}-{$id}-nav-" id="{$name}-{$id}-nav">
                {$i = 0}
                {foreach $data['members'] as $member}
                    <button type="button"
                            class="{$name}-{$id}-dot- {$name}-{$id}-dot-{$i}-{if $i == 0} {$name}-{$id}-dot-active- {$name}-{$id}-dot-{$i}-active-{/if}"
                            id="{$name}-{$id}-dot-{$i}"
                            data-slide="{$i}"
                            onclick="puqNeon_{$name}_{$id}.goTo({$i})">
                    </button>
                    {$i = $i + 1}
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var PREFIX = "{$name}-{$id}";
        var slider = document.getElementById(PREFIX + "-slider");
        if (!slider) return;

        var totalSlides = {$data['members']|count};
        var current = 0;
        var autoInterval = null;
        var paused = false;
        var DELAY = 5000;

        /* per-slide dot color classes */
        var dotActiveClasses = [];
        {$i = 0}
        {foreach $data['members'] as $member}
        dotActiveClasses.push(PREFIX + "-dot-{$i}-active-");
        {$i = $i + 1}
        {/foreach}

        function getSlide(i) {
            return document.getElementById(PREFIX + "-slide-" + i);
        }

        function getDot(i) {
            return document.getElementById(PREFIX + "-dot-" + i);
        }

        function showSlide(index) {
            if (index < 0) index = totalSlides - 1;
            if (index >= totalSlides) index = 0;

            for (var s = 0; s < totalSlides; s++) {
                var sl = getSlide(s);
                if (sl) sl.classList.remove(PREFIX + "-slide-active-");
                var dt = getDot(s);
                if (dt) {
                    dt.classList.remove(PREFIX + "-dot-active-");
                    if (dotActiveClasses[s]) dt.classList.remove(dotActiveClasses[s]);
                }
            }

            var target = getSlide(index);
            if (target) target.classList.add(PREFIX + "-slide-active-");

            var dot = getDot(index);
            if (dot) {
                dot.classList.add(PREFIX + "-dot-active-");
                if (dotActiveClasses[index]) dot.classList.add(dotActiveClasses[index]);
            }

            current = index;
        }

        function nextSlide() {
            showSlide(current + 1);
        }

        function startAuto() {
            stopAuto();
            autoInterval = setInterval(function() {
                if (!paused) nextSlide();
            }, DELAY);
        }

        function stopAuto() {
            if (autoInterval) {
                clearInterval(autoInterval);
                autoInterval = null;
            }
        }

        var api = {
            goTo: function(index) {
                showSlide(index);
                startAuto();
            }
        };

        window["puqNeon_" + PREFIX.replace("-", "_")] = api;
        window["puqNeon_{$name}_{$id}"] = api;

        slider.addEventListener("mouseenter", function() {
            paused = true;
        });

        slider.addEventListener("mouseleave", function() {
            paused = false;
        });

        var touchStartX = 0;
        slider.addEventListener("touchstart", function(e) {
            touchStartX = e.changedTouches[0].screenX;
            paused = true;
        }, { passive: true });

        slider.addEventListener("touchend", function(e) {
            var diff = touchStartX - e.changedTouches[0].screenX;
            if (Math.abs(diff) > 50) {
                if (diff > 0) {
                    showSlide(current + 1);
                } else {
                    showSlide(current - 1);
                }
                startAuto();
            }
            paused = false;
        }, { passive: true });

        if (totalSlides > 1) {
            startAuto();
        }
    })();
</script>
