<style>
    .{$name}-{$id} {
        padding-left: 0;
        padding-right: 0;
        padding-top: 0;
        padding-bottom: 0;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id}-slider- {
        position: relative;
    {if $data['width']}
        width: {$data['width']};
        margin: 0 auto;
    {else}
        width: 100%;
    {/if}
        min-height: {if $data['height'] neq ''}{$data['height']}{else}70vh{/if};
    }

    .{$name}-{$id}-slide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: opacity 0.8s ease, background-color 0.8s ease;
        pointer-events: none;
        padding: 80px 40px;
        box-sizing: border-box;
    }

    .{$name}-{$id}-slide-active- {
        opacity: 1;
        pointer-events: auto;
    }

    .{$name}-{$id}-counter- {
        position: absolute;
        top: 32px;
        right: 40px;
        font-size: 0.85rem;
        font-weight: 300;
        letter-spacing: 2px;
        z-index: 5;
        opacity: 0.6;
        font-variant-numeric: tabular-nums;
        transition: color 0.8s ease;
    }

    .{$name}-{$id}-title- {
        font-weight: 700;
        line-height: 1.1;
        letter-spacing: -1px;
        margin: 0 0 24px 0;
        text-align: center;
        max-width: 800px;
        transition: color 0.8s ease;
    }

    .{$name}-{$id}-desc- {
        font-weight: 300;
        line-height: 1.7;
        margin: 0 0 40px 0;
        text-align: center;
        max-width: 560px;
        opacity: 0.85;
        transition: color 0.8s ease;
    }

    .{$name}-{$id}-link- {
        display: inline-block;
        text-decoration: none;
        font-weight: 500;
        font-size: 1rem;
        letter-spacing: 0.5px;
        position: relative;
        padding-bottom: 4px;
        transition: color 0.3s ease;
    }

    .{$name}-{$id}-link-::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 1.5px;
        background: currentColor;
        transform: scaleX(0.6);
        transform-origin: left;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id}-link-:hover::after {
        transform: scaleX(1);
    }

    .{$name}-{$id}-progress- {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 3px;
        z-index: 5;
        overflow: hidden;
    }

    .{$name}-{$id}-progress-bar- {
        height: 100%;
        width: 0%;
        transition: width 0.1s linear;
    }

    .{$name}-{$id}-progress-bar-running- {
        width: 100%;
        transition: width 5s linear;
    }

    .{$name}-{$id}-progress-bar-reset- {
        width: 0%;
        transition: none;
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-slider- {
            min-height: {if $data['height'] neq ''}{$data['height']}{else}50vh{/if};
        }

        .{$name}-{$id}-slide- {
            padding: 60px 24px;
        }

        .{$name}-{$id}-title- {
            letter-spacing: -0.5px;
        }

        .{$name}-{$id}-counter- {
            top: 20px;
            right: 24px;
            font-size: 0.75rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    <div class="{$name}-{$id}-slider-" id="{$name}-{$id}-slider">
        <div class="{$name}-{$id}-counter-" id="{$name}-{$id}-counter"></div>

        {$i = 0}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-slide-{if $i == 0} {$name}-{$id}-slide-active-{/if}"
                 id="{$name}-{$id}-slide-{$i}"
                 style="background-color: {$member['member_background_color']};">

                <div class="{$name}-{$id}-title-"
                     style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">
                    {$member['member_header']}
                </div>

                <div class="{$name}-{$id}-desc-"
                     style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">
                    {$member['member_description']}
                </div>

                {if $member['member_button_text']}
                    <a href="{$member['member_button_url']}"
                       {if $member['mmnew_tab']}target="_blank"{/if}
                       class="{$name}-{$id}-link-"
                       style="color: {$member['member_button_color']};">
                        {$member['member_button_text']}
                    </a>
                {/if}
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
        <div class="{$name}-{$id}-progress-">
            <div class="{$name}-{$id}-progress-bar-" id="{$name}-{$id}-progress-bar"></div>
        </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var prefix = "{$name}-{$id}";
        var totalSlides = {$i};
        if (totalSlides < 1) return;

        var currentIndex = 0;
        var interval = 5000;
        var timer = null;
        var paused = false;

        var slider = document.getElementById(prefix + "-slider");
        var counter = document.getElementById(prefix + "-counter");
        var progressBar = document.getElementById(prefix + "-progress-bar");
        var slides = [];
        var colors = [];

        for (var s = 0; s < totalSlides; s++) {
            slides.push(document.getElementById(prefix + "-slide-" + s));
        }

        {$i = 0}
        {foreach $data['members'] as $member}
        colors.push("{$member['member_button_color']}");
        {$i = $i + 1}
        {/foreach}

        function padNum(n) {
            return n < 10 ? "0" + n : "" + n;
        }

        function updateCounter() {
            if (counter) {
                var slide = slides[currentIndex];
                var headerColor = slide.querySelector(".{$name}-{$id}-title-");
                counter.textContent = padNum(currentIndex + 1) + " / " + padNum(totalSlides);
                if (headerColor) {
                    counter.style.color = headerColor.style.color;
                }
            }
        }

        function showSlide(idx) {
            for (var j = 0; j < slides.length; j++) {
                slides[j].classList.remove(prefix + "-slide-active-");
            }
            slides[idx].classList.add(prefix + "-slide-active-");
            currentIndex = idx;
            updateCounter();
            startProgress();
        }

        function nextSlide() {
            var next = (currentIndex + 1) % totalSlides;
            showSlide(next);
        }

        function startProgress() {
            if (!progressBar) return;
            progressBar.style.backgroundColor = colors[currentIndex] || colors[0];
            progressBar.classList.remove(prefix + "-progress-bar-running-");
            progressBar.classList.add(prefix + "-progress-bar-reset-");
            void progressBar.offsetWidth;
            progressBar.classList.remove(prefix + "-progress-bar-reset-");
            progressBar.classList.add(prefix + "-progress-bar-running-");
        }

        function startAutoplay() {
            stopAutoplay();
            timer = setInterval(function() {
                if (!paused) {
                    nextSlide();
                }
            }, interval);
        }

        function stopAutoplay() {
            if (timer) {
                clearInterval(timer);
                timer = null;
            }
        }

        slider.addEventListener("mouseenter", function() {
            paused = true;
            if (progressBar) {
                var computed = window.getComputedStyle(progressBar);
                progressBar.style.width = computed.width;
                progressBar.classList.remove(prefix + "-progress-bar-running-");
            }
        });

        slider.addEventListener("mouseleave", function() {
            paused = false;
            if (progressBar) {
                progressBar.style.width = "";
                progressBar.classList.add(prefix + "-progress-bar-running-");
            }
        });

        updateCounter();
        startProgress();
        startAutoplay();
    })();
</script>
