<style>
    .{$name}-{$id} {
    {if $data['full_width']}
        padding-left: 0 !important;
        padding-right: 0 !important;
        padding-top: 0 !important;
        padding-bottom: 0 !important;
    {/if}
        overflow: hidden;
        z-index: 0;
    }

    .{$name}-{$id}-slider- {
        position: relative;
    {if $data['width']}
        width: {$data['width']};
        margin: 0 auto;
    {else}
        width: 100%;
    {/if}
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 550px;
    {/if}
        overflow: hidden;
    }

    .{$name}-{$id}-slide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        display: grid;
        grid-template-columns: 55% 45%;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.8s ease-in-out;
    }

    .{$name}-{$id}-slide-active- {
        opacity: 1;
        pointer-events: auto;
    }

    .{$name}-{$id}-slide-reverse- {
        grid-template-columns: 45% 55%;
    }

    .{$name}-{$id}-imgcol- {
        position: relative;
        overflow: hidden;
        height: 100%;
    }

    .{$name}-{$id}-imgcol- img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        opacity: 0;
        transition: opacity 1s ease;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-imgcol- img {
        opacity: 1;
    }

    .{$name}-{$id}-imgfallback- {
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center center;
        background-repeat: no-repeat;
        position: relative;
    }

    .{$name}-{$id}-imgtint- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0.4;
    }

    .{$name}-{$id}-textcol- {
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 50px 50px 50px 50px;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id}-slide-reverse- .{$name}-{$id}-textcol- {
        padding: 50px 50px 50px 50px;
    }

    .{$name}-{$id}-counter- {
        font-size: 14px;
        font-weight: 500;
        letter-spacing: 2px;
        margin-bottom: 24px;
        opacity: 0;
        transform: translateY(20px);
        transition: opacity 0.5s ease, transform 0.5s ease;
        transition-delay: 0.3s;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-counter- {
        opacity: 0.7;
        transform: translateY(0);
    }

    .{$name}-{$id}-title- {
        font-size: 42px;
        font-weight: 800;
        line-height: 1.15;
        margin: 0 0 0 0;
        opacity: 0;
        transform: translateY(30px);
        transition: opacity 0.6s ease, transform 0.6s ease;
        transition-delay: 0.4s;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-title- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-line- {
        height: 2px;
        width: 60px;
        margin: 20px 0;
        opacity: 0;
        transform: scaleX(0);
        transform-origin: left;
        transition: opacity 0.5s ease, transform 0.5s ease;
        transition-delay: 0.6s;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-line- {
        opacity: 1;
        transform: scaleX(1);
    }

    .{$name}-{$id}-desc- {
        font-size: 16px;
        line-height: 1.8;
        margin: 0 0 30px 0;
        opacity: 0;
        transform: translateY(20px);
        transition: opacity 0.6s ease, transform 0.6s ease;
        transition-delay: 0.7s;
        max-width: 480px;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-desc- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-btn- {
        display: inline-block;
        padding: 14px 32px;
        text-decoration: none;
        font-size: 13px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 2px;
        transition: opacity 0.6s ease, transform 0.6s ease, filter 0.3s ease;
        transition-delay: 0.85s;
        opacity: 0;
        transform: translateY(20px);
        cursor: pointer;
        align-self: flex-start;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-btn- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-btn-:hover {
        filter: brightness(1.15);
    }

    .{$name}-{$id}-nav- {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        padding: 18px 30px;
        z-index: 10;
    }

    .{$name}-{$id}-navbtn- {
        background: none;
        border: none;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        padding: 8px 16px;
        letter-spacing: 0.5px;
        transition: opacity 0.3s ease;
        opacity: 0.7;
    }

    .{$name}-{$id}-navbtn-:hover {
        opacity: 1;
    }

    .{$name}-{$id}-navsep- {
        font-size: 14px;
        opacity: 0.4;
        user-select: none;
    }

    @media screen and (max-width: 767px) {
        .{$name}-{$id}-slider- {
        {if !$data['height']}
            height: auto;
        {/if}
        }

        .{$name}-{$id}-slide- {
            display: flex;
            flex-direction: column;
            position: relative;
            opacity: 0;
            height: auto;
            pointer-events: none;
            max-height: 0;
            overflow: hidden;
            transition: opacity 0.6s ease-in-out, max-height 0s linear 0.6s;
        }

        .{$name}-{$id}-slide-active- {
            opacity: 1;
            position: relative;
            pointer-events: auto;
            max-height: 9999px;
            overflow: visible;
            transition: opacity 0.6s ease-in-out, max-height 0s linear 0s;
        }

        .{$name}-{$id}-slide-reverse- {
            flex-direction: column;
        }

        .{$name}-{$id}-imgcol- {
            height: 250px;
            width: 100%;
            order: -1;
        }

        .{$name}-{$id}-imgfallback- {
            height: 250px;
        }

        .{$name}-{$id}-textcol- {
            padding: 30px 24px 60px 24px;
        }

        .{$name}-{$id}-slide-reverse- .{$name}-{$id}-textcol- {
            padding: 30px 24px 60px 24px;
        }

        .{$name}-{$id}-title- {
            font-size: 28px;
        }

        .{$name}-{$id}-desc- {
            font-size: 15px;
            max-width: 100%;
        }

        .{$name}-{$id}-counter- {
            font-size: 12px;
        }

        .{$name}-{$id}-nav- {
            padding: 14px 20px;
        }

        .{$name}-{$id}-navbtn- {
            font-size: 13px;
            padding: 6px 12px;
        }
    }
</style>

<div class="{$name}-{$id}">
    <div class="{$name}-{$id}-slider-" id="{$name}-{$id}-slider">
        {$i = 1}
        {$total = count($data['members'])}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-slide-{if $i == 1} {$name}-{$id}-slide-active-{/if}{if $i % 2 == 0} {$name}-{$id}-slide-reverse-{/if}" id="{$name}-{$id}-slide-{$i}" style="background-color: {$member['member_background_color']};">
                {if $i % 2 == 0}
                    <div class="{$name}-{$id}-textcol-">
                        <div class="{$name}-{$id}-counter-" style="color: {$member['member_description_color']};">{if $i < 10}0{/if}{$i} &mdash; {if $total < 10}0{/if}{$total}</div>
                        <h2 class="{$name}-{$id}-title-" style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">{$member['member_header']}</h2>
                        <div class="{$name}-{$id}-line-" style="background-color: {$member['member_button_color']};"></div>
                        <p class="{$name}-{$id}-desc-" style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">{$member['member_description']}</p>
                        {if $member['member_button_text'] neq ''}
                            <a class="{$name}-{$id}-btn-" href="{$member['member_button_url']}" {if $member['mmnew_tab']}target="_blank"{/if} style="
                                background-color: {$member['member_button_color']};
                                color: {$member['member_button_color_text']};
                                border: 2px solid {$member['member_button_color_border']};
                            ">{$member['member_button_text']}</a>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-imgcol-">
                        {if $member['member_img'] neq ''}
                            <img src="{$member['member_img']}" alt="{$member['member_header']}" />
                        {elseif $member['member_background_img'] neq ''}
                            <div class="{$name}-{$id}-imgfallback-" style="background-image: url('{$member['member_background_img']}');">
                                <div class="{$name}-{$id}-imgtint-" style="background-color: {$member['member_background_color']};"></div>
                            </div>
                        {else}
                            <div class="{$name}-{$id}-imgfallback-" style="background-color: {$member['member_background_color']};"></div>
                        {/if}
                    </div>
                {else}
                    <div class="{$name}-{$id}-imgcol-">
                        {if $member['member_img'] neq ''}
                            <img src="{$member['member_img']}" alt="{$member['member_header']}" />
                        {elseif $member['member_background_img'] neq ''}
                            <div class="{$name}-{$id}-imgfallback-" style="background-image: url('{$member['member_background_img']}');">
                                <div class="{$name}-{$id}-imgtint-" style="background-color: {$member['member_background_color']};"></div>
                            </div>
                        {else}
                            <div class="{$name}-{$id}-imgfallback-" style="background-color: {$member['member_background_color']};"></div>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-textcol-">
                        <div class="{$name}-{$id}-counter-" style="color: {$member['member_description_color']};">{if $i < 10}0{/if}{$i} &mdash; {if $total < 10}0{/if}{$total}</div>
                        <h2 class="{$name}-{$id}-title-" style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">{$member['member_header']}</h2>
                        <div class="{$name}-{$id}-line-" style="background-color: {$member['member_button_color']};"></div>
                        <p class="{$name}-{$id}-desc-" style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">{$member['member_description']}</p>
                        {if $member['member_button_text'] neq ''}
                            <a class="{$name}-{$id}-btn-" href="{$member['member_button_url']}" {if $member['mmnew_tab']}target="_blank"{/if} style="
                                background-color: {$member['member_button_color']};
                                color: {$member['member_button_color_text']};
                                border: 2px solid {$member['member_button_color_border']};
                            ">{$member['member_button_text']}</a>
                        {/if}
                    </div>
                {/if}
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
            <div class="{$name}-{$id}-nav-" id="{$name}-{$id}-nav">
                <button class="{$name}-{$id}-navbtn-" id="{$name}-{$id}-prev" aria-label="Previous slide">&larr; Previous</button>
                <span class="{$name}-{$id}-navsep-">|</span>
                <button class="{$name}-{$id}-navbtn-" id="{$name}-{$id}-next" aria-label="Next slide">Next &rarr;</button>
            </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var prefix = "{$name}-{$id}";
        var slider = document.getElementById(prefix + "-slider");
        if (!slider) return;

        var slides = slider.querySelectorAll("." + prefix + "-slide-");
        var totalSlides = slides.length;
        if (totalSlides === 0) return;

        var prevBtn = document.getElementById(prefix + "-prev");
        var nextBtn = document.getElementById(prefix + "-next");
        var nav = document.getElementById(prefix + "-nav");
        var current = 0;
        var interval = null;
        var paused = false;

        function updateNavColors() {
            if (!nav) return;
            var activeSlide = slides[current];
            var btnEl = activeSlide.querySelector("." + prefix + "-btn-");
            var navColor = "";
            if (btnEl) {
                navColor = btnEl.style.backgroundColor;
            }
            var buttons = nav.querySelectorAll("." + prefix + "-navbtn-");
            var sep = nav.querySelector("." + prefix + "-navsep-");
            for (var b = 0; b < buttons.length; b++) {
                buttons[b].style.color = navColor;
            }
            if (sep) {
                sep.style.color = navColor;
            }
        }

        function goTo(index) {
            slides[current].classList.remove(prefix + "-slide-active-");
            current = (index + totalSlides) % totalSlides;
            slides[current].classList.add(prefix + "-slide-active-");
            updateNavColors();
        }

        function nextSlide() {
            goTo(current + 1);
        }

        function prevSlide() {
            goTo(current - 1);
        }

        function startAutoplay() {
            if (interval) clearInterval(interval);
            interval = setInterval(function() {
                if (!paused) nextSlide();
            }, 5000);
        }

        if (nextBtn) {
            nextBtn.addEventListener("click", function() {
                nextSlide();
                startAutoplay();
            });
        }

        if (prevBtn) {
            prevBtn.addEventListener("click", function() {
                prevSlide();
                startAutoplay();
            });
        }

        slider.addEventListener("mouseenter", function() {
            paused = true;
        });

        slider.addEventListener("mouseleave", function() {
            paused = false;
        });

        updateNavColors();
        startAutoplay();
    })();
</script>
