<style>
    .{$name}-{$id} {
        padding-left: 0 !important;
        padding-right: 0 !important;
    }

    .{$name}-{$id}-hero- {
        position: relative;
        overflow: hidden;
    {if $data['width']}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {else}
        width: 100%;
    {/if}
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 100vh;
    {/if}
    }

    .{$name}-{$id}-hslide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        visibility: hidden;
        transition: opacity 1s ease, visibility 1s ease, transform 1s ease;
        transform: scale(1.04);
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .{$name}-{$id}-hslide-active- {
        opacity: 1;
        visibility: visible;
        transform: scale(1);
    }

    .{$name}-{$id}-hbg- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 0;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
    }

    .{$name}-{$id}-hoverlay- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
        opacity: 0.55;
    }

    .{$name}-{$id}-hcontent- {
        position: relative;
        z-index: 2;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        max-width: 860px;
        padding: 60px 30px;
        width: 100%;
    }

    .{$name}-{$id}-hthumb- {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        object-fit: cover;
        margin-bottom: 24px;
        border: 3px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    }

    .{$name}-{$id}-htitle- {
        font-weight: 800;
        line-height: 1.1;
        letter-spacing: -1px;
        margin: 0 0 20px 0;
    }

    .{$name}-{$id}-hdesc- {
        line-height: 1.7;
        font-weight: 300;
        margin: 0 0 32px 0;
        max-width: 680px;
        opacity: 0.9;
    }

    .{$name}-{$id}-hbtn- {
        display: inline-block;
        padding: 14px 44px;
        font-size: 15px;
        font-weight: 700;
        text-decoration: none;
        border-radius: 50px;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: transform 0.3s ease, box-shadow 0.3s ease, filter 0.3s ease;
        cursor: pointer;
    }

    .{$name}-{$id}-hbtn-:hover {
        transform: translateY(-3px) scale(1.03);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.35);
        filter: brightness(1.12);
        text-decoration: none;
    }

    .{$name}-{$id}-dots- {
        position: absolute;
        bottom: 30px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .{$name}-{$id}-dot- {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.4);
        border: none;
        cursor: pointer;
        transition: transform 0.3s ease, background 0.3s ease, width 0.3s ease;
        padding: 0;
        outline: none;
    }

    .{$name}-{$id}-dot-:hover {
        background: rgba(255, 255, 255, 0.7);
        transform: scale(1.2);
    }

    .{$name}-{$id}-dot-active- {
        width: 14px;
        height: 14px;
        transform: scale(1);
    }

    .{$name}-{$id}-dot-active-:hover {
        transform: scale(1.1);
    }

    .{$name}-{$id}-arrow- {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        z-index: 10;
        background: rgba(0, 0, 0, 0.2);
        backdrop-filter: blur(4px);
        border: 1px solid rgba(255, 255, 255, 0.15);
        color: rgba(255, 255, 255, 0.85);
        width: 48px;
        height: 48px;
        border-radius: 50%;
        cursor: pointer;
        font-size: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background 0.3s ease, transform 0.3s ease, border-color 0.3s ease;
        padding: 0;
        outline: none;
    }

    .{$name}-{$id}-arrow-:hover {
        background: rgba(0, 0, 0, 0.45);
        border-color: rgba(255, 255, 255, 0.35);
        transform: translateY(-50%) scale(1.1);
    }

    .{$name}-{$id}-arrow-prev- {
        left: 20px;
    }

    .{$name}-{$id}-arrow-next- {
        right: 20px;
    }

    @media screen and (max-width: 991px) {
        .{$name}-{$id}-hcontent- {
            padding: 40px 24px;
        }

        .{$name}-{$id}-hthumb- {
            width: 70px;
            height: 70px;
            margin-bottom: 18px;
        }

        .{$name}-{$id}-arrow- {
            width: 38px;
            height: 38px;
            font-size: 16px;
        }

        .{$name}-{$id}-arrow-prev- {
            left: 12px;
        }

        .{$name}-{$id}-arrow-next- {
            right: 12px;
        }

        .{$name}-{$id}-dots- {
            bottom: 18px;
        }
    }

    @media screen and (max-width: 600px) {
        .{$name}-{$id}-hcontent- {
            padding: 30px 16px;
        }

        .{$name}-{$id}-hthumb- {
            width: 56px;
            height: 56px;
            margin-bottom: 14px;
        }

        .{$name}-{$id}-hbtn- {
            padding: 12px 30px;
            font-size: 13px;
        }

        .{$name}-{$id}-arrow- {
            width: 34px;
            height: 34px;
            font-size: 14px;
        }

        .{$name}-{$id}-arrow-prev- {
            left: 8px;
        }

        .{$name}-{$id}-arrow-next- {
            right: 8px;
        }

        .{$name}-{$id}-dots- {
            bottom: 12px;
            gap: 8px;
        }

        .{$name}-{$id}-dot- {
            width: 8px;
            height: 8px;
        }

        .{$name}-{$id}-dot-active- {
            width: 12px;
            height: 12px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-hero-" id="{$name}-{$id}-hero">
        {$i = 1}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-hslide-{if $i == 1} {$name}-{$id}-hslide-active-{/if}"
                 id="{$name}-{$id}-hslide-{$i}">

                <div class="{$name}-{$id}-hbg-"
                     style="{if $member['member_background_img']}background-image: url('{$member['member_background_img']}');{/if}">
                </div>

                <div class="{$name}-{$id}-hoverlay-"
                     style="background-color: {$member['member_background_color']};"></div>

                <div class="{$name}-{$id}-hcontent-">
                    {if $member['member_img']}
                        <img class="{$name}-{$id}-hthumb-"
                             src="{$member['member_img']}"
                             alt="{$member['member_header']}" />
                    {/if}

                    {if $member['member_header']}
                        <div class="{$name}-{$id}-htitle-"
                             style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">
                            {$member['member_header']}
                        </div>
                    {/if}

                    {if $member['member_description']}
                        <div class="{$name}-{$id}-hdesc-"
                             style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">
                            {$member['member_description']}
                        </div>
                    {/if}

                    {if $member['member_button_text']}
                        <a href="{$member['member_button_url']}"
                           {if $member['mmnew_tab']}target="_blank"{/if}
                           class="{$name}-{$id}-hbtn-"
                           style="color: {$member['member_button_color_text']}; background-color: {$member['member_button_color']}; border: 2px solid {$member['member_button_color_border']};">
                            {$member['member_button_text']}
                        </a>
                    {/if}
                </div>
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
            <button class="{$name}-{$id}-arrow- {$name}-{$id}-arrow-prev-"
                    id="{$name}-{$id}-prev"
                    onclick="puqHero_{$name}_{$id}.prev()"
                    aria-label="Previous slide">&#10094;</button>

            <button class="{$name}-{$id}-arrow- {$name}-{$id}-arrow-next-"
                    id="{$name}-{$id}-next"
                    onclick="puqHero_{$name}_{$id}.next()"
                    aria-label="Next slide">&#10095;</button>
        {/if}

        {if !$data['disable_nav_button']}
            <div class="{$name}-{$id}-dots-" id="{$name}-{$id}-dots">
                {$i = 1}
                {foreach $data['members'] as $member}
                    <button class="{$name}-{$id}-dot-{if $i == 1} {$name}-{$id}-dot-active-{/if}"
                            id="{$name}-{$id}-dot-{$i}"
                            onclick="puqHero_{$name}_{$id}.goTo({$i})"
                            style="{if $i == 1}background-color: {$member['member_button_color']};{/if}"
                            aria-label="Go to slide {$i}"></button>
                    {$i = $i + 1}
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var ns = "{$name}";
        var id = "{$id}";
        var totalSlides = {$data['members']|count};
        var currentSlide = 1;
        var autoplayInterval = null;
        var autoplayDelay = 5000;
        var isPaused = false;

        var dotColors = [
            {foreach $data['members'] as $member}"{$member['member_button_color']}"{if !$member@last},{/if}{/foreach}
        ];

        function getEl(suffix) {
            return document.getElementById(ns + "-" + id + "-" + suffix);
        }

        function getAllSlides() {
            var hero = getEl("hero");
            if (!hero) return [];
            return hero.querySelectorAll("." + ns + "-" + id + "-hslide-");
        }

        function getAllDots() {
            var dots = getEl("dots");
            if (!dots) return [];
            return dots.querySelectorAll("." + ns + "-" + id + "-dot-");
        }

        function showSlide(index) {
            if (index < 1 || index > totalSlides) return;
            var slides = getAllSlides();
            var dots = getAllDots();

            for (var s = 0; s < slides.length; s++) {
                slides[s].classList.remove(ns + "-" + id + "-hslide-active-");
            }

            for (var d = 0; d < dots.length; d++) {
                dots[d].classList.remove(ns + "-" + id + "-dot-active-");
                dots[d].style.backgroundColor = "rgba(255, 255, 255, 0.4)";
            }

            var target = getEl("hslide-" + index);
            if (target) target.classList.add(ns + "-" + id + "-hslide-active-");

            var dot = getEl("dot-" + index);
            if (dot) {
                dot.classList.add(ns + "-" + id + "-dot-active-");
                dot.style.backgroundColor = dotColors[index - 1] || "rgba(255, 255, 255, 0.9)";
            }

            currentSlide = index;
        }

        function nextSlide() {
            var next = currentSlide + 1;
            if (next > totalSlides) next = 1;
            showSlide(next);
        }

        function prevSlide() {
            var prev = currentSlide - 1;
            if (prev < 1) prev = totalSlides;
            showSlide(prev);
        }

        function startAutoplay() {
            stopAutoplay();
            autoplayInterval = setInterval(function() {
                if (!isPaused) {
                    nextSlide();
                }
            }, autoplayDelay);
        }

        function stopAutoplay() {
            if (autoplayInterval) {
                clearInterval(autoplayInterval);
                autoplayInterval = null;
            }
        }

        var api = {
            goTo: function(index) {
                showSlide(index);
                stopAutoplay();
                startAutoplay();
            },
            next: function() {
                nextSlide();
                stopAutoplay();
                startAutoplay();
            },
            prev: function() {
                prevSlide();
                stopAutoplay();
                startAutoplay();
            }
        };

        window["puqHero_" + ns + "_" + id] = api;

        var hero = getEl("hero");
        if (hero) {
            hero.addEventListener("mouseenter", function() {
                isPaused = true;
            });

            hero.addEventListener("mouseleave", function() {
                isPaused = false;
            });

            var touchStartX = 0;
            var touchEndX = 0;

            hero.addEventListener("touchstart", function(e) {
                touchStartX = e.changedTouches[0].screenX;
            }, { passive: true });

            hero.addEventListener("touchend", function(e) {
                touchEndX = e.changedTouches[0].screenX;
                var diff = touchStartX - touchEndX;
                if (Math.abs(diff) > 50) {
                    if (diff > 0) {
                        api.next();
                    } else {
                        api.prev();
                    }
                }
            }, { passive: true });
        }

        if (totalSlides > 1) {
            startAutoplay();
        }
    })();
</script>