<style>
    .{$name}-{$id} {
        padding: 0 !important;
    }

    .{$name}-{$id}-glass-wrap {
        position: relative;
        overflow: hidden;
    {if $data['width']}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {else}
        width: 100%;
    {/if}
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 520px;
    {/if}
    }

    /* ---- slide ---- */
    .{$name}-{$id}-glass-slide {
        position: absolute;
        inset: 0;
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.9s ease, visibility 0.9s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px;
        box-sizing: border-box;
    }
    .{$name}-{$id}-glass-slide-active {
        opacity: 1;
        visibility: visible;
    }

    /* ---- background layer ---- */
    .{$name}-{$id}-glass-bg {
        position: absolute;
        inset: 0;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        z-index: 0;
    }
    .{$name}-{$id}-glass-bg-overlay {
        position: absolute;
        inset: 0;
        z-index: 1;
        opacity: 0.35;
    }

    /* ---- glass card ---- */
    .{$name}-{$id}-glass-card {
        position: relative;
        z-index: 2;
        display: flex;
        flex-direction: row;
        align-items: center;
        gap: 32px;
        max-width: 800px;
        width: 100%;
        padding: 44px 40px;
        border-radius: 24px;
        backdrop-filter: blur(24px) saturate(1.4);
        -webkit-backdrop-filter: blur(24px) saturate(1.4);
        border: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
    }

    /* ---- text content ---- */
    .{$name}-{$id}-glass-text {
        flex: 1;
        display: flex;
        flex-direction: column;
        gap: 14px;
        min-width: 0;
    }
    .{$name}-{$id}-glass-title {
        margin: 0;
        font-weight: 800;
        line-height: 1.15;
        letter-spacing: -0.5px;
    }
    .{$name}-{$id}-glass-desc {
        margin: 0;
        line-height: 1.7;
        font-weight: 400;
        opacity: 0.92;
    }
    .{$name}-{$id}-glass-btn {
        display: inline-flex;
        align-self: flex-start;
        padding: 12px 34px;
        font-size: 15px;
        font-weight: 600;
        text-decoration: none;
        border-radius: 50px;
        border: none;
        cursor: pointer;
        transition: transform 0.25s ease, filter 0.25s ease;
        margin-top: 6px;
    }
    .{$name}-{$id}-glass-btn:hover {
        transform: translateY(-2px);
        filter: brightness(1.15);
        text-decoration: none;
    }

    /* ---- image inside card ---- */
    .{$name}-{$id}-glass-img {
        flex-shrink: 0;
        width: 160px;
        height: 160px;
        border-radius: 20px;
        object-fit: cover;
        border: 2px solid rgba(255, 255, 255, 0.25);
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2);
    }

    /* ---- nav dots ---- */
    .{$name}-{$id}-glass-dots {
        position: absolute;
        bottom: 22px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        border-radius: 50px;
        backdrop-filter: blur(14px);
        -webkit-backdrop-filter: blur(14px);
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.12);
    }
    .{$name}-{$id}-glass-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        border: 2px solid rgba(255, 255, 255, 0.5);
        background: transparent;
        cursor: pointer;
        padding: 0;
        transition: all 0.3s ease;
    }
    .{$name}-{$id}-glass-dot:hover {
        border-color: rgba(255, 255, 255, 0.8);
    }
    .{$name}-{$id}-glass-dot-active {
        transform: scale(1.3);
    }

    /* ---- arrows ---- */
    .{$name}-{$id}-glass-arrow {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        z-index: 10;
        width: 44px;
        height: 44px;
        border-radius: 50%;
        border: 1px solid rgba(255, 255, 255, 0.2);
        background: rgba(0, 0, 0, 0.15);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        color: rgba(255, 255, 255, 0.8);
        font-size: 18px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.25s ease;
        padding: 0;
    }
    .{$name}-{$id}-glass-arrow:hover {
        background: rgba(0, 0, 0, 0.35);
        border-color: rgba(255, 255, 255, 0.4);
    }
    .{$name}-{$id}-glass-arrow-prev {
        left: 16px;
    }
    .{$name}-{$id}-glass-arrow-next {
        right: 16px;
    }

    /* ---- responsive ---- */
    @media screen and (max-width: 991px) {
        .{$name}-{$id}-glass-slide {
            padding: 30px 20px 60px 20px;
        }
        .{$name}-{$id}-glass-card {
            flex-direction: column;
            text-align: center;
            padding: 32px 28px;
            gap: 20px;
            max-width: 500px;
        }
        .{$name}-{$id}-glass-text {
            align-items: center;
        }
        .{$name}-{$id}-glass-btn {
            align-self: center;
        }
        .{$name}-{$id}-glass-img {
            width: 120px;
            height: 120px;
            order: -1;
        }
        .{$name}-{$id}-glass-arrow {
            width: 36px;
            height: 36px;
            font-size: 14px;
        }
    }
    @media screen and (max-width: 600px) {
        .{$name}-{$id}-glass-wrap {
            height: auto;
            min-height: 420px;
        }
        .{$name}-{$id}-glass-slide {
            padding: 24px 14px 56px 14px;
            position: relative;
            display: none;
        }
        .{$name}-{$id}-glass-slide-active {
            display: flex;
        }
        .{$name}-{$id}-glass-card {
            padding: 24px 18px;
            border-radius: 16px;
        }
        .{$name}-{$id}-glass-title {
            font-size: 22px !important;
        }
        .{$name}-{$id}-glass-desc {
            font-size: 13px !important;
        }
        .{$name}-{$id}-glass-img {
            width: 90px;
            height: 90px;
            border-radius: 14px;
        }
        .{$name}-{$id}-glass-arrow {
            display: none;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-glass-wrap" id="{$name}-{$id}-glass-wrap">
        {$i = 0}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-glass-slide{if $i == 0} {$name}-{$id}-glass-slide-active{/if}"
                 id="{$name}-{$id}-gs-{$i}">

                <div class="{$name}-{$id}-glass-bg"
                     style="background-color: {$member['member_background_color']};{if $member['member_background_img']} background-image: url('{$member['member_background_img']}');{/if}"></div>
                <div class="{$name}-{$id}-glass-bg-overlay"
                     style="background: {$member['member_background_color']};"></div>

                <div class="{$name}-{$id}-glass-card"
                     style="background: {$member['member_background_color']}80;">

                    <div class="{$name}-{$id}-glass-text">
                        {if $member['member_header']}
                            <h2 class="{$name}-{$id}-glass-title"
                                style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">
                                {$member['member_header']}
                            </h2>
                        {/if}
                        {if $member['member_description']}
                            <p class="{$name}-{$id}-glass-desc"
                               style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">
                                {$member['member_description']}
                            </p>
                        {/if}
                        {if $member['member_button_text']}
                            <a href="{$member['member_button_url']}"
                               {if $member['mmnew_tab']}target="_blank"{/if}
                               class="{$name}-{$id}-glass-btn"
                               style="color: {$member['member_button_color_text']}; background: {$member['member_button_color']};">
                                {$member['member_button_text']}
                            </a>
                        {/if}
                    </div>

                    {if $member['member_img']}
                        <img class="{$name}-{$id}-glass-img"
                             src="{$member['member_img']}"
                             alt="{$member['member_header']}" />
                    {/if}
                </div>
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
            <button class="{$name}-{$id}-glass-arrow {$name}-{$id}-glass-arrow-prev"
                    id="{$name}-{$id}-gprev"
                    onclick="puqGlass_{$name}_{$id}.prev()">&#10094;</button>
            <button class="{$name}-{$id}-glass-arrow {$name}-{$id}-glass-arrow-next"
                    id="{$name}-{$id}-gnext"
                    onclick="puqGlass_{$name}_{$id}.next()">&#10095;</button>

            <div class="{$name}-{$id}-glass-dots" id="{$name}-{$id}-gdots">
                {$i = 0}
                {foreach $data['members'] as $member}
                    <button type="button"
                            class="{$name}-{$id}-glass-dot{if $i == 0} {$name}-{$id}-glass-dot-active{/if}"
                            id="{$name}-{$id}-gd-{$i}"
                            style="border-color: {$member['member_button_color']};"
                            onclick="puqGlass_{$name}_{$id}.goTo({$i})"></button>
                    {$i = $i + 1}
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var P = "{$name}-{$id}";
        var wrap = document.getElementById(P + "-glass-wrap");
        if (!wrap) return;

        var total = {$data['members']|count};
        var cur = 0;
        var timer = null;
        var paused = false;
        var DELAY = 5000;

        var dotColors = [
            {$i = 0}
            {foreach $data['members'] as $member}
                "{$member['member_button_color']}"{if $i < ($data['members']|count) - 1},{/if}
                {$i = $i + 1}
            {/foreach}
        ];

        function getEl(id) {
            return document.getElementById(id);
        }

        function show(idx) {
            if (idx < 0) idx = total - 1;
            if (idx >= total) idx = 0;

            for (var s = 0; s < total; s++) {
                var sl = getEl(P + "-gs-" + s);
                var dt = getEl(P + "-gd-" + s);
                if (sl) {
                    if (s === idx) {
                        sl.classList.add(P + "-glass-slide-active");
                    } else {
                        sl.classList.remove(P + "-glass-slide-active");
                    }
                }
                if (dt) {
                    if (s === idx) {
                        dt.classList.add(P + "-glass-dot-active");
                        dt.style.background = dotColors[s] || "transparent";
                    } else {
                        dt.classList.remove(P + "-glass-dot-active");
                        dt.style.background = "transparent";
                    }
                }
            }
            cur = idx;
        }

        function startTimer() {
            stopTimer();
            timer = setInterval(function() {
                if (!paused) show(cur + 1);
            }, DELAY);
        }

        function stopTimer() {
            if (timer) {
                clearInterval(timer);
                timer = null;
            }
        }

        var api = {
            goTo: function(i) { show(i); startTimer(); },
            next: function() { show(cur + 1); startTimer(); },
            prev: function() { show(cur - 1); startTimer(); }
        };
        window["puqGlass_{$name}_{$id}"] = api;

        wrap.addEventListener("mouseenter", function() { paused = true; });
        wrap.addEventListener("mouseleave", function() { paused = false; });

        var tx = 0;
        wrap.addEventListener("touchstart", function(e) {
            tx = e.changedTouches[0].screenX;
            paused = true;
        }, { passive: true });
        wrap.addEventListener("touchend", function(e) {
            var diff = tx - e.changedTouches[0].screenX;
            if (Math.abs(diff) > 50) {
                show(diff > 0 ? cur + 1 : cur - 1);
                startTimer();
            }
            paused = false;
        }, { passive: true });

        if (total > 1) startTimer();
    })();
</script>
