<style>
    .{$name}-{$id} {
        padding: 0;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id}-cinema- {
        position: relative;
    {if $data['width']}
        width: {$data['width']};
        margin: 0 auto;
    {else}
        width: 100%;
    {/if}
        min-height: {if $data['height'] neq ''}{$data['height']}{else}70vh{/if};
    }

    .{$name}-{$id}-cslide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        pointer-events: none;
        transition: opacity 1s ease;
    }

    .{$name}-{$id}-cslide-active- {
        opacity: 1;
        pointer-events: auto;
    }

    .{$name}-{$id}-cbg- {
        position: absolute;
        top: 0;
        left: 0;
        width: 110%;
        height: 100%;
        background-size: cover;
        background-position: center;
        transition: transform 6s ease-out;
        transform: translateX(0);
    }

    .{$name}-{$id}-cslide-active- .{$name}-{$id}-cbg- {
        transform: translateX(-2%);
    }

    .{$name}-{$id}-coverlay- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
    }

    .{$name}-{$id}-ccontent- {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        z-index: 2;
        display: flex;
        align-items: flex-end;
        justify-content: space-between;
        padding: 40px 50px 60px 50px;
        box-sizing: border-box;
    }

    .{$name}-{$id}-ctext- {
        flex: 1;
        max-width: 700px;
    }

    .{$name}-{$id}-ctitle- {
        font-weight: 800;
        line-height: 1.08;
        letter-spacing: -0.5px;
        margin: 0 0 16px 0;
        text-shadow: 0 2px 20px rgba(0, 0, 0, 0.4);
    }

    .{$name}-{$id}-cdesc- {
        line-height: 1.6;
        margin: 0 0 28px 0;
        opacity: 0.85;
        max-width: 540px;
        text-shadow: 0 1px 8px rgba(0, 0, 0, 0.3);
    }

    .{$name}-{$id}-cbtn- {
        display: inline-block;
        padding: 12px 32px;
        font-size: 0.95rem;
        font-weight: 600;
        text-decoration: none;
        background: transparent;
        border-width: 2px;
        border-style: solid;
        border-radius: 4px;
        transition: background-color 0.3s ease, color 0.3s ease, transform 0.3s ease;
        letter-spacing: 0.5px;
    }

    .{$name}-{$id}-cbtn-:hover {
        transform: translateY(-2px);
    }

    .{$name}-{$id}-cposter- {
        width: 80px;
        height: 120px;
        border-radius: 6px;
        object-fit: cover;
        margin-left: 40px;
        flex-shrink: 0;
        box-shadow: 0 4px 24px rgba(0, 0, 0, 0.4);
        opacity: 0.95;
    }

    .{$name}-{$id}-cnav- {
        position: absolute;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 5;
        display: flex;
        gap: 8px;
        align-items: center;
    }

    .{$name}-{$id}-cdot- {
        width: 20px;
        height: 4px;
        border-radius: 2px;
        background: rgba(255, 255, 255, 0.35);
        cursor: pointer;
        transition: width 0.4s ease, background-color 0.4s ease;
        border: none;
        padding: 0;
    }

    .{$name}-{$id}-cdot-active- {
        width: 40px;
        background: rgba(255, 255, 255, 0.9);
    }

    .{$name}-{$id}-cdot-:hover {
        background: rgba(255, 255, 255, 0.7);
    }

    @media (max-width: 991px) {
        .{$name}-{$id}-ccontent- {
            padding: 30px 30px 50px 30px;
        }

        .{$name}-{$id}-cposter- {
            display: none;
        }

        .{$name}-{$id}-ctitle- {
            letter-spacing: 0;
        }
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-cinema- {
            min-height: {if $data['height'] neq ''}{$data['height']}{else}50vh{/if};
        }

        .{$name}-{$id}-ccontent- {
            padding: 24px 20px 50px 20px;
        }

        .{$name}-{$id}-cbtn- {
            padding: 10px 24px;
            font-size: 0.85rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    <div class="{$name}-{$id}-cinema-" id="{$name}-{$id}-cinema">

        {$i = 0}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-cslide-{if $i == 0} {$name}-{$id}-cslide-active-{/if}"
                 id="{$name}-{$id}-cslide-{$i}">

                <div class="{$name}-{$id}-cbg-"
                     style="background-image: url('{$member['member_background_img']}'); background-color: {$member['member_background_color']};"></div>

                <div class="{$name}-{$id}-coverlay-"
                     style="background: linear-gradient(to bottom, transparent 15%, {$member['member_background_color']} 100%); opacity: 0.7;"></div>

                <div class="{$name}-{$id}-ccontent-">
                    <div class="{$name}-{$id}-ctext-">
                        <div class="{$name}-{$id}-ctitle-"
                             style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">
                            {$member['member_header']}
                        </div>

                        <div class="{$name}-{$id}-cdesc-"
                             style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">
                            {$member['member_description']}
                        </div>

                        {if $member['member_button_text']}
                            <a href="{$member['member_button_url']}"
                               {if $member['mmnew_tab']}target="_blank"{/if}
                               class="{$name}-{$id}-cbtn-"
                               style="color: {$member['member_button_color_text']}; border-color: {$member['member_button_color_border']};"
                               data-fill="{$member['member_button_color']}"
                               data-text="{$member['member_button_color_text']}">
                                {$member['member_button_text']}
                            </a>
                        {/if}
                    </div>

                    {if $member['member_img']}
                        <img class="{$name}-{$id}-cposter-"
                             src="{$member['member_img']}"
                             alt="{$member['member_header']}" />
                    {/if}
                </div>
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
        <div class="{$name}-{$id}-cnav-" id="{$name}-{$id}-cnav">
            {$i = 0}
            {foreach $data['members'] as $member}
                <button class="{$name}-{$id}-cdot-{if $i == 0} {$name}-{$id}-cdot-active-{/if}"
                        id="{$name}-{$id}-cdot-{$i}"
                        data-index="{$i}"
                        aria-label="Slide {$i + 1}"></button>
                {$i = $i + 1}
            {/foreach}
        </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var prefix = "{$name}-{$id}";
        var total = {$i};
        if (total < 1) return;

        var current = 0;
        var autoplayMs = 5000;
        var timer = null;
        var paused = false;

        var cinema = document.getElementById(prefix + "-cinema");
        var slides = [];
        var dots = [];

        for (var s = 0; s < total; s++) {
            slides.push(document.getElementById(prefix + "-cslide-" + s));
            var dot = document.getElementById(prefix + "-cdot-" + s);
            if (dot) dots.push(dot);
        }

        function goTo(idx) {
            for (var j = 0; j < total; j++) {
                slides[j].classList.remove(prefix + "-cslide-active-");
                if (dots[j]) dots[j].classList.remove(prefix + "-cdot-active-");
            }
            slides[idx].classList.add(prefix + "-cslide-active-");
            if (dots[idx]) dots[idx].classList.add(prefix + "-cdot-active-");
            current = idx;
        }

        function next() {
            goTo((current + 1) % total);
        }

        function startTimer() {
            stopTimer();
            timer = setInterval(function() {
                if (!paused) next();
            }, autoplayMs);
        }

        function stopTimer() {
            if (timer) {
                clearInterval(timer);
                timer = null;
            }
        }

        for (var d = 0; d < dots.length; d++) {
            dots[d].addEventListener("click", function() {
                var idx = parseInt(this.getAttribute("data-index"), 10);
                goTo(idx);
                startTimer();
            });
        }

        var allBtns = cinema.querySelectorAll(".{$name}-{$id}-cbtn-");
        for (var b = 0; b < allBtns.length; b++) {
            (function(btn) {
                var fillColor = btn.getAttribute("data-fill");
                var textColor = btn.getAttribute("data-text");
                btn.addEventListener("mouseenter", function() {
                    btn.style.backgroundColor = fillColor;
                    btn.style.color = textColor;
                });
                btn.addEventListener("mouseleave", function() {
                    btn.style.backgroundColor = "transparent";
                    btn.style.color = textColor;
                });
            })(allBtns[b]);
        }

        cinema.addEventListener("mouseenter", function() {
            paused = true;
        });

        cinema.addEventListener("mouseleave", function() {
            paused = false;
        });

        startTimer();
    })();
</script>
