<style>
    .{$name}-{$id} {
        padding-left: 0 !important;
        padding-right: 0 !important;
    {if $data['width']}
        display: flex;
        align-items: center;
        justify-content: center;
    {/if}
    }

    .{$name}-{$id}-cards-outer- {
    {if $data['width']}
        width: {$data['width']};
        max-width: 100%;
    {else}
        width: 100%;
    {/if}
        position: relative;
    }

    .{$name}-{$id}-scroll-wrap- {
        overflow-x: auto;
        overflow-y: hidden;
        scroll-snap-type: x mandatory;
        -webkit-overflow-scrolling: touch;
        scrollbar-width: none;
        display: flex;
        gap: 20px;
        padding: 20px 24px 24px 24px;
    }

    .{$name}-{$id}-scroll-wrap-::-webkit-scrollbar {
        display: none;
    }

    .{$name}-{$id}-card- {
        flex: 0 0 320px;
        min-width: 320px;
        scroll-snap-align: start;
        border-radius: 12px;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        transition: box-shadow 0.3s ease, transform 0.3s ease;
        border-width: 1px;
        border-style: solid;
    }

    .{$name}-{$id}-card-:hover {
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        transform: translateY(-4px);
    }

    .{$name}-{$id}-card-img- {
        width: 100%;
        height: 200px;
        overflow: hidden;
        position: relative;
    }

    .{$name}-{$id}-card-img- img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
    }

    .{$name}-{$id}-card-img-bg- {
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
    }

    .{$name}-{$id}-card-body- {
        padding: 22px 20px;
        display: flex;
        flex-direction: column;
        flex: 1;
    }

    .{$name}-{$id}-card-title- {
        margin: 0 0 10px 0;
        font-weight: 700;
        line-height: 1.3;
        word-wrap: break-word;
    }

    .{$name}-{$id}-card-desc- {
        margin: 0 0 20px 0;
        line-height: 1.6;
        word-wrap: break-word;
        flex: 1;
    }

    .{$name}-{$id}-card-btn- {
        display: inline-block;
        padding: 10px 24px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        border-radius: 6px;
        border-width: 2px;
        border-style: solid;
        transition: opacity 0.25s ease, transform 0.25s ease;
        cursor: pointer;
        text-align: center;
        align-self: flex-start;
    }

    .{$name}-{$id}-card-btn-:hover {
        opacity: 0.85;
        transform: translateY(-1px);
    }

    .{$name}-{$id}-arrows-wrap- {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 12px;
        padding: 8px 0 16px 0;
    }

    .{$name}-{$id}-arrow- {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: opacity 0.25s ease, transform 0.2s ease;
        font-size: 18px;
        font-weight: 700;
        padding: 0;
        line-height: 1;
        opacity: 0.7;
        background: rgba(0, 0, 0, 0.08);
        color: inherit;
    }

    .{$name}-{$id}-arrow-:hover {
        opacity: 1;
        transform: scale(1.1);
    }

    .{$name}-{$id}-arrow- svg {
        width: 18px;
        height: 18px;
        fill: currentColor;
    }

    {$i = 0}
    {foreach $data['members'] as $member}
    .{$name}-{$id}-card-{$i}-btn- {
        background-color: {$member['member_button_color']};
        color: {$member['member_button_color_text']};
        border-color: {$member['member_button_color_border']};
    }
    {$i = $i + 1}
    {/foreach}

    @media screen and (max-width: 768px) {
        .{$name}-{$id}-card- {
            flex: 0 0 280px;
            min-width: 280px;
        }

        .{$name}-{$id}-scroll-wrap- {
            gap: 14px;
            padding: 16px 16px 20px 16px;
        }

        .{$name}-{$id}-card-img- {
            height: 170px;
        }

        .{$name}-{$id}-card-body- {
            padding: 18px 16px;
        }
    }
</style>

<div class="{$name}-{$id}">
    <div class="{$name}-{$id}-cards-outer-" id="{$name}-{$id}-cards-outer">
        <div class="{$name}-{$id}-scroll-wrap-" id="{$name}-{$id}-scroll-wrap">
            {$i = 0}
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-card-" style="background-color: {$member['member_background_color']}; border-color: {$member['member_button_color_border']};">
                    <div class="{$name}-{$id}-card-img-">
                        {if $member['member_img']}
                            <img src="{$member['member_img']}" alt="{$member['member_header']}" />
                        {elseif $member['member_background_img']}
                            <div class="{$name}-{$id}-card-img-bg-" style="background-image: url('{$member['member_background_img']}'); background-color: {$member['member_background_color']};"></div>
                        {else}
                            <div class="{$name}-{$id}-card-img-bg-" style="background-color: {$member['member_background_color']};"></div>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-card-body-">
                        {if $member['member_header']}
                            <div class="{$name}-{$id}-card-title-" style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">{$member['member_header']}</div>
                        {/if}
                        {if $member['member_description']}
                            <div class="{$name}-{$id}-card-desc-" style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">{$member['member_description']}</div>
                        {/if}
                        {if $member['member_button_text']}
                            <a href="{$member['member_button_url']}" {if $member['mmnew_tab']}target="_blank"{/if} class="{$name}-{$id}-card-btn- {$name}-{$id}-card-{$i}-btn-">{$member['member_button_text']}</a>
                        {/if}
                    </div>
                </div>
                {$i = $i + 1}
            {/foreach}
        </div>

        {if !$data['disable_nav_button']}
        <div class="{$name}-{$id}-arrows-wrap-" id="{$name}-{$id}-arrows">
            <button type="button" class="{$name}-{$id}-arrow-" id="{$name}-{$id}-arrow-prev" aria-label="Scroll left">
                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/></svg>
            </button>
            <button type="button" class="{$name}-{$id}-arrow-" id="{$name}-{$id}-arrow-next" aria-label="Scroll right">
                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M8.59 16.59L10 18l6-6-6-6-1.41 1.41L13.17 12z"/></svg>
            </button>
        </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var PREFIX = "{$name}-{$id}";
        var scrollWrap = document.getElementById(PREFIX + "-scroll-wrap");
        var prevBtn = document.getElementById(PREFIX + "-arrow-prev");
        var nextBtn = document.getElementById(PREFIX + "-arrow-next");
        var cards = scrollWrap.children;
        var total = cards.length;
        var autoInterval = null;
        var paused = false;
        var AUTO_DELAY = 4000;

        if (total === 0) return;

        function getCardWidth() {
            if (cards.length === 0) return 320;
            var card = cards[0];
            var style = window.getComputedStyle(scrollWrap);
            var gap = parseFloat(style.gap) || 20;
            return card.offsetWidth + gap;
        }

        function scrollByCards(count) {
            var cardW = getCardWidth();
            scrollWrap.scrollBy({
                left: cardW * count,
                behavior: "smooth"
            });
        }

        function autoScroll() {
            if (paused) return;
            var maxScroll = scrollWrap.scrollWidth - scrollWrap.clientWidth;
            if (scrollWrap.scrollLeft >= maxScroll - 2) {
                scrollWrap.scrollTo({ left: 0, behavior: "smooth" });
            } else {
                scrollByCards(1);
            }
        }

        function startAuto() {
            stopAuto();
            autoInterval = setInterval(autoScroll, AUTO_DELAY);
        }

        function stopAuto() {
            if (autoInterval) clearInterval(autoInterval);
            autoInterval = null;
        }

        /* arrow buttons */
        if (prevBtn) {
            prevBtn.addEventListener("click", function() {
                scrollByCards(-1);
                startAuto();
            });
        }
        if (nextBtn) {
            nextBtn.addEventListener("click", function() {
                scrollByCards(1);
                startAuto();
            });
        }

        /* hover pause */
        scrollWrap.addEventListener("mouseenter", function() {
            paused = true;
            stopAuto();
        });

        scrollWrap.addEventListener("mouseleave", function() {
            paused = false;
            startAuto();
        });

        /* touch pause */
        scrollWrap.addEventListener("touchstart", function() {
            paused = true;
            stopAuto();
        }, { passive: true });

        scrollWrap.addEventListener("touchend", function() {
            paused = false;
            startAuto();
        }, { passive: true });

        /* init */
        startAuto();
    })();
</script>
