<style>
    .{$name}-{$id}-split-wrap {
        position: relative;
        z-index: 2;
        max-width: {if $data['width'] neq ''}{$data['width']}{else}1200px{/if};
        margin: 0 auto;
        padding: 0 16px;
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    }

    /* ---- header ---- */
    {if !$data['disable_header']}
    .{$name}-{$id}-split-header {
        position: relative;
        text-align: center;
        padding: 48px 24px;
        margin-bottom: 32px;
        border-radius: 12px;
        overflow: hidden;
        background-color: {$data['header_background_color']};
    {if $data['header_background_img'] neq ''}
        background-image: url("{$data['header_background_img']}");
        background-size: cover;
        background-position: center;
        {if $data['header_background_fix']}
        background-attachment: fixed;
        {/if}
    {/if}
    }
    {if $data['header_background_darken']}
    .{$name}-{$id}-split-header::before {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        z-index: 0;
    }
    {/if}
    .{$name}-{$id}-split-header > * {
        position: relative;
        z-index: 1;
    }
    .{$name}-{$id}-split-htitle {
        font-size: 2rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 8px 0;
    }
    .{$name}-{$id}-split-hdesc {
        font-size: 1.05rem;
        color: {$data['header_description_color']};
        margin: 0;
    }
    {/if}

    /* ---- grid ---- */
    .{$name}-{$id}-split-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax({if $data['card_width'] neq ''}{$data['card_width']}{else}520px{/if}, 1fr));
        gap: 24px;
    }

    /* ---- card ---- */
    .{$name}-{$id}-split-card {
        display: flex;
        flex-direction: row;
        border-radius: 12px;
        overflow: hidden;
        background: {$data['color_6']};
        border: 1px solid {$data['color_7']};
        transition: box-shadow 0.3s ease;
    }
    .{$name}-{$id}-split-card:hover {
        box-shadow: 0 0 0 3px {$data['color_7']}, 0 8px 28px {$data['color_7']};
    }

    /* ---- left panel ---- */
    .{$name}-{$id}-split-left {
        position: relative;
        width: 42%;
        min-width: 180px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 28px 24px;
        background: {$data['color_7']};
        overflow: hidden;
    }
    .{$name}-{$id}-split-left-hasimg {
        background-size: cover;
        background-position: center;
    }
    .{$name}-{$id}-split-left-hasimg::before {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['color_7']};
        opacity: 0.7;
    }
    .{$name}-{$id}-split-left > * {
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id}-split-grp {
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        color: {$data['color_2']};
        margin-bottom: 6px;
    }
    .{$name}-{$id}-split-pname {
        font-size: 1.35rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0;
        line-height: 1.3;
    }

    /* ---- badge ---- */
    .{$name}-{$id}-split-badge {
        display: inline-block;
        margin-top: 14px;
        padding: 4px 14px;
        font-size: 0.7rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        border-radius: 4px;
    }
    .{$name}-{$id}-split-badge-hot {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
    }
    .{$name}-{$id}-split-badge-new {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
    }
    .{$name}-{$id}-split-badge-sale {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
    }

    /* ---- right panel ---- */
    .{$name}-{$id}-split-right {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        padding: 28px 28px;
    }

    .{$name}-{$id}-split-price {
        font-size: 1.6rem;
        font-weight: 800;
        color: {$data['color_3']};
        margin-bottom: 2px;
    }
    .{$name}-{$id}-split-cycle {
        font-size: 0.82rem;
        color: {$data['color_4']};
        margin-bottom: 14px;
    }
    .{$name}-{$id}-split-desc {
        font-size: 0.88rem;
        color: {$data['color_5']};
        line-height: 1.65;
        margin-bottom: 18px;
    }
    .{$name}-{$id}-split-btn {
        display: inline-block;
        padding: 10px 28px;
        margin-top: auto;
        font-size: 0.9rem;
        font-weight: 600;
        text-decoration: none;
        border-radius: 8px;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        transition: filter 0.25s ease, transform 0.25s ease;
        text-align: center;
        align-self: flex-start;
    }
    .{$name}-{$id}-split-btn:hover {
        filter: brightness(1.12);
        transform: translateY(-2px);
        text-decoration: none;
        color: {$data['order_now_button_text_color']};
    }

    /* ---- responsive ---- */
    @media (max-width: 768px) {
        .{$name}-{$id}-split-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id}-split-card {
            flex-direction: column;
        }
        .{$name}-{$id}-split-left {
            width: 100%;
            min-width: unset;
            padding: 24px 20px;
        }
        .{$name}-{$id}-split-right {
            padding: 20px 20px;
        }
        .{$name}-{$id}-split-htitle {
            font-size: 1.5rem;
        }
        .{$name}-{$id}-split-price {
            font-size: 1.3rem;
        }
    }
</style>

<div class="{$name}-{$id}-split-wrap">

    {if !$data['disable_header']}
    <div class="{$name}-{$id}-split-header">
        {if $data['header_text'] neq ''}
            <h2 class="{$name}-{$id}-split-htitle">{$data['header_text']}</h2>
        {/if}
        {if $data['header_description'] neq ''}
            <p class="{$name}-{$id}-split-hdesc">{$data['header_description']}</p>
        {/if}
    </div>
    {/if}

    <div class="{$name}-{$id}-split-grid">
        {foreach $data['products'] as $product}
        <div class="{$name}-{$id}-split-card">

            <div class="{$name}-{$id}-split-left{if $product['product_img'] neq ''} {$name}-{$id}-split-left-hasimg{/if}"
                 {if $product['product_img'] neq ''}style="background-image:url('{$product['product_img']}')"{/if}>
                {if $product['product_group_name'] neq ''}
                    <div class="{$name}-{$id}-split-grp">{$product['product_group_name']}</div>
                {/if}
                <h3 class="{$name}-{$id}-split-pname">{$product['product_name']}</h3>

                {if $product['product_label']}
                    {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                    <span class="{$name}-{$id}-split-badge {$name}-{$id}-split-badge-{$product['product_label']}">{$data[$lbl_key]}</span>
                {/if}
            </div>

            <div class="{$name}-{$id}-split-right">
                <div class="{$name}-{$id}-split-price">{$product['product_price']['amount_string']}</div>
                {if $product['product_price']['cycle'] neq ''}
                    <div class="{$name}-{$id}-split-cycle">{$product['product_price']['cycle']}</div>
                {/if}
                {if $product['product_description'] neq ''}
                    <div class="{$name}-{$id}-split-desc">{$product['product_description']}</div>
                {/if}
                <a href="{$product['product_order_url']}" class="{$name}-{$id}-split-btn">
                    {if $data['order_now_button_name'] neq ''}{$data['order_now_button_name']}{else}Order Now{/if}
                </a>
            </div>

        </div>
        {/foreach}
    </div>

</div>
