<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 40px;
    }

    .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        padding: 56px 20px 40px 20px;
    {if !$data['disable_header']}
        background-color: {$data['header_background_color']};
        {if $data['header_background_img'] neq ''}
            background-image: url("{$data['header_background_img']}");
            background-size: cover;
            background-position: center;
            {if $data['header_background_fix']}
                background-attachment: fixed;
            {/if}
        {/if}
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    {/if}
    }

    {if !$data['disable_header'] && $data['header_background_darken']}
    .{$name}-{$id}-header::before {
        content: "";
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    }
    {/if}

    .{$name}-{$id}-header-title {
        position: relative;
        z-index: 1;
        font-size: 1.6rem;
        font-weight: 300;
        color: {$data['header_text_color']};
        margin: 0 0 6px 0;
        line-height: 1.4;
        letter-spacing: 0.5px;
    }

    .{$name}-{$id}-header-desc {
        position: relative;
        z-index: 1;
        font-size: 0.9rem;
        color: {$data['header_description_color']};
        margin: 0;
        line-height: 1.7;
        max-width: 520px;
        margin-left: auto;
        margin-right: auto;
        font-weight: 300;
    }

    .{$name}-{$id}-grid {
        position: relative;
        z-index: 2;
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: stretch;
        gap: 20px;
        max-width: {$data['width']};
        margin: 0 auto;
        padding-top: 40px;
    }

    .{$name}-{$id}-card {
        display: flex;
        flex-direction: column;
        width: {$data['card_width']};
        background: {$data['color_6']};
        border: 1px solid {$data['color_7']};
        border-radius: 4px;
        padding: 32px;
        transition: border-color 0.3s ease;
        position: relative;
    }

    .{$name}-{$id}-card:hover {
        border-color: {$data['color_3']};
    }

    .{$name}-{$id}-card-img {
        width: 100%;
        height: 140px;
        object-fit: cover;
        display: block;
        border-radius: 2px;
        margin-bottom: 24px;
    }

    .{$name}-{$id}-name-row {
        display: flex;
        align-items: baseline;
        gap: 10px;
        flex-wrap: wrap;
        margin-bottom: 6px;
    }

    .{$name}-{$id}-product-name {
        font-size: 0.95rem;
        font-weight: 600;
        color: {$data['color_1']};
        line-height: 1.4;
    }

    .{$name}-{$id}-label {
        display: inline-block;
        font-size: 0.65rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        padding: 1px 0;
    }

    .{$name}-{$id}-label-hot {
        color: {$data['hot_color']};
    }

    .{$name}-{$id}-label-new {
        color: {$data['new_color']};
    }

    .{$name}-{$id}-label-sale {
        color: {$data['sale_color']};
    }

    .{$name}-{$id}-group {
        font-size: 0.7rem;
        font-weight: 400;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        color: {$data['color_2']};
        margin-bottom: 20px;
    }

    .{$name}-{$id}-price-block {
        margin-bottom: 20px;
    }

    .{$name}-{$id}-price {
        font-size: 1.1rem;
        font-weight: 600;
        color: {$data['color_3']};
        line-height: 1.3;
    }

    .{$name}-{$id}-cycle {
        font-size: 0.72rem;
        color: {$data['color_4']};
        margin-top: 2px;
        font-weight: 300;
    }

    .{$name}-{$id}-desc {
        font-size: 0.8rem;
        color: {$data['color_5']};
        line-height: 1.75;
        flex: 1;
        margin-bottom: 28px;
        font-weight: 300;
    }

    .{$name}-{$id}-btn {
        display: inline-block;
        background: none;
        border: none;
        padding: 0;
        margin-top: auto;
        color: {$data['order_now_button_color']};
        font-size: 0.82rem;
        font-weight: 600;
        text-decoration: underline;
        text-underline-offset: 3px;
        text-decoration-thickness: 1px;
        cursor: pointer;
        transition: text-decoration-thickness 0.2s ease, text-underline-offset 0.2s ease;
        letter-spacing: 0.3px;
    }

    .{$name}-{$id}-btn:hover {
        text-decoration-thickness: 2px;
        text-underline-offset: 5px;
        color: {$data['order_now_button_color']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-grid {
            gap: 16px;
            padding-top: 28px;
        }
        .{$name}-{$id}-card {
            width: 100%;
            max-width: 380px;
            padding: 24px;
        }
        .{$name}-{$id}-header-title {
            font-size: 1.3rem;
        }
        .{$name}-{$id}-header {
            padding: 36px 16px 28px 16px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if !$data['disable_header'] && ($data['header_text'] neq '' || $data['header_description'] neq '')}
        <div class="{$name}-{$id}-header">
            {if $data['header_text'] neq ''}
                <h2 class="{$name}-{$id}-header-title">{$data['header_text']}</h2>
            {/if}
            {if $data['header_description'] neq ''}
                <p class="{$name}-{$id}-header-desc">{$data['header_description']}</p>
            {/if}
        </div>
    {/if}

    <div class="{$name}-{$id}-grid">
        {foreach $data['products'] as $product}
            <div class="{$name}-{$id}-card">
                {if $product['product_img'] neq ''}
                    <img class="{$name}-{$id}-card-img" src="{$product['product_img']}" alt="{$product['product_name']}" />
                {/if}

                <div class="{$name}-{$id}-name-row">
                    <span class="{$name}-{$id}-product-name">{$product['product_name']}</span>
                    {if $product['product_label']}
                        {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                        <span class="{$name}-{$id}-label {$name}-{$id}-label-{$product['product_label']}">{$data[$lbl_key]}</span>
                    {/if}
                </div>

                {if $product['product_group_name'] neq ''}
                    <div class="{$name}-{$id}-group">{$product['product_group_name']}</div>
                {/if}

                <div class="{$name}-{$id}-price-block">
                    <div class="{$name}-{$id}-price">{$product['product_price']['amount_string']}</div>
                    {if !$product['product_price_free'] && $product['product_price']['cycle'] neq ''}
                        <div class="{$name}-{$id}-cycle">{$product['product_price']['cycle']}</div>
                    {/if}
                </div>

                {if $product['product_description'] neq ''}
                    <div class="{$name}-{$id}-desc">{$product['product_description']}</div>
                {/if}

                <a href="{$product['product_order_url']}" class="{$name}-{$id}-btn">{$data['order_now_button_name']}</a>
            </div>
        {/foreach}
    </div>
</div>
