<style>
    .{$name}-{$id}-list-wrap {
        position: relative;
        z-index: 2;
        max-width: {if $data['width'] neq ''}{$data['width']}{else}1100px{/if};
        margin: 0 auto;
        padding: 0 16px;
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    }

    /* ---- header ---- */
    {if !$data['disable_header']}
    .{$name}-{$id}-list-header {
        position: relative;
        text-align: center;
        padding: 44px 24px;
        margin-bottom: 24px;
        border-radius: 10px;
        overflow: hidden;
        background-color: {$data['header_background_color']};
    {if $data['header_background_img'] neq ''}
        background-image: url("{$data['header_background_img']}");
        background-size: cover;
        background-position: center;
        {if $data['header_background_fix']}
        background-attachment: fixed;
        {/if}
    {/if}
    }
    {if $data['header_background_darken']}
    .{$name}-{$id}-list-header::before {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        z-index: 0;
    }
    {/if}
    .{$name}-{$id}-list-header > * {
        position: relative;
        z-index: 1;
    }
    .{$name}-{$id}-list-htitle {
        font-size: 1.8rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 6px 0;
    }
    .{$name}-{$id}-list-hdesc {
        font-size: 1rem;
        color: {$data['header_description_color']};
        margin: 0;
    }
    {/if}

    /* ---- table ---- */
    .{$name}-{$id}-list-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        border: 1px solid {$data['color_7']};
        border-radius: 8px;
        overflow: hidden;
    }

    /* ---- head row ---- */
    .{$name}-{$id}-list-thead {
        background: {$data['color_7']};
    }
    .{$name}-{$id}-list-thead th {
        padding: 12px 18px;
        font-size: 0.72rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1.2px;
        color: {$data['color_6']};
        text-align: left;
        border: none;
    }
    .{$name}-{$id}-list-thead th:last-child {
        text-align: right;
    }

    /* ---- body rows ---- */
    .{$name}-{$id}-list-row {
        border-bottom: 1px solid {$data['color_7']};
        transition: background 0.2s ease;
    }
    .{$name}-{$id}-list-row:last-child {
        border-bottom: none;
    }
    .{$name}-{$id}-list-row:nth-child(odd) {
        background: {$data['color_6']};
    }
    .{$name}-{$id}-list-row:nth-child(even) {
        background: {$data['color_6']};
        filter: brightness(0.97);
    }
    .{$name}-{$id}-list-row:hover {
        background: {$data['color_7']};
        filter: brightness(1);
    }
    .{$name}-{$id}-list-row:hover .{$name}-{$id}-list-pname,
    .{$name}-{$id}-list-row:hover .{$name}-{$id}-list-desc,
    .{$name}-{$id}-list-row:hover .{$name}-{$id}-list-price,
    .{$name}-{$id}-list-row:hover .{$name}-{$id}-list-cycle {
        filter: brightness(1.15);
    }

    .{$name}-{$id}-list-row td {
        padding: 14px 18px;
        vertical-align: middle;
        border: none;
    }

    /* ---- columns ---- */
    .{$name}-{$id}-list-col-name {
        min-width: 170px;
    }
    .{$name}-{$id}-list-pname {
        font-size: 0.95rem;
        font-weight: 600;
        color: {$data['color_1']};
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .{$name}-{$id}-list-grp {
        display: block;
        font-size: 0.72rem;
        color: {$data['color_2']};
        margin-top: 2px;
    }

    .{$name}-{$id}-list-col-desc {
        max-width: 320px;
    }
    .{$name}-{$id}-list-desc {
        font-size: 0.84rem;
        color: {$data['color_5']};
        line-height: 1.4;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .{$name}-{$id}-list-col-price {
        text-align: right;
        white-space: nowrap;
    }
    .{$name}-{$id}-list-price {
        font-size: 1.05rem;
        font-weight: 700;
        color: {$data['color_3']};
    }
    .{$name}-{$id}-list-cycle {
        display: block;
        font-size: 0.72rem;
        color: {$data['color_4']};
    }

    .{$name}-{$id}-list-col-action {
        text-align: right;
        white-space: nowrap;
    }
    .{$name}-{$id}-list-btn {
        display: inline-block;
        padding: 8px 22px;
        font-size: 0.82rem;
        font-weight: 600;
        text-decoration: none;
        border-radius: 6px;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        transition: filter 0.2s ease, transform 0.2s ease;
    }
    .{$name}-{$id}-list-btn:hover {
        filter: brightness(1.12);
        transform: translateY(-1px);
        text-decoration: none;
        color: {$data['order_now_button_text_color']};
    }

    /* ---- badge ---- */
    .{$name}-{$id}-list-badge {
        display: inline-block;
        padding: 2px 8px;
        font-size: 0.62rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.8px;
        border-radius: 3px;
        vertical-align: middle;
        flex-shrink: 0;
    }
    .{$name}-{$id}-list-badge-hot {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
    }
    .{$name}-{$id}-list-badge-new {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
    }
    .{$name}-{$id}-list-badge-sale {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
    }

    /* ---- responsive ---- */
    @media (max-width: 768px) {
        .{$name}-{$id}-list-table,
        .{$name}-{$id}-list-thead,
        .{$name}-{$id}-list-thead tr,
        .{$name}-{$id}-list-thead th,
        .{$name}-{$id}-list-row,
        .{$name}-{$id}-list-row td {
            display: block;
            width: 100%;
        }
        .{$name}-{$id}-list-thead {
            display: none;
        }
        .{$name}-{$id}-list-row {
            padding: 16px;
            margin-bottom: 8px;
            border-radius: 8px;
            border: 1px solid {$data['color_7']};
            border-bottom: 1px solid {$data['color_7']};
        }
        .{$name}-{$id}-list-row td {
            padding: 4px 0;
            text-align: left;
        }
        .{$name}-{$id}-list-col-price {
            text-align: left;
        }
        .{$name}-{$id}-list-col-action {
            text-align: left;
            padding-top: 10px;
        }
        .{$name}-{$id}-list-col-desc {
            max-width: none;
        }
        .{$name}-{$id}-list-desc {
            white-space: normal;
        }
        .{$name}-{$id}-list-htitle {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}-list-wrap">

    {if !$data['disable_header']}
    <div class="{$name}-{$id}-list-header">
        {if $data['header_text'] neq ''}
            <h2 class="{$name}-{$id}-list-htitle">{$data['header_text']}</h2>
        {/if}
        {if $data['header_description'] neq ''}
            <p class="{$name}-{$id}-list-hdesc">{$data['header_description']}</p>
        {/if}
    </div>
    {/if}

    <table class="{$name}-{$id}-list-table">
        <thead class="{$name}-{$id}-list-thead">
            <tr>
                <th>Product</th>
                <th>Description</th>
                <th>Price</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
        {foreach $data['products'] as $product}
            <tr class="{$name}-{$id}-list-row">
                <td class="{$name}-{$id}-list-col-name">
                    <div class="{$name}-{$id}-list-pname">
                        <span>{$product['product_name']}</span>
                        {if $product['product_label']}
                            {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                            <span class="{$name}-{$id}-list-badge {$name}-{$id}-list-badge-{$product['product_label']}">{$data[$lbl_key]}</span>
                        {/if}
                    </div>
                    {if $product['product_group_name'] neq ''}
                        <span class="{$name}-{$id}-list-grp">{$product['product_group_name']}</span>
                    {/if}
                </td>
                <td class="{$name}-{$id}-list-col-desc">
                    <div class="{$name}-{$id}-list-desc">{$product['product_description']}</div>
                </td>
                <td class="{$name}-{$id}-list-col-price">
                    <span class="{$name}-{$id}-list-price">{$product['product_price']['amount_string']}</span>
                    {if $product['product_price']['cycle'] neq ''}
                        <span class="{$name}-{$id}-list-cycle">{$product['product_price']['cycle']}</span>
                    {/if}
                </td>
                <td class="{$name}-{$id}-list-col-action">
                    <a href="{$product['product_order_url']}" class="{$name}-{$id}-list-btn">
                        {if $data['order_now_button_name'] neq ''}{$data['order_now_button_name']}{else}Order Now{/if}
                    </a>
                </td>
            </tr>
        {/foreach}
        </tbody>
    </table>

</div>
