<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 40px;
    }

    .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        padding: 48px 20px 36px 20px;
    {if !$data['disable_header']}
        background-color: {$data['header_background_color']};
        {if $data['header_background_img'] neq ''}
            background-image: url("{$data['header_background_img']}");
            background-size: cover;
            background-position: center;
            {if $data['header_background_fix']}
                background-attachment: fixed;
            {/if}
        {/if}
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    {/if}
    }

    {if !$data['disable_header'] && $data['header_background_darken']}
    .{$name}-{$id}-header::before {
        content: "";
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    }
    {/if}

    .{$name}-{$id}-header-title {
        position: relative;
        z-index: 1;
        font-size: 2rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 8px 0;
        line-height: 1.3;
    }

    .{$name}-{$id}-header-desc {
        position: relative;
        z-index: 1;
        font-size: 1.05rem;
        color: {$data['header_description_color']};
        margin: 0;
        line-height: 1.6;
        max-width: 620px;
        margin-left: auto;
        margin-right: auto;
    }

    .{$name}-{$id}-list {
        position: relative;
        z-index: 2;
        max-width: {$data['width']};
        margin: 0 auto;
        padding-top: 24px;
    }

    .{$name}-{$id}-row {
        display: flex;
        align-items: center;
        gap: 24px;
        padding: 24px 16px;
        background: {$data['color_6']};
        border-bottom: 1px solid {$data['color_7']};
        transition: background-color 0.3s ease;
        position: relative;
    }

    .{$name}-{$id}-row:first-child {
        border-top: 1px solid {$data['color_7']};
    }

    .{$name}-{$id}-row:hover {
        background-color: {$data['color_7']}0d;
    }

    .{$name}-{$id}-row-left {
        display: flex;
        align-items: center;
        gap: 18px;
        flex: 0 0 280px;
        min-width: 0;
    }

    .{$name}-{$id}-row-img {
        width: 64px;
        height: 64px;
        border-radius: 10px;
        object-fit: cover;
        flex-shrink: 0;
        border: 1px solid {$data['color_7']};
    }

    .{$name}-{$id}-row-info {
        min-width: 0;
    }

    .{$name}-{$id}-row-group {
        font-size: 0.7rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: {$data['color_2']};
        margin-bottom: 3px;
    }

    .{$name}-{$id}-row-name {
        font-size: 1.05rem;
        font-weight: 700;
        color: {$data['color_1']};
        line-height: 1.3;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .{$name}-{$id}-row-center {
        flex: 1;
        min-width: 0;
    }

    .{$name}-{$id}-row-desc {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.6;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .{$name}-{$id}-row-right {
        display: flex;
        align-items: center;
        gap: 20px;
        flex-shrink: 0;
    }

    .{$name}-{$id}-row-pricing {
        text-align: right;
        min-width: 100px;
    }

    .{$name}-{$id}-row-price {
        font-size: 1.3rem;
        font-weight: 800;
        color: {$data['color_3']};
        line-height: 1.2;
    }

    .{$name}-{$id}-row-cycle {
        font-size: 0.75rem;
        color: {$data['color_4']};
        margin-top: 2px;
    }

    .{$name}-{$id}-row-btn {
        display: inline-block;
        padding: 10px 24px;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        border-radius: 8px;
        font-size: 0.85rem;
        font-weight: 600;
        text-decoration: none;
        transition: filter 0.25s ease, transform 0.25s ease;
        cursor: pointer;
        white-space: nowrap;
    }

    .{$name}-{$id}-row-btn:hover {
        filter: brightness(1.1);
        transform: translateY(-1px);
        color: {$data['order_now_button_text_color']};
        text-decoration: none;
    }

    .{$name}-{$id}-label {
        display: inline-block;
        padding: 2px 10px;
        border-radius: 50px;
        font-size: 0.65rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-left: 10px;
        vertical-align: middle;
        line-height: 1.6;
    }

    .{$name}-{$id}-label-hot {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
    }

    .{$name}-{$id}-label-new {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
    }

    .{$name}-{$id}-label-sale {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-row {
            flex-direction: column;
            align-items: flex-start;
            gap: 14px;
            padding: 20px 0;
        }
        .{$name}-{$id}-row-left {
            flex: none;
            width: 100%;
        }
        .{$name}-{$id}-row-center {
            width: 100%;
        }
        .{$name}-{$id}-row-right {
            width: 100%;
            justify-content: space-between;
        }
        .{$name}-{$id}-row-pricing {
            text-align: left;
        }
        .{$name}-{$id}-header-title {
            font-size: 1.5rem;
        }
        .{$name}-{$id}-header {
            padding: 32px 16px 28px 16px;
        }
        .{$name}-{$id}-row-name {
            white-space: normal;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if !$data['disable_header'] && ($data['header_text'] neq '' || $data['header_description'] neq '')}
        <div class="{$name}-{$id}-header">
            {if $data['header_text'] neq ''}
                <h2 class="{$name}-{$id}-header-title">{$data['header_text']}</h2>
            {/if}
            {if $data['header_description'] neq ''}
                <p class="{$name}-{$id}-header-desc">{$data['header_description']}</p>
            {/if}
        </div>
    {/if}

    <div class="{$name}-{$id}-list">
        {foreach $data['products'] as $product}
            <div class="{$name}-{$id}-row">
                <div class="{$name}-{$id}-row-left">
                    {if $product['product_img'] neq ''}
                        <img class="{$name}-{$id}-row-img" src="{$product['product_img']}" alt="{$product['product_name']}" />
                    {/if}
                    <div class="{$name}-{$id}-row-info">
                        {if $product['product_group_name'] neq ''}
                            <div class="{$name}-{$id}-row-group">{$product['product_group_name']}</div>
                        {/if}
                        <div class="{$name}-{$id}-row-name">
                            {$product['product_name']}
                            {if $product['product_label']}
                                {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                                <span class="{$name}-{$id}-label {$name}-{$id}-label-{$product['product_label']}">{$data[$lbl_key]}</span>
                            {/if}
                        </div>
                    </div>
                </div>

                <div class="{$name}-{$id}-row-center">
                    {if $product['product_description'] neq ''}
                        <div class="{$name}-{$id}-row-desc">{$product['product_description']}</div>
                    {/if}
                </div>

                <div class="{$name}-{$id}-row-right">
                    <div class="{$name}-{$id}-row-pricing">
                        <div class="{$name}-{$id}-row-price">{$product['product_price']['amount_string']}</div>
                        {if !$product['product_price_free'] && $product['product_price']['cycle'] neq ''}
                            <div class="{$name}-{$id}-row-cycle">{$product['product_price']['cycle']}</div>
                        {/if}
                    </div>
                    <a href="{$product['product_order_url']}" class="{$name}-{$id}-row-btn">{$data['order_now_button_name']}</a>
                </div>
            </div>
        {/foreach}
    </div>
</div>
