<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 40px;
    }

    .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        padding: 52px 20px 40px 20px;
    {if !$data['disable_header']}
        background-color: {$data['header_background_color']};
        {if $data['header_background_img'] neq ''}
            background-image: url("{$data['header_background_img']}");
            background-size: cover;
            background-position: center;
            {if $data['header_background_fix']}
                background-attachment: fixed;
            {/if}
        {/if}
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    {/if}
    }

    {if !$data['disable_header'] && $data['header_background_darken']}
    .{$name}-{$id}-header::before {
        content: "";
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    }
    {/if}

    .{$name}-{$id}-header-title {
        position: relative;
        z-index: 1;
        font-size: 2.1rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 10px 0;
        line-height: 1.25;
        letter-spacing: -0.3px;
    }

    .{$name}-{$id}-header-desc {
        position: relative;
        z-index: 1;
        font-size: 1rem;
        color: {$data['header_description_color']};
        margin: 0;
        line-height: 1.7;
        max-width: 560px;
        margin-left: auto;
        margin-right: auto;
        font-weight: 300;
    }

    .{$name}-{$id}-grid {
        position: relative;
        z-index: 2;
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: stretch;
        gap: 24px;
        max-width: {$data['width']};
        margin: 0 auto;
        padding-top: 36px;
    }

    .{$name}-{$id}-card {
        position: relative;
        display: flex;
        flex-direction: column;
        width: {$data['card_width']};
        background: {$data['color_6']}cc;
        border: 1px solid {$data['color_7']}44;
        border-radius: 16px;
        overflow: hidden;
        backdrop-filter: blur(16px);
        -webkit-backdrop-filter: blur(16px);
        transition: border-color 0.35s ease, box-shadow 0.35s ease;
    }

    .{$name}-{$id}-card:hover {
        border-color: {$data['color_7']};
        box-shadow: 0 8px 40px {$data['color_7']}22;
    }

    .{$name}-{$id}-card-img {
        width: 100%;
        height: 180px;
        object-fit: cover;
        display: block;
    }

    .{$name}-{$id}-card-body {
        display: flex;
        flex-direction: column;
        flex: 1;
        padding: 28px;
    }

    .{$name}-{$id}-label {
        position: absolute;
        top: 14px;
        right: 14px;
        padding: 5px 14px;
        border-radius: 50px;
        font-size: 0.68rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.8px;
        z-index: 3;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        line-height: 1.5;
    }

    .{$name}-{$id}-label-hot {
        background: {$data['hot_color']}dd;
        color: {$data['hot_text_color']};
    }

    .{$name}-{$id}-label-new {
        background: {$data['new_color']}dd;
        color: {$data['new_text_color']};
    }

    .{$name}-{$id}-label-sale {
        background: {$data['sale_color']}dd;
        color: {$data['sale_text_color']};
    }

    .{$name}-{$id}-group {
        font-size: 0.72rem;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        color: {$data['color_2']};
        margin-bottom: 8px;
    }

    .{$name}-{$id}-product-name {
        font-size: 1.2rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 16px;
        line-height: 1.3;
    }

    .{$name}-{$id}-price-block {
        margin-bottom: 16px;
    }

    .{$name}-{$id}-price {
        font-size: 1.6rem;
        font-weight: 800;
        color: {$data['color_3']};
        line-height: 1.2;
    }

    .{$name}-{$id}-cycle {
        font-size: 0.78rem;
        color: {$data['color_4']};
        margin-top: 3px;
        font-weight: 300;
    }

    .{$name}-{$id}-desc {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.7;
        flex: 1;
        margin-bottom: 24px;
    }

    .{$name}-{$id}-btn {
        display: inline-block;
        width: 100%;
        text-align: center;
        padding: 12px 24px;
        margin-top: auto;
        background: transparent;
        color: {$data['order_now_button_color']};
        border: 2px solid {$data['order_now_button_color']};
        border-radius: 50px;
        font-size: 0.9rem;
        font-weight: 600;
        text-decoration: none;
        transition: background 0.3s ease, color 0.3s ease, transform 0.25s ease;
        cursor: pointer;
        box-sizing: border-box;
    }

    .{$name}-{$id}-btn:hover {
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        transform: translateY(-2px);
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-grid {
            gap: 18px;
            padding-top: 24px;
        }
        .{$name}-{$id}-card {
            width: 100%;
            max-width: 400px;
        }
        .{$name}-{$id}-header-title {
            font-size: 1.5rem;
        }
        .{$name}-{$id}-header {
            padding: 36px 16px 28px 16px;
        }
        .{$name}-{$id}-card-body {
            padding: 20px;
        }
        .{$name}-{$id}-price {
            font-size: 1.35rem;
        }
        .{$name}-{$id}-card-img {
            height: 150px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if !$data['disable_header'] && ($data['header_text'] neq '' || $data['header_description'] neq '')}
        <div class="{$name}-{$id}-header">
            {if $data['header_text'] neq ''}
                <h2 class="{$name}-{$id}-header-title">{$data['header_text']}</h2>
            {/if}
            {if $data['header_description'] neq ''}
                <p class="{$name}-{$id}-header-desc">{$data['header_description']}</p>
            {/if}
        </div>
    {/if}

    <div class="{$name}-{$id}-grid">
        {foreach $data['products'] as $product}
            <div class="{$name}-{$id}-card">
                {if $product['product_label']}
                    {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                    <span class="{$name}-{$id}-label {$name}-{$id}-label-{$product['product_label']}">{$data[$lbl_key]}</span>
                {/if}

                {if $product['product_img'] neq ''}
                    <img class="{$name}-{$id}-card-img" src="{$product['product_img']}" alt="{$product['product_name']}" />
                {/if}

                <div class="{$name}-{$id}-card-body">
                    {if $product['product_group_name'] neq ''}
                        <div class="{$name}-{$id}-group">{$product['product_group_name']}</div>
                    {/if}

                    <div class="{$name}-{$id}-product-name">{$product['product_name']}</div>

                    <div class="{$name}-{$id}-price-block">
                        <div class="{$name}-{$id}-price">{$product['product_price']['amount_string']}</div>
                        {if !$product['product_price_free'] && $product['product_price']['cycle'] neq ''}
                            <div class="{$name}-{$id}-cycle">{$product['product_price']['cycle']}</div>
                        {/if}
                    </div>

                    {if $product['product_description'] neq ''}
                        <div class="{$name}-{$id}-desc">{$product['product_description']}</div>
                    {/if}

                    <a href="{$product['product_order_url']}" class="{$name}-{$id}-btn">{$data['order_now_button_name']}</a>
                </div>
            </div>
        {/foreach}
    </div>
</div>
