class PUQProductCards {
    static get toolbox() {
        return {
            title: 'Product Cards',
            icon: '<i class="fas fa-shopping-cart"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {


        const productGroups = JSON.parse(productgroupsJson);
        let groupOptions = '';

        productGroups.forEach(function(group) {
            groupOptions += '<option value="' + group.id + '">' + group.name + '</option>';
        });

        const optionTemplates = generateOptionTemplates('PUQProductCards');
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td class="fieldlabel"><h1 style="color: blue;">Product Cards</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

     <tr>
        <td class="fieldlabel"><b>Color</b></td>
        <td colspan="3" class="fieldarea">

            <label for="color_1">Product name:</label>
            <input type="color" name="color_1" class="form-control input-inline input-50">

            <label for="color_2">Group name:</label>
            <input type="color" name="color_2" class="form-control input-inline input-50">

            <label for="color_3">Price:</label>
            <input type="color" name="color_3" class="form-control input-inline input-50">

            <label for="color_4">Billing cycle:</label>
            <input type="color" name="color_4" class="form-control input-inline input-50">

            <label for="color_5">Description:</label>
            <input type="color" name="color_5" class="form-control input-inline input-50">
            <br>
            <label for="color_6">Card background:</label>
            <input type="color" name="color_6" class="form-control input-inline input-50">

            <label for="color_7">Card border:</label>
            <input type="color" name="color_7" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">

        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>
    <tr>
        <td class="fieldlabel"><b>Header text/color</b><br>e.g. (Our products)</td>
        <td class="fieldarea">
            <input type="text" name="header_text" value="" class="form-control input-inline input-200">
            <input type="color" name="header_text_color" class="form-control input-inline input-50">
            <br>
            <input type="text" name="header_description" value="" class="form-control input-inline input-200">
            <input type="color" name="header_description_color" class="form-control input-inline input-50"><br>
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_header"><b>Disable header</b></label>
        </td>
        <td class="fieldlabel"><b>Header img/color</td>
        <td class="fieldarea">
            <input type="text" name="header_background_img" value="" class="form-control input-inline input-200">
            <input type="color" name="header_background_color" class="form-control input-inline input-50"><br>
            <label class="checkbox-inline">
            <input type="checkbox" name="header_background_fix"><b>Fix header background</b></label>
            <br>
            <label class="checkbox-inline">
            <input type="checkbox" name="header_background_darken"><b>Darken header background</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">Hot label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="hot_label" value="" class="form-control input-inline input-300">
            <input type="color" name="hot_color" class="form-control input-inline input-60">
            <label for="hot_text_color">Text color:</label>
            <input type="color" name="hot_text_color" value="" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">New label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="new_label" value="" class="form-control input-inline input-300">
            <input type="color" name="new_color" class="form-control input-inline input-60">
            <label for="new_text_color">Text color:</label>
            <input type="color" name="new_text_color" value="" class="form-control input-inline input-50">
        </td>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">Sale label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="sale_label" value="" class="form-control input-inline input-300">
            <input type="color" name="sale_color" class="form-control input-inline input-60">
            <label for="sale_text_color">Text color:</label>
            <input type="color" name="sale_text_color" value="" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Order Now button name</b><br>e.g. (Order Now)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="order_now_button_name" value="" class="form-control input-inline input-200">
            <label for="order_now_button_color">Button color:</label>
            <input type="color" name="order_now_button_color" class="form-control input-inline input-50">
            <label for="order_now_button_text_color">Text color:</label>
            <input type="color" name="order_now_button_text_color" class="form-control input-inline input-50">
        </td>
    </tr>


    <tr>
        <td class="fieldlabel">
            Product card parameters
        </td>
        <td colspan="3" class="fieldarea">
            <label for="width">Card width: </label>
            <input type="text" name="card_width" class="form-control input-inline input-100" value="">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><a type="button" name="add-row"><div style="font-size: 24px;" class="fa fa-plus"></div></a></td>
        <td colspan="3" class="fieldarea">
        <label for="show_product_from_group">Show products from group:</label>
            <select name="show_product_from_group" class="form-control select-inline" style="width: 300px;">
                <option value="none">none</option>
                ${groupOptions}
            </select>

            <label for="show_product_from_group_show_price">Show price:</label>
            <select name="show_product_from_group_show_price" class="form-control select-inline" style="width: 200px;">
                <option value="first_price">First price</option>
                <option value="best_price">Best price</option>
                <option value="monthly_price">Monthly price</option>
                <option value="semi_annual_price">Semi annual price</option>
                <option value="annual_price">Annual price</option>
                <option value="biennially_price">Biennially price</option>
                <option value="triennially_price">Triennially price</option>
            </select>
            <br>
            <label class="checkbox-inline"><input type="checkbox" name="show_behind_list"><b>Show behind the list</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"></td>
        <td colspan="3" class="fieldarea">
            <table name="ProductsTable" class="datatable">
                <thead>
                <tr>
                    <th class="text-center" style="width: 405px;"><b>Name/IMG</b></th>
                    <th class="text-center"><b>Options</b></th>
                    <th class="text-center"></th>
                    <th class="text-center"></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </td>
    </tr>

    </tbody>
</table>
`);

        const productsData = JSON.parse(productsJson);
        let productOptions = '';

        productsData.forEach(function(product) {
            productOptions += '<option value="' + product.id + '">' + product.name + ' (' + product.group_name + ') </option>';
        });

        const table = render.querySelector("[name='ProductsTable']");
        const addRowButton = render.querySelector("[name='add-row']");

        const products = this.data && this.data.products ? this.data.products : {};
        const tbody = table.querySelector("tbody");
        Object.entries(products).forEach(([key, value]) => {
            const row = document.createElement("tr");

            let options = "";
            productsData.forEach(function(product) {
                if (product.id == value.product_name) {
                    options += '<option value="' + product.id + '" selected>' + product.name + ' (' + product.group_name + ') </option>';
                } else {
                    options += '<option value="' + product.id + '">' + product.name + ' (' + product.group_name + ') </option>';
                }
            });

            var label_none = '';
            var label_hot = '';
            var label_new = '';
            var label_sale = '';
            if (value.product_label === '') {
                label_none = 'selected';
            }if (value.product_label === 'hot') {
                label_hot = 'selected';
            }
            if (value.product_label === 'new') {
                label_new = 'selected';
            }
            if (value.product_label === 'sale') {
                label_sale = 'selected';
            }

            var first_price = '';
            var best_price = '';
            var monthly_price = '';
            var semi_annual_price = '';
            var annual_price = '';
            var biennially_price = '';
            var triennially_price = '';

            if (value.show_price === 'first_price') {
                first_price = 'selected';
            }
            if (value.show_price === 'best_price') {
                best_price = 'selected';
            }
            if (value.show_price === 'monthly_price') {
                monthly_price = 'selected';
            }
            if (value.show_price === 'semi_annual_price') {
                semi_annual_price = 'selected';
            }
            if (value.show_price === 'annual_price') {
                annual_price = 'selected';
            }
            if (value.show_price === 'biennially_price') {
                biennially_price = 'selected';
            }
            if (value.show_price === 'triennially_price') {
                triennially_price = 'selected';
            }

            row.innerHTML = `
                <td class="text-left" style="width: 405px;">
                    <label for="product_name">Product Name: </label>
                    <select name="product_name" class="form-control" style="width: 400px;">
                            ${options}
                    </select>

                    <label for="member_img">IMG: </label>
                    <input type="text" name="product_img" value="${value.product_img}" class="form-control input-inline input-400"><br>
                </td>
                <td class="text-left">
                    <label for="product_label">Lable: </label>
                     <select name="product_label" class="form-control" style="width: 200px;">
                        <option value="" ${label_none}>none</option>
                        <option value="hot" ${label_hot}>Hot</option>
                        <option value="new" ${label_new}>New</option>
                        <option value="sale" ${label_sale}>Sale</option>
                    </select>

                     <label for="show_price">Show price: </label>
                     <select name="show_price" class="form-control" style="width: 200px;">
                        <option value="first_price" ${first_price}>First price</option>
                        <option value="best_price" ${best_price}>Best price</option>
                        <option value="monthly_price" ${monthly_price}>Monthly price</option>
                        <option value="semi_annual_price" ${semi_annual_price}>Semi annual price</option>
                        <option value="annual_price" ${annual_price}>Annual price</option>
                        <option value="biennially_price" ${biennially_price}>Biennially price</option>
                        <option value="triennially_price" ${triennially_price}>Triennially price</option>
                    </select>
                </td>
                </td>
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
            `;
            tbody.appendChild(row);
            addRowListeners(row);
        });

        function addRow() {
            const tbody = table.querySelector("tbody");
            const row = document.createElement("tr");
            row.innerHTML = `
                <td class="text-left" style="width: 405px;">
                    <label for="product_name">Product Name: </label>
                    <select name="product_name" class="form-control" style="width: 400px;">
                            ${productOptions}
                    </select>

                    <label for="product_img">IMG: </label>
                    <input type="text" name="product_img" value="" class="form-control input-inline input-400"><br>
                </td>
                <td class="text-left">
                     <label for="product_label">Lable: </label>
                     <select name="product_label" class="form-control" style="width: 200px;">
                        <option value="">none</option>
                        <option value="hot">Hot</option>
                        <option value="new">New</option>
                        <option value="sale">Sale</option>
                    </select>

                    <label for="show_price">Show price: </label>
                     <select name="show_price" class="form-control" style="width: 200px;">
                        <option value="first_price">First price</option>
                        <option value="best_price">Best price</option>
                        <option value="monthly_price">Monthly price</option>
                        <option value="semi_annual_price">Semi annual price</option>
                        <option value="annual_price">Annual price</option>
                        <option value="biennially_price">Biennially price</option>
                        <option value="triennially_price">Triennially price</option>
                    </select>
                </td>
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
  `;
            tbody.appendChild(row);
            addRowListeners(row);
        }

        function removeRow(row) {
            row.remove();
        }

        function moveRow(row, direction) {
            const tbody = row.parentNode;
            const rows = Array.from(tbody.children);
            const index = rows.indexOf(row);
            const newIndex = index + direction;

            if (newIndex >= 0 && newIndex < rows.length) {
                const siblingRow = rows[newIndex];
                if (direction === 1) {
                    tbody.insertBefore(row, siblingRow.nextSibling);
                } else {
                    tbody.insertBefore(row, siblingRow);
                }
            } else if (newIndex === -1) {
                tbody.insertBefore(row, rows[0]);
            } else if (newIndex === rows.length) {
                tbody.insertBefore(row, null);
            }
        }

        function addRowListeners(row) {
            const removeButton = row.querySelector("[name='remove-row']");
            const moveUpButton = row.querySelector("[name='move-up']");
            const moveDownButton = row.querySelector("[name='move-down']");

            removeButton.addEventListener("click", () => {
                removeRow(row);
            });

            moveUpButton.addEventListener("click", () => {
                moveRow(row, -1);
            });

            moveDownButton.addEventListener("click", () => {
                moveRow(row, 1);
            });
        }

        addRowButton.addEventListener("click", () => {
            addRow();
        });

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const color_1 = this.data && this.data.color_1 ? this.data.color_1 : "";
        $(render).find("[name='color_1']").val(color_1);
        if (color_1 === '') {
            $(render).find("[name='color_1']").val('#000000');
        }

        const color_2 = this.data && this.data.color_2 ? this.data.color_2 : "";
        $(render).find("[name='color_2']").val(color_2);
        if (color_2 === '') {
            $(render).find("[name='color_2']").val('#969090');
        }

        const color_3 = this.data && this.data.color_3 ? this.data.color_3 : "";
        $(render).find("[name='color_3']").val(color_3);
        if (color_3 === '') {
            $(render).find("[name='color_3']").val('#d21111');
        }

        const color_4 = this.data && this.data.color_4 ? this.data.color_4 : "";
        $(render).find("[name='color_4']").val(color_4);
        if (color_4 === '') {
            $(render).find("[name='color_4']").val('#ecab4e');
        }

        const color_5 = this.data && this.data.color_5 ? this.data.color_5 : "";
        $(render).find("[name='color_5']").val(color_5);
        if (color_5 === '') {
            $(render).find("[name='color_5']").val('#000000');
        }

        const color_6 = this.data && this.data.color_6 ? this.data.color_6 : "";
        $(render).find("[name='color_6']").val(color_6);
        if (color_6 === '') {
            $(render).find("[name='color_6']").val('#fdfdfd');
        }

        const color_7 = this.data && this.data.color_7 ? this.data.color_7 : "";
        $(render).find("[name='color_7']").val(color_7);
        if (color_7 === '') {
            $(render).find("[name='color_7']").val('#7405d0');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#ffffff');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const header_text = this.data && this.data.header_text ? this.data.header_text : "";
        $(render).find("[name='header_text']").val(header_text);
        if (header_text === '') {
            $(render).find("[name='header_text']").val('Our products');
        }

        const header_text_color = this.data && this.data.header_text_color ? this.data.header_text_color : "";
        $(render).find("[name='header_text_color']").val(header_text_color);
        if (header_text_color === '') {
            $(render).find("[name='header_text_color']").val('#000000');
        }

        const header_description = this.data && this.data.header_description ? this.data.header_description : "";
        $(render).find("[name='header_description']").val(header_description);

        const header_description_color = this.data && this.data.header_description_color ? this.data.header_description_color : "";
        $(render).find("[name='header_description_color']").val(header_description_color);
        if (header_description_color === '') {
            $(render).find("[name='header_description_color']").val('#7405d0');
        }

        const header_background_img = this.data && this.data.header_background_img ? this.data.header_background_img : "";
        $(render).find("[name='header_background_img']").val(header_background_img);

        const header_background_color = this.data && this.data.header_background_color ? this.data.header_background_color : "";
        $(render).find("[name='header_background_color']").val(header_background_color);
        if (header_background_color === '') {
            $(render).find("[name='header_background_color']").val('#d8b9f0');
        }

        if (this.data.disable_header === true) {
            $(render).find("[name='disable_header']").attr('checked', 'checked');
        }

        if (this.data.header_background_fix === true) {
            $(render).find("[name='header_background_fix']").attr('checked', 'checked');
        }

        if (this.data.header_background_darken === true) {
            $(render).find("[name='header_background_darken']").attr('checked', 'checked');
        }

        const hot_label = this.data && this.data.hot_label ? this.data.hot_label : "";
        $(render).find("[name='hot_label']").val(hot_label);
        if (hot_label === '') {
            $(render).find("[name='hot_label']").val('Hot');
        }

        const hot_color = this.data && this.data.hot_color ? this.data.hot_color : "";
        $(render).find("[name='hot_color']").val(hot_color);
        if (hot_color === '') {
            $(render).find("[name='hot_color']").val('#d51111');
        }

        const hot_text_color = this.data && this.data.hot_text_color ? this.data.hot_text_color : "";
        $(render).find("[name='hot_text_color']").val(hot_text_color);
        if (hot_text_color === '') {
            $(render).find("[name='hot_text_color']").val('#ffffff');
        }

        const new_label = this.data && this.data.new_label ? this.data.new_label : "";
        $(render).find("[name='new_label']").val(new_label);
        if (new_label === '') {
            $(render).find("[name='new_label']").val('New');
        }

        const new_color = this.data && this.data.new_color ? this.data.new_color : "";
        $(render).find("[name='new_color']").val(new_color);
        if (new_color === '') {
            $(render).find("[name='new_color']").val('#5cb75c');
        }

        const new_text_color = this.data && this.data.new_text_color ? this.data.new_text_color : "";
        $(render).find("[name='new_text_color']").val(new_text_color);
        if (new_text_color === '') {
            $(render).find("[name='new_text_color']").val('#4f1998');
        }

        const sale_label = this.data && this.data.sale_label ? this.data.sale_label : "";
        $(render).find("[name='sale_label']").val(sale_label);
        if (sale_label === '') {
            $(render).find("[name='sale_label']").val('Sale');
        }

        const sale_color = this.data && this.data.sale_color ? this.data.sale_color : "";
        $(render).find("[name='sale_color']").val(sale_color);
        if (sale_color === '') {
            $(render).find("[name='sale_color']").val('#eeac4e');
        }

        const sale_text_color = this.data && this.data.sale_text_color ? this.data.sale_text_color : "";
        $(render).find("[name='sale_text_color']").val(sale_text_color);
        if (sale_text_color === '') {
            $(render).find("[name='sale_text_color']").val('#000000');
        }

        const order_now_button_name = this.data && this.data.order_now_button_name ? this.data.order_now_button_name : "";
        $(render).find("[name='order_now_button_name']").val(order_now_button_name);
        if (order_now_button_name === '') {
            $(render).find("[name='order_now_button_name']").val('Order Now');
        }

        const order_now_button_color = this.data && this.data.order_now_button_color ? this.data.order_now_button_color : "";
        $(render).find("[name='order_now_button_color']").val(order_now_button_color);
        if (order_now_button_color === '') {
            $(render).find("[name='order_now_button_color']").val('#6420c0');
        }

        const order_now_button_text_color = this.data && this.data.order_now_button_text_color ? this.data.order_now_button_text_color : "";
        $(render).find("[name='order_now_button_text_color']").val(order_now_button_text_color);
        if (order_now_button_text_color === '') {
            $(render).find("[name='order_now_button_text_color']").val('#0de1b9');
        }

        const card_width = this.data && this.data.card_width ? this.data.card_width : "";
        $(render).find("[name='card_width']").val(card_width);

        const show_product_from_group = this.data && this.data.show_product_from_group ? this.data.show_product_from_group : "";
        $(render).find("[name='show_product_from_group']").val(show_product_from_group);
        if (show_product_from_group === '') {
            $(render).find("[name='show_product_from_group']").val('none');
        }

        const show_product_from_group_show_price = this.data && this.data.show_product_from_group_show_price ? this.data.show_product_from_group_show_price : "";
        $(render).find("[name='show_product_from_group_show_price']").val(show_product_from_group_show_price);
        if (show_product_from_group_show_price === '') {
            $(render).find("[name='show_product_from_group_show_price']").val('first_price');
        }

        if (this.data.show_behind_list === true) {
            $(render).find("[name='show_behind_list']").attr('checked', 'checked');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }

        var disable_header = false;
        if ($(content).find("[name='disable_header']").is(':checked')) {
            disable_header = true;
        }

        var header_background_darken = false;
        if ($(content).find("[name='header_background_darken']").is(':checked')) {
            header_background_darken = true;
        }

        var header_background_fix = false;
        if ($(content).find("[name='header_background_fix']").is(':checked')) {
            header_background_fix = true;
        }

        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var show_behind_list = false;
        if ($(content).find("[name='show_behind_list']").is(':checked')) {
            show_behind_list = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        const table = content.querySelector("[name='ProductsTable']")
        const rows = table.querySelectorAll('tbody tr');
        const data = {};
        rows.forEach((row, index) => {
            const inputs = row.querySelectorAll('input');
            const selects = row.querySelectorAll('select');

            const values = {};
            inputs.forEach(input => {
                const name = input.getAttribute('name');
                if (name === 'product_img') {
                    values[name] = input.value;
                }
            });

            selects.forEach(select => {
                const name = select.getAttribute('name');
                if (name === 'product_name') {
                    values[name] = select.value;
                }
                if (name === 'product_label') {
                    values[name] = select.value;
                }
                if (name === 'show_price') {
                    values[name] = select.value;
                }
            });

            if (Object.keys(values).length > 0) {
                data[index] = values;
            }
        });

        return {
            "width": $(content).find("[name='width']").val().replace(/\t/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/\t/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/\t/g, ""),
            "style": style.replace(/\t/g, ""),

            "color_1": $(content).find("[name='color_1']").val().replace(/\t/g, ""),
            "color_2": $(content).find("[name='color_2']").val().replace(/\t/g, ""),
            "color_3": $(content).find("[name='color_3']").val().replace(/\t/g, ""),
            "color_4": $(content).find("[name='color_4']").val().replace(/\t/g, ""),
            "color_5": $(content).find("[name='color_5']").val().replace(/\t/g, ""),
            "color_6": $(content).find("[name='color_6']").val().replace(/\t/g, ""),
            "color_7": $(content).find("[name='color_7']").val().replace(/\t/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/\t/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/\t/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "header_background_fix": header_background_fix,
            "header_background_darken": header_background_darken,
            "full_width": full_width,

            "header_text": $(content).find("[name='header_text']").val().replace(/\t/g, ""),
            "header_text_color": $(content).find("[name='header_text_color']").val().replace(/\t/g, ""),
            "header_description": $(content).find("[name='header_description']").val().replace(/\t/g, ""),
            "header_description_color": $(content).find("[name='header_description_color']").val().replace(/\t/g, ""),
            "header_background_img": $(content).find("[name='header_background_img']").val().replace(/\t/g, ""),
            "header_background_color": $(content).find("[name='header_background_color']").val().replace(/\t/g, ""),

            "disable_header": disable_header,

            "hot_label": $(content).find("[name='hot_label']").val().replace(/\t/g, ""),
            "hot_color": $(content).find("[name='hot_color']").val().replace(/\t/g, ""),
            "hot_text_color": $(content).find("[name='hot_text_color']").val().replace(/\t/g, ""),

            "new_label": $(content).find("[name='new_label']").val().replace(/\t/g, ""),
            "new_color": $(content).find("[name='new_color']").val().replace(/\t/g, ""),
            "new_text_color": $(content).find("[name='new_text_color']").val().replace(/\t/g, ""),

            "sale_label": $(content).find("[name='sale_label']").val().replace(/\t/g, ""),
            "sale_color": $(content).find("[name='sale_color']").val().replace(/\t/g, ""),
            "sale_text_color": $(content).find("[name='sale_text_color']").val().replace(/\t/g, ""),

            "order_now_button_name": $(content).find("[name='order_now_button_name']").val().replace(/\t/g, ""),
            "order_now_button_color": $(content).find("[name='order_now_button_color']").val().replace(/\t/g, ""),
            "order_now_button_text_color": $(content).find("[name='order_now_button_text_color']").val().replace(/\t/g, ""),

            "card_width": $(content).find("[name='card_width']").val().replace(/\t/g, ""),

            "show_product_from_group": $(content).find("[name='show_product_from_group']").val().replace(/\t/g, ""),
            "show_product_from_group_show_price": $(content).find("[name='show_product_from_group_show_price']").val().replace(/\t/g, ""),

            "show_behind_list": show_behind_list,

            "products": data
        };
    }
}
