class PUQPageBackground {
    static get toolbox() {
        return {
            title: 'Page Background',
            icon: '<i class="far fa-fill-drip"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true,
                bold: true,
                strong: true,
                iframe: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
                em: true,
                del: true,
                blockquote: true,
            }
        };
    }

    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        var id = this.data && this.data.id ? this.data.id : "";
        if (id === '') {
            id = Math.random().toString(36).substring(2, 12);
        }

        const optionTemplates = generateOptionTemplates('PUQPageBackground');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td class="fieldlabel"><h1 style="color: blue;">Page Background</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td class="fieldarea">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
            <label for="background_darken">Darken background: </label>
            <input type="text" name="background_darken" value="" class="form-control input-inline input-100">%
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td class="fieldarea">
            <input type="text" name="background_image" value="" class="form-control input-inline input-400">
            <input type="color" name="background_color" class="form-control input-inline input-50">
        </td>
    </tr>

     <tr>
        <td class="fieldlabel"><b>Background video</b></td>
        <td class="fieldarea">
            <table style="width: 100%;">
                <tr>
                    <td style="text-align: right;"><label for="background_video_mp4">mp4: </label></td>
                    <td><input type="text" name="background_video_mp4" value="" class="form-control input-inline input-500"></td>
                </tr>

                <tr>
                   <td style="text-align: right;"><label for="background_video_ogg">ogg: </label></td>
                    <td><input type="text" name="background_video_ogg" value="" class="form-control input-inline input-500"></td>
                </tr>

                </tr>
                    <td style="text-align: right;"><label for="background_video_webm">webm: </label></td>
                    <td><input type="text" name="background_video_webm" value="" class="form-control input-inline input-500"></td>
                </tr>
            </table>
        </td>
    </tr>
     </tbody>
</table>
`);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const background_darken = this.data && this.data.background_darken ? this.data.background_darken : "";
        $(render).find("[name='background_darken']").val(background_darken);
        if (background_darken === '') {
            $(render).find("[name='background_darken']").val('0');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#9f81c7');
        }

        const background_video_mp4 = this.data && this.data.background_video_mp4 ? this.data.background_video_mp4 : "";
        $(render).find("[name='background_video_mp4']").val(background_video_mp4);

        const background_video_ogg = this.data && this.data.background_video_ogg ? this.data.background_video_ogg : "";
        $(render).find("[name='background_video_ogg']").val(background_video_ogg);

        const background_video_webm = this.data && this.data.background_video_webm ? this.data.background_video_webm : "";
        $(render).find("[name='background_video_webm']").val(background_video_webm);

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        var background_darken =  parseInt($(content).find("[name='background_darken']").val().replace(/	/g, ""), 10);

        // Проверяем, является ли число целым и находится ли в диапазоне 0-99
        if (!(Number.isInteger(background_darken) && background_darken >= 0 && background_darken <= 99)) {
            background_darken = 0
        }


        return {
            "style": style.replace(/	/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/	/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/	/g, ""),
            "background_video_mp4": $(content).find("[name='background_video_mp4']").val().replace(/	/g, ""),
            "background_video_ogg": $(content).find("[name='background_video_ogg']").val().replace(/	/g, ""),
            "background_video_webm": $(content).find("[name='background_video_webm']").val().replace(/	/g, ""),
            "background_darken": background_darken,
        };
    }
}
