<style>
    .{$name}-{$id} {
        transition: top 0.3s ease-in-out;
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id}-sticky {
        z-index: 99999;
        position: fixed;
        top: 0;
        right: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
                       position: relative;
                       z-index: 2;
                       display: inline-block;
                       width: 100%;
                       text-align: center;
                   {if $data['width'] neq ''}
                       max-width: {$data['width']};
                   {/if}
                   }

    .{$name}-{$id} .{$name}-{$id}-header {
                       z-index: 2;
                       text-align: center;
                       font-size: 2rem;
                       font-weight: bold;
                       text-transform: uppercase;
                       letter-spacing: 2px;
                       margin: 1rem 0;
                       color: {$data['header_text_color']};
                   }

    .{$name}-{$id} .{$name}-{$id}-content {
                       background-color: {$data['color_5']};
                       text-align: center;
                       overflow: hidden;
                       max-height: 0;
                       transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1), padding 0.4s cubic-bezier(0.77, 0, 0.175, 1);
                       box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
                   }

    .{$name}-{$id} .{$name}-{$id}-mm-container ul {
                       list-style-type: none;
                       margin: 0;
                       padding: 0;
                   }

    .{$name}-{$id} .{$name}-{$id}-mm-container li {
                       display: inline;
                   }

    .{$name}-{$id} .{$name}-{$id}-mm-container a {
                       position: relative;
                       text-align: center;
                       background-color: {$data['color_1']};
                       color: {$data['color_2']};
                       text-decoration: none !important;
                       display: inline-block;
                       white-space: nowrap;
                       border: 1px solid {$data['color_3']};
                       padding: 10px 20px;
                       font-size: 16px;
                       margin: 5px;
                       cursor: pointer;
                       transition: all 0.2s ease-in-out;
                       border-radius: 5px;
                       font-weight: 600;
                   }

    .{$name}-{$id} .{$name}-{$id}-mm-container a:hover {
                       background-color: {$data['color_4']};
                       color: {$data['color_5']};
                       border: 1px solid {$data['color_6']};
                   }

    .{$name}-{$id} .{$name}-{$id}-mm-container select {
                       text-align: center;
                       margin-top: 10px;
                       margin-bottom: 10px;
                       width: 100%;
                       padding: 8px;
                       border: 1px solid {$data['color_3']};
                       border-radius: 5px;
                       font-size: 16px;
                       background-color: {$data['color_1']};
                       box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
                       color: {$data['color_2']};
                   }

    .{$name}-{$id} .{$name}-{$id}-mm-container select option {
                       font-size: 16px;
                   }
</style>

<div class="{$name}-{$id}" >
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-mm-container">
            <ul>
                {foreach $data['mm'] as $key=>$value}
                    <li><a {if $value['mmnew_tab']} target="_blank"{/if} href="{$value['mmurl']}">{$value['mmname']}</a></li>
                {/foreach}
            </ul>
        </div>

    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const menu{$id} = document.querySelector('.{$name}-{$id}');
        const menuHeight{$id} = menu{$id}.offsetHeight;
        let isMenuSticky{$id} = false;
        function handleScroll{$id}() {
            const currentScrollPosition{$id} = window.pageYOffset;
            if (currentScrollPosition{$id} > menuHeight{$id} && !isMenuSticky{$id}) {
                menu{$id}.classList.add('{$name}-{$id}-sticky');
                isMenuSticky{$id} = true;
            } else if (currentScrollPosition{$id} <= menuHeight{$id} && isMenuSticky{$id}) {
                menu{$id}.classList.remove('{$name}-{$id}-sticky');
                isMenuSticky{$id} = false;
            }
            if (currentScrollPosition{$id} === 0) {
                menu{$id}.classList.remove('{$name}-{$id}-sticky');
                isMenuSticky{$id} = false;
            }
        }
        window.addEventListener('scroll', handleScroll{$id});
    });
    if (/Mobi/.test(navigator.userAgent)) {
        window.addEventListener('DOMContentLoaded', function() {
            var container{$id} = document.querySelector('.{$name}-{$id}-mm-container');
            var select{$id} = document.createElement('select');
            select{$id}.setAttribute('id', 'dropdown{$id}');
            select{$id}.setAttribute('onchange', 'handleDropdownChange{$id}()');
            var listItems{$id} = container{$id}.querySelectorAll('li');
            listItems{$id}.forEach(function(item{$id}) {
                var link{$id} = item{$id}.querySelector('a');
                var option{$id} = document.createElement('option');
                option{$id}.setAttribute('value', link{$id}.getAttribute('href'));
                option{$id}.innerText = link{$id}.innerText;
                select{$id}.appendChild(option{$id});
            });
            container{$id}.innerHTML = '';
            container{$id}.appendChild(select{$id});
        });
        function handleDropdownChange{$id}() {
            var dropdown{$id} = document.getElementById('dropdown{$id}');
            var selectedOption{$id} = dropdown{$id}.options[dropdown{$id}.selectedIndex];
            window.location.href = selectedOption{$id}.value;
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        const parentElement{$id} = document.querySelector('.{$name}-{$id}-mm-container');
        const menuLinks{$id} = parentElement{$id}.querySelectorAll('a');
        let isScrollingDown{$id} = false; // Флаг для отслеживания направления прокрутки
        let lastScrollPosition{$id} = window.pageYOffset;

        menuLinks{$id}.forEach(function(link{$id}) {
            link{$id}.addEventListener('click', function(e) {
                const href{$id} = link{$id}.getAttribute('href');
                if (!href{$id}.startsWith('#')) {
                    return;
                }
                e.preventDefault();
                const targetId{$id} = href{$id}.substring(1);
                const targetElement{$id} = document.getElementById(targetId{$id});
                if (targetElement{$id}) {
                    function scrollToTarget{$id}() {
                        const startPosition{$id} = window.pageYOffset;
                        const targetPosition{$id} = targetElement{$id}.offsetTop;
                        const distance{$id} = targetPosition{$id} - startPosition{$id};
                        const duration{$id} = 2000;
                        const startTime{$id} = performance.now();
                        function animateScroll{$id}() {
                            const currentTime{$id} = performance.now();
                            const elapsed{$id} = currentTime{$id} - startTime{$id};
                            const progress{$id} = Math.min(elapsed{$id} / duration{$id}, 1);
                            const easing{$id} = easeInOutQuad{$id}(progress{$id});
                            window.scrollTo(0, startPosition{$id} + distance{$id} * easing{$id});
                            if (progress{$id} < 1) {
                                requestAnimationFrame(animateScroll{$id});
                            }
                        }
                        function easeInOutQuad{$id}(t{$id}) {
                            return t{$id} < 0.5 ? 2 * t{$id} * t{$id} : -1 + (4 - 2 * t{$id}) * t{$id};
                        }
                        animateScroll{$id}();
                    }

                    isScrollingDown{$id} = targetElement{$id}.offsetTop > lastScrollPosition{$id};
                    scrollToTarget{$id}();
                    lastScrollPosition{$id} = targetElement{$id}.offsetTop;

                    if (isScrollingDown{$id}) {
                        setTimeout(function() {
                            scrollToTarget{$id}();
                            const correctedPosition{$id} = targetElement{$id}.getBoundingClientRect().top + window.pageYOffset;
                            window.scrollTo(0, correctedPosition{$id});
                        }, 1800);
                    }
                }
            });
        });

        window.addEventListener('scroll', function() {
            isScrollingDown{$id} = window.pageYOffset > lastScrollPosition{$id};
            lastScrollPosition{$id} = window.pageYOffset;
        });
    });


</script>