<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        max-width: 1200px;
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-map {
        width: 100%;
        height: {if $data['map_height'] neq ''}{$data['map_height']}{else}400px{/if};
        border-radius: {if $data['border_radius'] neq ''}{$data['border_radius']}{else}12px{/if};
        overflow: hidden;
        z-index: 2;
    {if $data['show_shadow']}
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.12);
    {/if}
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-container">
        <div id="{$name}-{$id}-map" class="{$name}-{$id}-map"></div>
    </div>
</div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
{literal}
<script>
(function() {
    var mapId = '{/literal}{$name}-{$id}-map{literal}';
    var lat = parseFloat('{/literal}{$data['lat']}{literal}') || 52.2297;
    var lng = parseFloat('{/literal}{$data['lng']}{literal}') || 21.0122;
    var zoom = parseInt('{/literal}{$data['zoom']}{literal}') || 14;
    var title = '{/literal}{$data['marker_title']|escape:'javascript'}{literal}';
    var disableScroll = '{/literal}{if $data['disable_scroll_zoom']}1{else}0{/if}{literal}';

    var map = L.map(mapId, {
        scrollWheelZoom: disableScroll !== '1'
    }).setView([lat, lng], zoom);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a>',
        maxZoom: 19
    }).addTo(map);

    var marker = L.marker([lat, lng]).addTo(map);
    if (title) {
        marker.bindPopup('<b>' + title + '</b>');
    }
})();
</script>
{/literal}
