class PUQMap {
    static get toolbox() {
        return {
            title: 'Map',
            icon: '<i class="fas fa-map-marker-alt"></i>'
        };
    }
    constructor({data, api, block}) {
        this.data = data || {};
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true, bold: true, strong: true, iframe: true, i: true, a: true, s: true,
                img: true, small: true, br: true, mark: true, div: true, span: true,
                h1: true, h2: true, h3: true, h4: true, h5: true, hr: true, h6: true,
                ol: true, sup: true, sub: true, ul: true, li: true, p: true,
                table: true, tbody: true, tr: true, td: true, th: true,
                em: true, del: true, blockquote: true,
            }
        };
    }
    render() {
        const render = document.createElement('div');
        render.classList.add('puq' + this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQMap');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td class="fieldlabel"><h1 style="color: blue;">Map</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">
        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Latitude</b></td>
        <td class="fieldarea">
            <input type="text" name="lat" class="form-control input-inline input-200" value="" placeholder="e.g. 52.2297">
        </td>
        <td class="fieldlabel"><b>Longitude</b></td>
        <td class="fieldarea">
            <input type="text" name="lng" class="form-control input-inline input-200" value="" placeholder="e.g. 21.0122">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Zoom</b> <small>(1-18)</small></td>
        <td class="fieldarea">
            <input type="number" name="zoom" class="form-control input-inline input-100" min="1" max="18" value="14">
        </td>
        <td class="fieldlabel"><b>Marker Title</b></td>
        <td class="fieldarea">
            <input type="text" name="marker_title" class="form-control input-inline input-200" value="">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Map Height</b></td>
        <td class="fieldarea">
            <input type="text" name="map_height" class="form-control input-inline input-100" value="" placeholder="400px">
        </td>
        <td class="fieldlabel"><b>Border Radius</b></td>
        <td class="fieldarea">
            <input type="text" name="border_radius" class="form-control input-inline input-100" value="" placeholder="12px">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Options</b></td>
        <td colspan="3" class="fieldarea">
            <label class="checkbox-inline"><input type="checkbox" name="show_shadow"><b>Shadow</b></label>
            <label class="checkbox-inline"><input type="checkbox" name="disable_scroll_zoom"><b>Disable scroll zoom</b></label>
        </td>
    </tr>

    </tbody>
</table>
`);

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#FFFFFF');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }
        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }
        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const lat = this.data && this.data.lat ? this.data.lat : "52.2297";
        $(render).find("[name='lat']").val(lat);

        const lng = this.data && this.data.lng ? this.data.lng : "21.0122";
        $(render).find("[name='lng']").val(lng);

        const zoom = this.data && this.data.zoom ? this.data.zoom : "14";
        $(render).find("[name='zoom']").val(zoom);

        const marker_title = this.data && this.data.marker_title ? this.data.marker_title : "";
        $(render).find("[name='marker_title']").val(marker_title);

        const map_height = this.data && this.data.map_height ? this.data.map_height : "400px";
        $(render).find("[name='map_height']").val(map_height);

        const border_radius = this.data && this.data.border_radius ? this.data.border_radius : "12px";
        $(render).find("[name='border_radius']").val(border_radius);

        if (this.data.show_shadow !== false) {
            $(render).find("[name='show_shadow']").attr('checked', 'checked');
        }
        if (this.data.disable_scroll_zoom === true) {
            $(render).find("[name='disable_scroll_zoom']").attr('checked', 'checked');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";
                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings() {
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq' + this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {
        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }
        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }
        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }
        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }
        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }
        var show_shadow = false;
        if ($(content).find("[name='show_shadow']").is(':checked')) {
            show_shadow = true;
        }
        var disable_scroll_zoom = false;
        if ($(content).find("[name='disable_scroll_zoom']").is(':checked')) {
            disable_scroll_zoom = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        return {
            "width": $(content).find("[name='width']").val().replace(/\t/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/\t/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/\t/g, ""),
            "style": style.replace(/\t/g, ""),
            "background_image": $(content).find("[name='background_image']").val().replace(/\t/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/\t/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,
            "lat": $(content).find("[name='lat']").val().replace(/\t/g, ""),
            "lng": $(content).find("[name='lng']").val().replace(/\t/g, ""),
            "zoom": $(content).find("[name='zoom']").val(),
            "marker_title": $(content).find("[name='marker_title']").val().replace(/\t/g, ""),
            "map_height": $(content).find("[name='map_height']").val().replace(/\t/g, ""),
            "border_radius": $(content).find("[name='border_radius']").val().replace(/\t/g, ""),
            "show_shadow": show_shadow,
            "disable_scroll_zoom": disable_scroll_zoom,
        };
    }
}
