<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {/if}
        position: relative;
        overflow: hidden;
        display: flex;
        min-height: {if $data['height'] neq ''}{$data['height']}{else}80vh{/if};
    {if $data['vertical_align'] eq 'top'}
        align-items: flex-start;
    {elseif $data['vertical_align'] eq 'bottom'}
        align-items: flex-end;
    {else}
        align-items: center;
    {/if}
    {if $data['text_align'] eq 'left'}
        justify-content: flex-start;
    {elseif $data['text_align'] eq 'right'}
        justify-content: flex-end;
    {else}
        justify-content: center;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-overlay {
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: {if $data['overlay_color'] neq ''}{$data['overlay_color']}{else}#000000{/if};
        opacity: {if $data['overlay_opacity'] neq ''}{$data['overlay_opacity'] / 100}{else}0.4{/if};
        z-index: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-video {
        position: absolute;
        top: 50%; left: 50%;
        transform: translate(-50%, -50%);
        min-width: 100%; min-height: 100%;
        object-fit: cover;
        z-index: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        text-align: {if $data['text_align'] neq ''}{$data['text_align']}{else}center{/if};
        max-width: 900px;
        padding: 60px 30px;
        width: 100%;
    }

    .{$name}-{$id} .{$name}-{$id}-badge {
        display: inline-block;
        padding: 6px 18px;
        background: rgba(255, 255, 255, 0.15);
        border: 1px solid rgba(255, 255, 255, 0.25);
        border-radius: 50px;
        font-size: 0.8rem;
        font-weight: 600;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        color: {if $data['text_color'] neq ''}{$data['text_color']}{else}#ffffff{/if};
        margin-bottom: 24px;
        backdrop-filter: blur(4px);
    }

    .{$name}-{$id} .{$name}-{$id}-title {
        font-size: 3.2rem;
        font-weight: 800;
        color: {if $data['text_color'] neq ''}{$data['text_color']}{else}#ffffff{/if};
        margin: 0 0 16px 0;
        line-height: 1.15;
        letter-spacing: -0.5px;
    }

    .{$name}-{$id} .{$name}-{$id}-subtitle {
        font-size: 1.5rem;
        font-weight: 300;
        color: {if $data['text_color'] neq ''}{$data['text_color']}{else}#ffffff{/if};
        margin: 0 0 12px 0;
        opacity: 0.9;
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-desc {
        font-size: 1.05rem;
        color: {if $data['text_color'] neq ''}{$data['text_color']}{else}#ffffff{/if};
        opacity: 0.75;
        margin: 0 0 36px 0;
        line-height: 1.7;
        max-width: 640px;
    {if $data['text_align'] eq 'center' || $data['text_align'] eq ''}
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 36px;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-buttons {
        display: flex;
        gap: 16px;
        flex-wrap: wrap;
    {if $data['text_align'] eq 'center' || $data['text_align'] eq ''}
        justify-content: center;
    {elseif $data['text_align'] eq 'right'}
        justify-content: flex-end;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-btn {
        display: inline-block;
        padding: 16px 40px;
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        border-radius: {if $data['button_rounded']}50px{else}8px{/if};
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-btn-primary {
        background: {if $data['button_color'] neq ''}{$data['button_color']}{else}#337ab7{/if};
        color: #fff;
        border-color: {if $data['button_color'] neq ''}{$data['button_color']}{else}#337ab7{/if};
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.25);
    }

    .{$name}-{$id} .{$name}-{$id}-btn-primary:hover {
        filter: brightness(1.15);
        transform: translateY(-3px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-btn-secondary {
        background: transparent;
        color: {if $data['button2_color'] neq ''}{$data['button2_color']}{else}#ffffff{/if};
        border-color: {if $data['button2_color'] neq ''}{$data['button2_color']}{else}rgba(255,255,255,0.5){/if};
    }

    .{$name}-{$id} .{$name}-{$id}-btn-secondary:hover {
        background: {if $data['button2_color'] neq ''}{$data['button2_color']}{else}rgba(255,255,255,0.15){/if};
        color: #fff;
        transform: translateY(-3px);
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} {
            min-height: 60vh;
        }
        .{$name}-{$id} .{$name}-{$id}-container {
            padding: 40px 20px;
        }
        .{$name}-{$id} .{$name}-{$id}-title {
            font-size: 2rem;
        }
        .{$name}-{$id} .{$name}-{$id}-subtitle {
            font-size: 1.15rem;
        }
        .{$name}-{$id} .{$name}-{$id}-btn {
            padding: 14px 28px;
            font-size: 0.9rem;
        }
        .{$name}-{$id} .{$name}-{$id}-buttons {
            justify-content: center;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover" {if $data['parallax']}style="background-attachment:fixed;"{/if}></div>
    {/if}
    {if $data['video_url'] neq ''}
        <video class="{$name}-{$id}-video" autoplay muted loop playsinline>
            <source src="{$data['video_url']}" type="video/mp4">
        </video>
    {/if}
    <div class="{$name}-{$id}-overlay"></div>
    <div class="{$name}-{$id}-container">
        {if $data['badge'] neq ''}
            <div class="{$name}-{$id}-badge">{$data['badge']}</div>
        {/if}
        {if $data['title'] neq ''}
            <h1 class="{$name}-{$id}-title">{$data['title']}</h1>
        {/if}
        {if $data['subtitle'] neq ''}
            <p class="{$name}-{$id}-subtitle">{$data['subtitle']}</p>
        {/if}
        {if $data['description'] neq ''}
            <p class="{$name}-{$id}-desc">{$data['description']}</p>
        {/if}
        {if $data['button_text'] neq '' || $data['button2_text'] neq ''}
            <div class="{$name}-{$id}-buttons">
                {if $data['button_text'] neq ''}
                    <a href="{$data['button_url']}" target="{if $data['button_target'] neq ''}{$data['button_target']}{else}_self{/if}" class="{$name}-{$id}-btn {$name}-{$id}-btn-primary">{$data['button_text']}</a>
                {/if}
                {if $data['button2_text'] neq ''}
                    <a href="{$data['button2_url']}" target="{if $data['button2_target'] neq ''}{$data['button2_target']}{else}_self{/if}" class="{$name}-{$id}-btn {$name}-{$id}-btn-secondary">{$data['button2_text']}</a>
                {/if}
            </div>
        {/if}
    </div>
</div>
