class PUQFeatureGrid {
    static get toolbox() {
        return {
            title: 'Feature Grid',
            icon: '<i class="fas fa-th"></i>'
        };
    }
    constructor({data, api, block}) {
        this.data = data || {};
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true, bold: true, strong: true, iframe: true, i: true, a: true, s: true,
                img: true, small: true, br: true, mark: true, div: true, span: true,
                h1: true, h2: true, h3: true, h4: true, h5: true, hr: true, h6: true,
                ol: true, sup: true, sub: true, ul: true, li: true, p: true,
                table: true, tbody: true, tr: true, td: true, th: true,
                em: true, del: true, blockquote: true,
            }
        };
    }
    render() {
        const render = document.createElement('div');
        render.classList.add('puq' + this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQFeatureGrid');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td class="fieldlabel"><h1 style="color: blue;">Feature Grid</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">
        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Section Heading</b></td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="heading" class="form-control input-inline input-400" value="" placeholder="e.g. Why Choose Us">
            <label> Align: </label>
            <select name="heading_align" class="form-control select-inline">
                <option value="center">Center</option>
                <option value="left">Left</option>
                <option value="right">Right</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Section Subtitle</b></td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="subtitle" class="form-control" value="" placeholder="Short description under the heading">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Columns</b></td>
        <td class="fieldarea">
            <select name="columns" class="form-control select-inline">
                <option value="2">2</option>
                <option value="3">3</option>
                <option value="4">4</option>
            </select>
        </td>
        <td class="fieldlabel"><b>Gap</b></td>
        <td class="fieldarea">
            <select name="gap" class="form-control select-inline">
                <option value="16">Small (16px)</option>
                <option value="24">Medium (24px)</option>
                <option value="32">Large (32px)</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Icon Color</b></td>
        <td class="fieldarea">
            <input type="color" name="icon_color" class="form-control input-inline input-50">
        </td>
        <td class="fieldlabel"><b>Icon Shape</b></td>
        <td class="fieldarea">
            <select name="icon_shape" class="form-control select-inline">
                <option value="rounded">Rounded square</option>
                <option value="circle">Circle</option>
                <option value="none">No background</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Icon Size</b></td>
        <td class="fieldarea">
            <select name="icon_size" class="form-control select-inline">
                <option value="sm">Small</option>
                <option value="md">Medium</option>
                <option value="lg">Large</option>
            </select>
        </td>
        <td class="fieldlabel"><b>Card Align</b></td>
        <td class="fieldarea">
            <select name="card_align" class="form-control select-inline">
                <option value="center">Center</option>
                <option value="left">Left</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Title Color</b></td>
        <td class="fieldarea">
            <input type="color" name="title_color" class="form-control input-inline input-50">
        </td>
        <td class="fieldlabel"><b>Link Text</b></td>
        <td class="fieldarea">
            <input type="text" name="link_text" class="form-control input-inline input-200" value="" placeholder="Learn more">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Options</b></td>
        <td colspan="3" class="fieldarea">
            <label class="checkbox-inline"><input type="checkbox" name="show_border"><b>Card border</b></label>
            <label class="checkbox-inline"><input type="checkbox" name="show_shadow"><b>Card shadow</b></label>
            <label class="checkbox-inline"><input type="checkbox" name="show_accent"><b>Top accent line</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Items</b></td>
        <td colspan="3" class="fieldarea">
            <table class="table table-condensed table-bordered" style="margin-bottom:5px;">
                <thead><tr>
                    <th>Icon <small>(fa class)</small></th>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Link URL</th>
                    <th style="width:30px"></th>
                </tr></thead>
                <tbody class="puq-items-body"></tbody>
            </table>
            <button type="button" class="btn btn-sm btn-default puq-add-item"><i class="fas fa-plus"></i> Add Item</button>
        </td>
    </tr>

    </tbody>
</table>
`);

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#FFFFFF');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }
        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }
        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const heading = this.data && this.data.heading ? this.data.heading : "";
        $(render).find("[name='heading']").val(heading);

        const heading_align = this.data && this.data.heading_align ? this.data.heading_align : "center";
        $(render).find("[name='heading_align']").val(heading_align);

        const subtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(render).find("[name='subtitle']").val(subtitle);

        const columns = this.data && this.data.columns ? this.data.columns : "3";
        $(render).find("[name='columns']").val(columns);

        const gap = this.data && this.data.gap ? this.data.gap : "24";
        $(render).find("[name='gap']").val(gap);

        const icon_color = this.data && this.data.icon_color ? this.data.icon_color : "#337ab7";
        $(render).find("[name='icon_color']").val(icon_color);

        const icon_shape = this.data && this.data.icon_shape ? this.data.icon_shape : "rounded";
        $(render).find("[name='icon_shape']").val(icon_shape);

        const icon_size = this.data && this.data.icon_size ? this.data.icon_size : "md";
        $(render).find("[name='icon_size']").val(icon_size);

        const card_align = this.data && this.data.card_align ? this.data.card_align : "center";
        $(render).find("[name='card_align']").val(card_align);

        const title_color = this.data && this.data.title_color ? this.data.title_color : "#2c3e50";
        $(render).find("[name='title_color']").val(title_color);

        const link_text = this.data && this.data.link_text ? this.data.link_text : "Learn more";
        $(render).find("[name='link_text']").val(link_text);

        if (this.data.show_border === true) {
            $(render).find("[name='show_border']").attr('checked', 'checked');
        }
        if (this.data.show_shadow !== false) {
            $(render).find("[name='show_shadow']").attr('checked', 'checked');
        }
        if (this.data.show_accent === true) {
            $(render).find("[name='show_accent']").attr('checked', 'checked');
        }

        // Visual items editor
        const defaultItems = [
            {icon: "fas fa-server", title: "Feature 1", description: "Description here", link: ""},
            {icon: "fas fa-shield-alt", title: "Feature 2", description: "Description here", link: ""},
            {icon: "fas fa-bolt", title: "Feature 3", description: "Description here", link: ""}
        ];
        let itemsData = defaultItems;
        if (this.data && this.data.items) {
            try {
                itemsData = typeof this.data.items === 'string' ? JSON.parse(this.data.items) : this.data.items;
            } catch(e) { itemsData = defaultItems; }
        }
        const $tbody = $(render).find('.puq-items-body');
        const addItemRow = (item) => {
            $tbody.append(`<tr>
                <td><input type="text" class="form-control input-sm pi-icon" value="${(item.icon || '').replace(/"/g, '&quot;')}" placeholder="fas fa-star"></td>
                <td><input type="text" class="form-control input-sm pi-title" value="${(item.title || '').replace(/"/g, '&quot;')}"></td>
                <td><input type="text" class="form-control input-sm pi-desc" value="${(item.description || '').replace(/"/g, '&quot;')}"></td>
                <td><input type="text" class="form-control input-sm pi-link" value="${(item.link || '').replace(/"/g, '&quot;')}" placeholder="https://"></td>
                <td style="text-align:center"><button type="button" class="btn btn-xs btn-danger puq-remove-item"><i class="fas fa-times"></i></button></td>
            </tr>`);
        };
        itemsData.forEach(item => addItemRow(item));
        $(render).find('.puq-add-item').on('click', () => addItemRow({icon: '', title: '', description: '', link: ''}));
        $(render).on('click', '.puq-remove-item', function() { $(this).closest('tr').remove(); });

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";
                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings() {
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq' + this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {
        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }
        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }
        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }
        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }
        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }
        var show_border = false;
        if ($(content).find("[name='show_border']").is(':checked')) {
            show_border = true;
        }
        var show_shadow = false;
        if ($(content).find("[name='show_shadow']").is(':checked')) {
            show_shadow = true;
        }
        var show_accent = false;
        if ($(content).find("[name='show_accent']").is(':checked')) {
            show_accent = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        return {
            "width": $(content).find("[name='width']").val().replace(/\t/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/\t/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/\t/g, ""),
            "style": style.replace(/\t/g, ""),
            "background_image": $(content).find("[name='background_image']").val().replace(/\t/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/\t/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,
            "heading": $(content).find("[name='heading']").val().replace(/\t/g, ""),
            "heading_align": $(content).find("[name='heading_align']").val(),
            "subtitle": $(content).find("[name='subtitle']").val().replace(/\t/g, ""),
            "columns": $(content).find("[name='columns']").val(),
            "gap": $(content).find("[name='gap']").val(),
            "icon_color": $(content).find("[name='icon_color']").val(),
            "icon_shape": $(content).find("[name='icon_shape']").val(),
            "icon_size": $(content).find("[name='icon_size']").val(),
            "card_align": $(content).find("[name='card_align']").val(),
            "title_color": $(content).find("[name='title_color']").val(),
            "link_text": $(content).find("[name='link_text']").val().replace(/\t/g, ""),
            "show_border": show_border,
            "show_shadow": show_shadow,
            "show_accent": show_accent,
            "items": JSON.stringify($(content).find('.puq-items-body tr').map(function() {
                return {
                    icon: $(this).find('.pi-icon').val().trim(),
                    title: $(this).find('.pi-title').val().trim(),
                    description: $(this).find('.pi-desc').val().trim(),
                    link: $(this).find('.pi-link').val().trim()
                };
            }).get()),
        };
    }
}
