<style>
    .{$name}-{$id} .puq-domain-search-container{
        position: relative;
        z-index: 2;
                   {if $data['width'] neq ''}
                       max-width: {$data['width']};
                   {else}
                       padding-left: 20px;
                       padding-right: 20px;
                   {/if}
                       width: 100%;
        display: inline-block;
                       text-align: center;
    }

    .{$name}-{$id} .puq-domain-search-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .puq-domain-search-clearfix {
        align-items: center;
        justify-content: space-between;
    }

    .{$name}-{$id} .puq-domain-search-input-group {
        display: flex;
        align-items: center;
        border: 2px solid {$data['color_1']};
        border-radius: 15px;
        padding: 5px;
        color: {$data['color_1']};
    }

    .{$name}-{$id} .puq-domain-search-span-btn-group{
        display: flex;
    }

    .{$name}-{$id} .puq-domain-search-span-input-group{
        display: flex;
        width: 100%;
    }

    .{$name}-{$id} .puq-domain-search-span-input-group i{
        font-size: 40px;
    }

    .{$name}-{$id} .puq-domain-search-span-input-group input{
        font-size: 20px;
        width: 100%;
    }

    .{$name}-{$id} .puq-domain-search-span-input-group input::placeholder{
        color: {$data['placeholder_text_color']};
    }

    .{$name}-{$id} .puq-domain-search-input {
        border: none;
        background-color: transparent;
        color: {$data['color_1']};
        font-size: 16px;
        padding: 5px;
        flex-grow: 1;
        border-radius: 30px;
    }

    .{$name}-{$id} .puq-domain-search-input:focus {
        outline: none;
    }

    .{$name}-{$id} .puq-domain-search-btn-search,
    .{$name}-{$id} .puq-domain-search-btn-transfer,
    .{$name}-{$id} .puq-domain-search-btn-view-all-pricing{
        padding: 10px 20px;
        font-size: 16px;
        margin: 5px;
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        border-radius: 5px;
    }

    .{$name}-{$id} .puq-domain-search-btn-search{
        background-color: {$data['search_button_color']};
        color: {$data['search_button_text_color']};
        border: 1px solid {$data['search_button_text_color']};
    }

    .{$name}-{$id} .puq-domain-search-btn-transfer {
        background-color: {$data['transfer_button_color']};
        color: {$data['transfer_button_text_color']};
        border: 1px solid {$data['transfer_button_text_color']};
    }

    .{$name}-{$id} .puq-domain-search-btn-view-all-pricing {
        background-color: {$data['view_all_pricing_button_color']};
        color: {$data['view_all_pricing_button_text_color']};
        border: 1px solid {$data['view_all_pricing_button_text_color']};
        text-decoration: none;
        display: inline-block;
        white-space: nowrap;
    }

    .{$name}-{$id} .puq-domain-search-btn-search:hover{
        background-color: {$data['search_button_text_color']};
        color: {$data['search_button_color']};
        border: 1px solid {$data['search_button_color']};
    }

    .{$name}-{$id} .puq-domain-search-btn-transfer:hover {
        background-color: {$data['transfer_button_text_color']};
        color: {$data['transfer_button_color']};
        border: 1px solid {$data['transfer_button_color']};
    }

    .{$name}-{$id} .puq-domain-search-btn-view-all-pricing:hover {
        background-color: {$data['view_all_pricing_button_text_color']};
        color: {$data['view_all_pricing_button_color']};
        border: 1px solid {$data['view_all_pricing_button_color']};
    }

    @media screen and (max-width: 768px) {
        .{$name}-{$id} .puq-domain-search-input-group{
            display: block;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="puq-domain-search-container">
        <div class="puq-domain-search-clearfix">
            {if !$data['disable_header']}
                <h2 class="puq-domain-search-header">{$data['header']}</h2>
            {/if}
            <div class="puq-domain-search-input-group-wrapper">
                <div class="puq-domain-search-input-group">
                    <span class="puq-domain-search-span-input-group">
                        <i class="fad fa-search"></i>
                        <input id="domain{$id}" type="text" name="domain" placeholder="{if !$data['disable_placeholder']}{$data['placeholder']}{/if}" autocapitalize="none" class="puq-domain-search-input">
                    </span>
                    <span class="puq-domain-search-span-btn-group">
                        <a id="search_button_name{$id}" class="puq-domain-search-btn-search">{$data['search_button_name']}</a>
                    {if !$data['disable_transfer_button']}
                        <a id="transfer_button_name{$id}" class="puq-domain-search-btn-transfer">{$data['transfer_button_name']}</a>
                    {/if}
                    </span>
                </div>
            </div>
        </div>
        {if !$data['disable_view_all_pricing_button']}
            <a href="{$before_path}/domain/pricing" class="puq-domain-search-btn-view-all-pricing">{$data['view_all_pricing_button_name']}</a>
        {/if}
    </div>
</div>
<script>
    const search_button_name{$id} = document.getElementById("search_button_name{$id}");
    const transfer_button_name{$id} = document.getElementById("transfer_button_name{$id}");
    const domain{$id} = document.getElementById("domain{$id}");

    if (search_button_name{$id} !== null){
        search_button_name{$id}.addEventListener("click", (event) => {
            const link = "{$before_path}/cart.php?a=add&domain=register&query=" + encodeURIComponent(domain{$id}.value);
            search_button_name{$id}.href = link;
        });
    }

    if (transfer_button_name{$id} !== null) {
        transfer_button_name{$id}.addEventListener("click", (event) => {
            const link = "{$before_path}/cart.php?a=add&domain=transfer&query=" + encodeURIComponent(domain{$id}.value);
            transfer_button_name{$id}.href = link;
        });
    }
</script>