class PUQCTA {
    static get toolbox() {
        return {
            title: 'Call To Action',
            icon: '<i class="fas fa-bullhorn"></i>'
        };
    }
    constructor({data, api, block}) {
        this.data = data || {};
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true, bold: true, strong: true, iframe: true, i: true, a: true, s: true,
                img: true, small: true, br: true, mark: true, div: true, span: true,
                h1: true, h2: true, h3: true, h4: true, h5: true, hr: true, h6: true,
                ol: true, sup: true, sub: true, ul: true, li: true, p: true,
                table: true, tbody: true, tr: true, td: true, th: true,
                em: true, del: true, blockquote: true,
            }
        };
    }
    render() {
        const render = document.createElement('div');
        render.classList.add('puq' + this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQCTA');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td class="fieldlabel"><h1 style="color: blue;">Call To Action</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">
        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Heading</b></td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="heading" class="form-control" value="">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Subtitle</b></td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="subtitle" class="form-control" value="">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Description</b></td>
        <td colspan="3" class="fieldarea">
            <textarea name="description" class="form-control" rows="3"></textarea>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Layout</b></td>
        <td class="fieldarea">
            <select name="layout" class="form-control select-inline">
                <option value="center">Center</option>
                <option value="left">Left</option>
                <option value="horizontal">Horizontal</option>
            </select>
        </td>
        <td class="fieldlabel"><b>Text Color</b></td>
        <td class="fieldarea">
            <input type="color" name="text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Button 1</b></td>
        <td colspan="3" class="fieldarea">
            <label>Text: </label>
            <input type="text" name="button_text" class="form-control input-inline input-200" value="">
            <label>URL: </label>
            <input type="text" name="button_url" class="form-control input-inline input-300" value="">
            <label>Color: </label>
            <input type="color" name="button_color" class="form-control input-inline input-50">
            <br><br>
            <label>Target: </label>
            <select name="button_target" class="form-control select-inline">
                <option value="_self">Same tab</option>
                <option value="_blank">New tab</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Button 2</b></td>
        <td colspan="3" class="fieldarea">
            <label>Text: </label>
            <input type="text" name="button2_text" class="form-control input-inline input-200" value="">
            <label>URL: </label>
            <input type="text" name="button2_url" class="form-control input-inline input-300" value="">
            <label>Color: </label>
            <input type="color" name="button2_color" class="form-control input-inline input-50">
            <br><br>
            <label>Target: </label>
            <select name="button2_target" class="form-control select-inline">
                <option value="_self">Same tab</option>
                <option value="_blank">New tab</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Button Size</b></td>
        <td class="fieldarea">
            <select name="button_size" class="form-control select-inline">
                <option value="sm">Small</option>
                <option value="md">Medium</option>
                <option value="lg">Large</option>
            </select>
        </td>
        <td class="fieldlabel"><b>Button Rounded</b></td>
        <td class="fieldarea">
            <label class="checkbox-inline"><input type="checkbox" name="button_rounded"><b>Rounded corners</b></label>
        </td>
    </tr>

    </tbody>
</table>
`);

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#FFFFFF');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }
        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }
        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const heading = this.data && this.data.heading ? this.data.heading : "";
        $(render).find("[name='heading']").val(heading);

        const subtitle = this.data && this.data.subtitle ? this.data.subtitle : "";
        $(render).find("[name='subtitle']").val(subtitle);

        const description = this.data && this.data.description ? this.data.description : "";
        $(render).find("[name='description']").val(description);

        const layout = this.data && this.data.layout ? this.data.layout : "center";
        $(render).find("[name='layout']").val(layout);

        const text_color = this.data && this.data.text_color ? this.data.text_color : "#333333";
        $(render).find("[name='text_color']").val(text_color);

        const button_text = this.data && this.data.button_text ? this.data.button_text : "";
        $(render).find("[name='button_text']").val(button_text);

        const button_url = this.data && this.data.button_url ? this.data.button_url : "";
        $(render).find("[name='button_url']").val(button_url);

        const button_color = this.data && this.data.button_color ? this.data.button_color : "#337ab7";
        $(render).find("[name='button_color']").val(button_color);

        const button_target = this.data && this.data.button_target ? this.data.button_target : "_self";
        $(render).find("[name='button_target']").val(button_target);

        const button2_text = this.data && this.data.button2_text ? this.data.button2_text : "";
        $(render).find("[name='button2_text']").val(button2_text);

        const button2_url = this.data && this.data.button2_url ? this.data.button2_url : "";
        $(render).find("[name='button2_url']").val(button2_url);

        const button2_color = this.data && this.data.button2_color ? this.data.button2_color : "#6c757d";
        $(render).find("[name='button2_color']").val(button2_color);

        const button2_target = this.data && this.data.button2_target ? this.data.button2_target : "_self";
        $(render).find("[name='button2_target']").val(button2_target);

        const button_size = this.data && this.data.button_size ? this.data.button_size : "md";
        $(render).find("[name='button_size']").val(button_size);

        if (this.data.button_rounded === true) {
            $(render).find("[name='button_rounded']").attr('checked', 'checked');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";
                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings() {
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq' + this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {
        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }
        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }
        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }
        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }
        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }
        var button_rounded = false;
        if ($(content).find("[name='button_rounded']").is(':checked')) {
            button_rounded = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        return {
            "width": $(content).find("[name='width']").val().replace(/\t/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/\t/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/\t/g, ""),
            "style": style.replace(/\t/g, ""),
            "background_image": $(content).find("[name='background_image']").val().replace(/\t/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/\t/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,
            "heading": $(content).find("[name='heading']").val().replace(/\t/g, ""),
            "subtitle": $(content).find("[name='subtitle']").val().replace(/\t/g, ""),
            "description": $(content).find("[name='description']").val().replace(/\t/g, ""),
            "layout": $(content).find("[name='layout']").val(),
            "text_color": $(content).find("[name='text_color']").val(),
            "button_text": $(content).find("[name='button_text']").val().replace(/\t/g, ""),
            "button_url": $(content).find("[name='button_url']").val().replace(/\t/g, ""),
            "button_color": $(content).find("[name='button_color']").val(),
            "button_target": $(content).find("[name='button_target']").val(),
            "button2_text": $(content).find("[name='button2_text']").val().replace(/\t/g, ""),
            "button2_url": $(content).find("[name='button2_url']").val().replace(/\t/g, ""),
            "button2_color": $(content).find("[name='button2_color']").val(),
            "button2_target": $(content).find("[name='button2_target']").val(),
            "button_size": $(content).find("[name='button_size']").val(),
            "button_rounded": button_rounded,
        };
    }
}
