<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        max-width: 700px;
        margin: 0 auto;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-form .form-group {
        margin-bottom: 15px;
    }

    .{$name}-{$id} .{$name}-{$id}-form label {
        display: block;
        font-weight: 600;
        margin-bottom: 5px;
        color: #333;
    }

    .{$name}-{$id} .{$name}-{$id}-form input,
    .{$name}-{$id} .{$name}-{$id}-form textarea,
    .{$name}-{$id} .{$name}-{$id}-form select {
        width: 100%;
        padding: 10px 15px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 1rem;
        transition: border-color 0.3s;
    }

    .{$name}-{$id} .{$name}-{$id}-form input:focus,
    .{$name}-{$id} .{$name}-{$id}-form textarea:focus {
        border-color: #337ab7;
        outline: none;
    }

    .{$name}-{$id} .{$name}-{$id}-form textarea {
        min-height: 120px;
        resize: vertical;
    }

    .{$name}-{$id} .{$name}-{$id}-btn {
        display: inline-block;
        padding: 12px 35px;
        background: {if $data['button_color'] neq ''}{$data['button_color']}{else}#337ab7{/if};
        color: #fff;
        border: none;
        border-radius: 5px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: background 0.3s;
    }

    .{$name}-{$id} .{$name}-{$id}-btn:hover {
        filter: brightness(1.1);
    }

    .{$name}-{$id} .{$name}-{$id}-success {
        display: none;
        padding: 20px;
        background: #dff0d8;
        color: #3c763d;
        border-radius: 5px;
        text-align: center;
        font-weight: 600;
    }

    .{$name}-{$id} .{$name}-{$id}-error {
        display: none;
        padding: 10px;
        background: #f2dede;
        color: #a94442;
        border-radius: 5px;
        margin-bottom: 15px;
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-container">
        <div class="{$name}-{$id}-error" id="{$name}-{$id}-error"></div>
        <div class="{$name}-{$id}-success" id="{$name}-{$id}-success">{if $data['success_message'] neq ''}{$data['success_message']}{else}Thank you! Your message has been sent.{/if}</div>
        <form class="{$name}-{$id}-form" id="{$name}-{$id}-form" onsubmit="return puqContactSubmit{$id}(event)">
            {if !empty($data['fields'])}
                {foreach $data['fields'] as $field}
                    {if $field['type'] eq 'hidden'}
                        <input type="hidden" name="{$field['name']}" value="{$field['label']}">
                    {else}
                        <div class="form-group">
                            <label>{$field['label']} {if $field['required']}<span style="color:red">*</span>{/if}</label>
                            {if $field['type'] eq 'textarea'}
                                <textarea name="{$field['name']}" {if $field['required']}required{/if} {if !empty($field['pattern'])}data-pattern="{$field['pattern']}"{/if}></textarea>
                            {elseif $field['type'] eq 'select'}
                                <select name="{$field['name']}" {if $field['required']}required{/if}>
                                    <option value="">--</option>
                                    {if isset($field['options'])}{foreach $field['options'] as $opt}<option value="{$opt}">{$opt}</option>{/foreach}{/if}
                                </select>
                            {else}
                                <input type="{$field['type']}" name="{$field['name']}" {if $field['required']}required{/if} {if !empty($field['pattern'])}pattern="{$field['pattern']}"{/if}>
                            {/if}
                        </div>
                    {/if}
                {/foreach}
            {/if}
            <button type="submit" class="{$name}-{$id}-btn">{if $data['button_text'] neq ''}{$data['button_text']}{else}Send Message{/if}</button>
        </form>
    </div>
</div>

<script>
function puqContactSubmit{$id}(e) {
    e.preventDefault();
    var form = document.getElementById('{$name}-{$id}-form');
    var errorEl = document.getElementById('{$name}-{$id}-error');
    var successEl = document.getElementById('{$name}-{$id}-success');
    var btn = form.querySelector('button[type="submit"]');
    var btnText = btn.innerHTML;

    errorEl.style.display = 'none';
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

    var formData = new FormData(form);
    var data = {};
    formData.forEach(function(value, key) { data[key] = value; });
    data._token = window.puqCsrfToken;

    jQuery.ajax({
        url: window.puqWidgetAjaxUrl + '&widget_type=puqcontactform&widget_action=submit',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify(data),
        success: function(response) {
            if (response.success) {
                form.style.display = 'none';
                successEl.style.display = 'block';
            } else {
                errorEl.textContent = response.error || 'An error occurred. Please try again.';
                errorEl.style.display = 'block';
                btn.disabled = false;
                btn.innerHTML = btnText;
            }
        },
        error: function(xhr) {
            var msg = 'An error occurred. Please try again.';
            try {
                var resp = JSON.parse(xhr.responseText);
                if (resp.error) msg = resp.error;
            } catch(e) {}
            errorEl.textContent = msg;
            errorEl.style.display = 'block';
            btn.disabled = false;
            btn.innerHTML = btnText;
        }
    });
    return false;
}
</script>
