<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-palette"></i> {$meta.lang['Password Page Appearance']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="settings-content" style="display:none;">
        <div id="pwd-presets-row"></div>
        <div class="row" style="margin-top:5px;">
            <div class="col-md-7" id="pwd-settings-col"></div>
            <div class="col-md-5" id="pwd-preview-col"></div>
        </div>
        <div class="row" style="margin-top:15px;">
            <div class="col-md-12">
                <button type="button" class="btn btn-primary btn-lg" onclick="savePwdSettings(this)">
                    <i class="fas fa-check-square"></i> {$meta.lang['Save Settings']}
                </button>
            </div>
        </div>
    </div>
</div>

{literal}
<style>
    .pwd-preset-btn {
        display: inline-block;
        width: 90px;
        margin: 0 6px 8px 0;
        padding: 0;
        border: 2px solid #e5e7eb;
        border-radius: 8px;
        overflow: hidden;
        cursor: pointer;
        transition: border-color 0.2s, transform 0.15s, box-shadow 0.2s;
        background: #fff;
        vertical-align: top;
    }
    .pwd-preset-btn:hover {
        border-color: #667eea;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .pwd-preset-btn:active {
        transform: translateY(0);
    }
    .pwd-preset-btn .preset-header {
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .pwd-preset-btn .preset-header i {
        color: rgba(255,255,255,0.9);
        font-size: 14px;
    }
    .pwd-preset-btn .preset-label {
        font-size: 10px;
        font-weight: 600;
        padding: 4px 2px;
        text-align: center;
        color: #555;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
</style>
{/literal}

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var settingsData = {};

    var PWD_DEFAULTS = {
        pwd_gradient_start: '#667eea',
        pwd_gradient_end: '#764ba2',
        pwd_card_bg: '#ffffff',
        pwd_text_color: '#333333',
        pwd_card_radius: '16',
        pwd_icon_class: 'fas fa-shield-alt',
        pwd_error_color: '#dc2626',
        pwd_box_shadow: 'yes'
    };

    var PRESETS = [
        {
            name: 'Default',
            icon: 'fas fa-shield-alt',
            gradient_start: '#667eea', gradient_end: '#764ba2',
            card_bg: '#ffffff', text_color: '#333333',
            radius: '16', icon_class: 'fas fa-shield-alt',
            error_color: '#dc2626', shadow: 'yes'
        },
        {
            name: 'Ocean',
            icon: 'fas fa-water',
            gradient_start: '#0077b6', gradient_end: '#00b4d8',
            card_bg: '#ffffff', text_color: '#2b2d42',
            radius: '12', icon_class: 'fas fa-water',
            error_color: '#e63946', shadow: 'yes'
        },
        {
            name: 'Sunset',
            icon: 'fas fa-sun',
            gradient_start: '#f97316', gradient_end: '#ef4444',
            card_bg: '#fffbeb', text_color: '#451a03',
            radius: '20', icon_class: 'fas fa-sun',
            error_color: '#b91c1c', shadow: 'yes'
        },
        {
            name: 'Forest',
            icon: 'fas fa-leaf',
            gradient_start: '#059669', gradient_end: '#047857',
            card_bg: '#f0fdf4', text_color: '#14532d',
            radius: '14', icon_class: 'fas fa-leaf',
            error_color: '#dc2626', shadow: 'yes'
        },
        {
            name: 'Dark',
            icon: 'fas fa-moon',
            gradient_start: '#1e293b', gradient_end: '#0f172a',
            card_bg: '#1e293b', text_color: '#e2e8f0',
            radius: '12', icon_class: 'fas fa-moon',
            error_color: '#f87171', shadow: 'yes'
        },
        {
            name: 'Rose',
            icon: 'fas fa-heart',
            gradient_start: '#ec4899', gradient_end: '#db2777',
            card_bg: '#fff1f2', text_color: '#4c0519',
            radius: '20', icon_class: 'fas fa-heart',
            error_color: '#be123c', shadow: 'yes'
        },
        {
            name: 'Corporate',
            icon: 'fas fa-building',
            gradient_start: '#1e40af', gradient_end: '#1e3a8a',
            card_bg: '#ffffff', text_color: '#1e293b',
            radius: '4', icon_class: 'fas fa-lock',
            error_color: '#dc2626', shadow: 'yes'
        },
        {
            name: 'Neon',
            icon: 'fas fa-bolt',
            gradient_start: '#8b5cf6', gradient_end: '#06b6d4',
            card_bg: '#0f0f23', text_color: '#d4d4d8',
            radius: '16', icon_class: 'fas fa-bolt',
            error_color: '#f43f5e', shadow: 'yes'
        },
        {
            name: 'Gold',
            icon: 'fas fa-crown',
            gradient_start: '#b45309', gradient_end: '#92400e',
            card_bg: '#fffbeb', text_color: '#451a03',
            radius: '16', icon_class: 'fas fa-crown',
            error_color: '#dc2626', shadow: 'yes'
        },
        {
            name: 'Cherry',
            icon: 'fas fa-fire',
            gradient_start: '#dc2626', gradient_end: '#991b1b',
            card_bg: '#ffffff', text_color: '#1c1917',
            radius: '12', icon_class: 'fas fa-fire',
            error_color: '#b91c1c', shadow: 'yes'
        },
        {
            name: 'Arctic',
            icon: 'fas fa-snowflake',
            gradient_start: '#38bdf8', gradient_end: '#818cf8',
            card_bg: '#f0f9ff', text_color: '#1e3a5f',
            radius: '24', icon_class: 'fas fa-snowflake',
            error_color: '#e11d48', shadow: 'yes'
        },
        {
            name: 'Charcoal',
            icon: 'fas fa-adjust',
            gradient_start: '#374151', gradient_end: '#111827',
            card_bg: '#f9fafb', text_color: '#111827',
            radius: '8', icon_class: 'fas fa-user-lock',
            error_color: '#dc2626', shadow: 'no'
        },
        {
            name: 'Lavender',
            icon: 'fas fa-spa',
            gradient_start: '#a78bfa', gradient_end: '#c084fc',
            card_bg: '#faf5ff', text_color: '#3b0764',
            radius: '20', icon_class: 'fas fa-spa',
            error_color: '#e11d48', shadow: 'yes'
        },
        {
            name: 'Emerald',
            icon: 'fas fa-gem',
            gradient_start: '#10b981', gradient_end: '#0d9488',
            card_bg: '#ffffff', text_color: '#134e4a',
            radius: '16', icon_class: 'fas fa-gem',
            error_color: '#ef4444', shadow: 'yes'
        }
    ];

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    function pwdVal(key) {
        return settingsData[key] || PWD_DEFAULTS[key];
    }

    jQuery.ajax({
        url: ajaxUrl + '&ajax=getSettings',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                settingsData = response.data;
            }
            document.getElementById('main-loading').style.display = 'none';
            document.getElementById('settings-content').style.display = '';
            renderPresets();
            renderPreview();
            renderSettings();
        },
        error: function() {
            showNotification('{/literal}{$meta.lang['Failed to load settings']}{literal}', 'error');
            document.getElementById('main-loading').style.display = 'none';
            document.getElementById('settings-content').style.display = '';
            renderPresets();
            renderPreview();
            renderSettings();
        }
    });

    // ==========================================
    // Presets
    // ==========================================
    function renderPresets() {
        var html = '<div class="row" style="margin-bottom:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-magic"></i> {/literal}{$meta.lang['Quick Presets']}{literal}</h3></div>';
        html += '<div class="panel-body" style="padding:15px 15px 7px;">';

        for (var i = 0; i < PRESETS.length; i++) {
            var p = PRESETS[i];
            var grad = 'linear-gradient(135deg, ' + p.gradient_start + ' 0%, ' + p.gradient_end + ' 100%)';
            html += '<button type="button" class="pwd-preset-btn" onclick="applyPreset(' + i + ')">';
            html += '<div class="preset-header" style="background:' + grad + ';"><i class="' + escapeHtml(p.icon) + '"></i></div>';
            html += '<div class="preset-label">' + escapeHtml(p.name) + '</div>';
            html += '</button>';
        }

        html += '</div></div></div></div>';
        document.getElementById('pwd-presets-row').innerHTML = html;
    }

    window.applyPreset = function(index) {
        var p = PRESETS[index];
        if (!p) return;

        document.getElementById('pwd-gradient-start').value = p.gradient_start;
        document.getElementById('pwd-gradient-start-text').value = p.gradient_start;
        document.getElementById('pwd-gradient-end').value = p.gradient_end;
        document.getElementById('pwd-gradient-end-text').value = p.gradient_end;
        document.getElementById('pwd-card-bg').value = p.card_bg;
        document.getElementById('pwd-card-bg-text').value = p.card_bg;
        document.getElementById('pwd-text-color').value = p.text_color;
        document.getElementById('pwd-text-color-text').value = p.text_color;
        document.getElementById('pwd-card-radius').value = p.radius;
        document.getElementById('pwd-card-radius-val').textContent = p.radius;
        document.getElementById('pwd-icon-class').value = p.icon_class;
        document.getElementById('pwd-icon-preview').innerHTML = '<i class="' + escapeHtml(p.icon_class) + '"></i>';
        document.getElementById('pwd-error-color').value = p.error_color;
        document.getElementById('pwd-error-color-text').value = p.error_color;
        document.getElementById('pwd-box-shadow').value = p.shadow;
        updatePwdPreview();
    };

    // ==========================================
    // Settings form
    // ==========================================
    function renderSettings() {
        var html = '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-palette"></i> {/literal}{$meta.lang['Password Page Appearance']}{literal}</h3></div>';
        html += '<div class="panel-body"><form class="form-horizontal">';

        // Gradient Start
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Gradient Start Color']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="color" id="pwd-gradient-start" class="form-control" style="width:60px; height:34px; padding:2px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_gradient_start')) + '"> ';
        html += '<input type="text" id="pwd-gradient-start-text" class="form-control input-sm" style="width:100px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_gradient_start')) + '">';
        html += '</div></div>';

        // Gradient End
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Gradient End Color']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="color" id="pwd-gradient-end" class="form-control" style="width:60px; height:34px; padding:2px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_gradient_end')) + '"> ';
        html += '<input type="text" id="pwd-gradient-end-text" class="form-control input-sm" style="width:100px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_gradient_end')) + '">';
        html += '</div></div>';

        // Card Background
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Card Background']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="color" id="pwd-card-bg" class="form-control" style="width:60px; height:34px; padding:2px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_card_bg')) + '"> ';
        html += '<input type="text" id="pwd-card-bg-text" class="form-control input-sm" style="width:100px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_card_bg')) + '">';
        html += '</div></div>';

        // Text Color
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Text Color']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="color" id="pwd-text-color" class="form-control" style="width:60px; height:34px; padding:2px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_text_color')) + '"> ';
        html += '<input type="text" id="pwd-text-color-text" class="form-control input-sm" style="width:100px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_text_color')) + '">';
        html += '</div></div>';

        // Border Radius
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Card Border Radius']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="range" id="pwd-card-radius" min="0" max="30" value="' + escapeHtml(pwdVal('pwd_card_radius')) + '" style="width:200px; display:inline-block; vertical-align:middle;"> ';
        html += '<span id="pwd-card-radius-val">' + escapeHtml(pwdVal('pwd_card_radius')) + '</span>px';
        html += '</div></div>';

        // Icon Class
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Header Icon']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="text" id="pwd-icon-class" class="form-control input-sm" style="width:250px; display:inline-block;" value="' + escapeHtml(pwdVal('pwd_icon_class')) + '"> ';
        html += '<span id="pwd-icon-preview" style="font-size:1.3rem; vertical-align:middle;"><i class="' + escapeHtml(pwdVal('pwd_icon_class')) + '"></i></span>';
        html += '<p class="help-block" style="margin-top:4px;"><small>FontAwesome: fas fa-lock, fas fa-key, fas fa-shield-alt ...</small></p>';
        html += '</div></div>';

        // Error Color
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Error Color']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<input type="color" id="pwd-error-color" class="form-control" style="width:60px; height:34px; padding:2px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_error_color')) + '"> ';
        html += '<input type="text" id="pwd-error-color-text" class="form-control input-sm" style="width:100px; display:inline-block; vertical-align:middle;" value="' + escapeHtml(pwdVal('pwd_error_color')) + '">';
        html += '</div></div>';

        // Box Shadow
        html += '<div class="form-group" style="margin-bottom:12px;">';
        html += '<label class="col-sm-4 control-label">{/literal}{$meta.lang['Card Shadow']}{literal}</label>';
        html += '<div class="col-sm-8">';
        html += '<select id="pwd-box-shadow" class="form-control" style="width:150px; display:inline-block;">';
        html += '<option value="yes"' + (pwdVal('pwd_box_shadow') === 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['YES']}{literal}</option>';
        html += '<option value="no"' + (pwdVal('pwd_box_shadow') === 'no' ? ' selected' : '') + '>{/literal}{$meta.lang['NO']}{literal}</option>';
        html += '</select>';
        html += '</div></div>';

        // Reset
        html += '<div class="form-group" style="margin-bottom:0; margin-top:15px; border-top:1px solid #eee; padding-top:15px;">';
        html += '<div class="col-sm-offset-4 col-sm-8">';
        html += '<button type="button" class="btn btn-default btn-sm" onclick="resetPwdDefaults()"><i class="fa fa-undo"></i> {/literal}{$meta.lang['Reset to Defaults']}{literal}</button>';
        html += '</div></div>';

        html += '</form></div></div>';
        document.getElementById('pwd-settings-col').innerHTML = html;

        // Bind events
        var colorPairs = [
            ['pwd-gradient-start', 'pwd-gradient-start-text'],
            ['pwd-gradient-end', 'pwd-gradient-end-text'],
            ['pwd-card-bg', 'pwd-card-bg-text'],
            ['pwd-text-color', 'pwd-text-color-text'],
            ['pwd-error-color', 'pwd-error-color-text']
        ];
        colorPairs.forEach(function(pair) {
            var picker = document.getElementById(pair[0]);
            var text = document.getElementById(pair[1]);
            if (picker && text) {
                picker.addEventListener('input', function() { text.value = picker.value; updatePwdPreview(); });
                text.addEventListener('input', function() {
                    if (/^#[0-9a-fA-F]{6}$/.test(text.value)) { picker.value = text.value; }
                    updatePwdPreview();
                });
            }
        });

        var radiusSlider = document.getElementById('pwd-card-radius');
        if (radiusSlider) {
            radiusSlider.addEventListener('input', function() {
                document.getElementById('pwd-card-radius-val').textContent = radiusSlider.value;
                updatePwdPreview();
            });
        }

        var iconInput = document.getElementById('pwd-icon-class');
        if (iconInput) {
            iconInput.addEventListener('input', function() {
                document.getElementById('pwd-icon-preview').innerHTML = '<i class="' + escapeHtml(iconInput.value) + '"></i>';
                updatePwdPreview();
            });
        }

        var shadowSel = document.getElementById('pwd-box-shadow');
        if (shadowSel) shadowSel.addEventListener('change', function() { updatePwdPreview(); });

        updatePwdPreview();
    }

    // ==========================================
    // Preview
    // ==========================================
    function renderPreview() {
        var html = '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-eye"></i> {/literal}{$meta.lang['Preview']}{literal}</h3></div>';
        html += '<div class="panel-body" style="background:#f5f5f5; text-align:center; padding:25px 15px;">';
        html += '<div id="pwd-preview"></div>';
        html += '</div></div>';
        document.getElementById('pwd-preview-col').innerHTML = html;
    }

    function updatePwdPreview() {
        var el = document.getElementById('pwd-preview');
        if (!el) return;

        var gradStart = document.getElementById('pwd-gradient-start').value;
        var gradEnd = document.getElementById('pwd-gradient-end').value;
        var cardBg = document.getElementById('pwd-card-bg').value;
        var textColor = document.getElementById('pwd-text-color').value;
        var radius = document.getElementById('pwd-card-radius').value + 'px';
        var iconClass = document.getElementById('pwd-icon-class').value;
        var errorColor = document.getElementById('pwd-error-color').value;
        var shadow = document.getElementById('pwd-box-shadow').value === 'yes';

        var cardShadow = shadow ? '0 10px 40px rgba(0,0,0,0.08)' : 'none';
        var gradient = 'linear-gradient(135deg, ' + gradStart + ' 0%, ' + gradEnd + ' 100%)';

        var html = '<div style="display:inline-block; width:100%; max-width:300px; border-radius:' + radius + '; overflow:hidden; box-shadow:' + cardShadow + '; background:' + cardBg + '; text-align:center;">';
        html += '<div style="background:' + gradient + '; padding:25px 20px;">';
        html += '<i class="' + escapeHtml(iconClass) + '" style="font-size:2rem; color:rgba(255,255,255,0.9); display:block; margin-bottom:8px;"></i>';
        html += '<div style="color:#fff; font-size:1.1rem; font-weight:600;">{/literal}{$meta.lang['Password Protection']}{literal}</div>';
        html += '<div style="color:rgba(255,255,255,0.7); font-size:0.8rem; margin-top:5px;">{/literal}{$meta.lang['This page is password protected']}{literal}</div>';
        html += '</div>';
        html += '<div style="padding:20px; color:' + textColor + ';">';
        html += '<div style="background:' + errorColor + '15; color:' + errorColor + '; border:1px solid ' + errorColor + '40; border-radius:6px; padding:8px; margin-bottom:12px; font-size:0.8rem; display:flex; align-items:center; gap:6px; justify-content:center;"><i class="fas fa-exclamation-circle"></i> {/literal}{$meta.lang['Incorrect password. Please try again.']}{literal}</div>';
        html += '<div style="position:relative; margin-bottom:12px;">';
        html += '<input type="password" disabled style="width:100%; padding:10px 10px 10px 32px; border:2px solid #e5e7eb; border-radius:8px; font-size:0.9rem; box-sizing:border-box; background:' + cardBg + '; color:' + textColor + ';" placeholder="{/literal}{$meta.lang['Enter password']}{literal}">';
        html += '<i class="fas fa-lock" style="position:absolute; left:10px; top:50%; transform:translateY(-50%); color:#9ca3af; font-size:0.8rem;"></i>';
        html += '</div>';
        html += '<button disabled style="width:100%; padding:10px; background:' + gradient + '; color:#fff; border:none; border-radius:8px; font-size:0.9rem; font-weight:600; cursor:default; display:flex; align-items:center; justify-content:center; gap:6px;"><i class="fas fa-unlock"></i> {/literal}{$meta.lang['Unlock Page']}{literal}</button>';
        html += '</div></div>';

        el.innerHTML = html;
    }

    // ==========================================
    // Reset & Save
    // ==========================================
    window.resetPwdDefaults = function() {
        applyPreset(0);
    };

    window.savePwdSettings = function(btn) {
        btnLoading(btn);
        var settings = {
            pwd_gradient_start: document.getElementById('pwd-gradient-start').value,
            pwd_gradient_end: document.getElementById('pwd-gradient-end').value,
            pwd_card_bg: document.getElementById('pwd-card-bg').value,
            pwd_text_color: document.getElementById('pwd-text-color').value,
            pwd_card_radius: document.getElementById('pwd-card-radius').value,
            pwd_icon_class: document.getElementById('pwd-icon-class').value,
            pwd_error_color: document.getElementById('pwd-error-color').value,
            pwd_box_shadow: document.getElementById('pwd-box-shadow').value
        };

        jQuery.ajax({
            url: ajaxUrl + '&ajax=saveSettings',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(settings),
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Save failed']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('{/literal}{$meta.lang['Save failed']}{literal}', 'error');
            }
        });
    };
});
</script>
{/literal}
