<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-history"></i> {$meta.lang['Revision History']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="revisions-back"></div>
    <div id="revisions-table"></div>
    <div id="revision-preview" style="display:none;"></div>
</div>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var urlParams = new URLSearchParams(window.location.search);
    var pageId = urlParams.get('page_id') || urlParams.get('id');

    if (!pageId) {
        document.getElementById('main-loading').style.display = 'none';
        document.getElementById('revisions-table').innerHTML = '<div class="alert alert-warning" style="margin-top:15px;"><i class="fa fa-exclamation-triangle"></i> {/literal}{$meta.lang['No page ID specified']}{literal}</div>';
        return;
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    // Back to page link
    var backHtml = '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
    backHtml += '<a href="' + ajaxUrl + '&page=page_edit&id=' + pageId + '" class="btn btn-default"><i class="fa fa-arrow-left"></i> {/literal}{$meta.lang['Back to Page']}{literal}</a>';
    backHtml += '</div></div>';
    document.getElementById('revisions-back').innerHTML = backHtml;

    function loadRevisions() {
        jQuery.ajax({
            url: ajaxUrl + '&ajax=getRevisions&page_id=' + pageId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('main-loading').style.display = 'none';
                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }
                renderTable(response.data || []);
            },
            error: function() {
                document.getElementById('main-loading').style.display = 'none';
                showNotification('{/literal}{$meta.lang['Failed to load revisions']}{literal}', 'error');
            }
        });
    }

    function renderTable(revisions) {
        var html = '<div class="panel panel-default" style="margin-top:10px;">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-list"></i> {/literal}{$meta.lang['Revisions']}{literal} <small class="text-muted">({/literal}{$meta.lang['Page']}{literal} #' + pageId + ')</small></h3></div>';
        html += '<div class="panel-body">';
        if (revisions.length === 0) {
            html += '<p class="text-muted text-center" style="padding:30px;">{/literal}{$meta.lang['No revisions found']}{literal}</p>';
        } else {
            html += '<table class="table table-striped table-condensed">';
            html += '<thead><tr><th>{/literal}{$meta.lang['ID']}{literal}</th><th>{/literal}{$meta.lang['Date']}{literal}</th><th>{/literal}{$meta.lang['Admin']}{literal}</th><th>{/literal}{$meta.lang['Language']}{literal}</th><th>{/literal}{$meta.lang['Actions']}{literal}</th></tr></thead>';
            html += '<tbody>';
            for (var i = 0; i < revisions.length; i++) {
                var r = revisions[i];
                html += '<tr>';
                html += '<td>#' + r.id + '</td>';
                html += '<td><small>' + escapeHtml(r.created_at || '') + '</small></td>';
                html += '<td>' + escapeHtml(r.admin_name || '') + '</td>';
                html += '<td>' + escapeHtml(r.language || '{/literal}{$meta.lang['Default']}{literal}') + '</td>';
                html += '<td>';
                html += '<button class="btn btn-xs btn-info" onclick="viewRevision(' + r.id + ')" title="{/literal}{$meta.lang['View']}{literal}"><i class="fa fa-eye"></i> {/literal}{$meta.lang['View']}{literal}</button> ';
                html += '<button class="btn btn-xs btn-warning" onclick="restoreRevision(' + r.id + ')" title="{/literal}{$meta.lang['Restore']}{literal}"><i class="fa fa-undo"></i> {/literal}{$meta.lang['Restore']}{literal}</button>';
                html += '</td></tr>';
            }
            html += '</tbody></table>';
        }
        html += '</div></div>';
        document.getElementById('revisions-table').innerHTML = html;
    }

    window.viewRevision = function(revisionId) {
        var previewDiv = document.getElementById('revision-preview');
        previewDiv.style.display = '';
        previewDiv.innerHTML = '<div class="panel panel-info" style="margin-top:10px;"><div class="panel-heading"><h3 class="panel-title"><i class="fa fa-eye"></i> {/literal}{$meta.lang['Revision Preview']}{literal} #' + revisionId + ' <button type="button" class="close" onclick="closeRevisionPreview()">&times;</button></h3></div><div class="panel-body text-center"><i class="fa fa-spinner fa-spin"></i> {/literal}{$meta.lang['Loading...']}{literal}</div></div>';

        jQuery.ajax({
            url: ajaxUrl + '&ajax=getRevision&id=' + revisionId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data) {
                    var content = response.data.content || '';
                    var displayContent = '';
                    try {
                        var parsed = JSON.parse(content);
                        displayContent = '<pre style="max-height:400px; overflow:auto; background:#f9f9f9; padding:15px; border-radius:4px;">' + escapeHtml(JSON.stringify(parsed, null, 2)) + '</pre>';
                    } catch(e) {
                        displayContent = '<div style="max-height:400px; overflow:auto; background:#f9f9f9; padding:15px; border-radius:4px; border:1px solid #eee;">' + content + '</div>';
                    }
                    previewDiv.innerHTML = '<div class="panel panel-info" style="margin-top:10px;"><div class="panel-heading"><h3 class="panel-title"><i class="fa fa-eye"></i> {/literal}{$meta.lang['Revision Preview']}{literal} #' + revisionId + ' <button type="button" class="close" onclick="closeRevisionPreview()">&times;</button></h3></div><div class="panel-body">' + displayContent + '</div></div>';
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Failed to load revision']}{literal}', 'error');
                    previewDiv.style.display = 'none';
                }
            },
            error: function() {
                showNotification('{/literal}{$meta.lang['Failed to load revision']}{literal}', 'error');
                previewDiv.style.display = 'none';
            }
        });
    };

    window.closeRevisionPreview = function() {
        var previewDiv = document.getElementById('revision-preview');
        previewDiv.style.display = 'none';
        previewDiv.innerHTML = '';
    };

    window.restoreRevision = function(revisionId) {
        if (!confirm('{/literal}{$meta.lang['Are you sure you want to restore this revision?']}{literal}')) return;
        jQuery.ajax({
            url: ajaxUrl + '&ajax=restoreRevision',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ revision_id: revisionId }),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Revision restored successfully']}{literal}', 'success');
                    loadRevisions();
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Restore failed']}{literal}', 'error');
                }
            },
            error: function() {
                showNotification('{/literal}{$meta.lang['Restore failed']}{literal}', 'error');
            }
        });
    };

    loadRevisions();
});
</script>
{/literal}
