<style>
    .sticky-save { position: fixed; bottom: 10px; left: 50%; transform: translateX(-50%); z-index: 99999; }
    .lang-btn { margin: 2px; }
    .ce-block { border: 1px solid #ccc; box-shadow: 0 0 10px rgba(0,0,0,0.3); padding: 5px; margin: 10px 0; }
    .ce-block--focused { border-radius: 6px; border: 1px solid #ccca; box-shadow: 0 0 10px rgba(0,0,0,0.9); }
    .ce-block__content { max-width: 1024px; }
    .ce-toolbar__content { max-width: 1024px; }
    .codex-editor__redactor { border-radius: 2px; border: 4px solid #ccc; box-shadow: 0 0 10px rgba(0,0,0,0.3); padding: 20px; }
    .ce-popover__item[data-item-name="paragraph"] { display: none; }
    .ce-popover--opened { min-width: 400px; min-height: 500px; }

</style>

<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-edit"></i> {$meta.lang['Page edit']} <span id="page-title-display"></span></h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="editor-content" style="display:none;">
        <form id="pageform" onsubmit="return false;">
            <input type="hidden" id="field-type" value="type_editor_js">
            <input type="hidden" id="field-id" value="">

            <!-- Action buttons -->
            <div style="margin-bottom:15px;">
                <button type="button" id="saveButton" class="btn btn-primary" onclick="savePage()"><i class="fas fa-check-square"></i> {$meta.lang['Save Changes']}</button>
                <a id="btn-preview-module" href="#" target="_blank" class="btn btn-success"><i class="fa fa-search"></i> {$meta.lang['Preview (module url)']}</a>
                <a id="btn-preview-site" href="#" target="_blank" class="btn btn-success"><i class="fa fa-search"></i> {$meta.lang['Preview (site url)']}</a>
                <span id="actions-default" style="display:none;">
                    <button type="button" class="btn btn-info" onclick="clonePage(this)"><i class="fa fa-clone"></i> {$meta.lang['Clone']}</button>
                    <button type="button" class="btn btn-danger" onclick="deletePageConfirm(this)"><i class="fa fa-trash-alt"></i> {$meta.lang['Delete']}</button>
                </span>
                <span id="actions-language" style="display:none;">
                    <button type="button" class="btn btn-danger" onclick="deleteLanguage(this)"><i class="fa fa-trash-alt"></i> {$meta.lang['Delete translation']}</button>
                </span>
                <button type="button" class="btn btn-default" onclick="exportCurrentPage(this)"><i class="fa fa-download"></i> {$meta.lang['Export']}</button>
                <button type="button" class="btn btn-default" onclick="document.getElementById('import-file-edit').click()"><i class="fa fa-upload"></i> {$meta.lang['Import']}</button>
                <input type="file" id="import-file-edit" accept=".json" style="display:none;" onchange="importPageContent(this)">
                <a id="btn-revisions" href="#" class="btn btn-default"><i class="fa fa-history"></i> {$meta.lang['Revisions']}</a>
            </div>

            <!-- Main Settings -->
            <div class="panel panel-default">
                <div class="panel-heading" style="cursor:pointer;" onclick="jQuery('#section-main').toggle();">
                    <h3 class="panel-title"><i class="fa fa-cog"></i> {$meta.lang['Main']} <b id="field-id-display" style="margin-left:10px;"></b></h3>
                </div>
                <div class="panel-body" id="section-main">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['Name']}</label>
                                <input type="text" id="field-name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['URL']}</label>
                                <input type="text" id="field-url" class="form-control" placeholder="{$meta.lang['Auto-generated from name if empty']}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{$meta.lang['Status']}</label>
                                <select id="field-status" class="form-control">
                                    <option value="draft">{$meta.lang['Draft']}</option>
                                    <option value="published">{$meta.lang['Published']}</option>
                                    <option value="archived">{$meta.lang['Archived']}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{$meta.lang['Required login']}</label>
                                <select id="field-required_login" class="form-control">
                                    <option value="no">{$meta.lang['NO']}</option>
                                    <option value="yes">{$meta.lang['YES']}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{$meta.lang['Password']} <small class="text-muted">({$meta.lang['leave empty for no protection']})</small></label>
                                <input type="text" id="field-password" class="form-control" placeholder="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SEO -->
            <div class="panel panel-default">
                <div class="panel-heading" style="cursor:pointer;" onclick="jQuery('#section-seo').toggle();">
                    <h3 class="panel-title"><i class="fa fa-search"></i> SEO</h3>
                </div>
                <div class="panel-body" id="section-seo" style="display:none;">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['OG title']}</label>
                                <input type="text" id="field-og_title" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['OG description']}</label>
                                <input type="text" id="field-og_description" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['OG image']}</label>
                                <input type="text" id="field-og_image" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['Keyword(s)']}</label>
                                <input type="text" id="field-keywords" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['Canonical URL']}</label>
                                <input type="text" id="field-canonical_url" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['Meta Robots']}</label>
                                <select id="field-meta_robots" class="form-control">
                                    <option value="">Default</option>
                                    <option value="index, follow">index, follow</option>
                                    <option value="noindex, follow">noindex, follow</option>
                                    <option value="index, nofollow">index, nofollow</option>
                                    <option value="noindex, nofollow">noindex, nofollow</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Languages & Copy -->
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="fa fa-language"></i> {$meta.lang['Languages']}</h3>
                </div>
                <div class="panel-body">
                    <div id="languages-bar"></div>
                    <div id="copy-from-row" style="display:none; margin-top:10px;">
                        <label>{$meta.lang['Copy from']}</label>
                        <div style="display:flex; gap:10px; align-items:center;">
                            <select id="copy-from-select" class="form-control" style="width:auto;"></select>
                            <button type="button" class="btn btn-primary btn-sm" onclick="copyFromLanguage(this)"><i class="fa fa-file"></i> {$meta.lang['Copy']}</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Editor area -->
            <div style="width:100%;"><div style="max-width:1140px; margin:0 auto;" id="editor-area"></div></div>
        </form>
    </div>
</div>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var beforePath = '{/literal}{$meta.before_path}{literal}';
    var params = new URLSearchParams(window.location.search);
    var pageId = params.get('id');
    var currentLanguage = params.get('language') || '';

    if (!pageId) { window.location.href = ajaxUrl + '&page=pages'; return; }

    // Slugify helper
    function slugify(str) {
        return str.toString().toLowerCase().trim()
            .replace(/[\s_]+/g, '-')
            .replace(/[^\w\-]+/g, '')
            .replace(/\-\-+/g, '-')
            .replace(/^-+/, '')
            .replace(/-+$/, '');
    }

    // Load page data
    jQuery.ajax({
        url: ajaxUrl + '&ajax=getPage&id=' + pageId + (currentLanguage ? '&language=' + currentLanguage : ''),
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';
            if (!response.success || !response.data) {
                showNotification(response.error || 'Page not found', 'error');
                return;
            }
            populateForm(response.data);
            document.getElementById('editor-content').style.display = '';
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load page', 'error');
        }
    });

    function populateForm(data) {
        var page = data;

        // If editing a translation, overlay language-specific fields
        if (currentLanguage && page.languages) {
            for (var i = 0; i < page.languages.length; i++) {
                if (page.languages[i].language === currentLanguage) {
                    var langData = page.languages[i];
                    page = Object.assign({}, page, {
                        name: langData.name !== null ? langData.name : page.name,
                        page: langData.page !== null ? langData.page : page.page,
                        og_title: langData.og_title !== null ? langData.og_title : page.og_title,
                        og_description: langData.og_description !== null ? langData.og_description : page.og_description,
                        og_image: langData.og_image !== null ? langData.og_image : page.og_image,
                        keywords: langData.keywords !== null ? langData.keywords : page.keywords,
                    });
                    break;
                }
            }
        }

        document.getElementById('field-id').value = page.id;
        document.getElementById('field-name').value = page.name || '';
        document.getElementById('field-url').value = page.url || '';
        document.getElementById('field-status').value = page.status || 'draft';
        document.getElementById('field-required_login').value = page.required_login || 'no';
        document.getElementById('field-password').value = page.password || '';
        document.getElementById('field-og_title').value = page.og_title || '';
        document.getElementById('field-og_description').value = page.og_description || '';
        document.getElementById('field-og_image').value = page.og_image || '';
        document.getElementById('field-keywords').value = page.keywords || '';
        document.getElementById('field-canonical_url').value = page.canonical_url || '';
        document.getElementById('field-meta_robots').value = page.meta_robots || '';

        document.getElementById('field-id-display').textContent = 'ID: #' + page.id;
        document.getElementById('page-title-display').textContent = page.name ? '- ' + page.name : '';

        // Preview URLs
        document.getElementById('btn-preview-module').href = beforePath + '/?m=puq_page_manager&id=' + page.id;
        if (page.url) {
            document.getElementById('btn-preview-site').href = beforePath + '/' + page.url;
        }

        // Revisions link
        document.getElementById('btn-revisions').href = ajaxUrl + '&page=revisions&page_id=' + page.id;

        // Language handling
        if (currentLanguage) {
            document.getElementById('field-url').disabled = true;
            document.getElementById('actions-default').style.display = 'none';
            document.getElementById('actions-language').style.display = '';
        } else {
            document.getElementById('actions-default').style.display = '';
            document.getElementById('actions-language').style.display = 'none';
        }

        // Render language bar
        renderLanguageBar(page.languages || []);

        // Load editor
        loadEditor(page.page || '');
    }

    function renderLanguageBar(languages) {
        var bar = document.getElementById('languages-bar');
        var defaultLang = '{/literal}{$meta.lang['Default']}{literal}';
        var html = '<a href="' + ajaxUrl + '&page=page_edit&id=' + pageId + '" class="btn ' + (!currentLanguage ? 'btn-warning' : 'btn-default') + ' btn-sm lang-btn"><i class="fa fa-check-square" style="color:green;"></i> ' + defaultLang + '</a>';

        var copyOptions = '';
        if (currentLanguage) {
            copyOptions += '<option value="default">{/literal}{$meta.lang['Default']}{literal}</option>';
        }

        var langMap = {};
        if (languages) {
            for (var i = 0; i < languages.length; i++) {
                langMap[languages[i].language] = languages[i];
            }
        }

        var knownLangs = ['arabic','azerbaijani','catalan','chinese','croatian','czech','danish','dutch','english','estonian','farsi','french','german','hebrew','hungarian','italian','macedonian','norwegian','polish','romanian','russian','spanish','swedish','turkish','ukrainian'];
        for (var i = 0; i < knownLangs.length; i++) {
            var l = knownLangs[i];
            var hasTranslation = langMap[l] !== undefined;
            var isActive = currentLanguage === l;
            html += '<a href="' + ajaxUrl + '&page=page_edit&id=' + pageId + '&language=' + l + '" class="btn ' + (isActive ? 'btn-warning' : 'btn-default') + ' btn-sm lang-btn">';
            html += hasTranslation ? '<i class="fa fa-check-square" style="color:green;"></i>' : '<i class="fa fa-ban" style="color:red;"></i>';
            html += ' ' + l.charAt(0).toUpperCase() + l.slice(1) + '</a>';

            if (hasTranslation && currentLanguage !== l) {
                copyOptions += '<option value="' + l + '">' + l.charAt(0).toUpperCase() + l.slice(1) + '</option>';
            }
        }

        bar.innerHTML = html;

        if (copyOptions) {
            document.getElementById('copy-from-row').style.display = '';
            document.getElementById('copy-from-select').innerHTML = copyOptions;
        }
    }

    function loadEditor(content) {
        var area = document.getElementById('editor-area');
        area.innerHTML = '<textarea name="page" id="output_input" style="display:none;"></textarea>' +
            '<div id="editor-container"></div>';

        window.productgroupsJson = '[]';
        window.productsJson = '[]';
        window.widgetsTemplatesJson = '{}';
        window.widgetManifests = [];

        jQuery.ajax({ url: ajaxUrl + '&ajax=getProductGroups', dataType: 'json', async: false,
            success: function(r) { if (r.success) window.productgroupsJson = JSON.stringify(r.data || []); }
        });
        jQuery.ajax({ url: ajaxUrl + '&ajax=getProducts', dataType: 'json', async: false,
            success: function(r) { if (r.success) window.productsJson = JSON.stringify(r.data || []); }
        });
        jQuery.ajax({ url: ajaxUrl + '&ajax=getWidgetTemplates', dataType: 'json', async: false,
            success: function(r) { if (r.success) window.widgetsTemplatesJson = JSON.stringify(r.data || {}); }
        });
        jQuery.ajax({ url: ajaxUrl + '&ajax=getWidgetManifests', dataType: 'json', async: false,
            success: function(r) { if (r.success) window.widgetManifests = r.data || []; }
        });

        // Global helper for all widgets to generate style/template <option> lists
        window.generateOptionTemplates = function(key) {
            try {
                var templates = JSON.parse(window.widgetsTemplatesJson);
                var lowerKey = key.toLowerCase();
                if (lowerKey in templates) {
                    return templates[lowerKey].map(function(v) {
                        return '<option value="' + v + '">' + v + '</option>';
                    }).join('');
                }
            } catch(e) {}
            return '';
        };

        try {
            window.pageJson = JSON.parse(content || '{"blocks":[]}');
        } catch(e) {
            window.pageJson = { blocks: [] };
        }

        var widgetsBase = beforePath + '/modules/addons/puq_page_manager/widgets/';
        var loadIdx = 0;

        function loadNext() {
            if (loadIdx < window.widgetManifests.length) {
                var manifest = window.widgetManifests[loadIdx];
                var s = document.createElement('script');
                s.src = widgetsBase + manifest.dir + '/' + manifest.className + '.js';
                s.onload = function() { loadIdx++; loadNext(); };
                s.onerror = function() {
                    console.warn('Failed to load widget: ' + manifest.className);
                    loadIdx++;
                    loadNext();
                };
                document.body.appendChild(s);
            } else {
                loadCoreDeps();
            }
        }

        function loadCoreDeps() {
            var editorScript = document.createElement('script');
            editorScript.src = beforePath + '/modules/addons/puq_page_manager/templates/js/editor.js';
            editorScript.onload = function() {
                var tmce = document.createElement('script');
                tmce.src = beforePath + '/assets/js/tinymce/tinymce.min.js';
                tmce.onload = function() { initEditorJS(); };
                tmce.onerror = function() { initEditorJS(); };
                document.body.appendChild(tmce);
            };
            editorScript.onerror = function() {
                console.error('Failed to load EditorJS');
            };
            document.body.appendChild(editorScript);
        }

        loadNext();
    }

    function initEditorJS() {
        if (typeof EditorJS === 'undefined') {
            console.error('EditorJS not loaded');
            return;
        }
        var tools = {};
        for (var i = 0; i < window.widgetManifests.length; i++) {
            var manifest = window.widgetManifests[i];
            try {
                var cls = (new Function('return typeof ' + manifest.className + ' !== "undefined" ? ' + manifest.className + ' : undefined'))();
                if (cls) {
                    tools[manifest.type] = { class: cls, inlineToolbar: true };
                }
            } catch(e) {}
        }

        window.puqEditor = new EditorJS({
            readOnly: false,
            holder: 'editor-container',
            inlineToolbar: true,
            autofocus: true,
            tools: tools,
            data: { blocks: (window.pageJson && window.pageJson.blocks) ? window.pageJson.blocks : [] }
        });
    }

    window.savePage = function() {
        var btn = document.getElementById('saveButton');
        btnLoading(btn);
        if (window.puqEditor) {
            window.puqEditor.save().then(function(savedData) {
                doSave(JSON.stringify(savedData), btn);
            }).catch(function(error) {
                btnReset(btn);
                console.error('EditorJS save error:', error);
                showNotification('Save failed: ' + (error && error.message ? error.message : error), 'error');
            });
            return;
        }
        doSave('', btn);
    };

    function doSave(pageContent, btn) {
        var nameVal = document.getElementById('field-name').value;
        var urlVal = document.getElementById('field-url').value;

        // Auto-generate URL from name if empty
        if (!urlVal && nameVal && !currentLanguage) {
            urlVal = slugify(nameVal);
            document.getElementById('field-url').value = urlVal;
        }

        var data = {
            id: parseInt(document.getElementById('field-id').value),
            name: nameVal,
            url: urlVal,
            status: document.getElementById('field-status').value,
            required_login: document.getElementById('field-required_login').value,
            password: document.getElementById('field-password').value || null,
            type: 'type_editor_js',
            page: pageContent,
            og_title: document.getElementById('field-og_title').value,
            og_description: document.getElementById('field-og_description').value,
            og_image: document.getElementById('field-og_image').value,
            keywords: document.getElementById('field-keywords').value,
            canonical_url: document.getElementById('field-canonical_url').value,
            meta_robots: document.getElementById('field-meta_robots').value,
            language: currentLanguage || ''
        };

        jQuery.ajax({
            url: ajaxUrl + '&ajax=savePage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(data),
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                    // Update preview URL if it was auto-generated
                    if (data.url) {
                        document.getElementById('btn-preview-site').href = beforePath + '/' + data.url;
                    }
                } else {
                    showNotification(response.error || 'Save failed', 'error');
                }
            },
            error: function() { btnReset(btn); showNotification('Save failed', 'error'); }
        });
    }

    window.clonePage = function(btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=clonePage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ id: parseInt(pageId) }),
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data) {
                    window.location.href = ajaxUrl + '&page=page_edit&id=' + response.data.id;
                } else {
                    showNotification(response.error || 'Clone failed', 'error');
                    btnReset(btn);
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.deletePageConfirm = function(btn) {
        if (!confirm('{/literal}{$meta.lang['Confirm Delete']}{literal}')) return;
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=deletePage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ id: parseInt(pageId) }),
            dataType: 'json',
            success: function(response) {
                if (response.success) { window.location.href = ajaxUrl + '&page=pages'; }
                else {
                    showNotification(response.error || 'Delete failed', 'error');
                    btnReset(btn);
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.deleteLanguage = function(btn) {
        if (!confirm('{/literal}{$meta.lang['Are you sure you want to delete?']}{literal}')) return;
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=deletePageLanguage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ page_id: parseInt(pageId), language: currentLanguage }),
            dataType: 'json',
            success: function(response) {
                if (response.success) { window.location.href = ajaxUrl + '&page=page_edit&id=' + pageId; }
                else {
                    showNotification(response.error || 'Delete failed', 'error');
                    btnReset(btn);
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.copyFromLanguage = function(btn) {
        if (!confirm('{/literal}{$meta.lang['Are you sure you want to copy?']}{literal}')) return;
        btnLoading(btn);
        var from = document.getElementById('copy-from-select').value;
        var to = currentLanguage || 'default';
        jQuery.ajax({
            url: ajaxUrl + '&ajax=copyPageLanguage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ page_id: parseInt(pageId), from: from, to: to }),
            dataType: 'json',
            success: function(response) {
                if (response.success) { location.reload(); }
                else {
                    showNotification(response.error || 'Copy failed', 'error');
                    btnReset(btn);
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.exportCurrentPage = function(btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=exportPage&id=' + pageId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    var blob = new Blob([JSON.stringify(response.data, null, 2)], { type: 'application/json' });
                    var a = document.createElement('a');
                    a.href = URL.createObjectURL(blob);
                    a.download = 'page_' + pageId + '_export.json';
                    a.click();
                    showNotification('{/literal}{$meta.lang['Page exported']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Export failed']}{literal}', 'error');
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.importPageContent = function(input) {
        if (!input.files || !input.files[0]) return;
        if (!confirm('{/literal}{$meta.lang['This will replace current page content. Continue?']}{literal}')) {
            input.value = '';
            return;
        }
        var reader = new FileReader();
        reader.onload = function(e) {
            try {
                var importData = JSON.parse(e.target.result);
            } catch (err) {
                showNotification('Invalid JSON file', 'error');
                return;
            }
            if (importData.name !== undefined) document.getElementById('field-name').value = importData.name || '';
            if (importData.og_title !== undefined) document.getElementById('field-og_title').value = importData.og_title || '';
            if (importData.og_description !== undefined) document.getElementById('field-og_description').value = importData.og_description || '';
            if (importData.og_image !== undefined) document.getElementById('field-og_image').value = importData.og_image || '';
            if (importData.keywords !== undefined) document.getElementById('field-keywords').value = importData.keywords || '';
            if (importData.canonical_url !== undefined) document.getElementById('field-canonical_url').value = importData.canonical_url || '';
            if (importData.meta_robots !== undefined) document.getElementById('field-meta_robots').value = importData.meta_robots || '';

            if (importData.page) {
                var pageContent = atob(importData.page);
                try {
                    var parsed = JSON.parse(pageContent);
                    if (window.puqEditor && parsed.blocks) {
                        window.puqEditor.render(parsed);
                    }
                } catch(err) {}
            }
            showNotification('{/literal}{$meta.lang['Page imported successfully']}{literal}', 'success');
            input.value = '';
        };
        reader.readAsText(input.files[0]);
    };

    // Sticky save button
    var saveBtn = document.getElementById('saveButton');
    var stickyThreshold = 300;
    var isSticky = false;
    window.addEventListener('scroll', function() {
        if (window.pageYOffset > stickyThreshold && !isSticky) {
            saveBtn.classList.add('sticky-save');
            isSticky = true;
        } else if (window.pageYOffset <= stickyThreshold && isSticky) {
            saveBtn.classList.remove('sticky-save');
            isSticky = false;
        }
    });
});
</script>
{/literal}
