<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-tachometer-alt"></i> {$meta.lang['Dashboard']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="dash-counts"></div>
    <div id="dash-row2"></div>
    <div id="dash-history"></div>
</div>

<style>
    .dash-stat { text-align: center; padding: 18px 10px; }
    .dash-stat-value { font-size: 32px; font-weight: bold; line-height: 1.1; }
    .dash-stat-label { margin-top: 6px; color: #888; font-size: 13px; }
    .dash-info-item { display: flex; align-items: center; padding: 12px 0; border-bottom: 1px solid #f0f0f0; }
    .dash-info-item:last-child { border-bottom: none; }
    .dash-info-icon { width: 40px; height: 40px; border-radius: 8px; display: flex; align-items: center; justify-content: center; font-size: 16px; color: #fff; margin-right: 12px; flex-shrink: 0; }
    .dash-info-text { flex: 1; }
    .dash-info-text .dash-info-value { font-size: 20px; font-weight: bold; line-height: 1.2; }
    .dash-info-text .dash-info-label { font-size: 12px; color: #888; }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getDashboard';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';
            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }
            var d = response.data;
            renderCounts(d);
            renderRow2(d);
            renderHistory(d.recent_changes);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load dashboard data', 'error');
        }
    });

    function renderCounts(d) {
        var cards = [
            { value: d.total_pages, label: '{/literal}{$meta.lang['Total Pages']}{literal}', icon: 'fa-file-alt', color: '#337ab7' },
            { value: d.published, label: '{/literal}{$meta.lang['Published Pages']}{literal}', icon: 'fa-check-circle', color: '#5cb85c' },
            { value: d.draft, label: '{/literal}{$meta.lang['Draft Pages']}{literal}', icon: 'fa-pencil-alt', color: '#f0ad4e' },
            { value: d.archived, label: '{/literal}{$meta.lang['Archived Pages']}{literal}', icon: 'fa-archive', color: '#999' },
        ];
        var html = '<div class="row" style="margin-top:10px;">';
        for (var i = 0; i < cards.length; i++) {
            var c = cards[i];
            html += '<div class="col-md-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid ' + c.color + ';">';
            html += '<div class="dash-stat">';
            html += '<div class="dash-stat-value" style="color:' + c.color + ';">' + c.value + '</div>';
            html += '<div class="dash-stat-label"><i class="fa ' + c.icon + '"></i> ' + c.label + '</div>';
            html += '</div></div></div>';
        }
        html += '</div>';
        document.getElementById('dash-counts').innerHTML = html;
    }

    function renderRow2(d) {
        var html = '<div class="row" style="margin-top:5px;">';

        // Top Viewed
        html += '<div class="col-md-8">';
        html += '<div class="panel panel-default" style="min-height:220px;">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-eye"></i> {/literal}{$meta.lang['Top Viewed Pages']}{literal}</h3></div>';
        html += '<div class="panel-body">';
        var top = d.top_viewed || [];
        if (top.length > 0) {
            html += '<table class="table table-striped table-condensed"><thead><tr><th>{/literal}{$meta.lang['Name']}{literal}</th><th>{/literal}{$meta.lang['URL']}{literal}</th><th>{/literal}{$meta.lang['Views']}{literal}</th></tr></thead><tbody>';
            for (var i = 0; i < top.length; i++) {
                html += '<tr><td>' + escapeHtml(top[i].name) + '</td><td><small>' + escapeHtml(top[i].url) + '</small></td><td><strong>' + top[i].views + '</strong></td></tr>';
            }
            html += '</tbody></table>';
        } else {
            html += '<p class="text-muted text-center">{/literal}{$meta.lang['No data']}{literal}</p>';
        }
        html += '</div></div></div>';

        // System Info
        html += '<div class="col-md-4">';
        html += '<div class="panel panel-default" style="min-height:220px;">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['System Info']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        var infoItems = [
            { value: d.total_views || 0, label: '{/literal}{$meta.lang['Total Views']}{literal}', icon: 'fa-chart-bar', color: '#337ab7' },
            { value: d.total_revisions || 0, label: '{/literal}{$meta.lang['Total Revisions']}{literal}', icon: 'fa-history', color: '#5cb85c' },
            { value: d.total_widgets || 0, label: '{/literal}{$meta.lang['Available Widgets']}{literal}', icon: 'fa-puzzle-piece', color: '#9b59b6' },
        ];
        for (var i = 0; i < infoItems.length; i++) {
            var inf = infoItems[i];
            html += '<div class="dash-info-item">';
            html += '<div class="dash-info-icon" style="background:' + inf.color + ';"><i class="fa ' + inf.icon + '"></i></div>';
            html += '<div class="dash-info-text"><div class="dash-info-value">' + inf.value + '</div><div class="dash-info-label">' + inf.label + '</div></div>';
            html += '</div>';
        }

        html += '</div></div></div></div>';
        document.getElementById('dash-row2').innerHTML = html;
    }

    function renderHistory(changes) {
        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-history"></i> {/literal}{$meta.lang['Recent Changes']}{literal}</h3></div>';
        html += '<div class="panel-body">';
        if (changes && changes.length > 0) {
            html += '<table class="table table-striped table-condensed">';
            html += '<thead><tr><th>{/literal}{$meta.lang['Date']}{literal}</th><th>{/literal}{$meta.lang['Admin']}{literal}</th><th>{/literal}{$meta.lang['Name']}{literal}</th><th>{/literal}{$meta.lang['Language']}{literal}</th></tr></thead><tbody>';
            for (var i = 0; i < changes.length; i++) {
                var h = changes[i];
                html += '<tr><td><small>' + escapeHtml(h.created_at) + '</small></td>';
                html += '<td>' + escapeHtml(h.admin_name) + '</td>';
                html += '<td>' + escapeHtml(h.page_name) + '</td>';
                html += '<td>' + escapeHtml(h.language) + '</td></tr>';
            }
            html += '</tbody></table>';
        } else {
            html += '<p class="text-muted text-center" style="padding:20px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }
        html += '</div></div></div></div>';
        document.getElementById('dash-history').innerHTML = html;
    }
});
</script>
{/literal}
