<style>
    #contentarea {
        position: relative !important;
    }

    #page-preloader {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.5);
        z-index: 999;
        display: flex;
        justify-content: center;
        align-items: center;
        pointer-events: all;
    }

    .preloader-spinner {
        text-align: center;
        pointer-events: none;
    }

    .preloader-spinner i {
        font-size: 48px;
        color: #007bff;
    }

    .preloader-spinner p {
        margin-top: 15px;
        font-size: 16px;
        color: #666;
    }

    .navbar-nav > li.active > a {
        font-weight: bold;
    }

    .dropdown-menu > li.active > a {
        font-weight: bold;
        background-color: #e7e7e7;
    }
</style>

<nav class="navbar navbar-default">
    <div class="container-fluid">
        <div class="navbar-header">
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-menu" aria-expanded="false">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <a class="navbar-brand" href="#">
                <img src="{$meta.logo_url}" alt="Logo" style="cursor: default; height: 30px; display: inline-block; margin-top: -5px;">
            </a>
        </div>

        <div class="collapse navbar-collapse" id="navbar-menu">
            <ul class="nav navbar-nav">
                {foreach $nav_items as $item}
                    {if isset($item.position) && $item.position == 'right'}
                    {elseif $item.dropdown}
                        <li class="dropdown{if $item.active} active{/if}" id="nav_{$item.id}">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                <i class="{$item.icon}" style="margin-right: 3px;"></i> {$item.label} <span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu">
                                {foreach $item.items as $subitem}
                                    {if isset($subitem.divider) && $subitem.divider}
                                        <li role="separator" class="divider"></li>
                                    {elseif isset($subitem.external) && $subitem.external}
                                        <li>
                                            <a href="{$subitem.url}" target="_blank" rel="noopener">
                                                <i class="{$subitem.icon}" style="margin-right: 3px;"></i> {$subitem.label} <i class="fa fa-external-link-alt" style="font-size:10px;margin-left:4px;color:#999;"></i>
                                            </a>
                                        </li>
                                    {else}
                                        <li{if $subitem.active} class="active"{/if}>
                                            <a href="{$subitem.url}" class="nav-link-preloader">
                                                <i class="{$subitem.icon}" style="margin-right: 3px;"></i> {$subitem.label}
                                            </a>
                                        </li>
                                    {/if}
                                {/foreach}
                            </ul>
                        </li>
                    {else}
                        <li id="nav_{$item.id}"{if $item.active} class="active"{/if}>
                            <a href="{$item.url}" class="nav-link-preloader">
                                <i class="{$item.icon}" style="margin-right: 3px;"></i> {$item.label}
                            </a>
                        </li>
                    {/if}
                {/foreach}
            </ul>

            <ul class="nav navbar-nav navbar-right">
                {foreach $nav_items as $item}
                    {if isset($item.position) && $item.position == 'right'}
                        {if $item.dropdown}
                            <li class="dropdown{if $item.active} active{/if}" id="nav_{$item.id}">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                    <i class="{$item.icon}" style="margin-right: 3px;"></i> {$item.label} <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu">
                                    {foreach $item.items as $subitem}
                                        {if isset($subitem.divider) && $subitem.divider}
                                            <li role="separator" class="divider"></li>
                                        {elseif isset($subitem.external) && $subitem.external}
                                            <li>
                                                <a href="{$subitem.url}" target="_blank" rel="noopener">
                                                    <i class="{$subitem.icon}" style="margin-right: 3px;"></i> {$subitem.label} <i class="fa fa-external-link-alt" style="font-size:10px;margin-left:4px;color:#999;"></i>
                                                </a>
                                            </li>
                                        {else}
                                            <li{if $subitem.active} class="active"{/if}>
                                                <a href="{$subitem.url}" class="nav-link-preloader">
                                                    <i class="{$subitem.icon}" style="margin-right: 3px;"></i> {$subitem.label}
                                                </a>
                                            </li>
                                        {/if}
                                    {/foreach}
                                </ul>
                            </li>
                        {else}
                            <li id="nav_{$item.id}"{if $item.active} class="active"{/if}>
                                <a href="{$item.url}" class="nav-link-preloader">
                                    <i class="{$item.icon}" style="margin-right: 3px;"></i> {$item.label}
                                </a>
                            </li>
                        {/if}
                    {/if}
                {/foreach}
                <li><a href="#" style="cursor: default; color: #999; margin-right: 5px;"><i class="far fa-code-branch fa-fw"></i> v{$meta.version}</a></li>
            </ul>
        </div>
    </div>
</nav>

{if !$license_valid}
<div class="alert alert-danger" style="margin:0 0 15px 0; border-radius:0; text-align:center; font-size:14px;">
    <i class="fa fa-exclamation-triangle"></i>
    <strong>{$meta.lang['License Required']}</strong> — {$meta.lang['License warning message']}
    <br>
    <a href="{$meta.url_purchase_license}" target="_blank" class="btn btn-sm btn-danger" style="margin-top:8px;">
        <i class="fa fa-shopping-cart"></i> {$meta.lang['Purchase License']}
    </a>
</div>
{/if}

<div id="page-preloader" style="display: none;">
    <div class="preloader-spinner">
        <i class="fa fa-spinner fa-spin"></i>
        <p>{$meta.lang['Loading...']}</p>
    </div>
</div>

{literal}
    <script>
        function btnLoading(btn) {
            if (!btn) return;
            btn.setAttribute('data-original-html', btn.innerHTML);
            btn.disabled = true;
            var icon = btn.querySelector('i, .fa, .fas, .far, .fab');
            if (icon) {
                icon.setAttribute('data-original-class', icon.className);
                icon.className = 'fa fa-spinner fa-spin';
            } else {
                btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> ' + btn.textContent;
            }
        }

        function btnReset(btn) {
            if (!btn) return;
            var original = btn.getAttribute('data-original-html');
            if (original) {
                btn.innerHTML = original;
                btn.removeAttribute('data-original-html');
            }
            btn.disabled = false;
        }

        function showNotification(message, type){
            if(typeof jQuery.growl !== 'undefined'){
                if(type === 'success'){
                    jQuery.growl.notice({message: message});
                } else {
                    jQuery.growl.error({message: message});
                }
            } else if(typeof $.gritter !== 'undefined'){
                $.gritter.add({title: type === 'error' ? '{/literal}{$meta.lang['Error']}{literal}' : '{/literal}{$meta.lang['Success']}{literal}', text: message, class_name: type === 'error' ? 'gritter-error' : 'gritter-success'});
            } else if(typeof toastr !== 'undefined'){
                toastr[type](message);
            } else {
                alert(message);
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            var navLinks = document.querySelectorAll('.nav-link-preloader');
            var preloader = document.getElementById('page-preloader');
            var contentArea = document.getElementById('contentarea');

            if (contentArea && preloader) {
                contentArea.insertBefore(preloader, contentArea.firstChild);
            }

            navLinks.forEach(function (link) {
                link.addEventListener('click', function (e) {
                    e.preventDefault();
                    if (preloader) {
                        preloader.style.display = 'flex';
                    }
                    setTimeout(function () {
                        window.location.href = link.getAttribute('href');
                    }, 100);
                });
            });

            window.addEventListener('load', function () {
                if (preloader) {
                    preloader.style.display = 'none';
                }
            });
        });
    </script>
{/literal}
