<style>
    .puq-filter-btn {
        display: flex;
        align-items: center;
        justify-content: space-between;
        min-height: 34px;
    }

    .puq-filter-btn .badge:empty {
        display: none;
    }
</style>
<div class="row">
    <div class="col-md-12">

        <div class="clearfix" style="margin-bottom:15px;">
            <h1 class="pull-left" style="margin:0;">
                <i class="fa fa-file-invoice"></i> {$meta.lang['KSeF Integration']}
            </h1>
        </div>

        <div class="panel panel-default">
            <div class="panel-body">

                <div id="puq-status-filter" class="btn-group" style="margin-bottom:15px;">
                    <button type="button" class="btn puq-filter-btn" data-status="">{$meta.lang['All']}</button>
                    <button type="button" class="btn puq-filter-btn" data-status="pending">
                        <span class="label label-default">{$meta.lang['Pending']}</span>
                        <span class="badge bg-secondary" id="puq-cnt-pending"></span>
                    </button>
                    <button type="button" class="btn puq-filter-btn" data-status="processing">
                        <span class="label label-info">{$meta.lang['Processing']}</span>
                        <span class="badge bg-secondary" id="puq-cnt-processing"></span>
                    </button>
                    <button type="button" class="btn puq-filter-btn" data-status="accepted">
                        <span class="label label-success">{$meta.lang['Accepted']}</span>
                    </button>
                    <button type="button" class="btn puq-filter-btn" data-status="rejected">
                        <span class="label label-danger">{$meta.lang['Rejected']}</span>
                        <span class="badge bg-secondary" id="puq-cnt-rejected"></span>
                    </button>
                    <button type="button" class="btn puq-filter-btn" data-status="error">
                        <span class="label label-danger">{$meta.lang['Error']}</span>
                        <span class="badge bg-secondary" id="puq-cnt-error"></span>
                    </button>
                </div>


                <table id="puq-inv-table" class="table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{$meta.lang['Invoice']}</th>
                        <th>{$meta.lang['Client']}</th>
                        <th>{$meta.lang['Status']}</th>
                        <th>{$meta.lang['KSeF Number / Error']}</th>
                        <th>{$meta.lang['Dates (Issue / KSeF)']}</th>
                        <th class="text-center">{$meta.lang['Actions']}</th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

{literal}
<script>
    (function () {
        const baseUrl = '{/literal}{$meta.admin_module_url}&ajax={literal}';
        const adminUrl = '{/literal}{$meta.admin_url}{literal}';

        function escHtml(str) {
            if (!str) return '';
            var div = document.createElement('div');
            div.appendChild(document.createTextNode(str));
            return div.innerHTML;
        }

        const lang = {
            accepted: '{/literal}{$meta.lang['Accepted']}{literal}',
            processing: '{/literal}{$meta.lang['Processing']}{literal}',
            pending: '{/literal}{$meta.lang['Pending']}{literal}',
            rejected: '{/literal}{$meta.lang['Rejected']}{literal}',
            error: '{/literal}{$meta.lang['Error']}{literal}',
            net: '{/literal}{$meta.lang['Net']}{literal}',
            tax: '{/literal}{$meta.lang['Tax']}{literal}',
            total: '{/literal}{$meta.lang['Total']}{literal}',
            rate: '{/literal}{$meta.lang['Rate']}{literal}',
            company: '{/literal}{$meta.lang['Company']}{literal}',
            person: '{/literal}{$meta.lang['Person']}{literal}',
            retry: '{/literal}{$meta.lang['Retry']}{literal}',
            unpaid: '{/literal}{$meta.lang['Unpaid']}{literal}',
            request_failed: '{/literal}{$meta.lang['Request failed']}{literal}',
            retry_failed: '{/literal}{$meta.lang['Retry failed']}{literal}',
            failed: '{/literal}{$meta.lang['Failed']}{literal}',
            failed_xml: '{/literal}{$meta.lang['Failed to load XML']}{literal}',
            confirm_unpaid: '{/literal}{$meta.lang['Confirm mark unpaid invoice']}{literal}',
            send_to_ksef: '{/literal}{$meta.lang['Send to KSeF']}{literal}',
            sending: '{/literal}{$meta.lang['Sending...']}{literal}',
            send_failed: '{/literal}{$meta.lang['Failed to send to KSeF']}{literal}',
            invoice_sent: '{/literal}{$meta.lang['Invoice sent to KSeF']}{literal}',
            confirm_send_ksef: '{/literal}{$meta.lang['Confirm send to KSeF from list']}{literal}',
            failed_upo: '{/literal}{$meta.lang['Failed to download UPO']}{literal}'
        };

        function statusLabel(status) {
            var map = {
                'accepted': '<span class="label label-success">' + lang.accepted + '</span>',
                'processing': '<span class="label label-info">' + lang.processing + '</span>',
                'pending': '<span class="label label-default">' + lang.pending + '</span>',
                'rejected': '<span class="label label-danger">' + lang.rejected + '</span>',
                'error': '<span class="label label-danger">' + lang.error + '</span>'
            };
            return map[status] || '<span class="label label-default">' + escHtml(status) + '</span>';
        }

        function formatXml(xml) {
            var formatted = '';
            var reg = /(>)(<)(\/*)/g;
            xml = xml.replace(reg, '$1\r\n$2$3');
            var pad = 0;
            xml.split('\r\n').forEach(function (node) {
                var indent = 0;
                if (node.match(/^<\/\w/)) {
                    if (pad !== 0) pad -= 1;
                } else if (node.match(/^<\w([^>]*[^\/])?>.*$/)) {
                    indent = 1;
                }
                formatted += '  '.repeat(pad) + node + '\r\n';
                pad += indent;
            });
            return formatted.trim();
        }

        function loadStats() {
            $.getJSON(baseUrl + 'getInvoiceStats', function (res) {
                if (!res.success) return;
                var d = res.data;
                $('#puq-cnt-pending').text(d.pending || '');
                $('#puq-cnt-processing').text(d.processing || '');
                $('#puq-cnt-rejected').text(d.rejected || '');
                $('#puq-cnt-error').text(d.error || '');
            });
        }

        $(document).ready(function () {

            // Multi-select status filter: restore from localStorage
            var saved = localStorage.getItem('puq_ksef_status_filter') || '';
            var currentFilters = saved ? saved.split(',') : [];

            function updateFilterButtons() {
                $('#puq-status-filter .puq-filter-btn').each(function () {
                    var btnStatus = $(this).attr('data-status');
                    if (btnStatus === '') {
                        $(this).toggleClass('btn-primary', currentFilters.length === 0);
                        $(this).toggleClass('btn-default', currentFilters.length > 0);
                    } else {
                        var active = currentFilters.indexOf(btnStatus) >= 0;
                        $(this).toggleClass('btn-primary', active);
                        $(this).toggleClass('btn-default', !active);
                    }
                });
            }

            updateFilterButtons();
            loadStats();

            var invTable = $('#puq-inv-table').DataTable({
                serverSide: true,
                processing: true,
                ajax: {
                    url: baseUrl + 'getInvoices',
                    data: function (d) {
                        d.status = currentFilters.join(',');
                    }
                },
                order: [[0, 'desc']],
                language: {
                    processing: '<i class="fa fa-spinner fa-spin fa-2x"></i>'
                },
                columns: [
                    {data: 'id', width: '50px'},
                    {
                        data: null,
                        render: function (d) {
                            var url = adminUrl + 'billing/invoice/' + d.invoice_id;
                            var html = '<a href="' + url + '" target="_blank"><strong>'
                                + escHtml(d.invoice_number || '—') + '</strong></a>';

                            html += '<br><small class="fw-bold text-dark">'
                                + lang.net + ': ' + parseFloat(d.total_net).toFixed(2)
                                + '  ' + lang.tax + ': ' + parseFloat(d.total_tax).toFixed(2)
                                + ' (' + parseFloat(d.tax_rate).toFixed(0) + '%)'
                                + '  ' + lang.total + ': ' + parseFloat(d.total_gross).toFixed(2)
                                + ' ' + escHtml(d.currency_code) + '</small>';

                            if (d.currency_code !== 'PLN' && d.currency_rate) {
                                html += '<br><small class="text-muted">' + lang.rate + ': 1 '
                                    + escHtml(d.currency_code) + ' = '
                                    + parseFloat(d.currency_rate).toFixed(4) + ' PLN</small>';
                            }

                            return html;
                        }
                    },
                    {
                        data: 'buyer_type',
                        render: function (d) {
                            return d === 'company' ? lang.company : lang.person;
                        }
                    },
                    {
                        data: 'ksef_status',
                        className: 'text-center',
                        render: function (d) {
                            return statusLabel(d);
                        }
                    },
                    {
                        data: null,
                        render: function (d) {
                            if (d.ksef_status === 'rejected' || d.ksef_status === 'error') {
                                return '<span class="text-danger">' + escHtml(d.ksef_error_description || '') + '</span>';
                            }
                            if (d.ksef_status === 'accepted' && d.ksef_number) {
                                return '<span class="text-success"><i class="fa fa-check-circle"></i> ' + escHtml(d.ksef_number) + '</span>';
                            }
                            return escHtml(d.ksef_number || d.ksef_reference || '—');
                        }
                    },
                    {
                        data: null,
                        render: function (d) {
                            var html = '';
                            if (d.issue_date) html += '<small>' + escHtml(d.issue_date) + '</small>';
                            if (d.accepted_by_ksef_at) html += '<br><small>KSeF: ' + escHtml(d.accepted_by_ksef_at) + '</small>';
                            return html || '<span class="text-muted">—</span>';
                        }
                    },
                    {
                        data: null,
                        orderable: false,
                        className: 'text-center',
                        render: function (d) {
                            var btns = '';
                            var canSend = d.has_xml && (
                                d.ksef_status === 'pending'
                                || d.ksef_status === 'rejected'
                                || (d.ksef_status === 'error' && d.ksef_code)
                            );
                            if (canSend) {
                                btns += '<button class="btn btn-primary btn-sm puq-send-ksef" data-id="' + d.id + '">'
                                    + '<i class="fa fa-paper-plane"></i> ' + lang.send_to_ksef + '</button> ';
                            }
                            if (d.has_upo) {
                                btns += '<button class="btn btn-info btn-sm puq-download-upo" data-id="' + d.id + '" data-ksef-number="' + escHtml(d.ksef_number) + '">'
                                    + '<i class="fa fa-certificate"></i> UPO</button> ';
                            }
                            if (d.has_xml) {
                                btns += '<button class="btn btn-success btn-sm puq-download-xml" data-id="' + d.id + '">'
                                    + '<i class="fa fa-download"></i> XML</button> ';
                            }
                            if (d.ksef_status === 'error' || d.ksef_status === 'rejected') {
                                btns += '<button class="btn btn-warning btn-sm puq-retry-invoice" data-id="' + d.id + '">'
                                    + '<i class="fa fa-refresh"></i> ' + lang.retry + '</button> ';
                            }
                            if (d.ksef_status === 'error' || d.ksef_status === 'rejected' || d.ksef_status === 'pending') {
                                btns += '<button class="btn btn-danger btn-sm puq-mark-unpaid" data-id="' + d.id + '">'
                                    + '<i class="fa fa-undo"></i> ' + lang.unpaid + '</button>';
                            }
                            return btns || '<span class="text-muted">—</span>';
                        }
                    }
                ]
            });

            // Multi-select status filter click
            $('#puq-status-filter').on('click', '.puq-filter-btn', function () {
                var btnStatus = $(this).attr('data-status');

                if (btnStatus === '') {
                    currentFilters = [];
                } else {
                    var idx = currentFilters.indexOf(btnStatus);
                    if (idx >= 0) {
                        currentFilters.splice(idx, 1);
                    } else {
                        currentFilters.push(btnStatus);
                    }
                }

                localStorage.setItem('puq_ksef_status_filter', currentFilters.join(','));
                updateFilterButtons();
                invTable.ajax.reload();
            });

            // Download XML via separate AJAX
            $('#puq-inv-table tbody').on('click', '.puq-download-xml', function (e) {
                e.stopPropagation();
                var btn = $(this);
                var d = invTable.row(btn.closest('tr')).data();
                if (!d) return;

                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i>');

                $.ajax({
                    url: baseUrl + 'getInvoiceXml&id=' + d.id,
                    method: 'GET',
                    dataType: 'json',
                    success: function (resp) {
                        if (resp.success && resp.xml) {
                            var formattedXml = formatXml(resp.xml);
                            var blob = new Blob([formattedXml], {type: 'application/xml;charset=utf-8'});
                            var filename = (d.invoice_number || 'invoice_' + d.id).replace(/[^a-zA-Z0-9._-]/g, '_') + '.xml';

                            var link = document.createElement('a');
                            var url = URL.createObjectURL(blob);
                            link.href = url;
                            link.download = filename;
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link);
                            URL.revokeObjectURL(url);
                        } else {
                            alert(resp.error || lang.failed_xml);
                        }
                        btn.prop('disabled', false).html('<i class="fa fa-download"></i> XML');
                    },
                    error: function () {
                        alert(lang.request_failed);
                        btn.prop('disabled', false).html('<i class="fa fa-download"></i> XML');
                    }
                });
            });

            // Download UPO
            $('#puq-inv-table tbody').on('click', '.puq-download-upo', function (e) {
                e.stopPropagation();
                var btn = $(this);
                var d = invTable.row(btn.closest('tr')).data();
                if (!d) return;

                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i>');

                $.ajax({
                    url: baseUrl + 'downloadUpo&id=' + d.id,
                    method: 'GET',
                    dataType: 'json',
                    timeout: 120000,
                    success: function (resp) {
                        if (resp.success && resp.upo) {
                            var formattedXml = formatXml(resp.upo);
                            var blob = new Blob([formattedXml], {type: 'application/xml;charset=utf-8'});
                            var filename = 'UPO_' + (d.ksef_number || d.invoice_number || 'invoice_' + d.id).replace(/[^a-zA-Z0-9._-]/g, '_') + '.xml';

                            var link = document.createElement('a');
                            var url = URL.createObjectURL(blob);
                            link.href = url;
                            link.download = filename;
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link);
                            URL.revokeObjectURL(url);
                        } else {
                            alert(resp.error || lang.failed_upo);
                        }
                        btn.prop('disabled', false).html('<i class="fa fa-certificate"></i> UPO');
                    },
                    error: function () {
                        alert(lang.request_failed);
                        btn.prop('disabled', false).html('<i class="fa fa-certificate"></i> UPO');
                    }
                });
            });

            // Mark Unpaid
            $('#puq-inv-table tbody').on('click', '.puq-mark-unpaid', function (e) {
                e.stopPropagation();
                var btn = $(this);
                var d = invTable.row(btn.closest('tr')).data();
                if (!d) return;

                if (!confirm(lang.confirm_unpaid.replace('%s', d.invoice_number || '#' + d.invoice_id))) return;

                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i>');

                $.ajax({
                    url: baseUrl + 'markUnpaid',
                    method: 'POST',
                    data: {id: d.id},
                    dataType: 'json',
                    success: function (resp) {
                        if (resp.success && resp.invoice_id) {
                            window.location.href = adminUrl + 'billing/invoice/' + resp.invoice_id;
                        } else {
                            alert(resp.error || lang.failed);
                            btn.prop('disabled', false).html('<i class="fa fa-undo"></i> ' + lang.unpaid);
                        }
                    },
                    error: function () {
                        alert(lang.request_failed);
                        btn.prop('disabled', false).html('<i class="fa fa-undo"></i> ' + lang.unpaid);
                    }
                });
            });

            // Send to KSeF
            $('#puq-inv-table tbody').on('click', '.puq-send-ksef', function (e) {
                e.stopPropagation();
                var btn = $(this);
                var d = invTable.row(btn.closest('tr')).data();
                if (!d) return;

                var msg = lang.confirm_send_ksef.replace('%s', d.invoice_number || '#' + d.invoice_id);
                if (!confirm(msg)) return;

                var row = btn.closest('tr');
                row.find('button').prop('disabled', true);
                btn.html('<i class="fa fa-spinner fa-spin"></i> ' + lang.sending);

                $.ajax({
                    url: baseUrl + 'sendInvoiceNow',
                    method: 'POST',
                    data: {id: d.id},
                    dataType: 'json',
                    timeout: 120000,
                    success: function (resp) {
                        invTable.ajax.reload(null, false);
                        loadStats();
                        if (!resp.success) {
                            alert(resp.error || lang.send_failed);
                        }
                    },
                    error: function () {
                        alert(lang.request_failed);
                        invTable.ajax.reload(null, false);
                        loadStats();
                    }
                });
            });

            // Retry Invoice
            $('#puq-inv-table tbody').on('click', '.puq-retry-invoice', function (e) {
                e.stopPropagation();
                var btn = $(this);
                var d = invTable.row(btn.closest('tr')).data();
                if (!d) return;

                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ' + lang.retry + '...');

                $.ajax({
                    url: baseUrl + 'retryInvoice',
                    method: 'POST',
                    data: {id: d.id},
                    dataType: 'json',
                    success: function (resp) {
                        if (resp.success) {
                            invTable.ajax.reload(null, false);
                            loadStats();
                        } else {
                            alert(resp.error || lang.retry_failed);
                            btn.prop('disabled', false).html('<i class="fa fa-refresh"></i> ' + lang.retry);
                        }
                    },
                    error: function () {
                        alert(lang.request_failed);
                        btn.prop('disabled', false).html('<i class="fa fa-refresh"></i> ' + lang.retry);
                    }
                });
            });

        });
    })();
</script>
{/literal}
