<div class="row">
    <div class="col-md-12">
        <div class="clearfix" style="margin-bottom:20px;">
            <h1 class="pull-left" style="margin:0;">
                <i class="fa fa-home"></i> {$meta.lang['Home']}
            </h1>
            <div class="pull-right">
                <button type="button" class="btn btn-primary" id="puq-test-connection">
                    <i class="fa fa-plug"></i> {$meta.lang['Test Connection']}
                </button>
            </div>
        </div>

        <!-- Test Result Container -->
        <div id="puq-test-result" style="display:none; margin-bottom:20px;">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        <i class="fa fa-flask"></i> {$meta.lang['Connection Test Results']}
                    </h3>
                </div>
                <div class="panel-body">
                    <!-- Status Badge -->
                    <div id="puq-test-status" style="margin-bottom:20px;"></div>

                    <!-- Steps Log -->
                    <div class="panel panel-info">
                        <div class="panel-heading">
                            <h4 class="panel-title">{$meta.lang['Process Steps']}</h4>
                        </div>
                        <div class="panel-body">
                            <div id="puq-test-steps" style="font-family: monospace; white-space: pre-wrap; word-wrap: break-word; line-height: 1.8;"></div>
                        </div>
                    </div>

                    <!-- Debug Info -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title"><i class="fa fa-bug"></i> {$meta.lang['Debug Information']}</h4>
                        </div>
                        <div class="panel-body">
                            <div id="puq-test-debug" style="font-size: 12px; color: #666; background: #f5f5f5; padding: 10px; border-radius: 4px; font-family: monospace; max-height: 300px; overflow-y: auto;"></div>
                        </div>
                    </div>

                    <!-- Errors -->
                    <div id="puq-test-errors-panel" style="display:none;">
                        <div class="panel panel-danger">
                            <div class="panel-heading">
                                <h4 class="panel-title"><i class="fa fa-exclamation-triangle"></i> {$meta.lang['Errors']}</h4>
                            </div>
                            <div class="panel-body">
                                <div id="puq-test-errors" style="color: #a94442;"></div>
                            </div>
                        </div>
                    </div>

                    <!-- Warnings -->
                    <div id="puq-test-warnings-panel" style="display:none;">
                        <div class="panel panel-warning">
                            <div class="panel-heading">
                                <h4 class="panel-title"><i class="fa fa-warning"></i> {$meta.lang['Warnings']}</h4>
                            </div>
                            <div class="panel-body">
                                <div id="puq-test-warnings" style="color: #8a6d3b;"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loading Spinner -->
        <div id="puq-test-loading" style="display:none; text-align: center; margin:40px 0;">
            <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
            <div style="margin-top:15px; font-size:16px;">{$meta.lang['Testing connection...']}</div>
        </div>

        <!-- Invoice Statistics Widget -->
        <div id="puq-stats-widget" style="margin-bottom:20px;">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="fa fa-bar-chart"></i> {$meta.lang['Invoice Statistics']}</h3>
                </div>
                <div class="panel-body" style="padding:0;">
                    <div class="row text-center" id="puq-stats-row" style="margin:0;">
                        <div class="col-xs-2" style="padding:20px 10px; border-right:1px solid #eee;">
                            <div style="font-size:28px; font-weight:700;" id="puq-home-total"><i class="fa fa-spinner fa-spin text-muted"></i></div>
                            <div class="text-muted" style="font-size:12px; text-transform:uppercase; margin-top:4px;">{$meta.lang['Total2']}</div>
                        </div>
                        <div class="col-xs-2" style="padding:20px 10px; border-right:1px solid #eee;">
                            <div style="font-size:28px; font-weight:700; color:#777;" id="puq-home-pending">—</div>
                            <div class="text-muted" style="font-size:12px; text-transform:uppercase; margin-top:4px;">{$meta.lang['Pending']}</div>
                        </div>
                        <div class="col-xs-2" style="padding:20px 10px; border-right:1px solid #eee;">
                            <div style="font-size:28px; font-weight:700; color:#31b0d5;" id="puq-home-processing">—</div>
                            <div class="text-muted" style="font-size:12px; text-transform:uppercase; margin-top:4px;">{$meta.lang['Processing']}</div>
                        </div>
                        <div class="col-xs-2" style="padding:20px 10px; border-right:1px solid #eee;">
                            <div style="font-size:28px; font-weight:700; color:#449d44;" id="puq-home-accepted">—</div>
                            <div class="text-muted" style="font-size:12px; text-transform:uppercase; margin-top:4px;">{$meta.lang['Accepted']}</div>
                        </div>
                        <div class="col-xs-2" style="padding:20px 10px; border-right:1px solid #eee;">
                            <div style="font-size:28px; font-weight:700; color:#c9302c;" id="puq-home-rejected">—</div>
                            <div class="text-muted" style="font-size:12px; text-transform:uppercase; margin-top:4px;">{$meta.lang['Rejected']}</div>
                        </div>
                        <div class="col-xs-2" style="padding:20px 10px;">
                            <div style="font-size:28px; font-weight:700; color:#c9302c;" id="puq-home-error">—</div>
                            <div class="text-muted" style="font-size:12px; text-transform:uppercase; margin-top:4px;">{$meta.lang['Error']}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Welcome Info -->
        <div id="puq-welcome-info">
            <div class="alert alert-info">
                <h4><i class="fa fa-info-circle"></i> {$meta.lang['Welcome']}</h4>
                <p>{$meta.lang['KSeF Integration Module']} - {$meta.lang['Test your connection to KSeF server']}</p>
                <p>
                    <strong>{$meta.lang['Quick Start']}:</strong>
                    <ul style="margin-top:10px;">
                        <li>{$meta.lang['Go to Settings → Configuration']}</li>
                        <li>{$meta.lang['Configure your company data']}</li>
                        <li>{$meta.lang['Upload certificates in Settings → Certificates']}</li>
                        <li>{$meta.lang['Test connection using button above']}</li>
                    </ul>
                </p>
            </div>
        </div>
    </div>
</div>

{literal}
<script>
(function(){
    const baseUrl = '{/literal}{$meta.admin_module_url}&ajax={literal}';
    const lang = {
        testing: '{/literal}{$meta.lang['Testing connection...']}{literal}',
        success: '{/literal}{$meta.lang['Connection successful']}{literal}',
        failed: '{/literal}{$meta.lang['Connection failed']}{literal}',
    };

    // Load invoice statistics
    $.getJSON(baseUrl + 'getInvoiceStats', function(res) {
        if (!res.success) return;
        var d = res.data;
        $('#puq-home-total').text(d.total);
        $('#puq-home-pending').text(d.pending);
        $('#puq-home-processing').text(d.processing);
        $('#puq-home-accepted').text(d.accepted);
        $('#puq-home-rejected').text(d.rejected);
        $('#puq-home-error').text(d.error);
    }).fail(function() {
        $('#puq-home-total').text('?');
    });

    $('#puq-test-connection').click(function() {
        const btn = $(this);
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ' + lang.testing);
        $('#puq-welcome-info').hide();
        $('#puq-test-result').hide();
        $('#puq-test-loading').show();

        $.getJSON(baseUrl + 'testConnection', function(res) {
            $('#puq-test-loading').hide();

            if (!res.success) {
                showNotification(res.error || lang.failed, 'error');
                btn.prop('disabled', false).html('<i class="fa fa-plug"></i> Test Connection');
                return;
            }

            const data = res.data;

            // Status badge
            const statusHtml = data.success
                ? '<div class="alert alert-success"><strong>✅ ' + lang.success + '</strong></div>'
                : '<div class="alert alert-danger"><strong>❌ ' + lang.failed + '</strong></div>';
            $('#puq-test-status').html(statusHtml);

            // Steps
            if (data.steps && data.steps.length > 0) {
                $('#puq-test-steps').text(data.steps.join('\n'));
            }

            // Debug info
            if (data.debug && data.debug.length > 0) {
                const debugHtml = data.debug.map(line => '• ' + line).join('\n');
                $('#puq-test-debug').text(debugHtml);
            }

            // Errors
            if (data.errors && data.errors.length > 0) {
                const errorHtml = data.errors.map(err => '<div style="margin:5px 0;">❌ ' + err + '</div>').join('');
                $('#puq-test-errors').html(errorHtml);
                $('#puq-test-errors-panel').show();
            }

            // Warnings
            if (data.warnings && data.warnings.length > 0) {
                const warningHtml = data.warnings.map(warn => '<div style="margin:5px 0;">⚠️ ' + warn + '</div>').join('');
                $('#puq-test-warnings').html(warningHtml);
                $('#puq-test-warnings-panel').show();
            }

            $('#puq-test-result').show();
            btn.prop('disabled', false).html('<i class="fa fa-plug"></i> Test Connection');
        }).fail(function(xhr) {
            $('#puq-test-loading').hide();
            const msg = xhr.status + ': ' + (xhr.statusText || 'Unknown error');
            showNotification(msg, 'error');
            btn.prop('disabled', false).html('<i class="fa fa-plug"></i> Test Connection');
        });
    });
})();
</script>
{/literal}