<div class="row">
    <div class="col-md-12">

        <div class="clearfix" style="margin-bottom:15px;">
            <h1 class="pull-left" style="margin:0;">
                <i class="fa fa-shield"></i> {$meta.lang['Certificates']}
            </h1>

            <div class="pull-right">
                <button class="btn btn-success" id="puq-add-cert">
                    <i class="fa fa-plus"></i> {$meta.lang['Add Certificate']}
                </button>
            </div>
        </div>


        <div class="panel panel-default">
            <div class="panel-body">
                <table id="puq-cert-table" class="table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th>{$meta.lang['ID']}</th>
                        <th>{$meta.lang['Name']}</th>
                        <th>{$meta.lang['Type']}</th>
                        <th>{$meta.lang['Issuer']}</th>
                        <th>{$meta.lang['Subject']}</th>
                        <th>{$meta.lang['Valid From']}</th>
                        <th>{$meta.lang['Valid To']}</th>
                        <th>{$meta.lang['Expired']}</th>
                        <th class="text-center">{$meta.lang['Actions']}</th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="puq-cert-modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form id="puq-cert-form">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">{$meta.lang['Add Certificate']}</h4>
                </div>
                <div class="modal-body" style="position: relative;">
                    <input type="hidden" name="id" value="">

                    <div class="form-group">
                        <label class="control-label">{$meta.lang['Name']} <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="control-label">{$meta.lang['Type']}</label>
                        <select name="type" class="form-control">
                            <option value="test">{$meta.lang['Test']}</option>
                            <option value="prod" selected>{$meta.lang['Production']}</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="control-label">{$meta.lang['Certificate PEM']} <span class="text-danger">*</span></label>
                        <textarea name="cert_pem" class="form-control" rows="6" required style="font-family: monospace; font-size: 12px;"></textarea>
                    </div>

                    <div class="form-group">
                        <label class="control-label">{$meta.lang['Key PEM']} <span class="text-danger">*</span></label>
                        <textarea name="key_pem" class="form-control" rows="6" required style="font-family: monospace; font-size: 12px;"></textarea>
                    </div>

                    <div class="form-group">
                        <label class="control-label">{$meta.lang['Key Password']}</label>
                        <input type="password" name="key_password" class="form-control">
                        <small class="text-muted">{$meta.lang['Optional']}</small>
                    </div>

                    <div class="overlay" id="puq-loading-overlay" style="display:none;position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.9);z-index:9999;border-radius:4px;">
                        <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);text-align:center;">
                            <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
                            <div style="margin-top:10px;font-size:16px;">{$meta.lang['Saving...']}</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal" id="puq-close-btn">
                        <i class="fa fa-times"></i> {$meta.lang['Close']}
                    </button>
                    <button type="submit" class="btn btn-primary" id="puq-save-btn">
                        <i class="fa fa-save"></i> {$meta.lang['Save Certificate']}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="puq-delete-modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-exclamation-triangle text-danger"></i> {$meta.lang['Delete Certificate']}
                </h4>
            </div>
            <div class="modal-body" style="position: relative;">
                <div class="alert alert-danger">
                    <strong>{$meta.lang['Warning!']}</strong> {$meta.lang['Are you sure you want to delete this certificate?']}
                </div>
                <p class="text-center">
                    <strong style="font-size:16px;" id="puq-delete-cert-name"></strong>
                </p>

                <div class="overlay" id="puq-delete-overlay" style="display:none;position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.9);z-index:9999;border-radius:4px;">
                    <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);text-align:center;">
                        <i class="fa fa-spinner fa-spin fa-3x text-danger"></i>
                        <div style="margin-top:10px;font-size:16px;">{$meta.lang['Deleting...']}</div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" id="puq-cancel-delete">
                    <i class="fa fa-times"></i> {$meta.lang['Cancel']}
                </button>
                <button type="button" class="btn btn-danger" id="puq-confirm-delete">
                    <i class="fa fa-trash"></i> {$meta.lang['Delete']}
                </button>
            </div>
        </div>
    </div>
</div>

{literal}
<script>
    (function(){
        const baseUrl = '{/literal}{$meta.admin_module_url}&ajax={literal}';
        const lang = {
            prod: '{/literal}{$meta.lang['PROD']}{literal}',
            test: '{/literal}{$meta.lang['TEST']}{literal}',
            expired: '{/literal}{$meta.lang['Expired']}{literal}',
            valid: '{/literal}{$meta.lang['Valid']}{literal}',
            certificate_not_found: '{/literal}{$meta.lang['Certificate not found']}{literal}',
            certificate_saved: '{/literal}{$meta.lang['Certificate saved successfully']}{literal}',
            certificate_deleted: '{/literal}{$meta.lang['Certificate deleted successfully']}{literal}',
            error_saving: '{/literal}{$meta.lang['Error saving certificate']}{literal}',
            error_deleting: '{/literal}{$meta.lang['Error deleting certificate']}{literal}',
            invalid_response: '{/literal}{$meta.lang['Invalid server response']}{literal}',
            server_error: '{/literal}{$meta.lang['Server error']}{literal}'
        };

        $(document).ready(function(){
            var certTable = $('#puq-cert-table').DataTable({
                ajax: baseUrl + 'getCertificates',
                order:[[0,'desc']],
                processing: true,
                language: {
                    processing: '<i class="fa fa-spinner fa-spin fa-2x"></i>'
                },
                columns:[
                    {data:'id', width: '50px'},
                    {data:'name'},
                    {data:'type', width: '80px', className: 'text-center', render:function(d){
                            return d==='prod'?'<span class="label label-success">{/literal}{$meta.lang['Production']}{literal}</span>':'<span class="label label-info">{/literal}{$meta.lang['Test']}{literal}</span>';
                        }},
                    {data:'issuer', defaultContent:'<span class="text-muted">—</span>'},
                    {data:'subject', defaultContent:'<span class="text-muted">—</span>'},
                    {data:'valid_from', defaultContent:'<span class="text-muted">—</span>'},
                    {data:'valid_to', defaultContent:'<span class="text-muted">—</span>'},
                    {data:'expired', width: '80px', className: 'text-center', render:function(d){
                            return d==='Yes'?'<span class="label label-danger">'+lang.expired+'</span>':d==='No'?'<span class="label label-success">'+lang.valid+'</span>':'<span class="label label-warning">'+d+'</span>';
                        }},
                    {data:null, width: '120px', className: 'text-center', orderable: false, render:function(d){
                            return '<div class="btn-group btn-group-sm">' +
                                '<button class="btn btn-danger puq-delete" data-id="'+d.id+'" data-name="'+d.name+'" title="Delete"><i class="fa fa-trash"></i></button>' +
                                '</div>';
                        }}
                ]
            });

            $('#puq-add-cert').click(function(){
                $('#puq-cert-form')[0].reset();
                $('#puq-cert-form input[name=id]').val('');
                $('#puq-cert-modal').modal('show');
            });

            $('#puq-cert-table').on('click','.puq-edit',function(){
                var id = $(this).data('id');
                $.getJSON(baseUrl + 'getCertificate&id=' + id, function(res){
                    if(res && res.certificate){
                        var form = $('#puq-cert-form');
                        form.find('[name=id]').val(res.certificate.id);
                        form.find('[name=name]').val(res.certificate.name);
                        form.find('[name=type]').val(res.certificate.type);
                        form.find('[name=cert_pem]').val(res.certificate.cert_pem);
                        form.find('[name=key_pem]').val(res.certificate.key_pem);
                        form.find('[name=key_password]').val(res.certificate.key_password);
                        form.find('[name=valid_from]').val(res.certificate.valid_from || '');
                        form.find('[name=valid_to]').val(res.certificate.valid_to || '');
                        $('#puq-cert-modal').modal('show');
                    } else {
                        showNotification(lang.certificate_not_found, 'error');
                    }
                });
            });

            var deleteId = null;

            $('#puq-cert-table').on('click','.puq-delete',function(){
                deleteId = $(this).data('id');
                var name = $(this).data('name');
                $('#puq-delete-cert-name').text(name);
                $('#puq-delete-modal').modal('show');
            });

            $('#puq-confirm-delete').click(function(){
                if(!deleteId) return;

                var overlay = $('#puq-delete-overlay');
                var confirmBtn = $('#puq-confirm-delete');
                var cancelBtn = $('#puq-cancel-delete');

                overlay.show();
                confirmBtn.prop('disabled', true);
                cancelBtn.prop('disabled', true);

                $.ajax({
                    url: baseUrl + 'deleteCertificate',
                    type: 'POST',
                    data: {id: deleteId},
                    dataType: 'json',
                    success: function(res){
                        overlay.hide();
                        confirmBtn.prop('disabled', false);
                        cancelBtn.prop('disabled', false);

                        if(res && res.success){
                            $('#puq-delete-modal').modal('hide');
                            showNotification(res.message || lang.certificate_deleted, 'success');
                            certTable.ajax.reload(null, false);
                            deleteId = null;
                        } else {
                            showNotification(res.error || res.message || lang.error_deleting, 'error');
                        }
                    },
                    error: function(xhr){
                        overlay.hide();
                        confirmBtn.prop('disabled', false);
                        cancelBtn.prop('disabled', false);

                        var errorMsg = lang.server_error + ': ' + xhr.status;
                        try {
                            var response = JSON.parse(xhr.responseText);
                            if(response && response.error){
                                errorMsg = response.error;
                            }
                        } catch(e){}

                        showNotification(errorMsg, 'error');
                    }
                });
            });

            $('#puq-cert-form').submit(function(e){
                e.preventDefault();

                var form = $(this);
                var formData = form.serializeArray();
                var modal = $('#puq-cert-modal');
                var overlay = $('#puq-loading-overlay');
                var saveBtn = $('#puq-save-btn');
                var closeBtn = $('#puq-close-btn');
                var inputs = form.find('input:not([type=submit]), textarea, select, button');

                overlay.show();
                saveBtn.prop('disabled', true);
                closeBtn.prop('disabled', true);
                inputs.prop('readonly', true);

                $.ajax({
                    url: baseUrl + 'saveCertificate',
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(res){
                        overlay.hide();
                        saveBtn.prop('disabled', false);
                        closeBtn.prop('disabled', false);
                        inputs.prop('readonly', false);

                        if(res && res.success){
                            modal.modal('hide');
                            showNotification(res.message || lang.certificate_saved, 'success');
                            certTable.ajax.reload(null, false);
                        } else {
                            showNotification(res.error || res.message || lang.error_saving, 'error');
                        }
                    },
                    error: function(xhr){
                        overlay.hide();
                        saveBtn.prop('disabled', false);
                        closeBtn.prop('disabled', false);
                        inputs.prop('readonly', false);

                        var errorMsg = lang.server_error + ': ' + xhr.status;
                        try {
                            var response = JSON.parse(xhr.responseText);
                            if(response && response.error){
                                errorMsg = response.error;
                            }
                        } catch(e){}

                        showNotification(errorMsg, 'error');
                    }
                });
            });
        });
    })();
</script>
{/literal}