<div class="panel panel-default" id="puq-ksef-panel-inner">
    <div class="panel-heading">
        <div style="display:flex; align-items:center; justify-content:space-between;">
            <span>
                <i class="fas fa-file-invoice"></i>
                <strong>PUQ KSeF Integrator</strong>
            </span>
            <button type="button" class="btn btn-xs btn-default" onclick="window.puqKsefReloadPanel()" title="{$meta.lang['Reload']}">
                <i class="fas fa-sync-alt"></i> {$meta.lang['Reload']}
            </button>
        </div>
    </div>
    <div class="panel-body" style="height: 100%; overflow: auto;">
        {if $has_ksef}
            <div class="row">
                <div class="col-sm-2">
                    <div class="form-group" style="margin-bottom:0;">
                        <label>{$meta.lang['KSeF Status']}</label><br>
                        {if $ksef.ksef_status == 'accepted'}
                            <span class="label label-success"><i class="fas fa-check"></i> {$meta.lang['Accepted']}</span>
                        {elseif $ksef.ksef_status == 'processing'}
                            <span class="label label-info"><i class="fas fa-spinner fa-spin"></i> {$meta.lang['Processing']}</span>
                        {elseif $ksef.ksef_status == 'pending'}
                            <span class="label label-default"><i class="fas fa-clock"></i> {$meta.lang['Pending']}</span>
                        {elseif $ksef.ksef_status == 'rejected'}
                            <span class="label label-danger"><i class="fas fa-times"></i> {$meta.lang['Rejected']}</span>
                        {elseif $ksef.ksef_status == 'error'}
                            <span class="label label-danger"><i class="fas fa-exclamation-triangle"></i> {$meta.lang['Error']}</span>
                        {else}
                            <span class="label label-default">{$ksef.ksef_status}</span>
                        {/if}
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group" style="margin-bottom:0;">
                        <label>{$meta.lang['KSeF Number']}</label><br>
                        {if $ksef.ksef_number}
                            <code class="text-success"><strong>{$ksef.ksef_number}</strong></code>
                        {else}
                            <span class="text-muted">&mdash;</span>
                        {/if}
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group" style="margin-bottom:0;">
                        <label>{$meta.lang['Sent to KSeF']}</label><br>
                        {if $ksef.sent_to_ksef_at}
                            <small>{$ksef.sent_to_ksef_at}</small>
                        {else}
                            <span class="text-muted">&mdash;</span>
                        {/if}
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group" style="margin-bottom:0;">
                        <label>{$meta.lang['Accepted by KSeF']}</label><br>
                        {if $ksef.accepted_by_ksef_at}
                            <small>{$ksef.accepted_by_ksef_at}</small>
                        {else}
                            <span class="text-muted">&mdash;</span>
                        {/if}
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group" style="margin-bottom:0;">
                        <label>{$meta.lang['Currency']}</label><br>
                        <span>{$ksef.currency_code}</span>
                        {if $ksef.currency_code != 'PLN' && $ksef.currency_rate}
                            <br><small class="text-muted">{$meta.lang['Rate']}: 1 {$ksef.currency_code} = {$ksef.currency_rate} PLN</small>
                        {/if}
                    </div>
                </div>
            </div>

            {if $ksef.ksef_status == 'accepted' && $ksef.ksef_reference}
                <div class="row" style="margin-top:8px;">
                    <div class="col-sm-5">
                        <div class="form-group" style="margin-bottom:0;">
                            <label>{$meta.lang['KSeF Reference']}</label><br>
                            <small class="text-muted">{$ksef.ksef_reference}</small>
                        </div>
                    </div>
                    {if $ksef.ksef_invoice_hash}
                        <div class="col-sm-4">
                            <div class="form-group" style="margin-bottom:0;">
                                <label>{$meta.lang['Invoice Hash']}</label><br>
                                <small class="text-muted" style="word-break:break-all;">{$ksef.ksef_invoice_hash}</small>
                            </div>
                        </div>
                    {/if}
                    {if $ksef.ksef_invoicing_date}
                        <div class="col-sm-3">
                            <div class="form-group" style="margin-bottom:0;">
                                <label>{$meta.lang['KSeF Invoicing Date']}</label><br>
                                <small>{$ksef.ksef_invoicing_date}</small>
                            </div>
                        </div>
                    {/if}
                </div>
            {/if}

            {if $ksef.ksef_error_description}
                <div class="alert alert-danger" style="margin-top:10px; margin-bottom:10px;">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>{$meta.lang['Error']}:</strong> {$ksef.ksef_error_description|escape:'html'}
                </div>
            {/if}

            <div style="margin-top:10px;">
                {if $ksef.invoice_xml && ($ksef.ksef_status == 'pending' || $ksef.ksef_status == 'rejected' || ($ksef.ksef_status == 'error' && $ksef.ksef_code))}
                    <button type="button" class="btn btn-sm btn-primary puq-ksef-btn-send-now" data-id="{$ksef.id}">
                        <i class="fas fa-paper-plane"></i> {$meta.lang['Send to KSeF']}
                    </button>
                {/if}
                {if $ksef.ksef_status == 'error' || $ksef.ksef_status == 'rejected'}
                    <button type="button" class="btn btn-sm btn-warning puq-ksef-btn-retry" data-id="{$ksef.id}">
                        <i class="fas fa-redo"></i> {$meta.lang['Retry']}
                    </button>
                {/if}
                {if $ksef.ksef_status == 'error' || $ksef.ksef_status == 'rejected' || $ksef.ksef_status == 'pending'}
                    <button type="button" class="btn btn-sm btn-danger puq-ksef-btn-unpaid" data-id="{$ksef.id}">
                        <i class="fas fa-undo"></i> {$meta.lang['Mark Unpaid']}
                    </button>
                {/if}
                {if $ksef.upo_xml}
                    <button type="button" class="btn btn-sm btn-info puq-ksef-btn-upo" data-id="{$ksef.id}" data-ksef-number="{$ksef.ksef_number|escape:'html'}">
                        <i class="fas fa-certificate"></i> {$meta.lang['Download UPO']}
                    </button>
                {/if}
                {if $ksef.invoice_xml}
                    <button type="button" class="btn btn-sm btn-success puq-ksef-btn-xml" data-id="{$ksef.id}" data-filename="{$ksef.invoice_number|escape:'html'}">
                        <i class="fas fa-download"></i> XML
                    </button>
                {/if}
            </div>

            {if $ksef.ksef_status == 'accepted' && $ksef.ksef_upo_download_url}
                <div style="margin-top:8px;">
                    {if $ksef.ksef_upo_url_expires_at}
                        {assign var="now_ts" value=$smarty.now}
                        {assign var="exp_ts" value=$ksef.ksef_upo_url_expires_at|strtotime}
                        {if $exp_ts > $now_ts}
                            <small>
                                <i class="fas fa-external-link-alt text-info"></i>
                                <a href="{$ksef.ksef_upo_download_url|escape:'html'}" target="_blank" class="text-info">
                                    {$meta.lang['Direct UPO link from KSeF']}
                                </a>
                                <span class="text-muted">({$meta.lang['expires']}: {$ksef.ksef_upo_url_expires_at})</span>
                            </small>
                        {else}
                            <small class="text-muted">
                                <i class="fas fa-link"></i>
                                <del>{$meta.lang['Direct UPO link from KSeF']}</del>
                                <span class="text-danger">({$meta.lang['expired']}: {$ksef.ksef_upo_url_expires_at})</span>
                            </small>
                        {/if}
                    {else}
                        <small>
                            <i class="fas fa-external-link-alt text-info"></i>
                            <a href="{$ksef.ksef_upo_download_url|escape:'html'}" target="_blank" class="text-info">
                                {$meta.lang['Direct UPO link from KSeF']}
                            </a>
                        </small>
                    {/if}
                </div>
            {/if}
        {else}
            <p class="text-muted" style="margin-bottom:10px;">
                <i class="fas fa-info-circle"></i> {$meta.lang['This invoice has not been sent to KSeF.']}
            </p>
            {if $invoice_status == 'Paid'}
                <button type="button" class="btn btn-sm btn-primary puq-ksef-btn-send" data-invoice-id="{$invoice_id}">
                    <i class="fas fa-paper-plane"></i> {$meta.lang['Send to KSeF']}
                </button>
            {else}
                <span class="text-muted"><i class="fas fa-lock"></i> {$meta.lang['Invoice status']}: <strong>{$invoice_status}</strong> ({$meta.lang['must be Paid to send']})</span>
            {/if}
        {/if}
    </div>
</div>
