(function() {
    var L = window.puqKsefLang || {};
    var ajaxUrl = window.puqKsefAjaxUrl;
    var panel = document.getElementById('puq-ksef-panel-inner');
    if (!panel) return;

    function formatXml(xml) {
        var formatted = '';
        var reg = /(>)(<)(\/*)/g;
        xml = xml.replace(reg, '$1\r\n$2$3');
        var pad = 0;
        xml.split('\r\n').forEach(function(node) {
            var indent = 0;
            if (node.match(/^<\/\w/)) {
                if (pad !== 0) pad -= 1;
            } else if (node.match(/^<\w([^>]*[^\/])?>.*$/)) {
                indent = 1;
            }
            formatted += '  '.repeat(pad) + node + '\r\n';
            pad += indent;
        });
        return formatted.trim();
    }

    function btnSpinner(btn, text) {
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>' + (text ? ' ' + text : '');
    }

    function btnRestore(btn, icon, text) {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-' + icon + '"></i> ' + text;
    }

    // Retry
    panel.addEventListener('click', function(e) {
        var btn = e.target.closest('.puq-ksef-btn-retry');
        if (!btn) return;

        if (!confirm(L['Confirm retry KSeF'] || 'Are you sure you want to retry sending this invoice to KSeF?')) return;

        var ksefId = btn.getAttribute('data-id');
        btnSpinner(btn, L['Retrying...'] || 'Retry...');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', ajaxUrl + '&ajax=retryInvoice', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success) {
                        window.puqKsefReloadPanel();
                    } else {
                        alert(resp.error || L['Retry failed'] || 'Retry failed');
                        btnRestore(btn, 'redo', L['Retry'] || 'Retry');
                    }
                } catch (e) {
                    alert(L['Error processing response'] || 'Error processing response');
                    btnRestore(btn, 'redo', L['Retry'] || 'Retry');
                }
            }
        };
        xhr.send('id=' + ksefId);
    });

    // Mark Unpaid
    panel.addEventListener('click', function(e) {
        var btn = e.target.closest('.puq-ksef-btn-unpaid');
        if (!btn) return;

        if (!confirm(L['Confirm mark unpaid'] || 'Mark this invoice as Unpaid and delete the KSeF record?')) return;

        var ksefId = btn.getAttribute('data-id');
        btnSpinner(btn, L['Marking unpaid...'] || 'Unpaid...');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', ajaxUrl + '&ajax=markUnpaid', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success) {
                        window.location.reload();
                    } else {
                        alert(resp.error || L['Failed'] || 'Failed');
                        btnRestore(btn, 'undo', L['Mark Unpaid'] || 'Mark Unpaid');
                    }
                } catch (e) {
                    alert(L['Error processing response'] || 'Error processing response');
                    btnRestore(btn, 'undo', L['Mark Unpaid'] || 'Mark Unpaid');
                }
            }
        };
        xhr.send('id=' + ksefId);
    });

    // Download XML
    panel.addEventListener('click', function(e) {
        var btn = e.target.closest('.puq-ksef-btn-xml');
        if (!btn) return;

        var ksefId = btn.getAttribute('data-id');
        var filename = btn.getAttribute('data-filename');
        btnSpinner(btn);

        var xhr = new XMLHttpRequest();
        xhr.open('GET', ajaxUrl + '&ajax=getInvoiceXml&id=' + ksefId, true);
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success && resp.xml) {
                        var formattedXml = formatXml(resp.xml);
                        var blob = new Blob([formattedXml], {type: 'application/xml;charset=utf-8'});
                        var safeName = (filename || 'invoice_' + ksefId).replace(/[^a-zA-Z0-9._-]/g, '_') + '.xml';

                        var link = document.createElement('a');
                        var url = URL.createObjectURL(blob);
                        link.href = url;
                        link.download = safeName;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                        URL.revokeObjectURL(url);
                    } else {
                        alert(resp.error || L['Failed to load XML'] || 'Failed to load XML');
                    }
                } catch (e) {
                    alert(L['Error loading XML'] || 'Error loading XML');
                    console.error('PUQ KSeF:', e);
                }
                btnRestore(btn, 'download', 'XML');
            }
        };
        xhr.send();
    });

    // Download UPO
    panel.addEventListener('click', function(e) {
        var btn = e.target.closest('.puq-ksef-btn-upo');
        if (!btn) return;

        var ksefId = btn.getAttribute('data-id');
        var ksefNumber = btn.getAttribute('data-ksef-number');
        btnSpinner(btn, L['Downloading UPO...'] || 'Downloading...');

        var xhr = new XMLHttpRequest();
        xhr.open('GET', ajaxUrl + '&ajax=downloadUpo&id=' + ksefId, true);
        xhr.timeout = 120000;
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success && resp.upo) {
                        var formattedXml = formatXml(resp.upo);
                        var blob = new Blob([formattedXml], {type: 'application/xml;charset=utf-8'});
                        var filename = 'UPO_' + (ksefNumber || 'invoice_' + ksefId).replace(/[^a-zA-Z0-9._-]/g, '_') + '.xml';

                        var link = document.createElement('a');
                        var url = URL.createObjectURL(blob);
                        link.href = url;
                        link.download = filename;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                        URL.revokeObjectURL(url);
                    } else {
                        alert(resp.error || L['Failed to download UPO'] || 'Failed to download UPO');
                    }
                } catch (e) {
                    alert(L['Error processing response'] || 'Error processing response');
                }
                btnRestore(btn, 'certificate', L['Download UPO'] || 'UPO');
            }
        };
        xhr.send();
    });

    // Send Now (existing invoice in queue)
    panel.addEventListener('click', function(e) {
        var btn = e.target.closest('.puq-ksef-btn-send-now');
        if (!btn) return;

        if (!confirm(L['Confirm send to KSeF'] || 'Send this invoice to KSeF now? This may take 20-30 seconds.')) return;

        var ksefId = btn.getAttribute('data-id');
        btnSpinner(btn, L['Sending...'] || 'Sending...');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', ajaxUrl + '&ajax=sendInvoiceNow', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.timeout = 120000;
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success) {
                        window.puqKsefReloadPanel();
                    } else {
                        alert(resp.error || L['Failed to send to KSeF'] || 'Failed to send to KSeF');
                        btnRestore(btn, 'paper-plane', L['Send to KSeF'] || 'Send to KSeF');
                    }
                } catch (e) {
                    alert(L['Error processing response'] || 'Error processing response');
                    btnRestore(btn, 'paper-plane', L['Send to KSeF'] || 'Send to KSeF');
                }
            }
        };
        xhr.send('id=' + ksefId);
    });

    // Send to KSeF (new invoice, not yet in queue)
    panel.addEventListener('click', function(e) {
        var btn = e.target.closest('.puq-ksef-btn-send');
        if (!btn) return;

        if (!confirm(L['Confirm send to KSeF'] || 'Warning: The invoice issue date and due date will be changed to today\'s date. Continue?')) return;

        var invoiceId = btn.getAttribute('data-invoice-id');
        btnSpinner(btn, L['Sending...'] || 'Sending...');

        var xhr = new XMLHttpRequest();
        xhr.open('POST', ajaxUrl + '&ajax=sendToKsef', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success) {
                        window.puqKsefReloadPanel();
                    } else {
                        alert(resp.error || L['Failed to send to KSeF'] || 'Failed to send to KSeF');
                        btnRestore(btn, 'paper-plane', L['Send to KSeF'] || 'Send to KSeF');
                    }
                } catch (e) {
                    alert(L['Error processing response'] || 'Error processing response');
                    btnRestore(btn, 'paper-plane', L['Send to KSeF'] || 'Send to KSeF');
                }
            }
        };
        xhr.send('invoice_id=' + invoiceId);
    });

    console.log('PUQ KSeF: invoice panel JS loaded');
})();
