<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-file-pdf"></i> {$meta.lang['Help: Invoice Template']}</h3>
    </div>
    <div class="panel-body">

        <h4>{$meta.lang['help_intro_title']}</h4>
        <p>{$meta.lang['help_intro_text']}</p>

        <hr>

        <h4>1. {$meta.lang['help_prerequisites_title']}</h4>
        <ul>
            <li>{$meta.lang['help_prereq_module_active']}</li>
            <li>{$meta.lang['help_prereq_invoice_accepted']}</li>
            <li>{$meta.lang['help_prereq_gd']}</li>
        </ul>

        <hr>

        <h4>2. {$meta.lang['help_step_locate_title']}</h4>
        <p>{$meta.lang['help_step_locate_text']}</p>
        <pre><code>templates/[template_name]/   (WHMCS root)
  invoicepdf.tpl      — Smarty template
  or a custom .php PDF class</code></pre>

        <hr>

        <h4>3. {$meta.lang['help_step_require_title']}</h4>
        <p>{$meta.lang['help_step_require_text']}</p>
        <pre><code>require_once ROOTDIR . '/modules/addons/puq_ksef_integrator/lib/puqKSeFIntegratorPdfHelper.php';
$ksef = puq_ksef_get_invoice_data($invoiceid);</code></pre>

        <hr>

        <h4>4. {$meta.lang['help_func_params_title']}</h4>
        <p>{$meta.lang['help_func_params_text']}</p>

        <pre><code>puq_ksef_get_invoice_data(int $invoiceId, int $qrSize = 4, int $qrMargin = 2): array</code></pre>

        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>{$meta.lang['help_func_param_name']}</th>
                    <th>{$meta.lang['help_func_param_type']}</th>
                    <th>{$meta.lang['help_func_param_default']}</th>
                    <th>{$meta.lang['help_func_param_description']}</th>
                </tr>
            </thead>
            <tbody>
                <tr><td><code>$invoiceId</code></td><td>int</td><td>—</td><td>{$meta.lang['help_func_param_invoiceid']}</td></tr>
                <tr><td><code>$qrSize</code></td><td>int</td><td>4</td><td>{$meta.lang['help_func_param_qrsize']}</td></tr>
                <tr><td><code>$qrMargin</code></td><td>int</td><td>2</td><td>{$meta.lang['help_func_param_qrmargin']}</td></tr>
            </tbody>
        </table>

        <p>{$meta.lang['help_func_params_example']}</p>
        <pre><code>$ksef = puq_ksef_get_invoice_data($invoiceid, 6, 1);</code></pre>

        <hr>

        <h4>5. {$meta.lang['help_step_use_data_title']}</h4>
        <p>{$meta.lang['help_step_use_data_text']}</p>

        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>{$meta.lang['help_var_key']}</th>
                    <th>{$meta.lang['help_var_type']}</th>
                    <th>{$meta.lang['help_var_description']}</th>
                </tr>
            </thead>
            <tbody>
                <tr><td><code>ksef_found</code></td><td>bool</td><td>{$meta.lang['help_var_found']}</td></tr>
                <tr><td><code>ksef_number</code></td><td>string</td><td>{$meta.lang['help_var_number']}</td></tr>
                <tr><td><code>ksef_reference</code></td><td>string</td><td>{$meta.lang['help_var_reference']}</td></tr>
                <tr><td><code>ksef_status</code></td><td>string</td><td>{$meta.lang['help_var_status']}</td></tr>
                <tr><td><code>ksef_qr_url</code></td><td>string</td><td>{$meta.lang['help_var_qr_url']}</td></tr>
                <tr><td><code>ksef_qr_png_base64</code></td><td>string</td><td>{$meta.lang['help_var_qr_base64']}</td></tr>
                <tr><td><code>ksef_qr_png_data_uri</code></td><td>string</td><td>{$meta.lang['help_var_qr_data_uri']}</td></tr>
                <tr><td><code>ksef_invoice_hash</code></td><td>string</td><td>{$meta.lang['help_var_hash']}</td></tr>
                <tr><td><code>ksef_issue_date</code></td><td>string</td><td>{$meta.lang['help_var_issue_date']}</td></tr>
                <tr><td><code>ksef_accepted_at</code></td><td>string</td><td>{$meta.lang['help_var_accepted_at']}</td></tr>
            </tbody>
        </table>

        <hr>

        <h4>6. {$meta.lang['help_example_title']}</h4>
        <p>{$meta.lang['help_example_text']}</p>

        <pre><code>{literal}// --- KSeF QR Code block (add at the bottom of your PDF template) ---
require_once ROOTDIR . '/modules/addons/puq_ksef_integrator/lib/puqKSeFIntegratorPdfHelper.php';
$ksef = puq_ksef_get_invoice_data($invoiceid);

if ($ksef['ksef_found'] && $ksef['ksef_qr_png_base64']) {
    // Save QR PNG to a temp file
    $qrTmpFile = tempnam(sys_get_temp_dir(), 'ksef_qr_');
    file_put_contents($qrTmpFile, base64_decode($ksef['ksef_qr_png_base64']));

    // Center QR image (30x30mm) horizontally
    $pageWidth = $pdf->getPageWidth();
    $qrSize = 30;
    $qrX = ($pageWidth - $qrSize) / 2;
    $qrY = $pdf->GetY() + 5;
    $pdf->Image($qrTmpFile, $qrX, $qrY, $qrSize, $qrSize, 'PNG');

    // KSeF number centered below QR
    $pdf->SetY($qrY + $qrSize + 2);
    $pdf->SetFont('', 'B', 8);
    $pdf->Cell(0, 5, 'KSeF: ' . $ksef['ksef_number'], 0, 1, 'C');

    // Direct KSeF link centered below number
    if (!empty($ksef['ksef_qr_url'])) {
        $pdf->SetFont('', '', 7);
        $pdf->Cell(0, 4, $ksef['ksef_qr_url'], 0, 1, 'C', false, $ksef['ksef_qr_url']);
    }

    // Clean up temp file
    @unlink($qrTmpFile);
}{/literal}</code></pre>

        <hr>

        <h4>7. {$meta.lang['help_example_b_title']}</h4>
        <p>{$meta.lang['help_example_b_text']}</p>

        <pre><code>{literal}// --- KSeF QR Code block — no temp file ---
require_once ROOTDIR . '/modules/addons/puq_ksef_integrator/lib/puqKSeFIntegratorPdfHelper.php';
$ksef = puq_ksef_get_invoice_data($invoiceid);

if ($ksef['ksef_found'] && $ksef['ksef_qr_png_base64']) {
    // Pass raw PNG data directly via '@' prefix
    $qrRaw = '@' . base64_decode($ksef['ksef_qr_png_base64']);

    // Center QR image (30x30mm) horizontally
    $pageWidth = $pdf->getPageWidth();
    $qrSize = 30;
    $qrX = ($pageWidth - $qrSize) / 2;
    $qrY = $pdf->GetY() + 5;
    $pdf->Image($qrRaw, $qrX, $qrY, $qrSize, $qrSize, 'PNG');

    // KSeF number centered below QR
    $pdf->SetY($qrY + $qrSize + 2);
    $pdf->SetFont('', 'B', 8);
    $pdf->Cell(0, 5, 'KSeF: ' . $ksef['ksef_number'], 0, 1, 'C');

    // Direct KSeF link centered below number
    if (!empty($ksef['ksef_qr_url'])) {
        $pdf->SetFont('', '', 7);
        $pdf->Cell(0, 4, $ksef['ksef_qr_url'], 0, 1, 'C', false, $ksef['ksef_qr_url']);
    }
}{/literal}</code></pre>

        <hr>

        <h4>8. {$meta.lang['help_example_c_title']}</h4>
        <p>{$meta.lang['help_example_c_text']}</p>

        <pre><code>{literal}// --- KSeF QR Code block — temp file with fallback ---
require_once ROOTDIR . '/modules/addons/puq_ksef_integrator/lib/puqKSeFIntegratorPdfHelper.php';
$ksef = puq_ksef_get_invoice_data($invoiceid);

if ($ksef['ksef_found'] && $ksef['ksef_qr_png_base64']) {
    $qrPngData = base64_decode($ksef['ksef_qr_png_base64']);
    $qrImageArg = null;
    $qrTmpFile = null;

    // Try temp file first
    $qrTmpFile = @tempnam(sys_get_temp_dir(), 'ksef_qr_');
    if ($qrTmpFile && @file_put_contents($qrTmpFile, $qrPngData)) {
        $qrImageArg = $qrTmpFile;
    } else {
        // Fallback: pass raw data via '@' prefix
        $qrImageArg = '@' . $qrPngData;
        $qrTmpFile = null;
    }

    // Center QR image (30x30mm) horizontally
    $pageWidth = $pdf->getPageWidth();
    $qrSize = 30;
    $qrX = ($pageWidth - $qrSize) / 2;
    $qrY = $pdf->GetY() + 5;
    $pdf->Image($qrImageArg, $qrX, $qrY, $qrSize, $qrSize, 'PNG');

    // KSeF number centered below QR
    $pdf->SetY($qrY + $qrSize + 2);
    $pdf->SetFont('', 'B', 8);
    $pdf->Cell(0, 5, 'KSeF: ' . $ksef['ksef_number'], 0, 1, 'C');

    // Direct KSeF link centered below number
    if (!empty($ksef['ksef_qr_url'])) {
        $pdf->SetFont('', '', 7);
        $pdf->Cell(0, 4, $ksef['ksef_qr_url'], 0, 1, 'C', false, $ksef['ksef_qr_url']);
    }

    // Clean up temp file if used
    if ($qrTmpFile) {
        @unlink($qrTmpFile);
    }
}{/literal}</code></pre>

        <hr>

        <h4>9. {$meta.lang['help_notes_title']}</h4>
        <ul>
            <li>{$meta.lang['help_note_temp_file']}</li>
            <li>{$meta.lang['help_note_tcpdf_at']}</li>
            <li>{$meta.lang['help_note_safe_defaults']}</li>
        </ul>

        <hr>

        <h4>10. {$meta.lang['help_troubleshooting_title']}</h4>
        <ul>
            <li><strong>{$meta.lang['help_trouble_nothing']}</strong></li>
            <li>{$meta.lang['help_trouble_variable']}</li>
            <li>{$meta.lang['help_trouble_debug']}
                <pre><code>{literal}require_once ROOTDIR . '/modules/addons/puq_ksef_integrator/lib/puqKSeFIntegratorPdfHelper.php';
$ksef = puq_ksef_get_invoice_data($invoiceid);

// Temporary debug — remove after testing
error_log('PUQ KSeF PDF debug: invoiceid=' . $invoiceid . ' ksef_found=' . var_export($ksef['ksef_found'], true) . ' status=' . $ksef['ksef_status']);{/literal}</code></pre>
            </li>
        </ul>

    </div>
</div>
