<div class="row">
    <div class="col-md-12">

        <div class="clearfix" style="margin-bottom:15px;">
            <h1 class="pull-left" style="margin:0;">
                <i class="fa fa-cog"></i> {$meta.lang['Configuration']}
            </h1>

            <div class="pull-right">
                <button type="submit" form="puq-settings-form" class="btn btn-success" id="puq-save-settings">
                    <i class="fa fa-save"></i> {$meta.lang['Save Settings']}
                </button>
            </div>
        </div>

        <form id="puq-settings-form" style="position: relative;">

            <div id="puq-settings-overlay" style="display:block;position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.9);z-index:9999;border-radius:4px;">
                <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);text-align:center;">
                    <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
                    <div style="margin-top:10px;font-size:16px;">{$meta.lang['Loading...']}</div>
                </div>
            </div>

            {* ====== ENVIRONMENT ====== *}
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="fa fa-server"></i> {$meta.lang['Environment & Certificates']}</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Debug mode']}</label>
                                <select name="debug" class="form-control">
                                    <option value="0">{$meta.lang['Disabled']}</option>
                                    <option value="1">{$meta.lang['Enabled']}</option>
                                </select>
                                <small class="text-muted">{$meta.lang['During debugging, all important steps will be written to the WHMCS module log']}</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Working Environment']} <span class="text-danger">*</span></label>
                                <select name="environment" class="form-control">
                                    <option value="test">{$meta.lang['Test']}</option>
                                    <option value="prod">{$meta.lang['Production']}</option>
                                </select>
                                <small class="text-muted">{$meta.lang['Test environment hint']}</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Test Certificate']}</label>
                                <select name="cert_test_id" id="puq-cert-test" class="form-control">
                                    <option value="">— {$meta.lang['None']} —</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Production Certificate']}</label>
                                <select name="cert_prod_id" id="puq-cert-prod" class="form-control">
                                    <option value="">— {$meta.lang['None']} —</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {* ====== COMPANY DATA ====== *}
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="fa fa-building"></i> {$meta.lang['Company Data']}</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">NIP <span class="text-danger">*</span></label>
                                <input type="text" name="company_nip" class="form-control" maxlength="10" placeholder="1234567890">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Company Name']} <span class="text-danger">*</span></label>
                                <input type="text" name="company_name" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Street']} <span class="text-danger">*</span></label>
                                <input type="text" name="company_street" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Building No.']}</label>
                                <input type="text" name="company_building" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Apt. No.']}</label>
                                <input type="text" name="company_apartment" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Postal Code']} <span class="text-danger">*</span></label>
                                <input type="text" name="company_postal_code" class="form-control" placeholder="00-000">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['City']} <span class="text-danger">*</span></label>
                                <input type="text" name="company_city" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Country']} <span class="text-danger">*</span></label>
                                <input type="text" name="company_country" class="form-control" value="PL" maxlength="2">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Phone']}</label>
                                <input type="text" name="company_phone" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Email']}</label>
                                <input type="email" name="company_email" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {* ====== INVOICE SETTINGS ====== *}
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><i class="fa fa-file-invoice"></i> {$meta.lang['Invoice Settings']}</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Sending Mode']} <span class="text-danger">*</span></label>
                                <select name="sending_mode" class="form-control">
                                    <option value="immediate">{$meta.lang['Immediately after payment']}</option>
                                    <option value="manual">{$meta.lang['Manual']}</option>
                                </select>
                                <small class="text-muted">{$meta.lang['Sending mode hint']}</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Auto Retry on error']}</label>
                                <select name="auto_retry" class="form-control">
                                    <option value="0">{$meta.lang['Disabled']}</option>
                                    <option value="1">{$meta.lang['Enabled']}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Max Retry Count']}</label>
                                <input type="number" name="max_retry_count" class="form-control" value="3" min="1" max="10">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['VAT Exempt']}</label>
                                <select name="vat_exempt" class="form-control">
                                    <option value="0">{$meta.lang['No (standard VAT payer)']}</option>
                                    <option value="1">{$meta.lang['Yes (VAT exempt business)']}</option>
                                </select>
                                <small class="text-muted">{$meta.lang['VAT exempt hint']}</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['VAT code EU B2B']}</label>
                                <select name="vat_code_eu_b2b" class="form-control">
                                    <option value="0 EX">0% — {$meta.lang['Export']} (0 EX)</option>
                                    <option value="0 WDT">0% — WDT (0 WDT)</option>
                                    <option value="0 KR">0% — {$meta.lang['Domestic']} (0 KR)</option>
                                    <option value="zw">{$meta.lang['Exempt']} (zw)</option>
                                    <option value="oo">{$meta.lang['Reverse charge']} (oo)</option>
                                    <option value="np">{$meta.lang['Not applicable']} (np)</option>
                                </select>
                                <small class="text-muted">{$meta.lang['VAT code EU B2B hint']}</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">{$meta.lang['VAT code non-EU']}</label>
                                <select name="vat_code_non_eu" class="form-control">
                                    <option value="0 EX">0% — {$meta.lang['Export']} (0 EX)</option>
                                    <option value="0 WDT">0% — WDT (0 WDT)</option>
                                    <option value="0 KR">0% — {$meta.lang['Domestic']} (0 KR)</option>
                                    <option value="zw">{$meta.lang['Exempt']} (zw)</option>
                                    <option value="oo">{$meta.lang['Reverse charge']} (oo)</option>
                                    <option value="np">{$meta.lang['Not applicable']} (np)</option>
                                </select>
                                <small class="text-muted">{$meta.lang['VAT code non-EU hint']}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>
</div>

{literal}
<script>
    (function () {
        const baseUrl = '{/literal}{$meta.admin_module_url}&ajax={literal}';
        const lang = {
            saved: '{/literal}{$meta.lang['Settings saved successfully']}{literal}',
            error_saving: '{/literal}{$meta.lang['Error saving settings']}{literal}',
            server_error: '{/literal}{$meta.lang['Server error']}{literal}',
            none: '{/literal}{$meta.lang['None']}{literal}'
        };

        function populateCertDropdowns(certs, settings) {
            var testSelect = $('#puq-cert-test');
            var prodSelect = $('#puq-cert-prod');

            testSelect.find('option:not(:first)').remove();
            prodSelect.find('option:not(:first)').remove();

            $.each(certs, function (i, c) {
                var opt = '<option value="' + c.id + '">' + c.name + ' (#' + c.id + ')</option>';
                if (c.type === 'test') {
                    testSelect.append(opt);
                } else if (c.type === 'prod') {
                    prodSelect.append(opt);
                }
            });

            if (settings.cert_test_id) testSelect.val(settings.cert_test_id);
            if (settings.cert_prod_id) prodSelect.val(settings.cert_prod_id);
        }

        function loadSettings() {
            $.getJSON(baseUrl + 'getSettings', function (res) {
                if (!res || !res.success) {
                    $('#puq-settings-overlay').hide();
                    return;
                }

                var s = res.data.settings || {};
                var form = $('#puq-settings-form');

                // Populate form fields from settings
                $.each(s, function (key, val) {
                    var el = form.find('[name="' + key + '"]');
                    if (el.length && val !== null && val !== '') {
                        var strVal;
                        if (typeof val === 'boolean') {
                            strVal = val ? '1' : '0';
                        } else {
                            strVal = String(val).trim();
                        }

                        if (el.is('select')) {
                            el.find('option').each(function () {
                                if (String($(this).val()) === strVal) {
                                    $(this).prop('selected', true);
                                } else {
                                    $(this).prop('selected', false);
                                }
                            });
                        } else if (el.is(':checkbox') || el.is(':radio')) {
                            el.prop('checked', strVal === '1' || strVal === 'on' || strVal === 'true');
                        } else {
                            el.val(strVal);
                        }
                    }
                });

                populateCertDropdowns(res.data.certificates || [], s);

                $('#puq-settings-overlay').hide();
            }).fail(function () {
                $('#puq-settings-overlay').hide();
            });
        }

        $(document).ready(function () {
            loadSettings();

            $('#puq-settings-form').submit(function (e) {
                e.preventDefault();

                var form = $(this);
                var btn = $('#puq-save-settings');

                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ...');

                $.ajax({
                    url: baseUrl + 'saveSettings',
                    type: 'POST',
                    data: form.serializeArray(),
                    dataType: 'json',
                    success: function (res) {
                        btn.prop('disabled', false).html('<i class="fa fa-save"></i> {/literal}{$meta.lang["Save Settings"]}{literal}');
                        if (res && res.success) {
                            showNotification(res.message || lang.saved, 'success');
                            $('#puq-settings-overlay').show();
                            loadSettings();
                        } else {
                            showNotification(res.error || res.message || lang.error_saving, 'error');
                        }
                    },
                    error: function (xhr) {
                        btn.prop('disabled', false).html('<i class="fa fa-save"></i> {/literal}{$meta.lang["Save Settings"]}{literal}');
                        var msg = lang.server_error + ': ' + xhr.status;
                        try {
                            var r = JSON.parse(xhr.responseText);
                            if (r && r.error) msg = r.error;
                        } catch (e) {
                        }
                        showNotification(msg, 'error');
                    }
                });
            });
        });
    })();
</script>
{/literal}