<div class="row" id="ksef-checks">

    {assign var=checks value=[
    'checkShellExec' => 'shell_exec',
    'checkXmlSec'    => 'xmlsec1',
    'checkOpenSSL'   => 'OpenSSL',
    'checkTempDir'   => 'Temp directory'
    ]}

    {foreach $checks as $action => $title}
        <div class="col-md-3">
            <div class="panel panel-default ksef-check" data-action="{$action}">
                <div class="panel-heading">
                    <strong>{$title}</strong>
                    <span class="pull-right status-label label label-default">{$meta.lang['Checking…']}</span>
                </div>

                <div class="panel-body">

                    <!-- Loader -->
                    <div class="ksef-loader text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <div class="text-muted">{$meta.lang['Running check…']}</div>
                    </div>

                    <!-- Result -->
                    <div class="ksef-result" style="display:none;">
                        <table class="table table-condensed table-bordered">
                            <tbody></tbody>
                        </table>
                    </div>

                    <!-- Error -->
                    <div class="ksef-error alert alert-danger" style="display:none;"></div>

                </div>
            </div>
        </div>
    {/foreach}

</div>
<script>
    (function () {

        const baseUrl = '{$meta.admin_module_url}&ajax=';

        function humanize(key) {
            return key.replace(/_/g, ' ');
        }

        function renderValue(val) {
            if (val === true) {
                return '<span class="label label-success">{$meta.lang['YES']}</span>';
            }
            if (val === false) {
                return '<span class="label label-danger">{$meta.lang['NO']}</span>';
            }
            if (val === null) {
                return '<span class="text-muted">—</span>';
            }
            return val;
        }

        function renderTable(tbody, data) {
            tbody.innerHTML = '';

            Object.keys(data).forEach(function (key) {
                var tr = document.createElement('tr');

                tr.innerHTML =
                    '<th style="width:40%">' + humanize(key) + '</th>' +
                    '<td>' + renderValue(data[key]) + '</td>';

                tbody.appendChild(tr);
            });
        }

        document.querySelectorAll('.ksef-check').forEach(function (card) {

            const action = card.dataset.action;
            const label  = card.querySelector('.status-label');
            const loader = card.querySelector('.ksef-loader');
            const result = card.querySelector('.ksef-result');
            const error  = card.querySelector('.ksef-error');
            const tbody  = result.querySelector('tbody');

            fetch(baseUrl + action)
                .then(r => r.json())
                .then(res => {

                    loader.style.display = 'none';

                    if (res.status === 'success') {
                        label.className = 'pull-right status-label label label-success';
                        label.textContent = '{$meta.lang['OK']}';
                    } else {
                        label.className = 'pull-right status-label label label-danger';
                        label.textContent = '{$meta.lang['ERROR']}';
                    }

                    if (res.data) {
                        renderTable(tbody, res.data);
                        result.style.display = 'block';
                    }

                    if (res.error) {
                        error.textContent = res.error;
                        error.style.display = 'block';
                    }
                })
                .catch(e => {
                    loader.style.display = 'none';
                    label.className = 'pull-right status-label label label-danger';
                    label.textContent = '{$meta.lang['FAILED']}';
                    error.textContent = e.toString();
                    error.style.display = 'block';
                });
        });

    })();
</script>
