<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-palette"></i> {$meta.lang['PDF Template']}</h1>
    </div>
</div>

<div id="edit-loading" class="text-center" style="padding:40px 0;">
    <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
    <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
</div>

<div id="edit-content" style="margin-top:15px; display:none;">
    <input type="hidden" id="template-id" value="">

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-cog"></i> {$meta.lang['General']}</h3></div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['Layout']}</label>
                                <select class="form-control" id="tpl-layout">
                                    <option value="classic">{$meta.lang['Classic']}</option>
                                    <option value="modern">{$meta.lang['Modern']}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{$meta.lang['Paper Size']}</label>
                                <select class="form-control" id="tpl-paper-size">
                                    <option value="A4">A4</option>
                                    <option value="A3">A3</option>
                                    <option value="Letter">Letter</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Orientation']}</label>
                        <select class="form-control" id="tpl-orientation">
                            <option value="P">{$meta.lang['Portrait']}</option>
                            <option value="L">{$meta.lang['Landscape']}</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-font"></i> {$meta.lang['Typography']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Font Family']}</label>
                        <select class="form-control" id="tpl-font-family">
                            <option value="helvetica">Helvetica</option>
                            <option value="times">Times</option>
                            <option value="courier">Courier</option>
                            <option value="dejavusans">DejaVu Sans</option>
                            <option value="freeserif">Free Serif</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Font Size']}</label>
                        <input type="number" class="form-control" id="tpl-font-size" value="10" min="6" max="24">
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-paint-brush"></i> {$meta.lang['Colors']}</h3></div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{$meta.lang['Primary Color']}</label>
                                <input type="color" class="form-control" id="tpl-primary-color" value="#337ab7">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{$meta.lang['Secondary Color']}</label>
                                <input type="color" class="form-control" id="tpl-secondary-color" value="#555555">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{$meta.lang['Header Background']}</label>
                                <input type="color" class="form-control" id="tpl-header-bg" value="#f5f5f5">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-eye"></i> {$meta.lang['Display Options']}</h3></div>
                <div class="panel-body">
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-logo" checked> {$meta.lang['Show Logo']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-company-details" checked> {$meta.lang['Company Details']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-client-details" checked> {$meta.lang['Client Details']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-summary" checked> {$meta.lang['Summary']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-aging-report" checked> {$meta.lang['Aging Report']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-statement-table" checked> {$meta.lang['Statement Table']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="tpl-show-balance" checked> {$meta.lang['Balance']}</label></div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-code"></i> {$meta.lang['Custom Content']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Header Text']}</label>
                        <textarea class="form-control" id="tpl-header-text" rows="3" placeholder="{$meta.lang['Custom header text...']}"></textarea>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Footer Text']}</label>
                        <textarea class="form-control" id="tpl-footer-text" rows="3" placeholder="{$meta.lang['Custom footer text...']}"></textarea>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Custom CSS']}</label>
                        <textarea class="form-control" id="tpl-custom-css" rows="5" placeholder="{$meta.lang['Custom CSS styles...']}"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success btn-lg" id="btn-save" onclick="saveTemplate()" style="min-width:200px;">
                <i class="fa fa-save"></i> {$meta.lang['Save Template']}
            </button>
            <button class="btn btn-info btn-lg" onclick="previewTemplate()">
                <i class="fa fa-eye"></i> {$meta.lang['Preview']}
            </button>
        </div>
    </div>
</div>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';

    // Always load the default template
    jQuery.ajax({
        url: ajaxUrl + '&ajax=getTemplate',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('edit-loading').style.display = 'none';
            document.getElementById('edit-content').style.display = 'block';

            if (!response.success || !response.data) {
                showNotification(response.error || 'Template not found', 'error');
                return;
            }

            var t = response.data;
            document.getElementById('template-id').value = t.id;
            document.getElementById('tpl-layout').value = t.layout || 'classic';
            document.getElementById('tpl-paper-size').value = t.paper_size || 'A4';
            document.getElementById('tpl-orientation').value = t.orientation || 'P';
            document.getElementById('tpl-font-family').value = t.font_family || 'helvetica';
            document.getElementById('tpl-font-size').value = t.font_size || 10;
            document.getElementById('tpl-primary-color').value = t.primary_color || '#337ab7';
            document.getElementById('tpl-secondary-color').value = t.secondary_color || '#555555';
            document.getElementById('tpl-header-bg').value = t.header_bg_color || '#f5f5f5';
            document.getElementById('tpl-show-logo').checked = t.show_logo !== false && t.show_logo !== 0;
            document.getElementById('tpl-show-company-details').checked = t.show_company_details !== false && t.show_company_details !== 0;
            document.getElementById('tpl-show-client-details').checked = t.show_client_details !== false && t.show_client_details !== 0;
            document.getElementById('tpl-show-summary').checked = t.show_summary !== false && t.show_summary !== 0;
            document.getElementById('tpl-show-aging-report').checked = t.show_aging_report !== false && t.show_aging_report !== 0;
            document.getElementById('tpl-show-statement-table').checked = t.show_statement_table !== false && t.show_statement_table !== 0;
            document.getElementById('tpl-show-balance').checked = t.show_balance !== false && t.show_balance !== 0;
            document.getElementById('tpl-header-text').value = t.header_text || '';
            document.getElementById('tpl-footer-text').value = t.footer_text || '';
            document.getElementById('tpl-custom-css').value = t.custom_css || '';
        },
        error: function() {
            document.getElementById('edit-loading').innerHTML = '<p class="text-danger">Failed to load template</p>';
        }
    });

    function collectData() {
        return {
            id: document.getElementById('template-id').value || null,
            layout: document.getElementById('tpl-layout').value,
            paper_size: document.getElementById('tpl-paper-size').value,
            orientation: document.getElementById('tpl-orientation').value,
            font_family: document.getElementById('tpl-font-family').value,
            font_size: parseInt(document.getElementById('tpl-font-size').value),
            primary_color: document.getElementById('tpl-primary-color').value,
            secondary_color: document.getElementById('tpl-secondary-color').value,
            header_bg_color: document.getElementById('tpl-header-bg').value,
            show_logo: document.getElementById('tpl-show-logo').checked ? 1 : 0,
            show_company_details: document.getElementById('tpl-show-company-details').checked ? 1 : 0,
            show_client_details: document.getElementById('tpl-show-client-details').checked ? 1 : 0,
            show_summary: document.getElementById('tpl-show-summary').checked ? 1 : 0,
            show_aging_report: document.getElementById('tpl-show-aging-report').checked ? 1 : 0,
            show_statement_table: document.getElementById('tpl-show-statement-table').checked ? 1 : 0,
            show_balance: document.getElementById('tpl-show-balance').checked ? 1 : 0,
            header_text: document.getElementById('tpl-header-text').value,
            footer_text: document.getElementById('tpl-footer-text').value,
            custom_css: document.getElementById('tpl-custom-css').value
        };
    }

    window.saveTemplate = function() {
        var data = collectData();

        var btn = document.getElementById('btn-save');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=saveTemplate',
            type: 'POST',
            data: data,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                    if (response.data && response.data.id) {
                        document.getElementById('template-id').value = response.data.id;
                    }
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to save template', 'error');
            }
        });
    };

    window.previewTemplate = function() {
        var data = collectData();
        var qs = '&ajax=downloadPdf&preview=1';
        for (var key in data) {
            if (data[key] !== null && data[key] !== '') {
                qs += '&template_' + key + '=' + encodeURIComponent(data[key]);
            }
        }
        window.open(ajaxUrl + qs, '_blank');
    };
});
</script>
{/literal}
