<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-cog"></i> {$meta.lang['Settings']}</h1>
    </div>
</div>

<div id="settings-loading" class="text-center" style="padding:40px 0;">
    <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
</div>

<div id="settings-content" style="display:none;">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-sliders-h"></i> {$meta.lang['General']}</h3></div>
                <div class="panel-body">
                    <div class="checkbox">
                        <label><input type="checkbox" id="setting-enable-client-area"> {$meta.lang['Enable Client Area']}</label>
                        <p class="help-block">{$meta.lang['Allow clients to view and generate their own statements']}</p>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" id="setting-add-billing-menu"> {$meta.lang['Add to Billing Menu']}</label>
                        <p class="help-block">{$meta.lang['Show Account Statement link in client billing menu']}</p>
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-check-square"></i> {$meta.lang['Defaults']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Default Date Range']}</label>
                        <select class="form-control" id="setting-default-date-range">
                            <option value="this_month">{$meta.lang['This Month']}</option>
                            <option value="last_month">{$meta.lang['Last Month']}</option>
                            <option value="this_quarter">{$meta.lang['This Quarter']}</option>
                            <option value="last_quarter">{$meta.lang['Last Quarter']}</option>
                            <option value="this_year">{$meta.lang['This Year']}</option>
                            <option value="last_year">{$meta.lang['Last Year']}</option>
                        </select>
                    </div>
                    <hr>
                    <label>{$meta.lang['Default Include Options']}</label>
                    <div class="checkbox"><label><input type="checkbox" id="setting-default-paid" checked> {$meta.lang['Paid']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="setting-default-unpaid" checked> {$meta.lang['Unpaid']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="setting-default-refunded" checked> {$meta.lang['Refunded']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="setting-default-transactions" checked> {$meta.lang['Transactions']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="setting-default-credits" checked> {$meta.lang['Credits']}</label></div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-user"></i> {$meta.lang['Client Area']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Client Area URL']}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="client-area-url" value="{$meta.before_path}/index.php?m=puq_account_statement" readonly>
                            <span class="input-group-btn">
                                <button class="btn btn-default" type="button" onclick="copyClientAreaUrl()"><i class="fa fa-copy"></i></button>
                            </span>
                        </div>
                        <p class="help-block">{$meta.lang['Direct link to the client area statement page']}</p>
                    </div>
                    <hr>
                    <div class="checkbox">
                        <label><input type="checkbox" id="setting-client-download-pdf"> {$meta.lang['Client Can Download PDF']}</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" id="setting-client-download-csv"> {$meta.lang['Client Can Download CSV']}</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" id="setting-client-download-xlsx"> {$meta.lang['Client Can Download XLSX']}</label>
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-wrench"></i> {$meta.lang['Advanced']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Statement Expiry Days']}</label>
                        <input type="number" class="form-control" id="setting-expiry-days" min="0" value="30">
                        <p class="help-block">{$meta.lang['Number of days before shared statement links expire. 0 = never']}</p>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Auto Cleanup Days']}</label>
                        <input type="number" class="form-control" id="setting-cleanup-days" min="0" value="90">
                        <p class="help-block">{$meta.lang['Auto-delete saved statements older than X days. 0 = disabled']}</p>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Per Page']}</label>
                        <input type="number" class="form-control" id="setting-per-page" min="5" max="100" value="25">
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" id="setting-show-aging-report"> {$meta.lang['Show Aging Report']}</label>
                        <p class="help-block">{$meta.lang['Display aging report section in statements by default']}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success btn-lg" id="btn-save-settings" onclick="saveSettings()" style="min-width:200px;">
                <i class="fa fa-save"></i> {$meta.lang['Save Settings']}
            </button>
        </div>
    </div>
</div>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';

    // Load settings
    jQuery.ajax({
        url: ajaxUrl + '&ajax=getSettings',
        type: 'GET',
        dataType: 'json',
        success: function(r) {
            document.getElementById('settings-loading').style.display = 'none';
            document.getElementById('settings-content').style.display = 'block';

            if (!r.success) return;
            var s = r.data.settings || r.data;

            document.getElementById('setting-enable-client-area').checked = s.enable_client_area === '1' || s.enable_client_area === true || s.enable_client_area === 1;
            document.getElementById('setting-add-billing-menu').checked = s.add_billing_menu_item === '1' || s.add_billing_menu_item === true || s.add_billing_menu_item === 1;
            document.getElementById('setting-default-date-range').value = s.default_date_range || 'this_month';
            document.getElementById('setting-default-paid').checked = s.default_include_paid !== '0' && s.default_include_paid !== false && s.default_include_paid !== 0;
            document.getElementById('setting-default-unpaid').checked = s.default_include_unpaid !== '0' && s.default_include_unpaid !== false && s.default_include_unpaid !== 0;
            document.getElementById('setting-default-refunded').checked = s.default_include_refunded !== '0' && s.default_include_refunded !== false && s.default_include_refunded !== 0;
            document.getElementById('setting-default-transactions').checked = s.default_include_transactions !== '0' && s.default_include_transactions !== false && s.default_include_transactions !== 0;
            document.getElementById('setting-default-credits').checked = s.default_include_credits !== '0' && s.default_include_credits !== false && s.default_include_credits !== 0;
            document.getElementById('setting-client-download-pdf').checked = s.client_can_download_pdf === '1' || s.client_can_download_pdf === true || s.client_can_download_pdf === 1;
            document.getElementById('setting-client-download-csv').checked = s.client_can_download_csv === '1' || s.client_can_download_csv === true || s.client_can_download_csv === 1;
            document.getElementById('setting-client-download-xlsx').checked = s.client_can_download_xlsx === '1' || s.client_can_download_xlsx === true || s.client_can_download_xlsx === 1;
            document.getElementById('setting-expiry-days').value = s.statement_expiry_days || 30;
            document.getElementById('setting-cleanup-days').value = s.auto_cleanup_days || 90;
            document.getElementById('setting-per-page').value = s.per_page || 25;
            document.getElementById('setting-show-aging-report').checked = s.show_aging_report === '1' || s.show_aging_report === true || s.show_aging_report === 1;
        }
    });

    window.copyClientAreaUrl = function() {
        var urlField = document.getElementById('client-area-url');
        urlField.select();
        document.execCommand('copy');
        showNotification('{/literal}{$meta.lang['Copied to clipboard']}{literal}', 'success');
    };

    window.saveSettings = function() {
        var data = {
            enable_client_area: document.getElementById('setting-enable-client-area').checked ? '1' : '0',
            add_billing_menu_item: document.getElementById('setting-add-billing-menu').checked ? '1' : '0',
            default_date_range: document.getElementById('setting-default-date-range').value,
            default_include_paid: document.getElementById('setting-default-paid').checked ? '1' : '0',
            default_include_unpaid: document.getElementById('setting-default-unpaid').checked ? '1' : '0',
            default_include_refunded: document.getElementById('setting-default-refunded').checked ? '1' : '0',
            default_include_transactions: document.getElementById('setting-default-transactions').checked ? '1' : '0',
            default_include_credits: document.getElementById('setting-default-credits').checked ? '1' : '0',
            client_can_download_pdf: document.getElementById('setting-client-download-pdf').checked ? '1' : '0',
            client_can_download_csv: document.getElementById('setting-client-download-csv').checked ? '1' : '0',
            client_can_download_xlsx: document.getElementById('setting-client-download-xlsx').checked ? '1' : '0',
            statement_expiry_days: document.getElementById('setting-expiry-days').value,
            auto_cleanup_days: document.getElementById('setting-cleanup-days').value,
            per_page: document.getElementById('setting-per-page').value,
            show_aging_report: document.getElementById('setting-show-aging-report').checked ? '1' : '0'
        };

        var btn = document.getElementById('btn-save-settings');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=saveSettings',
            type: 'POST',
            data: data,
            dataType: 'json',
            success: function(r) {
                btnReset(btn);
                if (r.success) showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                else showNotification(r.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to save settings', 'error');
            }
        });
    };
});
</script>
{/literal}
