<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-clock"></i> {$meta.lang['Schedules']}</h1>
    </div>
</div>

<div class="row" style="margin-top:10px;">
    <div class="col-md-12">
        <a href="{$meta.admin_module_url}&page=schedule_edit" class="btn btn-success"><i class="fa fa-plus"></i> {$meta.lang['Add New']}</a>
    </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
        <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
        <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
    </div>
    <div class="col-md-12" id="schedules-container" style="display:none;"></div>
</div>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    function loadSchedules() {
        jQuery.ajax({
            url: ajaxUrl + '&ajax=getSchedules',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('main-loading').style.display = 'none';
                document.getElementById('schedules-container').style.display = 'block';

                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }

                renderSchedules(response.data.schedules);
            },
            error: function() {
                document.getElementById('main-loading').style.display = 'none';
                showNotification('Failed to load schedules', 'error');
            }
        });
    }

    function renderSchedules(schedules) {
        var container = document.getElementById('schedules-container');

        if (!schedules || schedules.length === 0) {
            container.innerHTML = '<p class="text-muted text-center" style="padding:40px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
            return;
        }

        var html = '<table class="table table-striped table-hover">';
        html += '<thead><tr>';
        html += '<th>{/literal}{$meta.lang['Name']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Frequency']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Client Filter']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Next Run']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Last Run']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Status']}{literal}</th>';
        html += '<th style="width:200px;">{/literal}{$meta.lang['Actions']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < schedules.length; i++) {
            var s = schedules[i];
            var statusBadge = s.is_active ? '<span class="label label-success">{/literal}{$meta.lang['Active']}{literal}</span>' : '<span class="label label-default">{/literal}{$meta.lang['Inactive']}{literal}</span>';

            html += '<tr>';
            html += '<td><strong>' + escapeHtml(s.name) + '</strong></td>';
            html += '<td>' + escapeHtml(s.frequency) + '</td>';
            html += '<td>' + escapeHtml(s.client_filter) + (s.filter_value ? ' (' + escapeHtml(s.filter_value) + ')' : '') + '</td>';
            html += '<td><small>' + escapeHtml(s.next_run || '-') + '</small></td>';
            html += '<td><small>' + escapeHtml(s.last_run || '-') + '</small></td>';
            html += '<td>' + statusBadge + '</td>';
            html += '<td>';
            html += '<a href="' + ajaxUrl + '&page=schedule_edit&id=' + s.id + '" class="btn btn-xs btn-primary" title="{/literal}{$meta.lang['Edit']}{literal}"><i class="fa fa-edit"></i></a> ';
            html += '<button class="btn btn-xs btn-warning" id="btn-run-' + s.id + '" onclick="runNow(' + s.id + ')" title="{/literal}{$meta.lang['Run Now']}{literal}"><i class="fa fa-play"></i></button> ';
            html += '<button class="btn btn-xs btn-' + (s.is_active ? 'default' : 'success') + '" id="btn-toggle-' + s.id + '" onclick="toggleSchedule(' + s.id + ')" title="{/literal}{$meta.lang['Toggle']}{literal}"><i class="fa fa-power-off"></i></button> ';
            html += '<button class="btn btn-xs btn-danger" onclick="deleteSchedule(' + s.id + ', \'' + escapeHtml(s.name).replace(/'/g, "\\'") + '\')" title="{/literal}{$meta.lang['Delete']}{literal}"><i class="fa fa-trash"></i></button>';
            html += '</td>';
            html += '</tr>';
        }

        html += '</tbody></table>';
        container.innerHTML = html;
    }

    window.runNow = function(id) {
        var btn = document.getElementById('btn-run-' + id);
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=runScheduleNow',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Schedule executed successfully']}{literal}', 'success');
                    loadSchedules();
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to run schedule', 'error');
            }
        });
    };

    window.toggleSchedule = function(id) {
        var btn = document.getElementById('btn-toggle-' + id);
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=toggleSchedule',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Schedule toggled']}{literal}', 'success');
                    loadSchedules();
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to toggle schedule', 'error');
            }
        });
    };

    window.deleteSchedule = function(id, name) {
        if (!confirm('{/literal}{$meta.lang['Confirm Delete']}{literal}')) return;

        jQuery.ajax({
            url: ajaxUrl + '&ajax=deleteSchedule',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Deleted successfully']}{literal}', 'success');
                    loadSchedules();
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            }
        });
    };

    loadSchedules();
});
</script>
{/literal}
