<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-clock"></i> <span id="page-title">{$meta.lang['Add Schedule']}</span></h1>
    </div>
</div>

<div id="edit-loading" class="text-center" style="padding:40px 0; display:none;">
    <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
    <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
</div>

<div id="edit-content" style="margin-top:15px;">
    <input type="hidden" id="schedule-id" value="">

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-cog"></i> {$meta.lang['General']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Name']}</label>
                        <input type="text" class="form-control" id="schedule-name" placeholder="{$meta.lang['Schedule name']}">
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Frequency']}</label>
                        <select class="form-control" id="schedule-frequency">
                            <option value="daily">{$meta.lang['Daily']}</option>
                            <option value="weekly">{$meta.lang['Weekly']}</option>
                            <option value="monthly" selected>{$meta.lang['Monthly']}</option>
                            <option value="quarterly">{$meta.lang['Quarterly']}</option>
                            <option value="yearly">{$meta.lang['Yearly']}</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>{$meta.lang['Period Type']}</label>
                        <select class="form-control" id="schedule-period-type">
                            <option value="last_month">{$meta.lang['Last Month']}</option>
                            <option value="last_quarter">{$meta.lang['Last Quarter']}</option>
                            <option value="last_year">{$meta.lang['Last Year']}</option>
                            <option value="custom">{$meta.lang['Custom']}</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-users"></i> {$meta.lang['Client Filter']}</h3></div>
                <div class="panel-body">
                    <div class="form-group">
                        <label>{$meta.lang['Filter Type']}</label>
                        <select class="form-control" id="schedule-client-filter">
                            <option value="all">{$meta.lang['All Clients']}</option>
                            <option value="group">{$meta.lang['By Client Group']}</option>
                            <option value="country">{$meta.lang['By Country']}</option>
                            <option value="unpaid">{$meta.lang['With Unpaid Invoices']}</option>
                        </select>
                    </div>
                    <div class="form-group" id="client-filter-value-group" style="display:none;">
                        <label>{$meta.lang['Filter Value']}</label>
                        <input type="text" class="form-control" id="schedule-filter-value">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-filter"></i> {$meta.lang['Include Options']}</h3></div>
                <div class="panel-body">
                    <div class="checkbox"><label><input type="checkbox" id="schedule-include-paid" checked> {$meta.lang['Paid']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="schedule-include-unpaid" checked> {$meta.lang['Unpaid']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="schedule-include-refunded" checked> {$meta.lang['Refunded']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="schedule-include-transactions" checked> {$meta.lang['Transactions']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="schedule-include-credits" checked> {$meta.lang['Credits']}</label></div>

                    <hr>

                    <div class="form-group">
                        <label>{$meta.lang['Payment Methods']}</label>
                        <select class="form-control" id="schedule-gateways" multiple size="4">
                        </select>
                        <small class="text-muted">{$meta.lang['Leave empty for all']}</small>
                    </div>

                    <div class="form-group">
                        <label>{$meta.lang['Product Groups']}</label>
                        <select class="form-control" id="schedule-product-groups" multiple size="4">
                        </select>
                        <small class="text-muted">{$meta.lang['Leave empty for all']}</small>
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-paper-plane"></i> {$meta.lang['Output']}</h3></div>
                <div class="panel-body">
                    <div class="checkbox"><label><input type="checkbox" id="schedule-save-archive" checked> {$meta.lang['Save to Archive']}</label></div>
                    <div class="checkbox"><label><input type="checkbox" id="schedule-send-email"> {$meta.lang['Send Email']}</label></div>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success btn-lg" id="btn-save" onclick="saveSchedule()" style="min-width:200px;">
                <i class="fa fa-save"></i> {$meta.lang['Save Schedule']}
            </button>
            <a href="{$meta.admin_module_url}&page=schedules" class="btn btn-default btn-lg"><i class="fa fa-arrow-left"></i> {$meta.lang['Cancel']}</a>
        </div>
    </div>
</div>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var urlParams = new URLSearchParams(window.location.search);
    var scheduleId = urlParams.get('id');

    // Client filter change
    document.getElementById('schedule-client-filter').addEventListener('change', function() {
        var val = this.value;
        document.getElementById('client-filter-value-group').style.display = (val === 'group' || val === 'country') ? 'block' : 'none';
    });

    // Load gateways
    jQuery.ajax({
        url: ajaxUrl + '&ajax=getGateways',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                var sel = document.getElementById('schedule-gateways');
                for (var i = 0; i < response.data.length; i++) {
                    var opt = document.createElement('option');
                    opt.value = response.data[i].module;
                    opt.textContent = response.data[i].name;
                    sel.appendChild(opt);
                }
            }
        }
    });

    // Load product groups
    jQuery.ajax({
        url: ajaxUrl + '&ajax=getProductGroups',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                var sel = document.getElementById('schedule-product-groups');
                for (var i = 0; i < response.data.length; i++) {
                    var opt = document.createElement('option');
                    opt.value = response.data[i].id;
                    opt.textContent = response.data[i].name;
                    sel.appendChild(opt);
                }
            }
        }
    });

    // If editing, load existing schedule
    if (scheduleId) {
        document.getElementById('page-title').textContent = '{/literal}{$meta.lang['Edit Schedule']}{literal}';
        document.getElementById('edit-loading').style.display = 'block';
        document.getElementById('edit-content').style.display = 'none';

        jQuery.ajax({
            url: ajaxUrl + '&ajax=getSchedule&id=' + scheduleId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('edit-loading').style.display = 'none';
                document.getElementById('edit-content').style.display = 'block';

                if (!response.success || !response.data) {
                    showNotification(response.error || 'Schedule not found', 'error');
                    return;
                }

                var s = response.data;
                document.getElementById('schedule-id').value = s.id;
                document.getElementById('schedule-name').value = s.name || '';
                document.getElementById('schedule-frequency').value = s.frequency || 'monthly';
                document.getElementById('schedule-period-type').value = s.period_type || 'last_month';
                document.getElementById('schedule-client-filter').value = s.client_filter || 'all';

                if (s.client_filter === 'group' || s.client_filter === 'country') {
                    document.getElementById('client-filter-value-group').style.display = 'block';
                    document.getElementById('schedule-filter-value').value = s.filter_value || '';
                }

                document.getElementById('schedule-include-paid').checked = s.include_paid !== false && s.include_paid !== 0;
                document.getElementById('schedule-include-unpaid').checked = s.include_unpaid !== false && s.include_unpaid !== 0;
                document.getElementById('schedule-include-refunded').checked = s.include_refunded !== false && s.include_refunded !== 0;
                document.getElementById('schedule-include-transactions').checked = s.include_transactions !== false && s.include_transactions !== 0;
                document.getElementById('schedule-include-credits').checked = s.include_credits !== false && s.include_credits !== 0;

                document.getElementById('schedule-save-archive').checked = s.save_archive !== false && s.save_archive !== 0;
                document.getElementById('schedule-send-email').checked = s.send_email === true || s.send_email === 1;

                // Set multi-select values after options are loaded
                setTimeout(function() {
                    if (s.gateways && Array.isArray(s.gateways)) {
                        var gSel = document.getElementById('schedule-gateways');
                        for (var i = 0; i < gSel.options.length; i++) {
                            if (s.gateways.indexOf(gSel.options[i].value) !== -1) gSel.options[i].selected = true;
                        }
                    }
                    if (s.product_groups && Array.isArray(s.product_groups)) {
                        var pSel = document.getElementById('schedule-product-groups');
                        for (var i = 0; i < pSel.options.length; i++) {
                            if (s.product_groups.indexOf(parseInt(pSel.options[i].value)) !== -1) pSel.options[i].selected = true;
                        }
                    }
                }, 1000);
            },
            error: function() {
                document.getElementById('edit-loading').innerHTML = '<p class="text-danger">Failed to load schedule</p>';
            }
        });
    }

    // Save
    window.saveSchedule = function() {
        var data = {
            id: document.getElementById('schedule-id').value || null,
            name: document.getElementById('schedule-name').value,
            frequency: document.getElementById('schedule-frequency').value,
            period_type: document.getElementById('schedule-period-type').value,
            client_filter: document.getElementById('schedule-client-filter').value,
            filter_value: document.getElementById('schedule-filter-value').value,
            include_paid: document.getElementById('schedule-include-paid').checked ? 1 : 0,
            include_unpaid: document.getElementById('schedule-include-unpaid').checked ? 1 : 0,
            include_refunded: document.getElementById('schedule-include-refunded').checked ? 1 : 0,
            include_transactions: document.getElementById('schedule-include-transactions').checked ? 1 : 0,
            include_credits: document.getElementById('schedule-include-credits').checked ? 1 : 0,
            save_archive: document.getElementById('schedule-save-archive').checked ? 1 : 0,
            send_email: document.getElementById('schedule-send-email').checked ? 1 : 0
        };

        // Collect multi-selects
        var gSel = document.getElementById('schedule-gateways');
        var gateways = [];
        for (var i = 0; i < gSel.options.length; i++) {
            if (gSel.options[i].selected) gateways.push(gSel.options[i].value);
        }
        data.gateways = gateways;

        var pSel = document.getElementById('schedule-product-groups');
        var pGroups = [];
        for (var i = 0; i < pSel.options.length; i++) {
            if (pSel.options[i].selected) pGroups.push(parseInt(pSel.options[i].value));
        }
        data.product_groups = pGroups;

        if (!data.name) {
            showNotification('{/literal}{$meta.lang['Name is required']}{literal}', 'error');
            return;
        }

        var btn = document.getElementById('btn-save');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=saveSchedule',
            type: 'POST',
            data: data,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                    if (!scheduleId && response.data && response.data.id) {
                        window.location.href = ajaxUrl + '&page=schedule_edit&id=' + response.data.id;
                    }
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to save schedule', 'error');
            }
        });
    };
});
</script>
{/literal}
