
<style>
    .license-block {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
        background: #ffffff;
        padding: 40px 20px;
    }

    .license-container {
        text-align: center;
        z-index: 10;
        position: relative;
    }

    .license-icon-wrapper {
        margin-bottom: 30px;
    }

    .license-icon {
        font-size: 140px;
        color: #d9534f;
        position: relative;
        text-shadow: 0 0 20px rgba(217, 83, 79, 0.3);
        animation: license-pulse 2s ease-in-out infinite;
        line-height: 1;
    }

    @keyframes license-pulse {
        0%, 100% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.05); opacity: 0.85; }
    }

    .license-title { font-size: 48px; color: #2d3748; margin: 20px 0; font-weight: 700; }
    .license-description { font-size: 18px; color: #718096; margin-bottom: 15px; max-width: 600px; margin-left: auto; margin-right: auto; }
    .license-hint { font-size: 14px; color: #a0aec0; margin-bottom: 40px; }

    .btn-license {
        display: inline-block; padding: 15px 40px; background: #d9534f; color: #fff;
        text-decoration: none; border-radius: 50px; font-size: 16px; font-weight: 600;
        border: none; transition: all 0.3s ease; box-shadow: 0 4px 15px rgba(217, 83, 79, 0.3); margin: 0 8px;
    }
    .btn-license:hover { background: #c9302c; transform: translateY(-2px); box-shadow: 0 6px 20px rgba(217, 83, 79, 0.4); color: #fff; text-decoration: none; }
    .btn-license i { margin-right: 8px; }

    .btn-home-link {
        display: inline-block; padding: 15px 40px; background: #667eea; color: #fff;
        text-decoration: none; border-radius: 50px; font-size: 16px; font-weight: 600;
        border: none; transition: all 0.3s ease; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3); margin: 0 8px;
    }
    .btn-home-link:hover { background: #5568d3; transform: translateY(-2px); box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4); color: #fff; text-decoration: none; }
    .btn-home-link i { margin-right: 8px; }

    .license-floating-particles { position: absolute; width: 100%; height: 100%; overflow: hidden; top: 0; left: 0; pointer-events: none; }
    .license-floating-particles span { position: absolute; display: block; width: 20px; height: 20px; background: rgba(217, 83, 79, 0.1); bottom: -150px; animation: license-float 25s infinite; border-radius: 50%; }
    .license-floating-particles span:nth-child(1) { left: 10%; width: 80px; height: 80px; animation-delay: 0s; animation-duration: 20s; background: rgba(217, 83, 79, 0.08); }
    .license-floating-particles span:nth-child(2) { left: 20%; width: 40px; height: 40px; animation-delay: 2s; animation-duration: 15s; background: rgba(240, 173, 78, 0.08); }
    .license-floating-particles span:nth-child(3) { left: 35%; width: 60px; height: 60px; animation-delay: 4s; animation-duration: 18s; background: rgba(217, 83, 79, 0.08); }
    .license-floating-particles span:nth-child(4) { left: 50%; width: 30px; height: 30px; animation-delay: 6s; animation-duration: 22s; background: rgba(240, 173, 78, 0.08); }
    .license-floating-particles span:nth-child(5) { left: 65%; width: 70px; height: 70px; animation-delay: 8s; animation-duration: 17s; background: rgba(217, 83, 79, 0.08); }
    .license-floating-particles span:nth-child(6) { left: 75%; width: 50px; height: 50px; animation-delay: 10s; animation-duration: 19s; background: rgba(240, 173, 78, 0.08); }
    .license-floating-particles span:nth-child(7) { left: 85%; width: 35px; height: 35px; animation-delay: 12s; animation-duration: 21s; background: rgba(217, 83, 79, 0.08); }
    .license-floating-particles span:nth-child(8) { left: 5%; width: 45px; height: 45px; animation-delay: 14s; animation-duration: 16s; background: rgba(240, 173, 78, 0.08); }
    .license-floating-particles span:nth-child(9) { left: 45%; width: 55px; height: 55px; animation-delay: 16s; animation-duration: 23s; background: rgba(217, 83, 79, 0.08); }
    .license-floating-particles span:nth-child(10) { left: 90%; width: 65px; height: 65px; animation-delay: 18s; animation-duration: 20s; background: rgba(240, 173, 78, 0.08); }

    @keyframes license-float {
        0% { transform: translateY(0) rotate(0deg); opacity: 1; }
        100% { transform: translateY(-1000px) rotate(720deg); opacity: 0; }
    }

    @media (max-width: 768px) {
        .license-icon { font-size: 100px; }
        .license-title { font-size: 32px; }
        .license-description { font-size: 16px; padding: 0 20px; }
    }
</style>

<div class="license-block">
    <div class="license-container">
        <div class="license-icon-wrapper">
            <div class="license-icon"><i class="fa fa-lock"></i></div>
        </div>
        <h1 class="license-title">{$meta.lang['License Required']}</h1>
        <p class="license-description">{$meta.lang['License required page description']}</p>
        <p class="license-hint">{$meta.lang['License required page hint']}</p>
        <div>
            <a href="{$meta.url_purchase_license}" target="_blank" class="btn-license">
                <i class="fa fa-shopping-cart"></i> {$meta.lang['Purchase License']}
            </a>
            <a href="{$meta.admin_module_url}&page=home" class="btn-home-link">
                <i class="fa fa-home"></i> {$meta.lang['Home']}
            </a>
        </div>
    </div>
    <div class="license-floating-particles">
        <span></span><span></span><span></span><span></span><span></span>
        <span></span><span></span><span></span><span></span><span></span>
    </div>
</div>
