<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-tachometer-alt"></i> {$meta.lang['Dashboard']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="dash-counts"></div>
    <div id="dash-quick-generate"></div>
    <div id="dash-recent"></div>
    <div id="dash-schedules"></div>
</div>

<style>
    .dash-stat { text-align: center; padding: 18px 10px; }
    .dash-stat-value { font-size: 32px; font-weight: bold; line-height: 1.1; }
    .dash-stat-label { margin-top: 6px; color: #888; font-size: 13px; }
</style>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getDashboard';
    var moduleUrl = '{/literal}{$meta.admin_module_url}{literal}';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';

            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }

            var d = response.data;
            renderCounts(d);
            renderQuickGenerate();
            renderRecentStatements(d.recent_statements);
            renderUpcomingSchedules(d.upcoming_schedules);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load dashboard data', 'error');
        }
    });

    function renderCounts(d) {
        var cards = [
            { value: d.this_month_statements || 0, label: '{/literal}{$meta.lang['This Month Statements']}{literal}', icon: 'fa-file-alt', color: '#337ab7' },
            { value: d.total_statements || 0, label: '{/literal}{$meta.lang['Total Statements']}{literal}', icon: 'fa-archive', color: '#5cb85c' },
            { value: d.active_schedules || 0, label: '{/literal}{$meta.lang['Active Schedules']}{literal}', icon: 'fa-clock', color: '#f0ad4e' },
            { value: d.next_scheduled_run || '-', label: '{/literal}{$meta.lang['Next Scheduled Run']}{literal}', icon: 'fa-calendar', color: '#5bc0de' }
        ];

        var html = '<div class="row" style="margin-top:10px;">';
        for (var i = 0; i < cards.length; i++) {
            var c = cards[i];
            html += '<div class="col-lg-3 col-md-6 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid ' + c.color + ';">';
            html += '<div class="dash-stat">';
            html += '<div class="dash-stat-value" style="color:' + c.color + ';">' + c.value + '</div>';
            html += '<div class="dash-stat-label"><i class="fa ' + c.icon + '"></i> ' + c.label + '</div>';
            html += '</div></div></div>';
        }
        html += '</div>';
        document.getElementById('dash-counts').innerHTML = html;
    }

    function renderQuickGenerate() {
        var html = '<div class="row" style="margin-top:5px;">';
        html += '<div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-bolt"></i> {/literal}{$meta.lang['Quick Generate']}{literal}</h3></div>';
        html += '<div class="panel-body">';
        html += '<div class="row">';
        html += '<div class="col-md-8">';
        html += '<div class="input-group">';
        html += '<input type="text" class="form-control" id="quick-client-search" placeholder="{/literal}{$meta.lang['Search client by name or email...']}{literal}">';
        html += '<span class="input-group-btn">';
        html += '<button class="btn btn-primary" id="btn-quick-generate" onclick="quickGenerate()"><i class="fa fa-file-alt"></i> {/literal}{$meta.lang['Generate']}{literal}</button>';
        html += '</span>';
        html += '</div>';
        html += '</div>';
        html += '</div>';
        html += '</div></div></div></div>';
        document.getElementById('dash-quick-generate').innerHTML = html;

        if (typeof jQuery.fn.select2 !== 'undefined') {
            jQuery('#quick-client-search').select2({
                ajax: {
                    url: moduleUrl + '&ajax=searchClients',
                    dataType: 'json',
                    delay: 300,
                    data: function(params) { return { q: params.term }; },
                    processResults: function(data) {
                        return { results: data.data || [] };
                    }
                },
                minimumInputLength: 2,
                placeholder: '{/literal}{$meta.lang['Search client by name or email...']}{literal}',
                allowClear: true
            });
        }
    }

    window.quickGenerate = function() {
        var clientId = jQuery('#quick-client-search').val();
        if (!clientId) {
            showNotification('{/literal}{$meta.lang['Please select a client']}{literal}', 'error');
            return;
        }
        window.location.href = moduleUrl + '&page=generate&client_id=' + clientId;
    };

    function renderRecentStatements(statements) {
        var html = '<div class="row" style="margin-top:5px;">';
        html += '<div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-history"></i> {/literal}{$meta.lang['Recent Statements']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (statements && statements.length > 0) {
            html += '<table class="table table-striped table-condensed">';
            html += '<thead><tr>';
            html += '<th>{/literal}{$meta.lang['Date']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Client']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Period']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Generated By']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Actions']}{literal}</th>';
            html += '</tr></thead><tbody>';

            for (var i = 0; i < statements.length && i < 10; i++) {
                var s = statements[i];
                html += '<tr>';
                html += '<td><small>' + escapeHtml(s.created_at) + '</small></td>';
                html += '<td>' + escapeHtml(s.client_name) + '</td>';
                html += '<td><small>' + escapeHtml(s.period_from) + ' - ' + escapeHtml(s.period_to) + '</small></td>';
                html += '<td>' + escapeHtml(s.generated_by) + '</td>';
                html += '<td><a href="' + moduleUrl + '&page=saved&view=' + s.id + '" class="btn btn-xs btn-primary"><i class="fa fa-eye"></i> {/literal}{$meta.lang['View']}{literal}</a></td>';
                html += '</tr>';
            }
            html += '</tbody></table>';
        } else {
            html += '<p class="text-muted text-center" style="padding:20px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div></div>';
        document.getElementById('dash-recent').innerHTML = html;
    }

    function renderUpcomingSchedules(schedules) {
        var html = '<div class="row" style="margin-top:5px;">';
        html += '<div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-calendar-alt"></i> {/literal}{$meta.lang['Upcoming Schedules']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (schedules && schedules.length > 0) {
            html += '<table class="table table-striped table-condensed">';
            html += '<thead><tr>';
            html += '<th>{/literal}{$meta.lang['Name']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Frequency']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Next Run']}{literal}</th>';
            html += '<th>{/literal}{$meta.lang['Status']}{literal}</th>';
            html += '</tr></thead><tbody>';

            for (var i = 0; i < schedules.length && i < 5; i++) {
                var sc = schedules[i];
                var statusBadge = sc.is_active ? '<span class="label label-success">{/literal}{$meta.lang['Active']}{literal}</span>' : '<span class="label label-default">{/literal}{$meta.lang['Inactive']}{literal}</span>';
                html += '<tr>';
                html += '<td>' + escapeHtml(sc.name) + '</td>';
                html += '<td>' + escapeHtml(sc.frequency) + '</td>';
                html += '<td><small>' + escapeHtml(sc.next_run) + '</small></td>';
                html += '<td>' + statusBadge + '</td>';
                html += '</tr>';
            }
            html += '</tbody></table>';
        } else {
            html += '<p class="text-muted text-center" style="padding:20px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div></div>';
        document.getElementById('dash-schedules').innerHTML = html;
    }
});
</script>
{/literal}
