<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-file-alt"></i> {$meta.lang['Generate']}</h1>
    </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-filter"></i> {$meta.lang['Statement Parameters']}</h3></div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{$meta.lang['Client']}</label>
                            <select class="form-control" id="client_search" style="width:100%;"></select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{$meta.lang['Date From']}</label>
                            <input type="date" class="form-control" id="date_from">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{$meta.lang['Date To']}</label>
                            <input type="date" class="form-control" id="date_to">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <label>{$meta.lang['Quick Period']}</label>
                        <div class="btn-group" style="margin-bottom:15px;">
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('this_month')">{$meta.lang['This Month']}</button>
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('last_month')">{$meta.lang['Last Month']}</button>
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('this_year')">{$meta.lang['This Year']}</button>
                            <button type="button" class="btn btn-default btn-sm" onclick="setQuickPeriod('last_year')">{$meta.lang['Last Year']}</button>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <label>{$meta.lang['Include']}</label>
                        <div style="margin-bottom:15px;">
                            <label class="checkbox-inline"><input type="checkbox" id="include_paid" checked> {$meta.lang['Paid']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_unpaid" checked> {$meta.lang['Unpaid']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_refunded" checked> {$meta.lang['Refunded']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_transactions" checked> {$meta.lang['Transactions']}</label>
                            <label class="checkbox-inline"><input type="checkbox" id="include_credits" checked> {$meta.lang['Credits']}</label>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{$meta.lang['Payment Methods']}</label>
                            <select class="form-control" id="payment_methods" multiple size="4">
                            </select>
                            <small class="text-muted">{$meta.lang['Leave empty for all']}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{$meta.lang['Product Groups']}</label>
                            <select class="form-control" id="product_groups" multiple size="4">
                            </select>
                            <small class="text-muted">{$meta.lang['Leave empty for all']}</small>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-primary" id="btn-view-statement" onclick="viewStatement()"><i class="fa fa-eye"></i> {$meta.lang['View Statement']}</button>
                        <button class="btn btn-info" id="btn-download-pdf" onclick="downloadPdf()"><i class="fa fa-file-pdf"></i> {$meta.lang['Download PDF']}</button>
                        <button class="btn btn-default" id="btn-download-csv" onclick="downloadCsv()"><i class="fa fa-file-csv"></i> {$meta.lang['Download CSV']}</button>
                        <button class="btn btn-default" id="btn-download-xlsx" onclick="downloadXlsx()"><i class="fa fa-file-excel"></i> {$meta.lang['Download XLSX']}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row" style="margin-top:10px; display:none;" id="statement-results">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title" style="display:inline-block;"><i class="fa fa-file-alt"></i> {$meta.lang['Statement Preview']}</h3>
                <div class="pull-right">
                    <button class="btn btn-success btn-xs" id="btn-save-archive" onclick="saveToArchive()"><i class="fa fa-archive"></i> {$meta.lang['Save to Archive']}</button>
                    <button class="btn btn-info btn-xs" id="btn-send-client" onclick="sendToClient()"><i class="fa fa-envelope"></i> {$meta.lang['Send to Client']}</button>
                    <button class="btn btn-default btn-xs" id="btn-generate-link" onclick="generateLink()"><i class="fa fa-link"></i> {$meta.lang['Generate Link']}</button>
                </div>
            </div>
            <div class="panel-body" id="statement-html">
            </div>
        </div>
    </div>
</div>

{literal}
<script>
(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';

    function formatDate(d) {
        var m = ('0' + (d.getMonth() + 1)).slice(-2);
        var day = ('0' + d.getDate()).slice(-2);
        return d.getFullYear() + '-' + m + '-' + day;
    }

    function collectParams() {
        var clientId = jQuery('#client_search').val();
        if (!clientId) {
            showNotification('{/literal}{$meta.lang['Please select a client']}{literal}', 'error');
            return null;
        }

        var params = {
            client_id: clientId,
            date_from: document.getElementById('date_from').value,
            date_to: document.getElementById('date_to').value,
            include_paid: document.getElementById('include_paid').checked ? 1 : 0,
            include_unpaid: document.getElementById('include_unpaid').checked ? 1 : 0,
            include_refunded: document.getElementById('include_refunded').checked ? 1 : 0,
            include_transactions: document.getElementById('include_transactions').checked ? 1 : 0,
            include_credits: document.getElementById('include_credits').checked ? 1 : 0
        };

        var pmSel = document.getElementById('payment_methods');
        var pmVals = [];
        for (var i = 0; i < pmSel.options.length; i++) {
            if (pmSel.options[i].selected) pmVals.push(pmSel.options[i].value);
        }
        if (pmVals.length > 0) params.payment_methods = pmVals;

        var pgSel = document.getElementById('product_groups');
        var pgVals = [];
        for (var i = 0; i < pgSel.options.length; i++) {
            if (pgSel.options[i].selected) pgVals.push(pgSel.options[i].value);
        }
        if (pgVals.length > 0) params.product_groups = pgVals;

        return params;
    }

    function buildQueryString(params) {
        var qs = '';
        for (var key in params) {
            if (Array.isArray(params[key])) {
                for (var i = 0; i < params[key].length; i++) {
                    qs += '&' + key + '[]=' + encodeURIComponent(params[key][i]);
                }
            } else {
                qs += '&' + key + '=' + encodeURIComponent(params[key]);
            }
        }
        return qs;
    }

    // Quick Period helper - global for onclick
    window.setQuickPeriod = function(period) {
        var now = new Date();
        var from, to;

        switch (period) {
            case 'this_month':
                from = new Date(now.getFullYear(), now.getMonth(), 1);
                to = new Date(now.getFullYear(), now.getMonth() + 1, 0);
                break;
            case 'last_month':
                from = new Date(now.getFullYear(), now.getMonth() - 1, 1);
                to = new Date(now.getFullYear(), now.getMonth(), 0);
                break;
            case 'this_year':
                from = new Date(now.getFullYear(), 0, 1);
                to = new Date(now.getFullYear(), 11, 31);
                break;
            case 'last_year':
                from = new Date(now.getFullYear() - 1, 0, 1);
                to = new Date(now.getFullYear() - 1, 11, 31);
                break;
        }

        document.getElementById('date_from').value = formatDate(from);
        document.getElementById('date_to').value = formatDate(to);
    };

    // View Statement - global for onclick
    window.viewStatement = function() {
        var params = collectParams();
        if (!params) return;

        var btn = document.getElementById('btn-view-statement');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=generateStatement',
            type: 'POST',
            data: params,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    document.getElementById('statement-html').innerHTML = response.data.html;
                    document.getElementById('statement-results').style.display = 'block';
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to generate statement', 'error');
            }
        });
    };

    // Download PDF - global for onclick
    window.downloadPdf = function() {
        var params = collectParams();
        if (!params) return;
        window.location.href = ajaxUrl + '&ajax=downloadPdf' + buildQueryString(params);
    };

    // Download CSV - global for onclick
    window.downloadCsv = function() {
        var params = collectParams();
        if (!params) return;
        window.location.href = ajaxUrl + '&ajax=downloadCsv' + buildQueryString(params);
    };

    // Download XLSX - global for onclick
    window.downloadXlsx = function() {
        var params = collectParams();
        if (!params) return;
        window.location.href = ajaxUrl + '&ajax=downloadXlsx' + buildQueryString(params);
    };

    // Save to Archive - global for onclick
    window.saveToArchive = function() {
        var params = collectParams();
        if (!params) return;

        var btn = document.getElementById('btn-save-archive');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=saveToArchive',
            type: 'POST',
            data: params,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to save statement', 'error');
            }
        });
    };

    // Send to Client - global for onclick
    window.sendToClient = function() {
        var params = collectParams();
        if (!params) return;

        var btn = document.getElementById('btn-send-client');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=sendToClient',
            type: 'POST',
            data: params,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Email sent successfully']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to send email', 'error');
            }
        });
    };

    // Generate Link - global for onclick
    window.generateLink = function() {
        var params = collectParams();
        if (!params) return;

        var btn = document.getElementById('btn-generate-link');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxUrl + '&ajax=generateLink',
            type: 'POST',
            data: params,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    var tempInput = document.createElement('input');
                    tempInput.value = response.data.url;
                    document.body.appendChild(tempInput);
                    tempInput.select();
                    document.execCommand('copy');
                    document.body.removeChild(tempInput);
                    showNotification('{/literal}{$meta.lang['Link copied to clipboard']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to generate link', 'error');
            }
        });
    };

    // Initialization - runs when jQuery is ready (works even if DOM already loaded)
    jQuery(function() {
        // Initialize Select2 for client search
        if (typeof jQuery.fn.select2 !== 'undefined') {
            jQuery('#client_search').select2({
                ajax: {
                    url: ajaxUrl + '&ajax=searchClients',
                    dataType: 'json',
                    delay: 300,
                    data: function(params) { return { q: params.term }; },
                    processResults: function(data) {
                        return { results: data.data || [] };
                    }
                },
                minimumInputLength: 2,
                placeholder: '{/literal}{$meta.lang['Search client by name or email...']}{literal}',
                allowClear: true
            });
        }

        {/literal}
        {if isset($smarty.get.client_id)}
        {literal}
        // Pre-populate client if URL param present
        var preClientId = '{/literal}{$smarty.get.client_id}{literal}';
        if (preClientId) {
            jQuery.ajax({
                url: ajaxUrl + '&ajax=getClient&id=' + preClientId,
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.data) {
                        var option = new Option(response.data.text, response.data.id, true, true);
                        jQuery('#client_search').append(option).trigger('change');
                    }
                }
            });
        }
        {/literal}
        {/if}
        {literal}

        // Set default period to this month
        setQuickPeriod('this_month');

        // Load Payment Methods
        jQuery.ajax({
            url: ajaxUrl + '&ajax=getGateways',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data) {
                    var sel = document.getElementById('payment_methods');
                    for (var i = 0; i < response.data.length; i++) {
                        var opt = document.createElement('option');
                        opt.value = response.data[i].gateway;
                        opt.textContent = response.data[i].name;
                        sel.appendChild(opt);
                    }
                }
            }
        });

        // Load Product Groups
        jQuery.ajax({
            url: ajaxUrl + '&ajax=getProductGroups',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data) {
                    var sel = document.getElementById('product_groups');
                    for (var i = 0; i < response.data.length; i++) {
                        var opt = document.createElement('option');
                        opt.value = response.data[i].id;
                        opt.textContent = response.data[i].name;
                        sel.appendChild(opt);
                    }
                }
            }
        });
    });
})();
</script>
{/literal}
