<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-archive"></i> {$meta.lang['Saved Statements']}</h1>
    </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading"><h3 class="panel-title"><i class="fa fa-filter"></i> {$meta.lang['Filters']}</h3></div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{$meta.lang['Client']}</label>
                            <select class="form-control" id="filter_client" style="width:100%;"></select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>{$meta.lang['Date From']}</label>
                            <input type="date" class="form-control" id="filter_date_from">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>{$meta.lang['Date To']}</label>
                            <input type="date" class="form-control" id="filter_date_to">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>{$meta.lang['Generated By']}</label>
                            <select class="form-control" id="filter_generated_by">
                                <option value="">{$meta.lang['All']}</option>
                                <option value="manual">{$meta.lang['Manual']}</option>
                                <option value="schedule">{$meta.lang['Schedule']}</option>
                                <option value="bulk">{$meta.lang['Bulk']}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button class="btn btn-primary" id="btn-filter" onclick="loadSaved(1)"><i class="fa fa-search"></i> {$meta.lang['Filter']}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
        <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
        <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
    </div>
    <div class="col-md-12" id="saved-container" style="display:none;"></div>
</div>

<div class="row">
    <div class="col-md-12 text-center" id="pagination-container"></div>
</div>

{literal}
<script>
jQuery(function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var currentPage = 1;

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    // Initialize Select2 for client filter
    if (typeof jQuery.fn.select2 !== 'undefined') {
        jQuery('#filter_client').select2({
            ajax: {
                url: ajaxUrl + '&ajax=searchClients',
                dataType: 'json',
                delay: 300,
                data: function(params) { return { q: params.term }; },
                processResults: function(data) {
                    return { results: data.data || [] };
                }
            },
            minimumInputLength: 2,
            placeholder: '{/literal}{$meta.lang['Search client...']}{literal}',
            allowClear: true
        });
    }

    window.loadSaved = function(page) {
        currentPage = page || 1;
        document.getElementById('main-loading').style.display = 'block';
        document.getElementById('saved-container').style.display = 'none';

        var params = {
            page: currentPage,
            client_id: jQuery('#filter_client').val() || '',
            date_from: document.getElementById('filter_date_from').value,
            date_to: document.getElementById('filter_date_to').value,
            generated_by: document.getElementById('filter_generated_by').value
        };

        jQuery.ajax({
            url: ajaxUrl + '&ajax=getSaved',
            type: 'GET',
            data: params,
            dataType: 'json',
            success: function(response) {
                document.getElementById('main-loading').style.display = 'none';
                document.getElementById('saved-container').style.display = 'block';

                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }

                renderSaved(response.data.statements);
                renderPagination(response.data.total, response.data.per_page, currentPage);
            },
            error: function() {
                document.getElementById('main-loading').style.display = 'none';
                showNotification('Failed to load saved statements', 'error');
            }
        });
    };

    function renderSaved(statements) {
        var container = document.getElementById('saved-container');

        if (!statements || statements.length === 0) {
            container.innerHTML = '<p class="text-muted text-center" style="padding:40px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
            return;
        }

        var html = '<table class="table table-striped table-hover">';
        html += '<thead><tr>';
        html += '<th>#</th>';
        html += '<th>{/literal}{$meta.lang['Client']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Period']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Generated By']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Generated At']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Status']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Actions']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < statements.length; i++) {
            var s = statements[i];
            var statusBadge = s.status === 'active' ? '<span class="label label-success">{/literal}{$meta.lang['Active']}{literal}</span>' : '<span class="label label-default">' + escapeHtml(s.status) + '</span>';
            html += '<tr>';
            html += '<td>' + s.id + '</td>';
            html += '<td>' + escapeHtml(s.client_name) + '</td>';
            html += '<td><small>' + escapeHtml(s.period_from) + ' - ' + escapeHtml(s.period_to) + '</small></td>';
            html += '<td>' + escapeHtml(s.generated_by) + '</td>';
            html += '<td><small>' + escapeHtml(s.created_at) + '</small></td>';
            html += '<td>' + statusBadge + '</td>';
            html += '<td>';
            html += '<a href="' + ajaxUrl + '&ajax=downloadPdf&saved_id=' + s.id + '" class="btn btn-xs btn-info" title="{/literal}{$meta.lang['View PDF']}{literal}"><i class="fa fa-file-pdf"></i></a> ';
            html += '<button class="btn btn-xs btn-default" onclick="copyLink(' + s.id + ')" title="{/literal}{$meta.lang['Copy Link']}{literal}"><i class="fa fa-link"></i></button> ';
            html += '<button class="btn btn-xs btn-danger" onclick="deleteSaved(' + s.id + ')" title="{/literal}{$meta.lang['Delete']}{literal}"><i class="fa fa-trash"></i></button>';
            html += '</td>';
            html += '</tr>';
        }

        html += '</tbody></table>';
        container.innerHTML = html;
    }

    function renderPagination(total, perPage, page) {
        var totalPages = Math.ceil(total / perPage);
        if (totalPages <= 1) {
            document.getElementById('pagination-container').innerHTML = '';
            return;
        }

        var html = '<ul class="pagination">';
        html += '<li' + (page <= 1 ? ' class="disabled"' : '') + '><a href="javascript:void(0)" onclick="loadSaved(' + (page - 1) + ')">&laquo;</a></li>';

        for (var i = 1; i <= totalPages; i++) {
            html += '<li' + (i === page ? ' class="active"' : '') + '><a href="javascript:void(0)" onclick="loadSaved(' + i + ')">' + i + '</a></li>';
        }

        html += '<li' + (page >= totalPages ? ' class="disabled"' : '') + '><a href="javascript:void(0)" onclick="loadSaved(' + (page + 1) + ')">&raquo;</a></li>';
        html += '</ul>';

        document.getElementById('pagination-container').innerHTML = html;
    }

    window.copyLink = function(id) {
        jQuery.ajax({
            url: ajaxUrl + '&ajax=generateLink',
            type: 'POST',
            data: { statement_id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data) {
                    var tempInput = document.createElement('input');
                    tempInput.value = response.data.url;
                    document.body.appendChild(tempInput);
                    tempInput.select();
                    document.execCommand('copy');
                    document.body.removeChild(tempInput);
                    showNotification('{/literal}{$meta.lang['Link copied to clipboard']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            }
        });
    };

    window.deleteSaved = function(id) {
        if (!confirm('{/literal}{$meta.lang['Confirm Delete']}{literal}')) return;

        jQuery.ajax({
            url: ajaxUrl + '&ajax=deleteSaved',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Deleted successfully']}{literal}', 'success');
                    loadSaved(currentPage);
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Error']}{literal}', 'error');
                }
            }
        });
    };

    loadSaved(1);
});
</script>
{/literal}
