<div class="card">
    <div class="card-body">
        <h3 class="card-title"><i class="fas fa-file-alt"></i> {$meta.lang['Account Statement']}</h3>

        <div class="row" style="margin-top:15px;">
            <div class="col-md-4">
                <div class="form-group">
                    <label>{$meta.lang['Date From']}</label>
                    <input type="date" class="form-control" id="date_from">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>{$meta.lang['Date To']}</label>
                    <input type="date" class="form-control" id="date_to">
                </div>
            </div>
            <div class="col-md-4">
                <label>{$meta.lang['Quick Period']}</label>
                <div class="btn-group btn-group-sm d-flex" role="group">
                    <button type="button" class="btn btn-outline-secondary" onclick="setQuickPeriod('this_month')">{$meta.lang['This Month']}</button>
                    <button type="button" class="btn btn-outline-secondary" onclick="setQuickPeriod('last_month')">{$meta.lang['Last Month']}</button>
                    <button type="button" class="btn btn-outline-secondary" onclick="setQuickPeriod('this_year')">{$meta.lang['This Year']}</button>
                    <button type="button" class="btn btn-outline-secondary" onclick="setQuickPeriod('last_year')">{$meta.lang['Last Year']}</button>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top:10px;">
            <div class="col-md-12">
                <label>{$meta.lang['Include']}</label>
                <div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" id="include_paid" checked>
                        <label class="form-check-label" for="include_paid">{$meta.lang['Paid']}</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" id="include_unpaid" checked>
                        <label class="form-check-label" for="include_unpaid">{$meta.lang['Unpaid']}</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" id="include_refunded" checked>
                        <label class="form-check-label" for="include_refunded">{$meta.lang['Refunded']}</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" id="include_transactions" checked>
                        <label class="form-check-label" for="include_transactions">{$meta.lang['Transactions']}</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" id="include_credits" checked>
                        <label class="form-check-label" for="include_credits">{$meta.lang['Credits']}</label>
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-primary" id="btn-view" onclick="viewStatement()"><i class="fas fa-eye"></i> {$meta.lang['View']}</button>
                {if $allow_pdf}
                <button class="btn btn-info" id="btn-pdf" onclick="downloadPdf()"><i class="fas fa-file-pdf"></i> {$meta.lang['Download PDF']}</button>
                {/if}
                {if $allow_csv}
                <button class="btn btn-secondary" id="btn-csv" onclick="downloadCsv()"><i class="fas fa-file-csv"></i> {$meta.lang['Download CSV']}</button>
                {/if}
                {if $allow_xlsx}
                <button class="btn btn-secondary" id="btn-xlsx" onclick="downloadXlsx()"><i class="fas fa-file-excel"></i> {$meta.lang['Download XLSX']}</button>
                {/if}
            </div>
        </div>
    </div>
</div>

<div class="card mt-3" id="statement-results" style="display:none;">
    <div class="card-body">
        <h5 class="card-title"><i class="fas fa-file-alt"></i> {$meta.lang['Statement Preview']}</h5>
        <div id="statement-html"></div>
    </div>
</div>

<div class="card mt-3" id="saved-statements-card" style="display:none;">
    <div class="card-body">
        <h5 class="card-title"><i class="fas fa-archive"></i> {$meta.lang['Saved Statements']}</h5>
        <div id="saved-statements-table"></div>
    </div>
</div>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxBase = 'index.php?m=puq_account_statement&ajax=';

    function formatDate(d) {
        var m = ('0' + (d.getMonth() + 1)).slice(-2);
        var day = ('0' + d.getDate()).slice(-2);
        return d.getFullYear() + '-' + m + '-' + day;
    }

    function showNotification(message, type) {
        if (typeof jQuery.growl !== 'undefined') {
            if (type === 'success') jQuery.growl.notice({ message: message });
            else jQuery.growl.error({ message: message });
        } else {
            alert(message);
        }
    }

    function btnLoading(btn) {
        btn.disabled = true;
        btn._origHtml = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    }

    function btnReset(btn) {
        btn.disabled = false;
        if (btn._origHtml) btn.innerHTML = btn._origHtml;
    }

    // Set default period
    window.setQuickPeriod = function(period) {
        var now = new Date();
        var from, to;
        switch (period) {
            case 'this_month':
                from = new Date(now.getFullYear(), now.getMonth(), 1);
                to = new Date(now.getFullYear(), now.getMonth() + 1, 0);
                break;
            case 'last_month':
                from = new Date(now.getFullYear(), now.getMonth() - 1, 1);
                to = new Date(now.getFullYear(), now.getMonth(), 0);
                break;
            case 'this_year':
                from = new Date(now.getFullYear(), 0, 1);
                to = new Date(now.getFullYear(), 11, 31);
                break;
            case 'last_year':
                from = new Date(now.getFullYear() - 1, 0, 1);
                to = new Date(now.getFullYear() - 1, 11, 31);
                break;
        }
        document.getElementById('date_from').value = formatDate(from);
        document.getElementById('date_to').value = formatDate(to);
    };

    setQuickPeriod('this_month');

    function collectParams() {
        return {
            date_from: document.getElementById('date_from').value,
            date_to: document.getElementById('date_to').value,
            include_paid: document.getElementById('include_paid').checked ? 1 : 0,
            include_unpaid: document.getElementById('include_unpaid').checked ? 1 : 0,
            include_refunded: document.getElementById('include_refunded').checked ? 1 : 0,
            include_transactions: document.getElementById('include_transactions').checked ? 1 : 0,
            include_credits: document.getElementById('include_credits').checked ? 1 : 0
        };
    }

    function buildQueryString(params) {
        var qs = '';
        for (var key in params) {
            qs += '&' + key + '=' + encodeURIComponent(params[key]);
        }
        return qs;
    }

    // View Statement
    window.viewStatement = function() {
        var params = collectParams();
        var btn = document.getElementById('btn-view');
        btnLoading(btn);

        jQuery.ajax({
            url: ajaxBase + 'generateStatement',
            type: 'POST',
            data: params,
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    document.getElementById('statement-html').innerHTML = response.data.html;
                    document.getElementById('statement-results').style.display = 'block';
                } else {
                    showNotification(response.error || 'Error generating statement', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('Failed to generate statement', 'error');
            }
        });
    };

    // Download PDF
    window.downloadPdf = function() {
        var params = collectParams();
        window.location.href = ajaxBase + 'downloadPdf' + buildQueryString(params);
    };

    // Download CSV
    window.downloadCsv = function() {
        var params = collectParams();
        window.location.href = ajaxBase + 'downloadCsv' + buildQueryString(params);
    };

    // Download XLSX
    window.downloadXlsx = function() {
        var params = collectParams();
        window.location.href = ajaxBase + 'downloadXlsx' + buildQueryString(params);
    };

    // Load saved statements for this client
    jQuery.ajax({
        url: ajaxBase + 'getSaved',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data && response.data.statements && response.data.statements.length > 0) {
                var statements = response.data.statements;
                document.getElementById('saved-statements-card').style.display = 'block';

                var html = '<table class="table table-striped table-sm">';
                html += '<thead><tr>';
                html += '<th>{/literal}{$meta.lang['Date']}{literal}</th>';
                html += '<th>{/literal}{$meta.lang['Period']}{literal}</th>';
                html += '<th>{/literal}{$meta.lang['Actions']}{literal}</th>';
                html += '</tr></thead><tbody>';

                for (var i = 0; i < statements.length; i++) {
                    var s = statements[i];
                    html += '<tr>';
                    html += '<td><small>' + escapeHtml(s.created_at) + '</small></td>';
                    html += '<td><small>' + escapeHtml(s.period_from) + ' - ' + escapeHtml(s.period_to) + '</small></td>';
                    html += '<td>';
                    if (s.pdf_url) {
                        html += '<a href="' + s.pdf_url + '" class="btn btn-sm btn-info" target="_blank"><i class="fas fa-file-pdf"></i> PDF</a> ';
                    }
                    if (s.view_url) {
                        html += '<a href="' + s.view_url + '" class="btn btn-sm btn-primary" target="_blank"><i class="fas fa-eye"></i> {/literal}{$meta.lang['View']}{literal}</a>';
                    }
                    html += '</td>';
                    html += '</tr>';
                }

                html += '</tbody></table>';
                document.getElementById('saved-statements-table').innerHTML = html;
            }
        }
    });

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }
});
</script>
{/literal}
